/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.webvtt;

import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.util.regex.Pattern;

public final class WebvttParserUtil {
    private static final Pattern HEADER = Pattern.compile("^\ufeff?WEBVTT(( |\t).*)?$");

    private WebvttParserUtil() {
    }

    public static void validateWebvttHeaderLine(ParsableByteArray parsableByteArray) throws ParserException {
        String string = parsableByteArray.readLine();
        if (string == null || !HEADER.matcher(string).matches()) {
            throw new ParserException("Expected WEBVTT. Got " + string);
        }
    }

    public static long parseTimestampUs(String string) throws NumberFormatException {
        long l = 0L;
        String[] stringArray = string.split("\\.", 2);
        String[] stringArray2 = stringArray[0].split(":");
        for (int i = 0; i < stringArray2.length; ++i) {
            l = l * 60L + Long.parseLong(stringArray2[i]);
        }
        return (l * 1000L + Long.parseLong(stringArray[1])) * 1000L;
    }

    public static float parsePercentage(String string) throws NumberFormatException {
        if (!string.endsWith("%")) {
            throw new NumberFormatException("Percentages must end with %");
        }
        return Float.parseFloat(string.substring(0, string.length() - 1)) / 100.0f;
    }
}

