/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.ttml;

import android.text.Layout;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.text.SubtitleParser;
import com.google.android.exoplayer.text.ttml.TtmlColorParser;
import com.google.android.exoplayer.text.ttml.TtmlNode;
import com.google.android.exoplayer.text.ttml.TtmlStyle;
import com.google.android.exoplayer.text.ttml.TtmlSubtitle;
import com.google.android.exoplayer.util.ParserUtil;
import com.google.android.exoplayer.util.Util;
import com.vcc.playerwrappersdk.a;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public final class TtmlParser
implements SubtitleParser {
    private static final String TAG = "TtmlParser";
    private static final String ATTR_BEGIN = "begin";
    private static final String ATTR_DURATION = "dur";
    private static final String ATTR_END = "end";
    private static final String ATTR_STYLE = "style";
    private static final Pattern CLOCK_TIME = Pattern.compile("^([0-9][0-9]+):([0-9][0-9]):([0-9][0-9])(?:(\\.[0-9]+)|:([0-9][0-9])(?:\\.([0-9]+))?)?$");
    private static final Pattern OFFSET_TIME = Pattern.compile("^([0-9]+(?:\\.[0-9]+)?)(h|m|s|ms|f|t)$");
    private static final Pattern FONT_SIZE = Pattern.compile("^(([0-9]*.)?[0-9]+)(px|em|%)$");
    private static final int DEFAULT_FRAMERATE = 30;
    private static final int DEFAULT_SUBFRAMERATE = 1;
    private static final int DEFAULT_TICKRATE = 1;
    private final XmlPullParserFactory xmlParserFactory;

    public TtmlParser() {
        try {
            this.xmlParserFactory = XmlPullParserFactory.newInstance();
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new RuntimeException("Couldn't create XmlPullParserFactory instance", xmlPullParserException);
        }
    }

    @Override
    public boolean canParse(String string) {
        return "application/ttml+xml".equals(string);
    }

    @Override
    public TtmlSubtitle parse(byte[] byArray, int n, int n2) throws ParserException {
        try {
            XmlPullParser xmlPullParser = this.xmlParserFactory.newPullParser();
            HashMap<String, TtmlStyle> hashMap = new HashMap<String, TtmlStyle>();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
            xmlPullParser.setInput((InputStream)byteArrayInputStream, null);
            TtmlSubtitle ttmlSubtitle = null;
            LinkedList<TtmlNode> linkedList = new LinkedList<TtmlNode>();
            int n3 = 0;
            int n4 = xmlPullParser.getEventType();
            while (n4 != 1) {
                TtmlNode ttmlNode = (TtmlNode)linkedList.peekLast();
                if (n3 == 0) {
                    String string = xmlPullParser.getName();
                    if (n4 == 2) {
                        if (!TtmlParser.isSupportedTag(string)) {
                            a.b(TAG, "Ignoring unsupported tag: " + xmlPullParser.getName());
                            ++n3;
                        } else if ("head".equals(string)) {
                            this.parseHeader(xmlPullParser, hashMap);
                        } else {
                            try {
                                TtmlNode ttmlNode2 = this.parseNode(xmlPullParser, ttmlNode);
                                linkedList.addLast(ttmlNode2);
                                if (ttmlNode != null) {
                                    ttmlNode.addChild(ttmlNode2);
                                }
                            }
                            catch (ParserException parserException) {
                                a.a(TAG, "Suppressing parser error", parserException);
                                ++n3;
                            }
                        }
                    } else if (n4 == 4) {
                        ttmlNode.addChild(TtmlNode.buildTextNode(xmlPullParser.getText()));
                    } else if (n4 == 3) {
                        if (xmlPullParser.getName().equals("tt")) {
                            ttmlSubtitle = new TtmlSubtitle((TtmlNode)linkedList.getLast(), hashMap);
                        }
                        linkedList.removeLast();
                    }
                } else if (n4 == 2) {
                    ++n3;
                } else if (n4 == 3) {
                    --n3;
                }
                xmlPullParser.next();
                n4 = xmlPullParser.getEventType();
            }
            return ttmlSubtitle;
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new ParserException("Unable to parse source", xmlPullParserException);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Unexpected error when reading input.", iOException);
        }
    }

    private Map<String, TtmlStyle> parseHeader(XmlPullParser xmlPullParser, Map<String, TtmlStyle> map) throws IOException, XmlPullParserException {
        do {
            xmlPullParser.next();
            if (!ParserUtil.isStartTag(xmlPullParser, ATTR_STYLE)) continue;
            String string = xmlPullParser.getAttributeValue(null, ATTR_STYLE);
            TtmlStyle ttmlStyle = this.parseStyleAttributes(xmlPullParser, new TtmlStyle());
            if (string != null) {
                String[] stringArray = this.parseStyleIds(string);
                for (int i = 0; i < stringArray.length; ++i) {
                    ttmlStyle.chain(map.get(stringArray[i]));
                }
            }
            if (ttmlStyle.getId() == null) continue;
            map.put(ttmlStyle.getId(), ttmlStyle);
        } while (!ParserUtil.isEndTag(xmlPullParser, "head"));
        return map;
    }

    private String[] parseStyleIds(String string) {
        return string.split("\\s+");
    }

    private TtmlStyle parseStyleAttributes(XmlPullParser xmlPullParser, TtmlStyle ttmlStyle) {
        int n = xmlPullParser.getAttributeCount();
        block54: for (int i = 0; i < n; ++i) {
            String string = xmlPullParser.getAttributeName(i);
            String string2 = xmlPullParser.getAttributeValue(i);
            switch (ParserUtil.removeNamespacePrefix(string)) {
                case "id": {
                    if (!ATTR_STYLE.equals(xmlPullParser.getName())) continue block54;
                    ttmlStyle = this.createIfNull(ttmlStyle).setId(string2);
                    continue block54;
                }
                case "backgroundColor": {
                    ttmlStyle = this.createIfNull(ttmlStyle);
                    try {
                        ttmlStyle.setBackgroundColor(TtmlColorParser.parseColor(string2));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        a.c(TAG, "failed parsing background value: '" + string2 + "'");
                    }
                    continue block54;
                }
                case "color": {
                    ttmlStyle = this.createIfNull(ttmlStyle);
                    try {
                        ttmlStyle.setColor(TtmlColorParser.parseColor(string2));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        a.c(TAG, "failed parsing color value: '" + string2 + "'");
                    }
                    continue block54;
                }
                case "fontFamily": {
                    ttmlStyle = this.createIfNull(ttmlStyle).setFontFamily(string2);
                    continue block54;
                }
                case "fontSize": {
                    try {
                        ttmlStyle = this.createIfNull(ttmlStyle);
                        TtmlParser.parseFontSize(string2, ttmlStyle);
                    }
                    catch (ParserException parserException) {
                        a.c(TAG, "failed parsing fontSize value: '" + string2 + "'");
                    }
                    continue block54;
                }
                case "fontWeight": {
                    ttmlStyle = this.createIfNull(ttmlStyle).setBold("bold".equalsIgnoreCase(string2));
                    continue block54;
                }
                case "fontStyle": {
                    ttmlStyle = this.createIfNull(ttmlStyle).setItalic("italic".equalsIgnoreCase(string2));
                    continue block54;
                }
                case "textAlign": {
                    switch (Util.toLowerInvariant(string2)) {
                        case "left": {
                            ttmlStyle = this.createIfNull(ttmlStyle).setTextAlign(Layout.Alignment.ALIGN_NORMAL);
                            break;
                        }
                        case "start": {
                            ttmlStyle = this.createIfNull(ttmlStyle).setTextAlign(Layout.Alignment.ALIGN_NORMAL);
                            break;
                        }
                        case "right": {
                            ttmlStyle = this.createIfNull(ttmlStyle).setTextAlign(Layout.Alignment.ALIGN_OPPOSITE);
                            break;
                        }
                        case "end": {
                            ttmlStyle = this.createIfNull(ttmlStyle).setTextAlign(Layout.Alignment.ALIGN_OPPOSITE);
                            break;
                        }
                        case "center": {
                            ttmlStyle = this.createIfNull(ttmlStyle).setTextAlign(Layout.Alignment.ALIGN_CENTER);
                        }
                    }
                    continue block54;
                }
                case "textDecoration": {
                    switch (Util.toLowerInvariant(string2)) {
                        case "linethrough": {
                            ttmlStyle = this.createIfNull(ttmlStyle).setLinethrough(true);
                            break;
                        }
                        case "nolinethrough": {
                            ttmlStyle = this.createIfNull(ttmlStyle).setLinethrough(false);
                            break;
                        }
                        case "underline": {
                            ttmlStyle = this.createIfNull(ttmlStyle).setUnderline(true);
                            break;
                        }
                        case "nounderline": {
                            ttmlStyle = this.createIfNull(ttmlStyle).setUnderline(false);
                        }
                    }
                    continue block54;
                }
            }
        }
        return ttmlStyle;
    }

    private TtmlStyle createIfNull(TtmlStyle ttmlStyle) {
        return ttmlStyle == null ? new TtmlStyle() : ttmlStyle;
    }

    private TtmlNode parseNode(XmlPullParser xmlPullParser, TtmlNode ttmlNode) throws ParserException {
        long l = 0L;
        long l2 = -1L;
        long l3 = -1L;
        String[] stringArray = null;
        int n = xmlPullParser.getAttributeCount();
        TtmlStyle ttmlStyle = this.parseStyleAttributes(xmlPullParser, null);
        for (int i = 0; i < n; ++i) {
            String[] stringArray2;
            String string = ParserUtil.removeNamespacePrefix(xmlPullParser.getAttributeName(i));
            String string2 = xmlPullParser.getAttributeValue(i);
            if (string.equals(ATTR_BEGIN)) {
                l2 = TtmlParser.parseTimeExpression(string2, 30, 1, 1);
                continue;
            }
            if (string.equals(ATTR_END)) {
                l3 = TtmlParser.parseTimeExpression(string2, 30, 1, 1);
                continue;
            }
            if (string.equals(ATTR_DURATION)) {
                l = TtmlParser.parseTimeExpression(string2, 30, 1, 1);
                continue;
            }
            if (!string.equals(ATTR_STYLE) || (stringArray2 = this.parseStyleIds(string2)).length <= 0) continue;
            stringArray = stringArray2;
        }
        if (ttmlNode != null && ttmlNode.startTimeUs != -1L) {
            if (l2 != -1L) {
                l2 += ttmlNode.startTimeUs;
            }
            if (l3 != -1L) {
                l3 += ttmlNode.startTimeUs;
            }
        }
        if (l3 == -1L) {
            if (l > 0L) {
                l3 = l2 + l;
            } else if (ttmlNode != null && ttmlNode.endTimeUs != -1L) {
                l3 = ttmlNode.endTimeUs;
            }
        }
        return TtmlNode.buildNode(xmlPullParser.getName(), l2, l3, ttmlStyle, stringArray);
    }

    private static boolean isSupportedTag(String string) {
        return string.equals("tt") || string.equals("head") || string.equals("body") || string.equals("div") || string.equals("p") || string.equals("span") || string.equals("br") || string.equals(ATTR_STYLE) || string.equals("styling") || string.equals("layout") || string.equals("region") || string.equals("metadata") || string.equals("smpte:image") || string.equals("smpte:data") || string.equals("smpte:information");
    }

    private static void parseFontSize(String string, TtmlStyle ttmlStyle) throws ParserException {
        Matcher matcher;
        String[] stringArray = string.split("\\s+");
        if (stringArray.length == 1) {
            matcher = FONT_SIZE.matcher(string);
        } else if (stringArray.length == 2) {
            matcher = FONT_SIZE.matcher(stringArray[1]);
            a.c(TAG, "multiple values in fontSize attribute. Picking the second value for vertical font size and ignoring the first.");
        } else {
            throw new ParserException();
        }
        if (matcher.matches()) {
            String string2;
            switch (string2 = matcher.group(3)) {
                case "px": {
                    ttmlStyle.setFontSizeUnit((short)1);
                    break;
                }
                case "em": {
                    ttmlStyle.setFontSizeUnit((short)2);
                    break;
                }
                case "%": {
                    ttmlStyle.setFontSizeUnit((short)3);
                    break;
                }
                default: {
                    throw new ParserException();
                }
            }
        } else {
            throw new ParserException();
        }
        ttmlStyle.setFontSize(Float.valueOf(matcher.group(1)).floatValue());
    }

    private static long parseTimeExpression(String string, int n, int n2, int n3) throws ParserException {
        Matcher matcher = CLOCK_TIME.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            double d2 = Long.parseLong(string2) * 3600L;
            String string3 = matcher.group(2);
            d2 += (double)(Long.parseLong(string3) * 60L);
            String string4 = matcher.group(3);
            d2 += (double)Long.parseLong(string4);
            String string5 = matcher.group(4);
            d2 += string5 != null ? Double.parseDouble(string5) : 0.0;
            String string6 = matcher.group(5);
            d2 += string6 != null ? (double)Long.parseLong(string6) / (double)n : 0.0;
            String string7 = matcher.group(6);
            return (long)((d2 += string7 != null ? (double)Long.parseLong(string7) / (double)n2 / (double)n : 0.0) * 1000000.0);
        }
        matcher = OFFSET_TIME.matcher(string);
        if (matcher.matches()) {
            String string8 = matcher.group(1);
            double d3 = Double.parseDouble(string8);
            String string9 = matcher.group(2);
            if (string9.equals("h")) {
                d3 *= 3600.0;
            } else if (string9.equals("m")) {
                d3 *= 60.0;
            } else if (!string9.equals("s")) {
                if (string9.equals("ms")) {
                    d3 /= 1000.0;
                } else if (string9.equals("f")) {
                    d3 /= (double)n;
                } else if (string9.equals("t")) {
                    d3 /= (double)n3;
                }
            }
            return (long)(d3 * 1000000.0);
        }
        throw new ParserException("Malformed time expression: " + string);
    }
}

