/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.eia608;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.SampleSourceTrackRenderer;
import com.google.android.exoplayer.text.Cue;
import com.google.android.exoplayer.text.TextRenderer;
import com.google.android.exoplayer.text.eia608.ClosedCaption;
import com.google.android.exoplayer.text.eia608.ClosedCaptionCtrl;
import com.google.android.exoplayer.text.eia608.ClosedCaptionList;
import com.google.android.exoplayer.text.eia608.ClosedCaptionText;
import com.google.android.exoplayer.text.eia608.Eia608Parser;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.util.Collections;
import java.util.TreeSet;

public final class Eia608TrackRenderer
extends SampleSourceTrackRenderer
implements Handler.Callback {
    private static final int MSG_INVOKE_RENDERER = 0;
    private static final int CC_MODE_UNKNOWN = 0;
    private static final int CC_MODE_ROLL_UP = 1;
    private static final int CC_MODE_POP_ON = 2;
    private static final int CC_MODE_PAINT_ON = 3;
    private static final int DEFAULT_CAPTIONS_ROW_COUNT = 4;
    private static final int MAX_SAMPLE_READAHEAD_US = 5000000;
    private final Eia608Parser eia608Parser;
    private final TextRenderer textRenderer;
    private final Handler textRendererHandler;
    private final MediaFormatHolder formatHolder;
    private final SampleHolder sampleHolder;
    private final StringBuilder captionStringBuilder;
    private final TreeSet<ClosedCaptionList> pendingCaptionLists;
    private boolean inputStreamEnded;
    private int captionMode;
    private int captionRowCount;
    private String caption;
    private String lastRenderedCaption;
    private ClosedCaptionCtrl repeatableControl;

    public Eia608TrackRenderer(SampleSource sampleSource, TextRenderer textRenderer, Looper looper) {
        super(sampleSource);
        this.textRenderer = Assertions.checkNotNull(textRenderer);
        this.textRendererHandler = looper == null ? null : new Handler(looper, (Handler.Callback)this);
        this.eia608Parser = new Eia608Parser();
        this.formatHolder = new MediaFormatHolder();
        this.sampleHolder = new SampleHolder(1);
        this.captionStringBuilder = new StringBuilder();
        this.pendingCaptionLists = new TreeSet();
    }

    @Override
    protected boolean handlesTrack(MediaFormat mediaFormat) {
        return this.eia608Parser.canParse(mediaFormat.mimeType);
    }

    @Override
    protected void onEnabled(int n, long l, boolean bl) throws ExoPlaybackException {
        super.onEnabled(n, l, bl);
    }

    @Override
    protected void onDiscontinuity(long l) {
        this.inputStreamEnded = false;
        this.repeatableControl = null;
        this.pendingCaptionLists.clear();
        this.clearPendingSample();
        this.captionRowCount = 4;
        this.setCaptionMode(0);
        this.invokeRenderer(null);
    }

    @Override
    protected void doSomeWork(long l, long l2, boolean bl) throws ExoPlaybackException {
        int n;
        if (this.isSamplePending()) {
            this.maybeParsePendingSample(l);
        }
        int n2 = n = this.inputStreamEnded ? -1 : -3;
        while (!this.isSamplePending() && n == -3) {
            n = this.readSource(l, this.formatHolder, this.sampleHolder);
            if (n == -3) {
                this.maybeParsePendingSample(l);
                continue;
            }
            if (n != -1) continue;
            this.inputStreamEnded = true;
        }
        while (!this.pendingCaptionLists.isEmpty()) {
            if (this.pendingCaptionLists.first().timeUs > l) {
                return;
            }
            ClosedCaptionList closedCaptionList = this.pendingCaptionLists.pollFirst();
            this.consumeCaptionList(closedCaptionList);
            if (closedCaptionList.decodeOnly) continue;
            this.invokeRenderer(this.caption);
        }
    }

    @Override
    protected long getBufferedPositionUs() {
        return -3L;
    }

    @Override
    protected boolean isEnded() {
        return this.inputStreamEnded;
    }

    @Override
    protected boolean isReady() {
        return true;
    }

    private void invokeRenderer(String string) {
        if (Util.areEqual(this.lastRenderedCaption, string)) {
            return;
        }
        this.lastRenderedCaption = string;
        if (this.textRendererHandler != null) {
            this.textRendererHandler.obtainMessage(0, (Object)string).sendToTarget();
        } else {
            this.invokeRendererInternal(string);
        }
    }

    public boolean handleMessage(Message message) {
        switch (message.what) {
            case 0: {
                this.invokeRendererInternal((String)message.obj);
                return true;
            }
        }
        return false;
    }

    private void invokeRendererInternal(String string) {
        if (string == null) {
            this.textRenderer.onCues(Collections.emptyList());
        } else {
            this.textRenderer.onCues(Collections.singletonList(new Cue(string)));
        }
    }

    private void maybeParsePendingSample(long l) {
        if (this.sampleHolder.timeUs > l + 5000000L) {
            return;
        }
        ClosedCaptionList closedCaptionList = this.eia608Parser.parse(this.sampleHolder);
        this.clearPendingSample();
        if (closedCaptionList != null) {
            this.pendingCaptionLists.add(closedCaptionList);
        }
    }

    private void consumeCaptionList(ClosedCaptionList closedCaptionList) {
        int n = closedCaptionList.captions.length;
        if (n == 0) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            ClosedCaption closedCaption = closedCaptionList.captions[i];
            if (closedCaption.type == 0) {
                ClosedCaptionCtrl closedCaptionCtrl = (ClosedCaptionCtrl)closedCaption;
                boolean bl2 = bl = n == 1 && closedCaptionCtrl.isRepeatable();
                if (bl && this.repeatableControl != null && this.repeatableControl.cc1 == closedCaptionCtrl.cc1 && this.repeatableControl.cc2 == closedCaptionCtrl.cc2) {
                    this.repeatableControl = null;
                    continue;
                }
                if (bl) {
                    this.repeatableControl = closedCaptionCtrl;
                }
                if (closedCaptionCtrl.isMiscCode()) {
                    this.handleMiscCode(closedCaptionCtrl);
                    continue;
                }
                if (!closedCaptionCtrl.isPreambleAddressCode()) continue;
                this.handlePreambleAddressCode();
                continue;
            }
            this.handleText((ClosedCaptionText)closedCaption);
        }
        if (!bl) {
            this.repeatableControl = null;
        }
        if (this.captionMode == 1 || this.captionMode == 3) {
            this.caption = this.getDisplayCaption();
        }
    }

    private void handleText(ClosedCaptionText closedCaptionText) {
        if (this.captionMode != 0) {
            this.captionStringBuilder.append(closedCaptionText.text);
        }
    }

    private void handleMiscCode(ClosedCaptionCtrl closedCaptionCtrl) {
        switch (closedCaptionCtrl.cc2) {
            case 37: {
                this.captionRowCount = 2;
                this.setCaptionMode(1);
                return;
            }
            case 38: {
                this.captionRowCount = 3;
                this.setCaptionMode(1);
                return;
            }
            case 39: {
                this.captionRowCount = 4;
                this.setCaptionMode(1);
                return;
            }
            case 32: {
                this.setCaptionMode(2);
                return;
            }
            case 41: {
                this.setCaptionMode(3);
                return;
            }
        }
        if (this.captionMode == 0) {
            return;
        }
        switch (closedCaptionCtrl.cc2) {
            case 44: {
                this.caption = null;
                if (this.captionMode == 1 || this.captionMode == 3) {
                    this.captionStringBuilder.setLength(0);
                }
                return;
            }
            case 46: {
                this.captionStringBuilder.setLength(0);
                return;
            }
            case 47: {
                this.caption = this.getDisplayCaption();
                this.captionStringBuilder.setLength(0);
                return;
            }
            case 45: {
                this.maybeAppendNewline();
                return;
            }
            case 33: {
                if (this.captionStringBuilder.length() > 0) {
                    this.captionStringBuilder.setLength(this.captionStringBuilder.length() - 1);
                }
                return;
            }
        }
    }

    private void handlePreambleAddressCode() {
        this.maybeAppendNewline();
    }

    private void setCaptionMode(int n) {
        if (this.captionMode == n) {
            return;
        }
        this.captionMode = n;
        this.captionStringBuilder.setLength(0);
        if (n == 1 || n == 0) {
            this.caption = null;
        }
    }

    private void maybeAppendNewline() {
        int n = this.captionStringBuilder.length();
        if (n > 0 && this.captionStringBuilder.charAt(n - 1) != '\n') {
            this.captionStringBuilder.append('\n');
        }
    }

    private String getDisplayCaption() {
        int n;
        boolean bl;
        int n2 = this.captionStringBuilder.length();
        if (n2 == 0) {
            return null;
        }
        boolean bl2 = bl = this.captionStringBuilder.charAt(n2 - 1) == '\n';
        if (n2 == 1 && bl) {
            return null;
        }
        int n3 = n = bl ? n2 - 1 : n2;
        if (this.captionMode != 1) {
            return this.captionStringBuilder.substring(0, n);
        }
        int n4 = 0;
        int n5 = n;
        for (int i = 0; i < this.captionRowCount && n5 != -1; ++i) {
            n5 = this.captionStringBuilder.lastIndexOf("\n", n5 - 1);
        }
        if (n5 != -1) {
            n4 = n5 + 1;
        }
        this.captionStringBuilder.delete(0, n4);
        return this.captionStringBuilder.substring(0, n - n4);
    }

    private void clearPendingSample() {
        this.sampleHolder.timeUs = -1L;
        this.sampleHolder.clearData();
    }

    private boolean isSamplePending() {
        return this.sampleHolder.timeUs != -1L;
    }
}

