/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.smoothstreaming;

import android.net.Uri;
import android.os.SystemClock;
import android.util.Base64;
import android.util.SparseArray;
import com.google.android.exoplayer.BehindLiveWindowException;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.chunk.Chunk;
import com.google.android.exoplayer.chunk.ChunkExtractorWrapper;
import com.google.android.exoplayer.chunk.ChunkOperationHolder;
import com.google.android.exoplayer.chunk.ChunkSource;
import com.google.android.exoplayer.chunk.ContainerMediaChunk;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.chunk.FormatEvaluator;
import com.google.android.exoplayer.chunk.MediaChunk;
import com.google.android.exoplayer.drm.DrmInitData;
import com.google.android.exoplayer.extractor.mp4.FragmentedMp4Extractor;
import com.google.android.exoplayer.extractor.mp4.Track;
import com.google.android.exoplayer.extractor.mp4.TrackEncryptionBox;
import com.google.android.exoplayer.smoothstreaming.SmoothStreamingManifest;
import com.google.android.exoplayer.smoothstreaming.SmoothStreamingTrackSelector;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.CodecSpecificDataUtil;
import com.google.android.exoplayer.util.ManifestFetcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SmoothStreamingChunkSource
implements ChunkSource,
SmoothStreamingTrackSelector.Output {
    private static final int MINIMUM_MANIFEST_REFRESH_PERIOD_MS = 5000;
    private static final int INITIALIZATION_VECTOR_SIZE = 8;
    private final SmoothStreamingTrackSelector trackSelector;
    private final DataSource dataSource;
    private final FormatEvaluator.Evaluation evaluation;
    private final long liveEdgeLatencyUs;
    private final TrackEncryptionBox[] trackEncryptionBoxes;
    private final ManifestFetcher<SmoothStreamingManifest> manifestFetcher;
    private final DrmInitData.Mapped drmInitData;
    private final FormatEvaluator adaptiveFormatEvaluator;
    private final boolean live;
    private final ArrayList<ExposedTrack> tracks;
    private final SparseArray<ChunkExtractorWrapper> extractorWrappers;
    private final SparseArray<MediaFormat> mediaFormats;
    private boolean prepareCalled;
    private SmoothStreamingManifest currentManifest;
    private int currentManifestChunkOffset;
    private boolean needManifestRefresh;
    private ExposedTrack enabledTrack;
    private IOException fatalError;

    public SmoothStreamingChunkSource(ManifestFetcher<SmoothStreamingManifest> manifestFetcher, SmoothStreamingTrackSelector smoothStreamingTrackSelector, DataSource dataSource, FormatEvaluator formatEvaluator, long l) {
        this(manifestFetcher, manifestFetcher.getManifest(), smoothStreamingTrackSelector, dataSource, formatEvaluator, l);
    }

    public SmoothStreamingChunkSource(SmoothStreamingManifest smoothStreamingManifest, SmoothStreamingTrackSelector smoothStreamingTrackSelector, DataSource dataSource, FormatEvaluator formatEvaluator) {
        this(null, smoothStreamingManifest, smoothStreamingTrackSelector, dataSource, formatEvaluator, 0L);
    }

    private SmoothStreamingChunkSource(ManifestFetcher<SmoothStreamingManifest> manifestFetcher, SmoothStreamingManifest smoothStreamingManifest, SmoothStreamingTrackSelector smoothStreamingTrackSelector, DataSource dataSource, FormatEvaluator formatEvaluator, long l) {
        this.manifestFetcher = manifestFetcher;
        this.currentManifest = smoothStreamingManifest;
        this.trackSelector = smoothStreamingTrackSelector;
        this.dataSource = dataSource;
        this.adaptiveFormatEvaluator = formatEvaluator;
        this.liveEdgeLatencyUs = l * 1000L;
        this.evaluation = new FormatEvaluator.Evaluation();
        this.tracks = new ArrayList();
        this.extractorWrappers = new SparseArray();
        this.mediaFormats = new SparseArray();
        this.live = smoothStreamingManifest.isLive;
        SmoothStreamingManifest.ProtectionElement protectionElement = smoothStreamingManifest.protectionElement;
        if (protectionElement != null) {
            byte[] byArray = SmoothStreamingChunkSource.getProtectionElementKeyId(protectionElement.data);
            this.trackEncryptionBoxes = new TrackEncryptionBox[1];
            this.trackEncryptionBoxes[0] = new TrackEncryptionBox(true, 8, byArray);
            this.drmInitData = new DrmInitData.Mapped();
            this.drmInitData.put(protectionElement.uuid, new DrmInitData.SchemeInitData("video/mp4", protectionElement.data));
        } else {
            this.trackEncryptionBoxes = null;
            this.drmInitData = null;
        }
    }

    @Override
    public void maybeThrowError() throws IOException {
        if (this.fatalError != null) {
            throw this.fatalError;
        }
        this.manifestFetcher.maybeThrowError();
    }

    @Override
    public boolean prepare() {
        if (!this.prepareCalled) {
            this.prepareCalled = true;
            try {
                this.trackSelector.selectTracks(this.currentManifest, this);
            }
            catch (IOException iOException) {
                this.fatalError = iOException;
            }
        }
        return this.fatalError == null;
    }

    @Override
    public int getTrackCount() {
        return this.tracks.size();
    }

    @Override
    public final MediaFormat getFormat(int n) {
        return this.tracks.get((int)n).trackFormat;
    }

    @Override
    public void enable(int n) {
        this.enabledTrack = this.tracks.get(n);
        if (this.enabledTrack.isAdaptive()) {
            this.adaptiveFormatEvaluator.enable();
        }
        if (this.manifestFetcher != null) {
            this.manifestFetcher.enable();
        }
    }

    @Override
    public void continueBuffering(long l) {
        if (this.manifestFetcher == null || !this.currentManifest.isLive || this.fatalError != null) {
            return;
        }
        SmoothStreamingManifest smoothStreamingManifest = this.manifestFetcher.getManifest();
        if (this.currentManifest != smoothStreamingManifest && smoothStreamingManifest != null) {
            long l2;
            long l3;
            SmoothStreamingManifest.StreamElement streamElement = this.currentManifest.streamElements[this.enabledTrack.elementIndex];
            int n = streamElement.chunkCount;
            SmoothStreamingManifest.StreamElement streamElement2 = smoothStreamingManifest.streamElements[this.enabledTrack.elementIndex];
            this.currentManifestChunkOffset = n == 0 || streamElement2.chunkCount == 0 ? (this.currentManifestChunkOffset += n) : ((l3 = streamElement.getStartTimeUs(n - 1) + streamElement.getChunkDurationUs(n - 1)) <= (l2 = streamElement2.getStartTimeUs(0)) ? (this.currentManifestChunkOffset += n) : (this.currentManifestChunkOffset += streamElement.getChunkIndex(l2)));
            this.currentManifest = smoothStreamingManifest;
            this.needManifestRefresh = false;
        }
        if (this.needManifestRefresh && SystemClock.elapsedRealtime() > this.manifestFetcher.getManifestLoadStartTimestamp() + 5000L) {
            this.manifestFetcher.requestRefresh();
        }
    }

    @Override
    public final void getChunkOperation(List<? extends MediaChunk> list, long l, ChunkOperationHolder chunkOperationHolder) {
        int n;
        if (this.fatalError != null) {
            chunkOperationHolder.chunk = null;
            return;
        }
        this.evaluation.queueSize = list.size();
        if (this.enabledTrack.isAdaptive()) {
            this.adaptiveFormatEvaluator.evaluate(list, l, this.enabledTrack.adaptiveFormats, this.evaluation);
        } else {
            this.evaluation.format = this.enabledTrack.fixedFormat;
            this.evaluation.trigger = 2;
        }
        Format format = this.evaluation.format;
        chunkOperationHolder.queueSize = this.evaluation.queueSize;
        if (format == null) {
            chunkOperationHolder.chunk = null;
            return;
        }
        if (chunkOperationHolder.queueSize == list.size() && chunkOperationHolder.chunk != null && chunkOperationHolder.chunk.format.equals(format)) {
            return;
        }
        chunkOperationHolder.chunk = null;
        SmoothStreamingManifest.StreamElement streamElement = this.currentManifest.streamElements[this.enabledTrack.elementIndex];
        if (streamElement.chunkCount == 0) {
            if (this.currentManifest.isLive) {
                this.needManifestRefresh = true;
            } else {
                chunkOperationHolder.endOfStream = true;
            }
            return;
        }
        if (list.isEmpty()) {
            if (this.live) {
                l = SmoothStreamingChunkSource.getLiveSeekPosition(this.currentManifest, this.liveEdgeLatencyUs);
            }
            n = streamElement.getChunkIndex(l);
        } else {
            MediaChunk mediaChunk = list.get(chunkOperationHolder.queueSize - 1);
            n = mediaChunk.chunkIndex + 1 - this.currentManifestChunkOffset;
        }
        if (this.live && n < 0) {
            this.fatalError = new BehindLiveWindowException();
            return;
        }
        if (this.currentManifest.isLive) {
            if (n >= streamElement.chunkCount) {
                this.needManifestRefresh = true;
                return;
            }
            if (n == streamElement.chunkCount - 1) {
                this.needManifestRefresh = true;
            }
        } else if (n >= streamElement.chunkCount) {
            chunkOperationHolder.endOfStream = true;
            return;
        }
        boolean bl = !this.currentManifest.isLive && n == streamElement.chunkCount - 1;
        long l2 = streamElement.getStartTimeUs(n);
        long l3 = bl ? -1L : l2 + streamElement.getChunkDurationUs(n);
        int n2 = n + this.currentManifestChunkOffset;
        int n3 = SmoothStreamingChunkSource.getManifestTrackIndex(streamElement, format);
        int n4 = SmoothStreamingChunkSource.getManifestTrackKey(this.enabledTrack.elementIndex, n3);
        Uri uri = streamElement.buildRequestUri(n3, n);
        MediaChunk mediaChunk = SmoothStreamingChunkSource.newMediaChunk(format, uri, null, (ChunkExtractorWrapper)this.extractorWrappers.get(n4), this.drmInitData, this.dataSource, n2, l2, l3, this.evaluation.trigger, (MediaFormat)this.mediaFormats.get(n4), this.enabledTrack.adaptiveMaxWidth, this.enabledTrack.adaptiveMaxHeight);
        chunkOperationHolder.chunk = mediaChunk;
    }

    @Override
    public void onChunkLoadCompleted(Chunk chunk) {
    }

    @Override
    public void onChunkLoadError(Chunk chunk, Exception exception) {
    }

    @Override
    public void disable(List<? extends MediaChunk> list) {
        if (this.enabledTrack.isAdaptive()) {
            this.adaptiveFormatEvaluator.disable();
        }
        if (this.manifestFetcher != null) {
            this.manifestFetcher.disable();
        }
        this.evaluation.format = null;
        this.fatalError = null;
    }

    @Override
    public void adaptiveTrack(SmoothStreamingManifest smoothStreamingManifest, int n, int[] nArray) {
        if (this.adaptiveFormatEvaluator == null) {
            return;
        }
        MediaFormat mediaFormat = null;
        SmoothStreamingManifest.StreamElement streamElement = smoothStreamingManifest.streamElements[n];
        int n2 = -1;
        int n3 = -1;
        Format[] formatArray = new Format[nArray.length];
        for (int i = 0; i < formatArray.length; ++i) {
            int n4 = nArray[i];
            formatArray[i] = streamElement.tracks[n4].format;
            MediaFormat mediaFormat2 = this.initManifestTrack(smoothStreamingManifest, n, n4);
            if (mediaFormat == null || mediaFormat2.height > n3) {
                mediaFormat = mediaFormat2;
            }
            n2 = Math.max(n2, mediaFormat2.width);
            n3 = Math.max(n3, mediaFormat2.height);
        }
        Arrays.sort(formatArray, new Format.DecreasingBandwidthComparator());
        MediaFormat mediaFormat3 = mediaFormat.copyAsAdaptive(null);
        this.tracks.add(new ExposedTrack(mediaFormat3, n, formatArray, n2, n3));
    }

    @Override
    public void fixedTrack(SmoothStreamingManifest smoothStreamingManifest, int n, int n2) {
        MediaFormat mediaFormat = this.initManifestTrack(smoothStreamingManifest, n, n2);
        Format format = smoothStreamingManifest.streamElements[n].tracks[n2].format;
        this.tracks.add(new ExposedTrack(mediaFormat, n, format));
    }

    private MediaFormat initManifestTrack(SmoothStreamingManifest smoothStreamingManifest, int n, int n2) {
        List<Object> list;
        int n3;
        int n4 = SmoothStreamingChunkSource.getManifestTrackKey(n, n2);
        MediaFormat mediaFormat = (MediaFormat)this.mediaFormats.get(n4);
        if (mediaFormat != null) {
            return mediaFormat;
        }
        long l = this.live ? -1L : smoothStreamingManifest.durationUs;
        SmoothStreamingManifest.StreamElement streamElement = smoothStreamingManifest.streamElements[n];
        Format format = streamElement.tracks[n2].format;
        byte[][] byArray = streamElement.tracks[n2].csd;
        switch (streamElement.type) {
            case 1: {
                mediaFormat = MediaFormat.createVideoFormat(format.id, format.mimeType, format.bitrate, -1, l, format.width, format.height, Arrays.asList(byArray));
                n3 = Track.TYPE_vide;
                break;
            }
            case 0: {
                list = byArray != null ? Arrays.asList(byArray) : Collections.singletonList(CodecSpecificDataUtil.buildAacAudioSpecificConfig(format.audioSamplingRate, format.audioChannels));
                mediaFormat = MediaFormat.createAudioFormat(format.id, format.mimeType, format.bitrate, -1, l, format.audioChannels, format.audioSamplingRate, list, format.language);
                n3 = Track.TYPE_soun;
                break;
            }
            case 2: {
                mediaFormat = MediaFormat.createTextFormat(format.id, format.mimeType, format.bitrate, l, format.language);
                n3 = Track.TYPE_text;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type: " + streamElement.type);
            }
        }
        list = new Track(n2, n3, streamElement.timescale, -1L, l, mediaFormat, this.trackEncryptionBoxes, n3 == Track.TYPE_vide ? 4 : -1, null, null);
        FragmentedMp4Extractor fragmentedMp4Extractor = new FragmentedMp4Extractor(3, (Track)((Object)list));
        this.mediaFormats.put(n4, (Object)mediaFormat);
        this.extractorWrappers.put(n4, (Object)new ChunkExtractorWrapper(fragmentedMp4Extractor));
        return mediaFormat;
    }

    private static long getLiveSeekPosition(SmoothStreamingManifest smoothStreamingManifest, long l) {
        long l2 = Long.MIN_VALUE;
        for (int i = 0; i < smoothStreamingManifest.streamElements.length; ++i) {
            SmoothStreamingManifest.StreamElement streamElement = smoothStreamingManifest.streamElements[i];
            if (streamElement.chunkCount <= 0) continue;
            long l3 = streamElement.getStartTimeUs(streamElement.chunkCount - 1) + streamElement.getChunkDurationUs(streamElement.chunkCount - 1);
            l2 = Math.max(l2, l3);
        }
        return l2 - l;
    }

    private static int getManifestTrackIndex(SmoothStreamingManifest.StreamElement streamElement, Format format) {
        SmoothStreamingManifest.TrackElement[] trackElementArray = streamElement.tracks;
        for (int i = 0; i < trackElementArray.length; ++i) {
            if (!trackElementArray[i].format.equals(format)) continue;
            return i;
        }
        throw new IllegalStateException("Invalid format: " + format);
    }

    private static MediaChunk newMediaChunk(Format format, Uri uri, String string, ChunkExtractorWrapper chunkExtractorWrapper, DrmInitData drmInitData, DataSource dataSource, int n, long l, long l2, int n2, MediaFormat mediaFormat, int n3, int n4) {
        long l3 = 0L;
        DataSpec dataSpec = new DataSpec(uri, l3, -1L, string);
        return new ContainerMediaChunk(dataSource, dataSpec, n2, format, l, l2, n, l, chunkExtractorWrapper, mediaFormat, n3, n4, drmInitData, true, -1);
    }

    private static int getManifestTrackKey(int n, int n2) {
        Assertions.checkState(n <= 65536 && n2 <= 65536);
        return n << 16 | n2;
    }

    private static byte[] getProtectionElementKeyId(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; i += 2) {
            stringBuilder.append((char)byArray[i]);
        }
        String string = stringBuilder.toString();
        String string2 = string.substring(string.indexOf("<KID>") + 5, string.indexOf("</KID>"));
        byte[] byArray2 = Base64.decode((String)string2, (int)0);
        SmoothStreamingChunkSource.swap(byArray2, 0, 3);
        SmoothStreamingChunkSource.swap(byArray2, 1, 2);
        SmoothStreamingChunkSource.swap(byArray2, 4, 5);
        SmoothStreamingChunkSource.swap(byArray2, 6, 7);
        return byArray2;
    }

    private static void swap(byte[] byArray, int n, int n2) {
        byte by = byArray[n];
        byArray[n] = byArray[n2];
        byArray[n2] = by;
    }

    private static final class ExposedTrack {
        public final MediaFormat trackFormat;
        private final int elementIndex;
        private final Format fixedFormat;
        private final Format[] adaptiveFormats;
        private final int adaptiveMaxWidth;
        private final int adaptiveMaxHeight;

        public ExposedTrack(MediaFormat mediaFormat, int n, Format format) {
            this.trackFormat = mediaFormat;
            this.elementIndex = n;
            this.fixedFormat = format;
            this.adaptiveFormats = null;
            this.adaptiveMaxWidth = -1;
            this.adaptiveMaxHeight = -1;
        }

        public ExposedTrack(MediaFormat mediaFormat, int n, Format[] formatArray, int n2, int n3) {
            this.trackFormat = mediaFormat;
            this.elementIndex = n;
            this.adaptiveFormats = formatArray;
            this.adaptiveMaxWidth = n2;
            this.adaptiveMaxHeight = n3;
            this.fixedFormat = null;
        }

        public boolean isAdaptive() {
            return this.adaptiveFormats != null;
        }
    }
}

