/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.webm;

import com.google.android.exoplayer.extractor.ExtractorInput;
import java.io.IOException;

final class VarintReader {
    private static final int STATE_BEGIN_READING = 0;
    private static final int STATE_READ_CONTENTS = 1;
    private static final long[] VARINT_LENGTH_MASKS = new long[]{128L, 64L, 32L, 16L, 8L, 4L, 2L, 1L};
    private final byte[] scratch = new byte[8];
    private int state;
    private int length;

    public void reset() {
        this.state = 0;
        this.length = 0;
    }

    public long readUnsignedVarint(ExtractorInput extractorInput, boolean bl, boolean bl2, int n) throws IOException, InterruptedException {
        if (this.state == 0) {
            if (!extractorInput.readFully(this.scratch, 0, 1, bl)) {
                return -1L;
            }
            int n2 = this.scratch[0] & 0xFF;
            this.length = VarintReader.parseUnsignedVarintLength(n2);
            if (this.length == -1) {
                throw new IllegalStateException("No valid varint length mask found");
            }
            this.state = 1;
        }
        if (this.length > n) {
            this.state = 0;
            return -2L;
        }
        if (this.length != 1) {
            extractorInput.readFully(this.scratch, 1, this.length - 1);
        }
        this.state = 0;
        return VarintReader.assembleVarint(this.scratch, this.length, bl2);
    }

    public int getLastLength() {
        return this.length;
    }

    public static int parseUnsignedVarintLength(int n) {
        int n2 = -1;
        for (int i = 0; i < VARINT_LENGTH_MASKS.length; ++i) {
            if ((VARINT_LENGTH_MASKS[i] & (long)n) == 0L) continue;
            n2 = i + 1;
            break;
        }
        return n2;
    }

    public static long assembleVarint(byte[] byArray, int n, boolean bl) {
        long l = (long)byArray[0] & 0xFFL;
        if (bl) {
            l &= VARINT_LENGTH_MASKS[n - 1] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        for (int i = 1; i < n; ++i) {
            l = l << 8 | (long)byArray[i] & 0xFFL;
        }
        return l;
    }
}

