/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.ts;

public final class PtsTimestampAdjuster {
    public static final long DO_NOT_OFFSET = Long.MAX_VALUE;
    private static final long MAX_PTS_PLUS_ONE = 0x200000000L;
    private final long firstSampleTimestampUs;
    private long timestampOffsetUs;
    private volatile long lastPts;

    public PtsTimestampAdjuster(long l) {
        this.firstSampleTimestampUs = l;
        this.lastPts = Long.MIN_VALUE;
    }

    public void reset() {
        this.lastPts = Long.MIN_VALUE;
    }

    public boolean isInitialized() {
        return this.lastPts != Long.MIN_VALUE;
    }

    public long adjustTimestamp(long l) {
        long l2;
        if (this.lastPts != Long.MIN_VALUE) {
            l2 = (this.lastPts + 0x100000000L) / 0x200000000L;
            long l3 = l + 0x200000000L * (l2 - 1L);
            long l4 = l + 0x200000000L * l2;
            l = Math.abs(l3 - this.lastPts) < Math.abs(l4 - this.lastPts) ? l3 : l4;
        }
        l2 = PtsTimestampAdjuster.ptsToUs(l);
        if (this.firstSampleTimestampUs != Long.MAX_VALUE && this.lastPts == Long.MIN_VALUE) {
            this.timestampOffsetUs = this.firstSampleTimestampUs - l2;
        }
        this.lastPts = l;
        return l2 + this.timestampOffsetUs;
    }

    public static long ptsToUs(long l) {
        return l * 1000000L / 90000L;
    }

    public static long usToPts(long l) {
        return l * 90000L / 1000000L;
    }
}

