/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.dash.mpd;

import java.util.Locale;

public final class UrlTemplate {
    private static final String REPRESENTATION = "RepresentationID";
    private static final String NUMBER = "Number";
    private static final String BANDWIDTH = "Bandwidth";
    private static final String TIME = "Time";
    private static final String ESCAPED_DOLLAR = "$$";
    private static final String DEFAULT_FORMAT_TAG = "%01d";
    private static final int REPRESENTATION_ID = 1;
    private static final int NUMBER_ID = 2;
    private static final int BANDWIDTH_ID = 3;
    private static final int TIME_ID = 4;
    private final String[] urlPieces;
    private final int[] identifiers;
    private final String[] identifierFormatTags;
    private final int identifierCount;

    public static UrlTemplate compile(String string) {
        String[] stringArray = new String[5];
        int[] nArray = new int[4];
        String[] stringArray2 = new String[4];
        int n = UrlTemplate.parseTemplate(string, stringArray, nArray, stringArray2);
        return new UrlTemplate(stringArray, nArray, stringArray2, n);
    }

    private UrlTemplate(String[] stringArray, int[] nArray, String[] stringArray2, int n) {
        this.urlPieces = stringArray;
        this.identifiers = nArray;
        this.identifierFormatTags = stringArray2;
        this.identifierCount = n;
    }

    public String buildUri(String string, int n, int n2, long l) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.identifierCount; ++i) {
            stringBuilder.append(this.urlPieces[i]);
            if (this.identifiers[i] == 1) {
                stringBuilder.append(string);
                continue;
            }
            if (this.identifiers[i] == 2) {
                stringBuilder.append(String.format(Locale.US, this.identifierFormatTags[i], n));
                continue;
            }
            if (this.identifiers[i] == 3) {
                stringBuilder.append(String.format(Locale.US, this.identifierFormatTags[i], n2));
                continue;
            }
            if (this.identifiers[i] != 4) continue;
            stringBuilder.append(String.format(Locale.US, this.identifierFormatTags[i], l));
        }
        stringBuilder.append(this.urlPieces[this.identifierCount]);
        return stringBuilder.toString();
    }

    private static int parseTemplate(String string, String[] stringArray, int[] nArray, String[] stringArray2) {
        stringArray[0] = "";
        int n = 0;
        int n2 = 0;
        while (n < string.length()) {
            int n3 = string.indexOf("$", n);
            if (n3 == -1) {
                int n4 = n2;
                stringArray[n4] = stringArray[n4] + string.substring(n);
                n = string.length();
                continue;
            }
            if (n3 != n) {
                int n5 = n2;
                stringArray[n5] = stringArray[n5] + string.substring(n, n3);
                n = n3;
                continue;
            }
            if (string.startsWith(ESCAPED_DOLLAR, n)) {
                int n6 = n2;
                stringArray[n6] = stringArray[n6] + "$";
                n += 2;
                continue;
            }
            int n7 = string.indexOf("$", n + 1);
            String string2 = string.substring(n + 1, n7);
            if (string2.equals(REPRESENTATION)) {
                nArray[n2] = 1;
            } else {
                int n8 = string2.indexOf("%0");
                String string3 = DEFAULT_FORMAT_TAG;
                if (n8 != -1) {
                    string3 = string2.substring(n8);
                    if (!string3.endsWith("d")) {
                        string3 = string3 + "d";
                    }
                    string2 = string2.substring(0, n8);
                }
                if (string2.equals(NUMBER)) {
                    nArray[n2] = 2;
                } else if (string2.equals(BANDWIDTH)) {
                    nArray[n2] = 3;
                } else if (string2.equals(TIME)) {
                    nArray[n2] = 4;
                } else {
                    throw new IllegalArgumentException("Invalid template: " + string);
                }
                stringArray2[n2] = string3;
            }
            stringArray[++n2] = "";
            n = n7 + 1;
        }
        return n2;
    }
}

