/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.dash;

import android.os.Handler;
import android.util.SparseArray;
import com.google.android.exoplayer.BehindLiveWindowException;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.TimeRange;
import com.google.android.exoplayer.chunk.Chunk;
import com.google.android.exoplayer.chunk.ChunkExtractorWrapper;
import com.google.android.exoplayer.chunk.ChunkOperationHolder;
import com.google.android.exoplayer.chunk.ChunkSource;
import com.google.android.exoplayer.chunk.ContainerMediaChunk;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.chunk.FormatEvaluator;
import com.google.android.exoplayer.chunk.InitializationChunk;
import com.google.android.exoplayer.chunk.MediaChunk;
import com.google.android.exoplayer.chunk.SingleSampleMediaChunk;
import com.google.android.exoplayer.dash.DashSegmentIndex;
import com.google.android.exoplayer.dash.DashTrackSelector;
import com.google.android.exoplayer.dash.DashWrappingSegmentIndex;
import com.google.android.exoplayer.dash.mpd.AdaptationSet;
import com.google.android.exoplayer.dash.mpd.ContentProtection;
import com.google.android.exoplayer.dash.mpd.MediaPresentationDescription;
import com.google.android.exoplayer.dash.mpd.Period;
import com.google.android.exoplayer.dash.mpd.RangedUri;
import com.google.android.exoplayer.dash.mpd.Representation;
import com.google.android.exoplayer.drm.DrmInitData;
import com.google.android.exoplayer.extractor.ChunkIndex;
import com.google.android.exoplayer.extractor.mp4.FragmentedMp4Extractor;
import com.google.android.exoplayer.extractor.webm.WebmExtractor;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.util.Clock;
import com.google.android.exoplayer.util.ManifestFetcher;
import com.google.android.exoplayer.util.MimeTypes;
import com.google.android.exoplayer.util.SystemClock;
import com.vcc.playerwrappersdk.a;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class DashChunkSource
implements ChunkSource,
DashTrackSelector.Output {
    private static final String TAG = "DashChunkSource";
    private final Handler eventHandler;
    private final EventListener eventListener;
    private final DataSource dataSource;
    private final FormatEvaluator adaptiveFormatEvaluator;
    private final FormatEvaluator.Evaluation evaluation;
    private final ManifestFetcher<MediaPresentationDescription> manifestFetcher;
    private final DashTrackSelector trackSelector;
    private final ArrayList<ExposedTrack> tracks;
    private final SparseArray<PeriodHolder> periodHolders;
    private final Clock systemClock;
    private final long liveEdgeLatencyUs;
    private final long elapsedRealtimeOffsetUs;
    private final long[] availableRangeValues;
    private final boolean live;
    private final int eventSourceId;
    private MediaPresentationDescription currentManifest;
    private MediaPresentationDescription processedManifest;
    private ExposedTrack enabledTrack;
    private int nextPeriodHolderIndex;
    private TimeRange availableRange;
    private boolean prepareCalled;
    private boolean startAtLiveEdge;
    private boolean lastChunkWasInitialization;
    private IOException fatalError;

    public DashChunkSource(DashTrackSelector dashTrackSelector, DataSource dataSource, FormatEvaluator formatEvaluator, long l, int n, Representation ... representationArray) {
        this(dashTrackSelector, dataSource, formatEvaluator, l, n, Arrays.asList(representationArray));
    }

    public DashChunkSource(DashTrackSelector dashTrackSelector, DataSource dataSource, FormatEvaluator formatEvaluator, long l, int n, List<Representation> list) {
        this(DashChunkSource.buildManifest(l, n, list), dashTrackSelector, dataSource, formatEvaluator);
    }

    public DashChunkSource(MediaPresentationDescription mediaPresentationDescription, DashTrackSelector dashTrackSelector, DataSource dataSource, FormatEvaluator formatEvaluator) {
        this(null, mediaPresentationDescription, dashTrackSelector, dataSource, formatEvaluator, new SystemClock(), 0L, 0L, false, null, null, 0);
    }

    public DashChunkSource(ManifestFetcher<MediaPresentationDescription> manifestFetcher, DashTrackSelector dashTrackSelector, DataSource dataSource, FormatEvaluator formatEvaluator, long l, long l2, Handler handler, EventListener eventListener, int n) {
        this(manifestFetcher, manifestFetcher.getManifest(), dashTrackSelector, dataSource, formatEvaluator, new SystemClock(), l * 1000L, l2 * 1000L, true, handler, eventListener, n);
    }

    public DashChunkSource(ManifestFetcher<MediaPresentationDescription> manifestFetcher, DashTrackSelector dashTrackSelector, DataSource dataSource, FormatEvaluator formatEvaluator, long l, long l2, boolean bl, Handler handler, EventListener eventListener, int n) {
        this(manifestFetcher, manifestFetcher.getManifest(), dashTrackSelector, dataSource, formatEvaluator, new SystemClock(), l * 1000L, l2 * 1000L, bl, handler, eventListener, n);
    }

    DashChunkSource(ManifestFetcher<MediaPresentationDescription> manifestFetcher, MediaPresentationDescription mediaPresentationDescription, DashTrackSelector dashTrackSelector, DataSource dataSource, FormatEvaluator formatEvaluator, Clock clock, long l, long l2, boolean bl, Handler handler, EventListener eventListener, int n) {
        this.manifestFetcher = manifestFetcher;
        this.currentManifest = mediaPresentationDescription;
        this.trackSelector = dashTrackSelector;
        this.dataSource = dataSource;
        this.adaptiveFormatEvaluator = formatEvaluator;
        this.systemClock = clock;
        this.liveEdgeLatencyUs = l;
        this.elapsedRealtimeOffsetUs = l2;
        this.startAtLiveEdge = bl;
        this.eventHandler = handler;
        this.eventListener = eventListener;
        this.eventSourceId = n;
        this.evaluation = new FormatEvaluator.Evaluation();
        this.availableRangeValues = new long[2];
        this.periodHolders = new SparseArray();
        this.tracks = new ArrayList();
        this.live = mediaPresentationDescription.dynamic;
    }

    @Override
    public void maybeThrowError() throws IOException {
        if (this.fatalError != null) {
            throw this.fatalError;
        }
        if (this.manifestFetcher != null) {
            this.manifestFetcher.maybeThrowError();
        }
    }

    @Override
    public boolean prepare() {
        if (!this.prepareCalled) {
            this.prepareCalled = true;
            try {
                this.trackSelector.selectTracks(this.currentManifest, 0, this);
            }
            catch (IOException iOException) {
                this.fatalError = iOException;
            }
        }
        return this.fatalError == null;
    }

    @Override
    public int getTrackCount() {
        return this.tracks.size();
    }

    @Override
    public final MediaFormat getFormat(int n) {
        return this.tracks.get((int)n).trackFormat;
    }

    @Override
    public void enable(int n) {
        this.enabledTrack = this.tracks.get(n);
        if (this.enabledTrack.isAdaptive()) {
            this.adaptiveFormatEvaluator.enable();
        }
        if (this.manifestFetcher != null) {
            this.manifestFetcher.enable();
            this.processManifest(this.manifestFetcher.getManifest());
        } else {
            this.processManifest(this.currentManifest);
        }
    }

    @Override
    public void continueBuffering(long l) {
        long l2;
        if (this.manifestFetcher == null || !this.currentManifest.dynamic || this.fatalError != null) {
            return;
        }
        MediaPresentationDescription mediaPresentationDescription = this.manifestFetcher.getManifest();
        if (mediaPresentationDescription != null && mediaPresentationDescription != this.processedManifest) {
            this.processManifest(mediaPresentationDescription);
            this.processedManifest = mediaPresentationDescription;
        }
        if ((l2 = this.currentManifest.minUpdatePeriod) == 0L) {
            l2 = 5000L;
        }
        if (android.os.SystemClock.elapsedRealtime() > this.manifestFetcher.getManifestLoadStartTimestamp() + l2) {
            this.manifestFetcher.requestRefresh();
        }
    }

    @Override
    public final void getChunkOperation(List<? extends MediaChunk> list, long l, ChunkOperationHolder chunkOperationHolder) {
        Object object;
        Object object2;
        Object object3;
        boolean bl;
        PeriodHolder periodHolder;
        if (this.fatalError != null) {
            chunkOperationHolder.chunk = null;
            return;
        }
        this.evaluation.queueSize = list.size();
        if (this.evaluation.format == null || !this.lastChunkWasInitialization) {
            if (this.enabledTrack.isAdaptive()) {
                this.adaptiveFormatEvaluator.evaluate(list, l, this.enabledTrack.adaptiveFormats, this.evaluation);
            } else {
                this.evaluation.format = this.enabledTrack.fixedFormat;
                this.evaluation.trigger = 2;
            }
        }
        Format format = this.evaluation.format;
        chunkOperationHolder.queueSize = this.evaluation.queueSize;
        if (format == null) {
            chunkOperationHolder.chunk = null;
            return;
        }
        if (chunkOperationHolder.queueSize == list.size() && chunkOperationHolder.chunk != null && chunkOperationHolder.chunk.format.equals(format)) {
            return;
        }
        chunkOperationHolder.chunk = null;
        this.availableRange.getCurrentBoundsUs(this.availableRangeValues);
        if (list.isEmpty()) {
            if (this.live) {
                if (this.startAtLiveEdge) {
                    l = Math.max(this.availableRangeValues[0], this.availableRangeValues[1] - this.liveEdgeLatencyUs);
                } else {
                    l = Math.min(l, this.availableRangeValues[1] - 1L);
                    l = Math.max(l, this.availableRangeValues[0]);
                }
            }
            periodHolder = this.findPeriodHolder(l);
            bl = true;
        } else {
            if (this.startAtLiveEdge) {
                this.startAtLiveEdge = false;
            }
            object3 = list.get(chunkOperationHolder.queueSize - 1);
            long l2 = ((MediaChunk)object3).endTimeUs;
            if (this.live && l2 < this.availableRangeValues[0]) {
                this.fatalError = new BehindLiveWindowException();
                return;
            }
            if (this.currentManifest.dynamic && l2 >= this.availableRangeValues[1]) {
                return;
            }
            object2 = (PeriodHolder)this.periodHolders.valueAt(this.periodHolders.size() - 1);
            if (((MediaChunk)object3).parentId == ((PeriodHolder)object2).localIndex && ((RepresentationHolder)(object = ((PeriodHolder)object2).representationHolders.get(((MediaChunk)object3).format.id))).isBeyondLastSegment(((MediaChunk)object3).getNextChunkIndex())) {
                if (!this.currentManifest.dynamic) {
                    chunkOperationHolder.endOfStream = true;
                }
                return;
            }
            bl = false;
            periodHolder = (PeriodHolder)this.periodHolders.get(((MediaChunk)object3).parentId);
            if (periodHolder == null) {
                periodHolder = (PeriodHolder)this.periodHolders.valueAt(0);
                bl = true;
            } else if (!periodHolder.isIndexUnbounded() && ((RepresentationHolder)(object2 = periodHolder.representationHolders.get(((MediaChunk)object3).format.id))).isBeyondLastSegment(((MediaChunk)object3).getNextChunkIndex())) {
                periodHolder = (PeriodHolder)this.periodHolders.get(((MediaChunk)object3).parentId + 1);
                bl = true;
            }
        }
        object3 = periodHolder.representationHolders.get(format.id);
        Representation representation = ((RepresentationHolder)object3).representation;
        RangedUri rangedUri = null;
        object2 = null;
        object = ((RepresentationHolder)object3).mediaFormat;
        if (object == null) {
            rangedUri = representation.getInitializationUri();
        }
        if (((RepresentationHolder)object3).segmentIndex == null) {
            object2 = representation.getIndexUri();
        }
        if (rangedUri != null || object2 != null) {
            Chunk chunk = this.newInitializationChunk(rangedUri, (RangedUri)object2, representation, ((RepresentationHolder)object3).extractorWrapper, this.dataSource, periodHolder.localIndex, this.evaluation.trigger);
            this.lastChunkWasInitialization = true;
            chunkOperationHolder.chunk = chunk;
            return;
        }
        int n = list.isEmpty() ? ((RepresentationHolder)object3).getSegmentNum(l) : (bl ? ((RepresentationHolder)object3).getFirstAvailableSegmentNum() : list.get(chunkOperationHolder.queueSize - 1).getNextChunkIndex());
        Chunk chunk = this.newMediaChunk(periodHolder, (RepresentationHolder)object3, this.dataSource, (MediaFormat)object, this.enabledTrack, n, this.evaluation.trigger);
        this.lastChunkWasInitialization = false;
        chunkOperationHolder.chunk = chunk;
    }

    @Override
    public void onChunkLoadCompleted(Chunk chunk) {
        if (chunk instanceof InitializationChunk) {
            InitializationChunk initializationChunk = (InitializationChunk)chunk;
            String string = initializationChunk.format.id;
            PeriodHolder periodHolder = (PeriodHolder)this.periodHolders.get(initializationChunk.parentId);
            if (periodHolder == null) {
                return;
            }
            RepresentationHolder representationHolder = periodHolder.representationHolders.get(string);
            if (initializationChunk.hasFormat()) {
                representationHolder.mediaFormat = initializationChunk.getFormat();
            }
            if (representationHolder.segmentIndex == null && initializationChunk.hasSeekMap()) {
                representationHolder.segmentIndex = new DashWrappingSegmentIndex((ChunkIndex)initializationChunk.getSeekMap(), initializationChunk.dataSpec.uri.toString());
            }
            if (periodHolder.drmInitData == null && initializationChunk.hasDrmInitData()) {
                periodHolder.drmInitData = initializationChunk.getDrmInitData();
            }
        }
    }

    @Override
    public void onChunkLoadError(Chunk chunk, Exception exception) {
    }

    @Override
    public void disable(List<? extends MediaChunk> list) {
        if (this.enabledTrack.isAdaptive()) {
            this.adaptiveFormatEvaluator.disable();
        }
        if (this.manifestFetcher != null) {
            this.manifestFetcher.disable();
        }
        this.periodHolders.clear();
        this.evaluation.format = null;
        this.availableRange = null;
        this.fatalError = null;
        this.enabledTrack = null;
    }

    @Override
    public void adaptiveTrack(MediaPresentationDescription mediaPresentationDescription, int n, int n2, int[] nArray) {
        if (this.adaptiveFormatEvaluator == null) {
            a.c(TAG, "Skipping adaptive track (missing format evaluator)");
            return;
        }
        AdaptationSet adaptationSet = mediaPresentationDescription.getPeriod((int)n).adaptationSets.get(n2);
        int n3 = 0;
        int n4 = 0;
        Format format = null;
        Format[] formatArray = new Format[nArray.length];
        for (int i = 0; i < formatArray.length; ++i) {
            Format format2 = adaptationSet.representations.get((int)nArray[i]).format;
            if (format == null || format2.height > n4) {
                format = format2;
            }
            n3 = Math.max(n3, format2.width);
            n4 = Math.max(n4, format2.height);
            formatArray[i] = format2;
        }
        Arrays.sort(formatArray, new Format.DecreasingBandwidthComparator());
        long l = this.live ? -1L : mediaPresentationDescription.duration * 1000L;
        String string = DashChunkSource.getMediaMimeType(format);
        if (string == null) {
            a.c(TAG, "Skipped adaptive track (unknown media mime type)");
            return;
        }
        MediaFormat mediaFormat = DashChunkSource.getTrackFormat(adaptationSet.type, format, string, l);
        if (mediaFormat == null) {
            a.c(TAG, "Skipped adaptive track (unknown media format)");
            return;
        }
        this.tracks.add(new ExposedTrack(mediaFormat.copyAsAdaptive(null), n2, formatArray, n3, n4));
    }

    @Override
    public void fixedTrack(MediaPresentationDescription mediaPresentationDescription, int n, int n2, int n3) {
        List<AdaptationSet> list = mediaPresentationDescription.getPeriod((int)n).adaptationSets;
        AdaptationSet adaptationSet = list.get(n2);
        Format format = adaptationSet.representations.get((int)n3).format;
        String string = DashChunkSource.getMediaMimeType(format);
        if (string == null) {
            a.c(TAG, "Skipped track " + format.id + " (unknown media mime type)");
            return;
        }
        MediaFormat mediaFormat = DashChunkSource.getTrackFormat(adaptationSet.type, format, string, mediaPresentationDescription.dynamic ? -1L : mediaPresentationDescription.duration * 1000L);
        if (mediaFormat == null) {
            a.c(TAG, "Skipped track " + format.id + " (unknown media format)");
            return;
        }
        this.tracks.add(new ExposedTrack(mediaFormat, n2, format));
    }

    TimeRange getAvailableRange() {
        return this.availableRange;
    }

    private static MediaPresentationDescription buildManifest(long l, int n, List<Representation> list) {
        AdaptationSet adaptationSet = new AdaptationSet(0, n, list);
        Period period = new Period(null, 0L, Collections.singletonList(adaptationSet));
        return new MediaPresentationDescription(-1L, l, -1L, false, -1L, -1L, null, null, Collections.singletonList(period));
    }

    private static MediaFormat getTrackFormat(int n, Format format, String string, long l) {
        switch (n) {
            case 0: {
                return MediaFormat.createVideoFormat(format.id, string, format.bitrate, -1, l, format.width, format.height, null);
            }
            case 1: {
                return MediaFormat.createAudioFormat(format.id, string, format.bitrate, -1, l, format.audioChannels, format.audioSamplingRate, null, format.language);
            }
            case 2: {
                return MediaFormat.createTextFormat(format.id, string, format.bitrate, l, format.language);
            }
        }
        return null;
    }

    private static String getMediaMimeType(Format format) {
        String string = format.mimeType;
        if (MimeTypes.isAudio(string)) {
            return MimeTypes.getAudioMediaMimeType(format.codecs);
        }
        if (MimeTypes.isVideo(string)) {
            return MimeTypes.getVideoMediaMimeType(format.codecs);
        }
        if (DashChunkSource.mimeTypeIsRawText(string)) {
            return string;
        }
        if ("application/mp4".equals(string)) {
            if ("stpp".equals(format.codecs)) {
                return "application/ttml+xml";
            }
            if ("wvtt".equals(format.codecs)) {
                return "application/x-mp4vtt";
            }
        }
        return null;
    }

    static boolean mimeTypeIsWebm(String string) {
        return string.startsWith("video/webm") || string.startsWith("audio/webm") || string.startsWith("application/webm");
    }

    static boolean mimeTypeIsRawText(String string) {
        return "text/vtt".equals(string) || "application/ttml+xml".equals(string);
    }

    private Chunk newInitializationChunk(RangedUri rangedUri, RangedUri rangedUri2, Representation representation, ChunkExtractorWrapper chunkExtractorWrapper, DataSource dataSource, int n, int n2) {
        RangedUri rangedUri3;
        if (rangedUri != null) {
            rangedUri3 = rangedUri.attemptMerge(rangedUri2);
            if (rangedUri3 == null) {
                rangedUri3 = rangedUri;
            }
        } else {
            rangedUri3 = rangedUri2;
        }
        DataSpec dataSpec = new DataSpec(rangedUri3.getUri(), rangedUri3.start, rangedUri3.length, representation.getCacheKey());
        return new InitializationChunk(dataSource, dataSpec, n2, representation.format, chunkExtractorWrapper, n);
    }

    protected Chunk newMediaChunk(PeriodHolder periodHolder, RepresentationHolder representationHolder, DataSource dataSource, MediaFormat mediaFormat, ExposedTrack exposedTrack, int n, int n2) {
        Representation representation = representationHolder.representation;
        Format format = representation.format;
        long l = representationHolder.getSegmentStartTimeUs(n);
        long l2 = representationHolder.getSegmentEndTimeUs(n);
        RangedUri rangedUri = representationHolder.getSegmentUrl(n);
        DataSpec dataSpec = new DataSpec(rangedUri.getUri(), rangedUri.start, rangedUri.length, representation.getCacheKey());
        long l3 = periodHolder.startTimeUs - representation.presentationTimeOffsetUs;
        if (DashChunkSource.mimeTypeIsRawText(format.mimeType)) {
            return new SingleSampleMediaChunk(dataSource, dataSpec, 1, format, l, l2, n, exposedTrack.trackFormat, null, periodHolder.localIndex);
        }
        boolean bl = mediaFormat != null;
        return new ContainerMediaChunk(dataSource, dataSpec, n2, format, l, l2, n, l3, representationHolder.extractorWrapper, mediaFormat, exposedTrack.adaptiveMaxWidth, exposedTrack.adaptiveMaxHeight, periodHolder.drmInitData, bl, periodHolder.localIndex);
    }

    private long getNowUnixTimeUs() {
        if (this.elapsedRealtimeOffsetUs != 0L) {
            return this.systemClock.elapsedRealtime() * 1000L + this.elapsedRealtimeOffsetUs;
        }
        return System.currentTimeMillis() * 1000L;
    }

    private PeriodHolder findPeriodHolder(long l) {
        if (l < ((PeriodHolder)this.periodHolders.valueAt(0)).getAvailableStartTimeUs()) {
            return (PeriodHolder)this.periodHolders.valueAt(0);
        }
        for (int i = 0; i < this.periodHolders.size() - 1; ++i) {
            PeriodHolder periodHolder = (PeriodHolder)this.periodHolders.valueAt(i);
            if (l >= periodHolder.getAvailableEndTimeUs()) continue;
            return periodHolder;
        }
        return (PeriodHolder)this.periodHolders.valueAt(this.periodHolders.size() - 1);
    }

    private void processManifest(MediaPresentationDescription mediaPresentationDescription) {
        int n;
        Period period = mediaPresentationDescription.getPeriod(0);
        while (this.periodHolders.size() > 0 && ((PeriodHolder)this.periodHolders.valueAt((int)0)).startTimeUs < period.startMs * 1000L) {
            PeriodHolder periodHolder = (PeriodHolder)this.periodHolders.valueAt(0);
            this.periodHolders.remove(periodHolder.localIndex);
        }
        if (this.periodHolders.size() > mediaPresentationDescription.getPeriodCount()) {
            return;
        }
        try {
            n = this.periodHolders.size();
            if (n > 0) {
                ((PeriodHolder)this.periodHolders.valueAt(0)).updatePeriod(mediaPresentationDescription, 0, this.enabledTrack);
                if (n > 1) {
                    int n2 = n - 1;
                    ((PeriodHolder)this.periodHolders.valueAt(n2)).updatePeriod(mediaPresentationDescription, n2, this.enabledTrack);
                }
            }
        }
        catch (BehindLiveWindowException behindLiveWindowException) {
            this.fatalError = behindLiveWindowException;
            return;
        }
        for (n = this.periodHolders.size(); n < mediaPresentationDescription.getPeriodCount(); ++n) {
            PeriodHolder periodHolder = new PeriodHolder(this.nextPeriodHolderIndex, mediaPresentationDescription, n, this.enabledTrack);
            this.periodHolders.put(this.nextPeriodHolderIndex, (Object)periodHolder);
            ++this.nextPeriodHolderIndex;
        }
        TimeRange timeRange = this.getAvailableRange(this.getNowUnixTimeUs());
        if (this.availableRange == null || !this.availableRange.equals(timeRange)) {
            this.availableRange = timeRange;
            this.notifyAvailableRangeChanged(this.availableRange);
        }
        this.currentManifest = mediaPresentationDescription;
    }

    private TimeRange getAvailableRange(long l) {
        PeriodHolder periodHolder = (PeriodHolder)this.periodHolders.valueAt(0);
        PeriodHolder periodHolder2 = (PeriodHolder)this.periodHolders.valueAt(this.periodHolders.size() - 1);
        if (!this.currentManifest.dynamic || periodHolder2.isIndexExplicit()) {
            return new TimeRange.StaticTimeRange(periodHolder.getAvailableStartTimeUs(), periodHolder2.getAvailableEndTimeUs());
        }
        long l2 = periodHolder.getAvailableStartTimeUs();
        long l3 = periodHolder2.isIndexUnbounded() ? Long.MAX_VALUE : periodHolder2.getAvailableEndTimeUs();
        long l4 = this.systemClock.elapsedRealtime() * 1000L - (l - this.currentManifest.availabilityStartTime * 1000L);
        long l5 = this.currentManifest.timeShiftBufferDepth == -1L ? -1L : this.currentManifest.timeShiftBufferDepth * 1000L;
        return new TimeRange.DynamicTimeRange(l2, l3, l4, l5, this.systemClock);
    }

    private void notifyAvailableRangeChanged(final TimeRange timeRange) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    DashChunkSource.this.eventListener.onAvailableRangeChanged(DashChunkSource.this.eventSourceId, timeRange);
                }
            });
        }
    }

    protected static final class PeriodHolder {
        public final int localIndex;
        public final long startTimeUs;
        public final HashMap<String, RepresentationHolder> representationHolders;
        private final int[] representationIndices;
        private DrmInitData drmInitData;
        private boolean indexIsUnbounded;
        private boolean indexIsExplicit;
        private long availableStartTimeUs;
        private long availableEndTimeUs;

        public PeriodHolder(int n, MediaPresentationDescription mediaPresentationDescription, int n2, ExposedTrack exposedTrack) {
            int n3;
            this.localIndex = n;
            Period period = mediaPresentationDescription.getPeriod(n2);
            long l = PeriodHolder.getPeriodDurationUs(mediaPresentationDescription, n2);
            AdaptationSet adaptationSet = period.adaptationSets.get(exposedTrack.adaptationSetIndex);
            List<Representation> list = adaptationSet.representations;
            this.startTimeUs = period.startMs * 1000L;
            this.drmInitData = PeriodHolder.getDrmInitData(adaptationSet);
            if (!exposedTrack.isAdaptive()) {
                this.representationIndices = new int[]{PeriodHolder.getRepresentationIndex(list, ((ExposedTrack)exposedTrack).fixedFormat.id)};
            } else {
                this.representationIndices = new int[exposedTrack.adaptiveFormats.length];
                for (n3 = 0; n3 < exposedTrack.adaptiveFormats.length; ++n3) {
                    this.representationIndices[n3] = PeriodHolder.getRepresentationIndex(list, ((ExposedTrack)exposedTrack).adaptiveFormats[n3].id);
                }
            }
            this.representationHolders = new HashMap();
            for (n3 = 0; n3 < this.representationIndices.length; ++n3) {
                Representation representation = list.get(this.representationIndices[n3]);
                RepresentationHolder representationHolder = new RepresentationHolder(this.startTimeUs, l, representation);
                this.representationHolders.put(representation.format.id, representationHolder);
            }
            this.updateRepresentationIndependentProperties(l, list.get(this.representationIndices[0]));
        }

        public void updatePeriod(MediaPresentationDescription mediaPresentationDescription, int n, ExposedTrack exposedTrack) throws BehindLiveWindowException {
            Period period = mediaPresentationDescription.getPeriod(n);
            long l = PeriodHolder.getPeriodDurationUs(mediaPresentationDescription, n);
            List<Representation> list = period.adaptationSets.get((int)((ExposedTrack)exposedTrack).adaptationSetIndex).representations;
            for (int i = 0; i < this.representationIndices.length; ++i) {
                Representation representation = list.get(this.representationIndices[i]);
                this.representationHolders.get(representation.format.id).updateRepresentation(l, representation);
            }
            this.updateRepresentationIndependentProperties(l, list.get(this.representationIndices[0]));
        }

        public long getAvailableStartTimeUs() {
            return this.availableStartTimeUs;
        }

        public long getAvailableEndTimeUs() {
            if (this.isIndexUnbounded()) {
                throw new IllegalStateException("Period has unbounded index");
            }
            return this.availableEndTimeUs;
        }

        public boolean isIndexUnbounded() {
            return this.indexIsUnbounded;
        }

        public boolean isIndexExplicit() {
            return this.indexIsExplicit;
        }

        public DrmInitData getDrmInitData() {
            return this.drmInitData;
        }

        private void updateRepresentationIndependentProperties(long l, Representation representation) {
            DashSegmentIndex dashSegmentIndex = representation.getIndex();
            if (dashSegmentIndex != null) {
                int n = dashSegmentIndex.getFirstSegmentNum();
                int n2 = dashSegmentIndex.getLastSegmentNum(l);
                this.indexIsUnbounded = n2 == -1;
                this.indexIsExplicit = dashSegmentIndex.isExplicit();
                this.availableStartTimeUs = this.startTimeUs + dashSegmentIndex.getTimeUs(n);
                if (!this.indexIsUnbounded) {
                    this.availableEndTimeUs = this.startTimeUs + dashSegmentIndex.getTimeUs(n2) + dashSegmentIndex.getDurationUs(n2, l);
                }
            } else {
                this.indexIsUnbounded = false;
                this.indexIsExplicit = true;
                this.availableStartTimeUs = this.startTimeUs;
                this.availableEndTimeUs = this.startTimeUs + l;
            }
        }

        private static int getRepresentationIndex(List<Representation> list, String string) {
            for (int i = 0; i < list.size(); ++i) {
                Representation representation = list.get(i);
                if (!string.equals(representation.format.id)) continue;
                return i;
            }
            throw new IllegalStateException("Missing format id: " + string);
        }

        private static DrmInitData getDrmInitData(AdaptationSet adaptationSet) {
            if (adaptationSet.contentProtections.isEmpty()) {
                return null;
            }
            DrmInitData.Mapped mapped = null;
            for (int i = 0; i < adaptationSet.contentProtections.size(); ++i) {
                ContentProtection contentProtection = adaptationSet.contentProtections.get(i);
                if (contentProtection.uuid == null || contentProtection.data == null) continue;
                if (mapped == null) {
                    mapped = new DrmInitData.Mapped();
                }
                mapped.put(contentProtection.uuid, contentProtection.data);
            }
            return mapped;
        }

        private static long getPeriodDurationUs(MediaPresentationDescription mediaPresentationDescription, int n) {
            long l = mediaPresentationDescription.getPeriodDuration(n);
            if (l == -1L) {
                return -1L;
            }
            return l * 1000L;
        }
    }

    protected static final class RepresentationHolder {
        public final boolean mimeTypeIsRawText;
        public final ChunkExtractorWrapper extractorWrapper;
        public Representation representation;
        public DashSegmentIndex segmentIndex;
        public MediaFormat mediaFormat;
        private final long periodStartTimeUs;
        private long periodDurationUs;
        private int segmentNumShift;

        public RepresentationHolder(long l, long l2, Representation representation) {
            this.periodStartTimeUs = l;
            this.periodDurationUs = l2;
            this.representation = representation;
            String string = representation.format.mimeType;
            this.mimeTypeIsRawText = DashChunkSource.mimeTypeIsRawText(string);
            this.extractorWrapper = this.mimeTypeIsRawText ? null : new ChunkExtractorWrapper(DashChunkSource.mimeTypeIsWebm(string) ? new WebmExtractor() : new FragmentedMp4Extractor());
            this.segmentIndex = representation.getIndex();
        }

        public void updateRepresentation(long l, Representation representation) throws BehindLiveWindowException {
            int n;
            long l2;
            DashSegmentIndex dashSegmentIndex = this.representation.getIndex();
            DashSegmentIndex dashSegmentIndex2 = representation.getIndex();
            this.periodDurationUs = l;
            this.representation = representation;
            if (dashSegmentIndex == null) {
                return;
            }
            this.segmentIndex = dashSegmentIndex2;
            if (!dashSegmentIndex.isExplicit()) {
                return;
            }
            int n2 = dashSegmentIndex.getLastSegmentNum(this.periodDurationUs);
            long l3 = dashSegmentIndex.getTimeUs(n2) + dashSegmentIndex.getDurationUs(n2, this.periodDurationUs);
            if (l3 == (l2 = dashSegmentIndex2.getTimeUs(n = dashSegmentIndex2.getFirstSegmentNum()))) {
                this.segmentNumShift += dashSegmentIndex.getLastSegmentNum(this.periodDurationUs) + 1 - n;
            } else {
                if (l3 < l2) {
                    throw new BehindLiveWindowException();
                }
                this.segmentNumShift += dashSegmentIndex.getSegmentNum(l2, this.periodDurationUs) - n;
            }
        }

        public int getSegmentNum(long l) {
            return this.segmentIndex.getSegmentNum(l - this.periodStartTimeUs, this.periodDurationUs) + this.segmentNumShift;
        }

        public long getSegmentStartTimeUs(int n) {
            return this.segmentIndex.getTimeUs(n - this.segmentNumShift) + this.periodStartTimeUs;
        }

        public long getSegmentEndTimeUs(int n) {
            return this.getSegmentStartTimeUs(n) + this.segmentIndex.getDurationUs(n - this.segmentNumShift, this.periodDurationUs);
        }

        public int getLastSegmentNum() {
            return this.segmentIndex.getLastSegmentNum(this.periodDurationUs);
        }

        public boolean isBeyondLastSegment(int n) {
            int n2 = this.getLastSegmentNum();
            return n2 == -1 ? false : n > n2 + this.segmentNumShift;
        }

        public int getFirstAvailableSegmentNum() {
            return this.segmentIndex.getFirstSegmentNum() + this.segmentNumShift;
        }

        public RangedUri getSegmentUrl(int n) {
            return this.segmentIndex.getSegmentUrl(n - this.segmentNumShift);
        }
    }

    protected static final class ExposedTrack {
        public final MediaFormat trackFormat;
        public final int adaptiveMaxWidth;
        public final int adaptiveMaxHeight;
        private final int adaptationSetIndex;
        private final Format fixedFormat;
        private final Format[] adaptiveFormats;

        public ExposedTrack(MediaFormat mediaFormat, int n, Format format) {
            this.trackFormat = mediaFormat;
            this.adaptationSetIndex = n;
            this.fixedFormat = format;
            this.adaptiveFormats = null;
            this.adaptiveMaxWidth = -1;
            this.adaptiveMaxHeight = -1;
        }

        public ExposedTrack(MediaFormat mediaFormat, int n, Format[] formatArray, int n2, int n3) {
            this.trackFormat = mediaFormat;
            this.adaptationSetIndex = n;
            this.adaptiveFormats = formatArray;
            this.adaptiveMaxWidth = n2;
            this.adaptiveMaxHeight = n3;
            this.fixedFormat = null;
        }

        public boolean isAdaptive() {
            return this.adaptiveFormats != null;
        }
    }

    public static class NoAdaptationSetException
    extends IOException {
        public NoAdaptationSetException(String string) {
            super(string);
        }
    }

    public static interface EventListener {
        public void onAvailableRangeChanged(int var1, TimeRange var2);
    }
}

