/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.chunk;

import com.google.android.exoplayer.util.Assertions;
import java.util.Comparator;

public class Format {
    public final String id;
    public final String mimeType;
    public final int bitrate;
    public final int width;
    public final int height;
    public final float frameRate;
    public final int audioChannels;
    public final int audioSamplingRate;
    public final String codecs;
    public final String language;

    public Format(String string, String string2, int n, int n2, float f2, int n3, int n4, int n5) {
        this(string, string2, n, n2, f2, n3, n4, n5, null);
    }

    public Format(String string, String string2, int n, int n2, float f2, int n3, int n4, int n5, String string3) {
        this(string, string2, n, n2, f2, n3, n4, n5, string3, null);
    }

    public Format(String string, String string2, int n, int n2, float f2, int n3, int n4, int n5, String string3, String string4) {
        this.id = Assertions.checkNotNull(string);
        this.mimeType = string2;
        this.width = n;
        this.height = n2;
        this.frameRate = f2;
        this.audioChannels = n3;
        this.audioSamplingRate = n4;
        this.bitrate = n5;
        this.language = string3;
        this.codecs = string4;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Format format = (Format)object;
        return format.id.equals(this.id);
    }

    public static final class DecreasingBandwidthComparator
    implements Comparator<Format> {
        @Override
        public int compare(Format format, Format format2) {
            return format2.bitrate - format.bitrate;
        }
    }
}

