/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.audio;

import android.annotation.TargetApi;
import android.media.AudioTimestamp;
import android.media.MediaFormat;
import android.media.PlaybackParams;
import android.os.ConditionVariable;
import android.os.SystemClock;
import com.google.android.exoplayer.C;
import com.google.android.exoplayer.audio.AudioCapabilities;
import com.google.android.exoplayer.util.Ac3Util;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.DtsUtil;
import com.google.android.exoplayer.util.Util;
import com.vcc.playerwrappersdk.a;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public final class AudioTrack {
    public static final int RESULT_POSITION_DISCONTINUITY = 1;
    public static final int RESULT_BUFFER_CONSUMED = 2;
    public static final int SESSION_ID_NOT_SET = 0;
    public static final long CURRENT_POSITION_NOT_SET = Long.MIN_VALUE;
    private static final long MIN_BUFFER_DURATION_US = 250000L;
    private static final long MAX_BUFFER_DURATION_US = 750000L;
    private static final long PASSTHROUGH_BUFFER_DURATION_US = 250000L;
    private static final int BUFFER_MULTIPLICATION_FACTOR = 4;
    private static final String TAG = "AudioTrack";
    private static final long MAX_AUDIO_TIMESTAMP_OFFSET_US = 5000000L;
    private static final long MAX_LATENCY_US = 5000000L;
    private static final int START_NOT_SET = 0;
    private static final int START_IN_SYNC = 1;
    private static final int START_NEED_SYNC = 2;
    private static final int MAX_PLAYHEAD_OFFSET_COUNT = 10;
    private static final int MIN_PLAYHEAD_OFFSET_SAMPLE_INTERVAL_US = 30000;
    private static final int MIN_TIMESTAMP_SAMPLE_INTERVAL_US = 500000;
    public static boolean enablePreV21AudioSessionWorkaround = false;
    public static boolean failOnSpuriousAudioTimestamp = false;
    private final AudioCapabilities audioCapabilities;
    private final int streamType;
    private final ConditionVariable releasingConditionVariable;
    private final long[] playheadOffsets;
    private final AudioTrackUtil audioTrackUtil;
    private android.media.AudioTrack keepSessionIdAudioTrack;
    private android.media.AudioTrack audioTrack;
    private int sampleRate;
    private int channelConfig;
    private int encoding;
    private boolean passthrough;
    private int pcmFrameSize;
    private int bufferSize;
    private long bufferSizeUs;
    private int nextPlayheadOffsetIndex;
    private int playheadOffsetCount;
    private long smoothedPlayheadOffsetUs;
    private long lastPlayheadSampleTimeUs;
    private boolean audioTimestampSet;
    private long lastTimestampSampleTimeUs;
    private Method getLatencyMethod;
    private long submittedPcmBytes;
    private long submittedEncodedFrames;
    private int framesPerEncodedSample;
    private int startMediaTimeState;
    private long startMediaTimeUs;
    private long resumeSystemTimeUs;
    private long latencyUs;
    private float volume;
    private byte[] temporaryBuffer;
    private int temporaryBufferOffset;
    private int bufferBytesRemaining;

    public AudioTrack() {
        this(null, 3);
    }

    public AudioTrack(AudioCapabilities audioCapabilities, int n) {
        this.audioCapabilities = audioCapabilities;
        this.streamType = n;
        this.releasingConditionVariable = new ConditionVariable(true);
        if (Util.SDK_INT >= 18) {
            try {
                this.getLatencyMethod = android.media.AudioTrack.class.getMethod("getLatency", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        this.audioTrackUtil = Util.SDK_INT >= 23 ? new AudioTrackUtilV23() : (Util.SDK_INT >= 19 ? new AudioTrackUtilV19() : new AudioTrackUtil());
        this.playheadOffsets = new long[10];
        this.volume = 1.0f;
        this.startMediaTimeState = 0;
    }

    public boolean isPassthroughSupported(String string) {
        return this.audioCapabilities != null && this.audioCapabilities.supportsEncoding(AudioTrack.getEncodingForMimeType(string));
    }

    public boolean isInitialized() {
        return this.audioTrack != null;
    }

    public long getCurrentPositionUs(boolean bl) {
        long l;
        if (!this.hasCurrentPositionUs()) {
            return Long.MIN_VALUE;
        }
        if (this.audioTrack.getPlayState() == 3) {
            this.maybeSampleSyncParams();
        }
        long l2 = System.nanoTime() / 1000L;
        if (this.audioTimestampSet) {
            long l3 = l2 - this.audioTrackUtil.getTimestampNanoTime() / 1000L;
            long l4 = (long)((float)l3 * this.audioTrackUtil.getPlaybackSpeed());
            long l5 = this.durationUsToFrames(l4);
            long l6 = this.audioTrackUtil.getTimestampFramePosition() + l5;
            l = this.framesToDurationUs(l6) + this.startMediaTimeUs;
        } else {
            l = this.playheadOffsetCount == 0 ? this.audioTrackUtil.getPlaybackHeadPositionUs() + this.startMediaTimeUs : l2 + this.smoothedPlayheadOffsetUs + this.startMediaTimeUs;
            if (!bl) {
                l -= this.latencyUs;
            }
        }
        return l;
    }

    public void configure(MediaFormat mediaFormat, boolean bl) {
        this.configure(mediaFormat, bl, 0);
    }

    public void configure(MediaFormat mediaFormat, boolean bl, int n) {
        int n2;
        int n3;
        int n4 = mediaFormat.getInteger("channel-count");
        switch (n4) {
            case 1: {
                n3 = 4;
                break;
            }
            case 2: {
                n3 = 12;
                break;
            }
            case 3: {
                n3 = 28;
                break;
            }
            case 4: {
                n3 = 204;
                break;
            }
            case 5: {
                n3 = 220;
                break;
            }
            case 6: {
                n3 = 252;
                break;
            }
            case 7: {
                n3 = 1276;
                break;
            }
            case 8: {
                n3 = C.CHANNEL_OUT_7POINT1_SURROUND;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported channel count: " + n4);
            }
        }
        int n5 = mediaFormat.getInteger("sample-rate");
        String string = mediaFormat.getString("mime");
        int n6 = n2 = bl ? AudioTrack.getEncodingForMimeType(string) : 2;
        if (this.isInitialized() && this.sampleRate == n5 && this.channelConfig == n3 && this.encoding == n2) {
            return;
        }
        this.reset();
        this.encoding = n2;
        this.passthrough = bl;
        this.sampleRate = n5;
        this.channelConfig = n3;
        this.pcmFrameSize = 2 * n4;
        if (n != 0) {
            this.bufferSize = n;
        } else if (bl) {
            this.bufferSize = n2 == 5 || n2 == 6 ? 20480 : 49152;
        } else {
            int n7 = android.media.AudioTrack.getMinBufferSize((int)n5, (int)n3, (int)n2);
            Assertions.checkState(n7 != -2);
            int n8 = n7 * 4;
            int n9 = (int)this.durationUsToFrames(250000L) * this.pcmFrameSize;
            int n10 = (int)Math.max((long)n7, this.durationUsToFrames(750000L) * (long)this.pcmFrameSize);
            this.bufferSize = n8 < n9 ? n9 : (n8 > n10 ? n10 : n8);
        }
        this.bufferSizeUs = bl ? -1L : this.framesToDurationUs(this.pcmBytesToFrames(this.bufferSize));
    }

    public int initialize() throws InitializationException {
        return this.initialize(0);
    }

    public int initialize(int n) throws InitializationException {
        this.releasingConditionVariable.block();
        this.audioTrack = n == 0 ? new android.media.AudioTrack(this.streamType, this.sampleRate, this.channelConfig, this.encoding, this.bufferSize, 1) : new android.media.AudioTrack(this.streamType, this.sampleRate, this.channelConfig, this.encoding, this.bufferSize, 1, n);
        this.checkAudioTrackInitialized();
        n = this.audioTrack.getAudioSessionId();
        if (enablePreV21AudioSessionWorkaround && Util.SDK_INT < 21) {
            if (this.keepSessionIdAudioTrack != null && n != this.keepSessionIdAudioTrack.getAudioSessionId()) {
                this.releaseKeepSessionIdAudioTrack();
            }
            if (this.keepSessionIdAudioTrack == null) {
                int n2 = 4000;
                int n3 = 4;
                int n4 = 2;
                int n5 = 2;
                this.keepSessionIdAudioTrack = new android.media.AudioTrack(this.streamType, n2, n3, n4, n5, 0, n);
            }
        }
        this.audioTrackUtil.reconfigure(this.audioTrack, this.needsPassthroughWorkarounds());
        this.setAudioTrackVolume();
        return n;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public long getBufferSizeUs() {
        return this.bufferSizeUs;
    }

    public void play() {
        if (this.isInitialized()) {
            this.resumeSystemTimeUs = System.nanoTime() / 1000L;
            this.audioTrack.play();
        }
    }

    public void handleDiscontinuity() {
        if (this.startMediaTimeState == 1) {
            this.startMediaTimeState = 2;
        }
    }

    public int handleBuffer(ByteBuffer byteBuffer, int n, int n2, long l) throws WriteException {
        if (n2 == 0) {
            return 2;
        }
        if (this.needsPassthroughWorkarounds()) {
            if (this.audioTrack.getPlayState() == 2) {
                return 0;
            }
            if (this.audioTrack.getPlayState() == 1 && this.audioTrackUtil.getPlaybackHeadPosition() != 0L) {
                return 0;
            }
        }
        int n3 = 0;
        if (this.bufferBytesRemaining == 0) {
            this.bufferBytesRemaining = n2;
            byteBuffer.position(n);
            if (this.passthrough && this.framesPerEncodedSample == 0) {
                this.framesPerEncodedSample = AudioTrack.getFramesPerEncodedSample(this.encoding, byteBuffer);
            }
            long l2 = this.passthrough ? (long)this.framesPerEncodedSample : this.pcmBytesToFrames(n2);
            long l3 = this.framesToDurationUs(l2);
            long l4 = l - l3;
            if (this.startMediaTimeState == 0) {
                this.startMediaTimeUs = Math.max(0L, l4);
                this.startMediaTimeState = 1;
            } else {
                long l5 = this.startMediaTimeUs + this.framesToDurationUs(this.getSubmittedFrames());
                if (this.startMediaTimeState == 1 && Math.abs(l5 - l4) > 200000L) {
                    a.d(TAG, "Discontinuity detected [expected " + l5 + ", got " + l4 + "]");
                    this.startMediaTimeState = 2;
                }
                if (this.startMediaTimeState == 2) {
                    this.startMediaTimeUs += l4 - l5;
                    this.startMediaTimeState = 1;
                    n3 |= 1;
                }
            }
            if (Util.SDK_INT < 21) {
                if (this.temporaryBuffer == null || this.temporaryBuffer.length < n2) {
                    this.temporaryBuffer = new byte[n2];
                }
                byteBuffer.get(this.temporaryBuffer, 0, n2);
                this.temporaryBufferOffset = 0;
            }
        }
        int n4 = 0;
        if (Util.SDK_INT < 21) {
            int n5 = (int)(this.submittedPcmBytes - this.audioTrackUtil.getPlaybackHeadPosition() * (long)this.pcmFrameSize);
            int n6 = this.bufferSize - n5;
            if (n6 > 0 && (n4 = this.audioTrack.write(this.temporaryBuffer, this.temporaryBufferOffset, n6 = Math.min(this.bufferBytesRemaining, n6))) >= 0) {
                this.temporaryBufferOffset += n4;
            }
        } else {
            n4 = AudioTrack.writeNonBlockingV21(this.audioTrack, byteBuffer, this.bufferBytesRemaining);
        }
        if (n4 < 0) {
            throw new WriteException(n4);
        }
        this.bufferBytesRemaining -= n4;
        if (!this.passthrough) {
            this.submittedPcmBytes += (long)n4;
        }
        if (this.bufferBytesRemaining == 0) {
            if (this.passthrough) {
                this.submittedEncodedFrames += (long)this.framesPerEncodedSample;
            }
            n3 |= 2;
        }
        return n3;
    }

    public void handleEndOfStream() {
        if (this.isInitialized()) {
            this.audioTrackUtil.handleEndOfStream(this.getSubmittedFrames());
        }
    }

    @TargetApi(value=21)
    private static int writeNonBlockingV21(android.media.AudioTrack audioTrack, ByteBuffer byteBuffer, int n) {
        return audioTrack.write(byteBuffer, n, 1);
    }

    public boolean hasPendingData() {
        return this.isInitialized() && (this.getSubmittedFrames() > this.audioTrackUtil.getPlaybackHeadPosition() || this.overrideHasPendingData());
    }

    public void setPlaybackParams(PlaybackParams playbackParams) {
        this.audioTrackUtil.setPlaybackParameters(playbackParams);
    }

    public void setVolume(float f2) {
        if (this.volume != f2) {
            this.volume = f2;
            this.setAudioTrackVolume();
        }
    }

    public float getCurrentVolume() {
        return this.volume;
    }

    private void setAudioTrackVolume() {
        if (this.isInitialized()) {
            if (Util.SDK_INT >= 21) {
                AudioTrack.setAudioTrackVolumeV21(this.audioTrack, this.volume);
            } else {
                AudioTrack.setAudioTrackVolumeV3(this.audioTrack, this.volume);
            }
        }
    }

    @TargetApi(value=21)
    private static void setAudioTrackVolumeV21(android.media.AudioTrack audioTrack, float f2) {
        audioTrack.setVolume(f2);
    }

    private static void setAudioTrackVolumeV3(android.media.AudioTrack audioTrack, float f2) {
        audioTrack.setStereoVolume(f2, f2);
    }

    public void pause() {
        if (this.isInitialized()) {
            this.resetSyncParams();
            this.audioTrackUtil.pause();
        }
    }

    public void reset() {
        if (this.isInitialized()) {
            this.submittedPcmBytes = 0L;
            this.submittedEncodedFrames = 0L;
            this.framesPerEncodedSample = 0;
            this.bufferBytesRemaining = 0;
            this.startMediaTimeState = 0;
            this.latencyUs = 0L;
            this.resetSyncParams();
            int n = this.audioTrack.getPlayState();
            if (n == 3) {
                this.audioTrack.pause();
            }
            final android.media.AudioTrack audioTrack = this.audioTrack;
            this.audioTrack = null;
            this.audioTrackUtil.reconfigure(null, false);
            this.releasingConditionVariable.close();
            new Thread(){

                @Override
                public void run() {
                    try {
                        audioTrack.flush();
                        audioTrack.release();
                    }
                    finally {
                        AudioTrack.this.releasingConditionVariable.open();
                    }
                }
            }.start();
        }
    }

    public void release() {
        this.reset();
        this.releaseKeepSessionIdAudioTrack();
    }

    private void releaseKeepSessionIdAudioTrack() {
        if (this.keepSessionIdAudioTrack == null) {
            return;
        }
        final android.media.AudioTrack audioTrack = this.keepSessionIdAudioTrack;
        this.keepSessionIdAudioTrack = null;
        new Thread(){

            @Override
            public void run() {
                audioTrack.release();
            }
        }.start();
    }

    private boolean hasCurrentPositionUs() {
        return this.isInitialized() && this.startMediaTimeState != 0;
    }

    private void maybeSampleSyncParams() {
        long l = this.audioTrackUtil.getPlaybackHeadPositionUs();
        if (l == 0L) {
            return;
        }
        long l2 = System.nanoTime() / 1000L;
        if (l2 - this.lastPlayheadSampleTimeUs >= 30000L) {
            this.playheadOffsets[this.nextPlayheadOffsetIndex] = l - l2;
            this.nextPlayheadOffsetIndex = (this.nextPlayheadOffsetIndex + 1) % 10;
            if (this.playheadOffsetCount < 10) {
                ++this.playheadOffsetCount;
            }
            this.lastPlayheadSampleTimeUs = l2;
            this.smoothedPlayheadOffsetUs = 0L;
            for (int i = 0; i < this.playheadOffsetCount; ++i) {
                this.smoothedPlayheadOffsetUs += this.playheadOffsets[i] / (long)this.playheadOffsetCount;
            }
        }
        if (this.needsPassthroughWorkarounds()) {
            return;
        }
        if (l2 - this.lastTimestampSampleTimeUs >= 500000L) {
            this.audioTimestampSet = this.audioTrackUtil.updateTimestamp();
            if (this.audioTimestampSet) {
                long l3 = this.audioTrackUtil.getTimestampNanoTime() / 1000L;
                long l4 = this.audioTrackUtil.getTimestampFramePosition();
                if (l3 < this.resumeSystemTimeUs) {
                    this.audioTimestampSet = false;
                } else if (Math.abs(l3 - l2) > 5000000L) {
                    String string = "Spurious audio timestamp (system clock mismatch): " + l4 + ", " + l3 + ", " + l2 + ", " + l;
                    if (failOnSpuriousAudioTimestamp) {
                        throw new InvalidAudioTrackTimestampException(string);
                    }
                    a.c(TAG, string);
                    this.audioTimestampSet = false;
                } else if (Math.abs(this.framesToDurationUs(l4) - l) > 5000000L) {
                    String string = "Spurious audio timestamp (frame position mismatch): " + l4 + ", " + l3 + ", " + l2 + ", " + l;
                    if (failOnSpuriousAudioTimestamp) {
                        throw new InvalidAudioTrackTimestampException(string);
                    }
                    a.c(TAG, string);
                    this.audioTimestampSet = false;
                }
            }
            if (this.getLatencyMethod != null && !this.passthrough) {
                try {
                    this.latencyUs = (long)((Integer)this.getLatencyMethod.invoke((Object)this.audioTrack, (Object[])null)).intValue() * 1000L - this.bufferSizeUs;
                    this.latencyUs = Math.max(this.latencyUs, 0L);
                    if (this.latencyUs > 5000000L) {
                        a.c(TAG, "Ignoring impossibly large audio latency: " + this.latencyUs);
                        this.latencyUs = 0L;
                    }
                }
                catch (Exception exception) {
                    this.getLatencyMethod = null;
                }
            }
            this.lastTimestampSampleTimeUs = l2;
        }
    }

    private void checkAudioTrackInitialized() throws InitializationException {
        int n = this.audioTrack.getState();
        if (n == 1) {
            return;
        }
        try {
            this.audioTrack.release();
        }
        catch (Exception exception) {
        }
        finally {
            this.audioTrack = null;
        }
        throw new InitializationException(n, this.sampleRate, this.channelConfig, this.bufferSize);
    }

    private long pcmBytesToFrames(long l) {
        return l / (long)this.pcmFrameSize;
    }

    private long framesToDurationUs(long l) {
        return l * 1000000L / (long)this.sampleRate;
    }

    private long durationUsToFrames(long l) {
        return l * (long)this.sampleRate / 1000000L;
    }

    private long getSubmittedFrames() {
        return this.passthrough ? this.submittedEncodedFrames : this.pcmBytesToFrames(this.submittedPcmBytes);
    }

    private void resetSyncParams() {
        this.smoothedPlayheadOffsetUs = 0L;
        this.playheadOffsetCount = 0;
        this.nextPlayheadOffsetIndex = 0;
        this.lastPlayheadSampleTimeUs = 0L;
        this.audioTimestampSet = false;
        this.lastTimestampSampleTimeUs = 0L;
    }

    private boolean needsPassthroughWorkarounds() {
        return Util.SDK_INT < 23 && (this.encoding == 5 || this.encoding == 6);
    }

    private boolean overrideHasPendingData() {
        return this.needsPassthroughWorkarounds() && this.audioTrack.getPlayState() == 2 && this.audioTrack.getPlaybackHeadPosition() == 0;
    }

    private static int getEncodingForMimeType(String string) {
        switch (string) {
            case "audio/ac3": {
                return 5;
            }
            case "audio/eac3": {
                return 6;
            }
            case "audio/vnd.dts": {
                return 7;
            }
            case "audio/vnd.dts.hd": {
                return 8;
            }
        }
        return 0;
    }

    private static int getFramesPerEncodedSample(int n, ByteBuffer byteBuffer) {
        if (n == 7 || n == 8) {
            return DtsUtil.parseDtsAudioSampleCount(byteBuffer);
        }
        if (n == 5) {
            return Ac3Util.getAc3SyncframeAudioSampleCount();
        }
        if (n == 6) {
            return Ac3Util.parseEAc3SyncframeAudioSampleCount(byteBuffer);
        }
        throw new IllegalStateException("Unexpected audio encoding: " + n);
    }

    @TargetApi(value=23)
    private static class AudioTrackUtilV23
    extends AudioTrackUtilV19 {
        private PlaybackParams playbackParams;
        private float playbackSpeed = 1.0f;

        @Override
        public void reconfigure(android.media.AudioTrack audioTrack, boolean bl) {
            super.reconfigure(audioTrack, bl);
            this.maybeApplyPlaybackParams();
        }

        @Override
        public void setPlaybackParameters(PlaybackParams playbackParams) {
            this.playbackParams = playbackParams = (playbackParams != null ? playbackParams : new PlaybackParams()).allowDefaults();
            this.playbackSpeed = playbackParams.getSpeed();
            this.maybeApplyPlaybackParams();
        }

        @Override
        public float getPlaybackSpeed() {
            return this.playbackSpeed;
        }

        private void maybeApplyPlaybackParams() {
            if (this.audioTrack != null && this.playbackParams != null) {
                this.audioTrack.setPlaybackParams(this.playbackParams);
            }
        }
    }

    @TargetApi(value=19)
    private static class AudioTrackUtilV19
    extends AudioTrackUtil {
        private final AudioTimestamp audioTimestamp = new AudioTimestamp();
        private long rawTimestampFramePositionWrapCount;
        private long lastRawTimestampFramePosition;
        private long lastTimestampFramePosition;

        @Override
        public void reconfigure(android.media.AudioTrack audioTrack, boolean bl) {
            super.reconfigure(audioTrack, bl);
            this.rawTimestampFramePositionWrapCount = 0L;
            this.lastRawTimestampFramePosition = 0L;
            this.lastTimestampFramePosition = 0L;
        }

        @Override
        public boolean updateTimestamp() {
            boolean bl = this.audioTrack.getTimestamp(this.audioTimestamp);
            if (bl) {
                long l = this.audioTimestamp.framePosition;
                if (this.lastRawTimestampFramePosition > l) {
                    ++this.rawTimestampFramePositionWrapCount;
                }
                this.lastRawTimestampFramePosition = l;
                this.lastTimestampFramePosition = l + (this.rawTimestampFramePositionWrapCount << 32);
            }
            return bl;
        }

        @Override
        public long getTimestampNanoTime() {
            return this.audioTimestamp.nanoTime;
        }

        @Override
        public long getTimestampFramePosition() {
            return this.lastTimestampFramePosition;
        }
    }

    private static class AudioTrackUtil {
        protected android.media.AudioTrack audioTrack;
        private boolean needsPassthroughWorkaround;
        private int sampleRate;
        private long lastRawPlaybackHeadPosition;
        private long rawPlaybackHeadWrapCount;
        private long passthroughWorkaroundPauseOffset;
        private long stopTimestampUs;
        private long stopPlaybackHeadPosition;
        private long endPlaybackHeadPosition;

        private AudioTrackUtil() {
        }

        public void reconfigure(android.media.AudioTrack audioTrack, boolean bl) {
            this.audioTrack = audioTrack;
            this.needsPassthroughWorkaround = bl;
            this.stopTimestampUs = -1L;
            this.lastRawPlaybackHeadPosition = 0L;
            this.rawPlaybackHeadWrapCount = 0L;
            this.passthroughWorkaroundPauseOffset = 0L;
            if (audioTrack != null) {
                this.sampleRate = audioTrack.getSampleRate();
            }
        }

        public void handleEndOfStream(long l) {
            this.stopPlaybackHeadPosition = this.getPlaybackHeadPosition();
            this.stopTimestampUs = SystemClock.elapsedRealtime() * 1000L;
            this.endPlaybackHeadPosition = l;
            this.audioTrack.stop();
        }

        public void pause() {
            if (this.stopTimestampUs != -1L) {
                return;
            }
            this.audioTrack.pause();
        }

        public long getPlaybackHeadPosition() {
            if (this.stopTimestampUs != -1L) {
                long l = SystemClock.elapsedRealtime() * 1000L - this.stopTimestampUs;
                long l2 = l * (long)this.sampleRate / 1000000L;
                return Math.min(this.endPlaybackHeadPosition, this.stopPlaybackHeadPosition + l2);
            }
            int n = this.audioTrack.getPlayState();
            if (n == 1) {
                return 0L;
            }
            long l = 0xFFFFFFFFL & (long)this.audioTrack.getPlaybackHeadPosition();
            if (this.needsPassthroughWorkaround) {
                if (n == 2 && l == 0L) {
                    this.passthroughWorkaroundPauseOffset = this.lastRawPlaybackHeadPosition;
                }
                l += this.passthroughWorkaroundPauseOffset;
            }
            if (this.lastRawPlaybackHeadPosition > l) {
                ++this.rawPlaybackHeadWrapCount;
            }
            this.lastRawPlaybackHeadPosition = l;
            return l + (this.rawPlaybackHeadWrapCount << 32);
        }

        public long getPlaybackHeadPositionUs() {
            return this.getPlaybackHeadPosition() * 1000000L / (long)this.sampleRate;
        }

        public boolean updateTimestamp() {
            return false;
        }

        public long getTimestampNanoTime() {
            throw new UnsupportedOperationException();
        }

        public long getTimestampFramePosition() {
            throw new UnsupportedOperationException();
        }

        public void setPlaybackParameters(PlaybackParams playbackParams) {
            throw new UnsupportedOperationException();
        }

        public float getPlaybackSpeed() {
            return 1.0f;
        }
    }

    public static final class InvalidAudioTrackTimestampException
    extends RuntimeException {
        public InvalidAudioTrackTimestampException(String string) {
            super(string);
        }
    }

    public static final class WriteException
    extends Exception {
        public final int errorCode;

        public WriteException(int n) {
            super("AudioTrack write failed: " + n);
            this.errorCode = n;
        }
    }

    public static final class InitializationException
    extends Exception {
        public final int audioTrackState;

        public InitializationException(int n, int n2, int n3, int n4) {
            super("AudioTrack init failed: " + n + ", Config(" + n2 + ", " + n3 + ", " + n4 + ")");
            this.audioTrackState = n;
        }
    }
}

