/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.net.Uri;
import android.os.Handler;
import android.os.SystemClock;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.Loader;
import com.google.android.exoplayer.util.Assertions;
import java.io.IOException;
import java.util.Arrays;

public final class SingleSampleSource
implements SampleSource,
SampleSource.SampleSourceReader,
Loader.Callback,
Loader.Loadable {
    public static final int DEFAULT_MIN_LOADABLE_RETRY_COUNT = 3;
    private static final int INITIAL_SAMPLE_SIZE = 1;
    private static final int STATE_SEND_FORMAT = 0;
    private static final int STATE_SEND_SAMPLE = 1;
    private static final int STATE_END_OF_STREAM = 2;
    private final Uri uri;
    private final DataSource dataSource;
    private final MediaFormat format;
    private final int minLoadableRetryCount;
    private final Handler eventHandler;
    private final EventListener eventListener;
    private final int eventSourceId;
    private int state;
    private byte[] sampleData;
    private int sampleSize;
    private long pendingDiscontinuityPositionUs;
    private boolean loadingFinished;
    private Loader loader;
    private IOException currentLoadableException;
    private int currentLoadableExceptionCount;
    private long currentLoadableExceptionTimestamp;

    public SingleSampleSource(Uri uri, DataSource dataSource, MediaFormat mediaFormat) {
        this(uri, dataSource, mediaFormat, 3);
    }

    public SingleSampleSource(Uri uri, DataSource dataSource, MediaFormat mediaFormat, int n) {
        this(uri, dataSource, mediaFormat, n, null, null, 0);
    }

    public SingleSampleSource(Uri uri, DataSource dataSource, MediaFormat mediaFormat, int n, Handler handler, EventListener eventListener, int n2) {
        this.uri = uri;
        this.dataSource = dataSource;
        this.format = mediaFormat;
        this.minLoadableRetryCount = n;
        this.eventHandler = handler;
        this.eventListener = eventListener;
        this.eventSourceId = n2;
        this.sampleData = new byte[1];
    }

    @Override
    public SampleSource.SampleSourceReader register() {
        return this;
    }

    @Override
    public boolean prepare(long l) {
        if (this.loader == null) {
            this.loader = new Loader("Loader:" + this.format.mimeType);
        }
        return true;
    }

    @Override
    public int getTrackCount() {
        return 1;
    }

    @Override
    public MediaFormat getFormat(int n) {
        return this.format;
    }

    @Override
    public void enable(int n, long l) {
        this.state = 0;
        this.pendingDiscontinuityPositionUs = Long.MIN_VALUE;
        this.clearCurrentLoadableException();
        this.maybeStartLoading();
    }

    @Override
    public boolean continueBuffering(int n, long l) {
        this.maybeStartLoading();
        return this.loadingFinished;
    }

    @Override
    public void maybeThrowError() throws IOException {
        if (this.currentLoadableException != null && this.currentLoadableExceptionCount > this.minLoadableRetryCount) {
            throw this.currentLoadableException;
        }
    }

    @Override
    public long readDiscontinuity(int n) {
        long l = this.pendingDiscontinuityPositionUs;
        this.pendingDiscontinuityPositionUs = Long.MIN_VALUE;
        return l;
    }

    @Override
    public int readData(int n, long l, MediaFormatHolder mediaFormatHolder, SampleHolder sampleHolder) {
        if (this.state == 2) {
            return -1;
        }
        if (this.state == 0) {
            mediaFormatHolder.format = this.format;
            this.state = 1;
            return -4;
        }
        Assertions.checkState(this.state == 1);
        if (!this.loadingFinished) {
            return -2;
        }
        sampleHolder.timeUs = 0L;
        sampleHolder.size = this.sampleSize;
        sampleHolder.flags = 1;
        sampleHolder.ensureSpaceForWrite(sampleHolder.size);
        sampleHolder.data.put(this.sampleData, 0, this.sampleSize);
        this.state = 2;
        return -3;
    }

    @Override
    public void seekToUs(long l) {
        if (this.state == 2) {
            this.pendingDiscontinuityPositionUs = l;
            this.state = 1;
        }
    }

    @Override
    public long getBufferedPositionUs() {
        return this.loadingFinished ? -3L : 0L;
    }

    @Override
    public void disable(int n) {
        this.state = 2;
    }

    @Override
    public void release() {
        if (this.loader != null) {
            this.loader.release();
            this.loader = null;
        }
    }

    private void maybeStartLoading() {
        if (this.loadingFinished || this.state == 2 || this.loader.isLoading()) {
            return;
        }
        if (this.currentLoadableException != null) {
            long l = SystemClock.elapsedRealtime() - this.currentLoadableExceptionTimestamp;
            if (l < this.getRetryDelayMillis(this.currentLoadableExceptionCount)) {
                return;
            }
            this.currentLoadableException = null;
        }
        this.loader.startLoading(this, this);
    }

    private void clearCurrentLoadableException() {
        this.currentLoadableException = null;
        this.currentLoadableExceptionCount = 0;
    }

    private long getRetryDelayMillis(long l) {
        return Math.min((l - 1L) * 1000L, 5000L);
    }

    @Override
    public void onLoadCompleted(Loader.Loadable loadable) {
        this.loadingFinished = true;
        this.clearCurrentLoadableException();
    }

    @Override
    public void onLoadCanceled(Loader.Loadable loadable) {
    }

    @Override
    public void onLoadError(Loader.Loadable loadable, IOException iOException) {
        this.currentLoadableException = iOException;
        ++this.currentLoadableExceptionCount;
        this.currentLoadableExceptionTimestamp = SystemClock.elapsedRealtime();
        this.notifyLoadError(iOException);
        this.maybeStartLoading();
    }

    @Override
    public void cancelLoad() {
    }

    @Override
    public boolean isLoadCanceled() {
        return false;
    }

    @Override
    public void load() throws IOException, InterruptedException {
        this.sampleSize = 0;
        try {
            this.dataSource.open(new DataSpec(this.uri));
            int n = 0;
            while (n != -1) {
                this.sampleSize += n;
                if (this.sampleSize == this.sampleData.length) {
                    this.sampleData = Arrays.copyOf(this.sampleData, this.sampleData.length * 2);
                }
                n = this.dataSource.read(this.sampleData, this.sampleSize, this.sampleData.length - this.sampleSize);
            }
        }
        finally {
            this.dataSource.close();
        }
    }

    private void notifyLoadError(final IOException iOException) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    SingleSampleSource.this.eventListener.onLoadError(SingleSampleSource.this.eventSourceId, iOException);
                }
            });
        }
    }

    public static interface EventListener {
        public void onLoadError(int var1, IOException var2);
    }
}

