/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.MediaCodecUtil;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.TrackRenderer;
import java.io.IOException;
import java.util.Arrays;

public abstract class SampleSourceTrackRenderer
extends TrackRenderer {
    private final SampleSource.SampleSourceReader[] sources;
    private int[] handledSourceIndices;
    private int[] handledSourceTrackIndices;
    private SampleSource.SampleSourceReader enabledSource;
    private int enabledSourceTrackIndex;
    private long durationUs;

    public SampleSourceTrackRenderer(SampleSource ... sampleSourceArray) {
        this.sources = new SampleSource.SampleSourceReader[sampleSourceArray.length];
        for (int i = 0; i < sampleSourceArray.length; ++i) {
            this.sources[i] = sampleSourceArray[i].register();
        }
    }

    @Override
    protected final boolean doPrepare(long l) throws ExoPlaybackException {
        int n;
        boolean bl = true;
        for (n = 0; n < this.sources.length; ++n) {
            bl &= this.sources[n].prepare(l);
        }
        if (!bl) {
            return false;
        }
        n = 0;
        for (int i = 0; i < this.sources.length; ++i) {
            n += this.sources[i].getTrackCount();
        }
        long l2 = 0L;
        int n2 = 0;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n3 = this.sources.length;
        for (int i = 0; i < n3; ++i) {
            SampleSource.SampleSourceReader sampleSourceReader = this.sources[i];
            int n4 = sampleSourceReader.getTrackCount();
            for (int j = 0; j < n4; ++j) {
                boolean bl2;
                MediaFormat mediaFormat = sampleSourceReader.getFormat(j);
                try {
                    bl2 = this.handlesTrack(mediaFormat);
                }
                catch (MediaCodecUtil.DecoderQueryException decoderQueryException) {
                    throw new ExoPlaybackException(decoderQueryException);
                }
                if (!bl2) continue;
                nArray[n2] = i;
                nArray2[n2] = j;
                ++n2;
                if (l2 == -1L) continue;
                long l3 = mediaFormat.durationUs;
                if (l3 == -1L) {
                    l2 = -1L;
                    continue;
                }
                if (l3 == -2L) continue;
                l2 = Math.max(l2, l3);
            }
        }
        this.durationUs = l2;
        this.handledSourceIndices = Arrays.copyOf(nArray, n2);
        this.handledSourceTrackIndices = Arrays.copyOf(nArray2, n2);
        return true;
    }

    @Override
    protected void onEnabled(int n, long l, boolean bl) throws ExoPlaybackException {
        l = this.shiftInputPosition(l);
        this.enabledSource = this.sources[this.handledSourceIndices[n]];
        this.enabledSourceTrackIndex = this.handledSourceTrackIndices[n];
        this.enabledSource.enable(this.enabledSourceTrackIndex, l);
        this.onDiscontinuity(l);
    }

    @Override
    protected final void seekTo(long l) throws ExoPlaybackException {
        l = this.shiftInputPosition(l);
        this.enabledSource.seekToUs(l);
        this.checkForDiscontinuity(l);
    }

    @Override
    protected final void doSomeWork(long l, long l2) throws ExoPlaybackException {
        l = this.shiftInputPosition(l);
        boolean bl = this.enabledSource.continueBuffering(this.enabledSourceTrackIndex, l);
        l = this.checkForDiscontinuity(l);
        this.doSomeWork(l, l2, bl);
    }

    @Override
    protected long getBufferedPositionUs() {
        return this.enabledSource.getBufferedPositionUs();
    }

    @Override
    protected long getDurationUs() {
        return this.durationUs;
    }

    @Override
    protected void maybeThrowError() throws ExoPlaybackException {
        if (this.enabledSource != null) {
            this.maybeThrowError(this.enabledSource);
        } else {
            int n = this.sources.length;
            for (int i = 0; i < n; ++i) {
                this.maybeThrowError(this.sources[i]);
            }
        }
    }

    @Override
    protected void onDisabled() throws ExoPlaybackException {
        this.enabledSource.disable(this.enabledSourceTrackIndex);
        this.enabledSource = null;
    }

    @Override
    protected void onReleased() throws ExoPlaybackException {
        int n = this.sources.length;
        for (int i = 0; i < n; ++i) {
            this.sources[i].release();
        }
    }

    @Override
    protected final int getTrackCount() {
        return this.handledSourceTrackIndices.length;
    }

    @Override
    protected final MediaFormat getFormat(int n) {
        SampleSource.SampleSourceReader sampleSourceReader = this.sources[this.handledSourceIndices[n]];
        return sampleSourceReader.getFormat(this.handledSourceTrackIndices[n]);
    }

    protected long shiftInputPosition(long l) {
        return l;
    }

    protected final int readSource(long l, MediaFormatHolder mediaFormatHolder, SampleHolder sampleHolder) {
        return this.enabledSource.readData(this.enabledSourceTrackIndex, l, mediaFormatHolder, sampleHolder);
    }

    protected abstract boolean handlesTrack(MediaFormat var1) throws MediaCodecUtil.DecoderQueryException;

    protected abstract void onDiscontinuity(long var1) throws ExoPlaybackException;

    protected abstract void doSomeWork(long var1, long var3, boolean var5) throws ExoPlaybackException;

    private long checkForDiscontinuity(long l) throws ExoPlaybackException {
        long l2 = this.enabledSource.readDiscontinuity(this.enabledSourceTrackIndex);
        if (l2 != Long.MIN_VALUE) {
            this.onDiscontinuity(l2);
            return l2;
        }
        return l;
    }

    private void maybeThrowError(SampleSource.SampleSourceReader sampleSourceReader) throws ExoPlaybackException {
        try {
            sampleSourceReader.maybeThrowError();
        }
        catch (IOException iOException) {
            throw new ExoPlaybackException(iOException);
        }
    }
}

