/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.os.Handler;
import android.os.SystemClock;
import android.view.Surface;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.MediaCodecSelector;
import com.google.android.exoplayer.MediaCodecTrackRenderer;
import com.google.android.exoplayer.MediaCodecUtil;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.VideoFrameReleaseTimeHelper;
import com.google.android.exoplayer.drm.DrmSessionManager;
import com.google.android.exoplayer.util.MimeTypes;
import com.google.android.exoplayer.util.TraceUtil;
import com.google.android.exoplayer.util.Util;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public class MediaCodecVideoTrackRenderer
extends MediaCodecTrackRenderer {
    private static final String KEY_CROP_LEFT = "crop-left";
    private static final String KEY_CROP_RIGHT = "crop-right";
    private static final String KEY_CROP_BOTTOM = "crop-bottom";
    private static final String KEY_CROP_TOP = "crop-top";
    public static final int MSG_SET_SURFACE = 1;
    private final VideoFrameReleaseTimeHelper frameReleaseTimeHelper;
    private final EventListener eventListener;
    private final long allowedJoiningTimeUs;
    private final int videoScalingMode;
    private final int maxDroppedFrameCountToNotify;
    private Surface surface;
    private boolean reportedDrawnToSurface;
    private boolean renderedFirstFrame;
    private long joiningDeadlineUs;
    private long droppedFrameAccumulationStartTimeMs;
    private int droppedFrameCount;
    private int consecutiveDroppedFrameCount;
    private int pendingRotationDegrees;
    private float pendingPixelWidthHeightRatio;
    private int currentWidth;
    private int currentHeight;
    private int currentUnappliedRotationDegrees;
    private float currentPixelWidthHeightRatio;
    private int lastReportedWidth;
    private int lastReportedHeight;
    private int lastReportedUnappliedRotationDegrees;
    private float lastReportedPixelWidthHeightRatio;

    public MediaCodecVideoTrackRenderer(Context context, SampleSource sampleSource, MediaCodecSelector mediaCodecSelector, int n) {
        this(context, sampleSource, mediaCodecSelector, n, 0L);
    }

    public MediaCodecVideoTrackRenderer(Context context, SampleSource sampleSource, MediaCodecSelector mediaCodecSelector, int n, long l) {
        this(context, sampleSource, mediaCodecSelector, n, l, null, null, -1);
    }

    public MediaCodecVideoTrackRenderer(Context context, SampleSource sampleSource, MediaCodecSelector mediaCodecSelector, int n, long l, Handler handler, EventListener eventListener, int n2) {
        this(context, sampleSource, mediaCodecSelector, n, l, null, false, handler, eventListener, n2);
    }

    public MediaCodecVideoTrackRenderer(Context context, SampleSource sampleSource, MediaCodecSelector mediaCodecSelector, int n, long l, DrmSessionManager drmSessionManager, boolean bl, Handler handler, EventListener eventListener, int n2) {
        super(sampleSource, mediaCodecSelector, drmSessionManager, bl, handler, (MediaCodecTrackRenderer.EventListener)eventListener);
        this.frameReleaseTimeHelper = new VideoFrameReleaseTimeHelper(context);
        this.videoScalingMode = n;
        this.allowedJoiningTimeUs = l * 1000L;
        this.eventListener = eventListener;
        this.maxDroppedFrameCountToNotify = n2;
        this.joiningDeadlineUs = -1L;
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.currentPixelWidthHeightRatio = -1.0f;
        this.pendingPixelWidthHeightRatio = -1.0f;
        this.lastReportedWidth = -1;
        this.lastReportedHeight = -1;
        this.lastReportedPixelWidthHeightRatio = -1.0f;
    }

    @Override
    protected boolean handlesTrack(MediaCodecSelector mediaCodecSelector, MediaFormat mediaFormat) throws MediaCodecUtil.DecoderQueryException {
        String string = mediaFormat.mimeType;
        return MimeTypes.isVideo(string) && ("video/x-unknown".equals(string) || mediaCodecSelector.getDecoderInfo(string, false) != null);
    }

    @Override
    protected void onEnabled(int n, long l, boolean bl) throws ExoPlaybackException {
        super.onEnabled(n, l, bl);
        if (bl && this.allowedJoiningTimeUs > 0L) {
            this.joiningDeadlineUs = SystemClock.elapsedRealtime() * 1000L + this.allowedJoiningTimeUs;
        }
        this.frameReleaseTimeHelper.enable();
    }

    @Override
    protected void onDiscontinuity(long l) throws ExoPlaybackException {
        super.onDiscontinuity(l);
        this.renderedFirstFrame = false;
        this.consecutiveDroppedFrameCount = 0;
        this.joiningDeadlineUs = -1L;
    }

    @Override
    protected boolean isReady() {
        if (super.isReady() && (this.renderedFirstFrame || !this.codecInitialized() || this.getSourceState() == 2)) {
            this.joiningDeadlineUs = -1L;
            return true;
        }
        if (this.joiningDeadlineUs == -1L) {
            return false;
        }
        if (SystemClock.elapsedRealtime() * 1000L < this.joiningDeadlineUs) {
            return true;
        }
        this.joiningDeadlineUs = -1L;
        return false;
    }

    @Override
    protected void onStarted() {
        super.onStarted();
        this.droppedFrameCount = 0;
        this.droppedFrameAccumulationStartTimeMs = SystemClock.elapsedRealtime();
    }

    @Override
    protected void onStopped() {
        this.joiningDeadlineUs = -1L;
        this.maybeNotifyDroppedFrameCount();
        super.onStopped();
    }

    @Override
    protected void onDisabled() throws ExoPlaybackException {
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.currentPixelWidthHeightRatio = -1.0f;
        this.pendingPixelWidthHeightRatio = -1.0f;
        this.lastReportedWidth = -1;
        this.lastReportedHeight = -1;
        this.lastReportedPixelWidthHeightRatio = -1.0f;
        this.frameReleaseTimeHelper.disable();
        super.onDisabled();
    }

    @Override
    public void handleMessage(int n, Object object) throws ExoPlaybackException {
        if (n == 1) {
            this.setSurface((Surface)object);
        } else {
            super.handleMessage(n, object);
        }
    }

    private void setSurface(Surface surface) throws ExoPlaybackException {
        if (this.surface == surface) {
            return;
        }
        this.surface = surface;
        this.reportedDrawnToSurface = false;
        int n = this.getState();
        if (n == 2 || n == 3) {
            this.releaseCodec();
            this.maybeInitCodec();
        }
    }

    @Override
    protected boolean shouldInitCodec() {
        return super.shouldInitCodec() && this.surface != null && this.surface.isValid();
    }

    @Override
    protected void configureCodec(MediaCodec mediaCodec, boolean bl, android.media.MediaFormat mediaFormat, MediaCrypto mediaCrypto) {
        this.maybeSetMaxInputSize(mediaFormat, bl);
        mediaCodec.configure(mediaFormat, this.surface, mediaCrypto, 0);
        mediaCodec.setVideoScalingMode(this.videoScalingMode);
    }

    @Override
    protected void onInputFormatChanged(MediaFormatHolder mediaFormatHolder) throws ExoPlaybackException {
        super.onInputFormatChanged(mediaFormatHolder);
        this.pendingPixelWidthHeightRatio = mediaFormatHolder.format.pixelWidthHeightRatio == -1.0f ? 1.0f : mediaFormatHolder.format.pixelWidthHeightRatio;
        this.pendingRotationDegrees = mediaFormatHolder.format.rotationDegrees == -1 ? 0 : mediaFormatHolder.format.rotationDegrees;
    }

    protected final boolean haveRenderedFirstFrame() {
        return this.renderedFirstFrame;
    }

    @Override
    protected void onOutputFormatChanged(android.media.MediaFormat mediaFormat) {
        boolean bl = mediaFormat.containsKey(KEY_CROP_RIGHT) && mediaFormat.containsKey(KEY_CROP_LEFT) && mediaFormat.containsKey(KEY_CROP_BOTTOM) && mediaFormat.containsKey(KEY_CROP_TOP);
        this.currentWidth = bl ? mediaFormat.getInteger(KEY_CROP_RIGHT) - mediaFormat.getInteger(KEY_CROP_LEFT) + 1 : mediaFormat.getInteger("width");
        this.currentHeight = bl ? mediaFormat.getInteger(KEY_CROP_BOTTOM) - mediaFormat.getInteger(KEY_CROP_TOP) + 1 : mediaFormat.getInteger("height");
        this.currentPixelWidthHeightRatio = this.pendingPixelWidthHeightRatio;
        if (Util.SDK_INT >= 21) {
            if (this.pendingRotationDegrees == 90 || this.pendingRotationDegrees == 270) {
                int n = this.currentWidth;
                this.currentWidth = this.currentHeight;
                this.currentHeight = n;
                this.currentPixelWidthHeightRatio = 1.0f / this.currentPixelWidthHeightRatio;
            }
        } else {
            this.currentUnappliedRotationDegrees = this.pendingRotationDegrees;
        }
    }

    @Override
    protected boolean canReconfigureCodec(MediaCodec mediaCodec, boolean bl, MediaFormat mediaFormat, MediaFormat mediaFormat2) {
        return mediaFormat2.mimeType.equals(mediaFormat.mimeType) && (bl || mediaFormat.width == mediaFormat2.width && mediaFormat.height == mediaFormat2.height);
    }

    @Override
    protected boolean processOutputBuffer(long l, long l2, MediaCodec mediaCodec, ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo, int n, boolean bl) {
        if (bl) {
            this.skipOutputBuffer(mediaCodec, n);
            this.consecutiveDroppedFrameCount = 0;
            return true;
        }
        if (!this.renderedFirstFrame) {
            if (Util.SDK_INT >= 21) {
                this.renderOutputBufferV21(mediaCodec, n, System.nanoTime());
            } else {
                this.renderOutputBuffer(mediaCodec, n);
            }
            this.consecutiveDroppedFrameCount = 0;
            return true;
        }
        if (this.getState() != 3) {
            return false;
        }
        long l3 = SystemClock.elapsedRealtime() * 1000L - l2;
        long l4 = bufferInfo.presentationTimeUs - l - l3;
        long l5 = System.nanoTime();
        long l6 = l5 + l4 * 1000L;
        long l7 = this.frameReleaseTimeHelper.adjustReleaseTime(bufferInfo.presentationTimeUs, l6);
        l4 = (l7 - l5) / 1000L;
        if (l4 < -30000L) {
            this.dropOutputBuffer(mediaCodec, n);
            return true;
        }
        if (Util.SDK_INT >= 21) {
            if (l4 < 50000L) {
                this.renderOutputBufferV21(mediaCodec, n, l7);
                this.consecutiveDroppedFrameCount = 0;
                return true;
            }
        } else if (l4 < 30000L) {
            if (l4 > 11000L) {
                try {
                    Thread.sleep((l4 - 10000L) / 1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            this.renderOutputBuffer(mediaCodec, n);
            this.consecutiveDroppedFrameCount = 0;
            return true;
        }
        return false;
    }

    protected void skipOutputBuffer(MediaCodec mediaCodec, int n) {
        TraceUtil.beginSection("skipVideoBuffer");
        mediaCodec.releaseOutputBuffer(n, false);
        TraceUtil.endSection();
        ++this.codecCounters.skippedOutputBufferCount;
    }

    protected void dropOutputBuffer(MediaCodec mediaCodec, int n) {
        TraceUtil.beginSection("dropVideoBuffer");
        mediaCodec.releaseOutputBuffer(n, false);
        TraceUtil.endSection();
        ++this.codecCounters.droppedOutputBufferCount;
        ++this.droppedFrameCount;
        ++this.consecutiveDroppedFrameCount;
        this.codecCounters.maxConsecutiveDroppedOutputBufferCount = Math.max(this.consecutiveDroppedFrameCount, this.codecCounters.maxConsecutiveDroppedOutputBufferCount);
        if (this.droppedFrameCount == this.maxDroppedFrameCountToNotify) {
            this.maybeNotifyDroppedFrameCount();
        }
    }

    protected void renderOutputBuffer(MediaCodec mediaCodec, int n) {
        this.maybeNotifyVideoSizeChanged();
        TraceUtil.beginSection("releaseOutputBuffer");
        mediaCodec.releaseOutputBuffer(n, true);
        TraceUtil.endSection();
        ++this.codecCounters.renderedOutputBufferCount;
        this.renderedFirstFrame = true;
        this.maybeNotifyDrawnToSurface();
    }

    @TargetApi(value=21)
    protected void renderOutputBufferV21(MediaCodec mediaCodec, int n, long l) {
        this.maybeNotifyVideoSizeChanged();
        TraceUtil.beginSection("releaseOutputBuffer");
        mediaCodec.releaseOutputBuffer(n, l);
        TraceUtil.endSection();
        ++this.codecCounters.renderedOutputBufferCount;
        this.renderedFirstFrame = true;
        this.maybeNotifyDrawnToSurface();
    }

    @SuppressLint(value={"InlinedApi"})
    private void maybeSetMaxInputSize(android.media.MediaFormat mediaFormat, boolean bl) {
        int n;
        int n2;
        if (mediaFormat.containsKey("max-input-size")) {
            return;
        }
        int n3 = mediaFormat.getInteger("height");
        if (bl && mediaFormat.containsKey("max-height")) {
            n3 = Math.max(n3, mediaFormat.getInteger("max-height"));
        }
        int n4 = mediaFormat.getInteger("width");
        if (bl && mediaFormat.containsKey("max-width")) {
            n4 = Math.max(n3, mediaFormat.getInteger("max-width"));
        }
        switch (mediaFormat.getString("mime")) {
            case "video/3gpp": 
            case "video/mp4v-es": {
                n2 = n4 * n3;
                n = 2;
                break;
            }
            case "video/avc": {
                if ("BRAVIA 4K 2015".equals(Util.MODEL)) {
                    return;
                }
                n2 = (n4 + 15) / 16 * ((n3 + 15) / 16) * 16 * 16;
                n = 2;
                break;
            }
            case "video/x-vnd.on2.vp8": {
                n2 = n4 * n3;
                n = 2;
                break;
            }
            case "video/hevc": 
            case "video/x-vnd.on2.vp9": {
                n2 = n4 * n3;
                n = 4;
                break;
            }
            default: {
                return;
            }
        }
        int n5 = n2 * 3 / (2 * n);
        mediaFormat.setInteger("max-input-size", n5);
    }

    private void maybeNotifyVideoSizeChanged() {
        if (this.eventHandler == null || this.eventListener == null || this.lastReportedWidth == this.currentWidth && this.lastReportedHeight == this.currentHeight && this.lastReportedUnappliedRotationDegrees == this.currentUnappliedRotationDegrees && this.lastReportedPixelWidthHeightRatio == this.currentPixelWidthHeightRatio) {
            return;
        }
        final int n = this.currentWidth;
        final int n2 = this.currentHeight;
        final int n3 = this.currentUnappliedRotationDegrees;
        final float f2 = this.currentPixelWidthHeightRatio;
        this.eventHandler.post(new Runnable(){

            @Override
            public void run() {
                MediaCodecVideoTrackRenderer.this.eventListener.onVideoSizeChanged(n, n2, n3, f2);
            }
        });
        this.lastReportedWidth = n;
        this.lastReportedHeight = n2;
        this.lastReportedUnappliedRotationDegrees = n3;
        this.lastReportedPixelWidthHeightRatio = f2;
    }

    private void maybeNotifyDrawnToSurface() {
        if (this.eventHandler == null || this.eventListener == null || this.reportedDrawnToSurface) {
            return;
        }
        final Surface surface = this.surface;
        this.eventHandler.post(new Runnable(){

            @Override
            public void run() {
                MediaCodecVideoTrackRenderer.this.eventListener.onDrawnToSurface(surface);
            }
        });
        this.reportedDrawnToSurface = true;
    }

    private void maybeNotifyDroppedFrameCount() {
        if (this.eventHandler == null || this.eventListener == null || this.droppedFrameCount == 0) {
            return;
        }
        long l = SystemClock.elapsedRealtime();
        final int n = this.droppedFrameCount;
        final long l2 = l - this.droppedFrameAccumulationStartTimeMs;
        this.eventHandler.post(new Runnable(){

            @Override
            public void run() {
                MediaCodecVideoTrackRenderer.this.eventListener.onDroppedFrames(n, l2);
            }
        });
        this.droppedFrameCount = 0;
        this.droppedFrameAccumulationStartTimeMs = l;
    }

    public static interface EventListener
    extends MediaCodecTrackRenderer.EventListener {
        public void onDroppedFrames(int var1, long var2);

        public void onVideoSizeChanged(int var1, int var2, int var3, float var4);

        public void onDrawnToSurface(Surface var1);
    }
}

