/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.execchain;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.NoHttpResponseException;
import org.apache.http.annotation.Immutable;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.NonRepeatableRequestException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.impl.execchain.RequestEntityProxy;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

@Immutable
public class RetryExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final HttpRequestRetryHandler retryHandler;

    public RetryExec(ClientExecChain clientExecChain, HttpRequestRetryHandler httpRequestRetryHandler) {
        Args.notNull((Object)clientExecChain, (String)"HTTP request executor");
        Args.notNull((Object)httpRequestRetryHandler, (String)"HTTP request retry handler");
        this.requestExecutor = clientExecChain;
        this.retryHandler = httpRequestRetryHandler;
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware) throws IOException, HttpException {
        Args.notNull((Object)httpRoute, (String)"HTTP route");
        Args.notNull((Object)httpRequestWrapper, (String)"HTTP request");
        Args.notNull((Object)((Object)httpClientContext), (String)"HTTP context");
        Header[] headerArray = httpRequestWrapper.getAllHeaders();
        int n = 1;
        while (true) {
            try {
                return this.requestExecutor.execute(httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware);
            }
            catch (IOException iOException) {
                if (httpExecutionAware != null && httpExecutionAware.isAborted()) {
                    this.log.debug((Object)"Request has been aborted");
                    throw iOException;
                }
                if (this.retryHandler.retryRequest(iOException, n, (HttpContext)httpClientContext)) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)("I/O exception (" + iOException.getClass().getName() + ") caught when processing request to " + httpRoute + ": " + iOException.getMessage()));
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)iOException.getMessage(), (Throwable)iOException);
                    }
                    if (!RequestEntityProxy.isRepeatable(httpRequestWrapper)) {
                        this.log.debug((Object)"Cannot retry non-repeatable request");
                        throw new NonRepeatableRequestException("Cannot retry request with a non-repeatable request entity", iOException);
                    }
                    httpRequestWrapper.setHeaders(headerArray);
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)("Retrying request to " + httpRoute));
                    }
                } else {
                    if (iOException instanceof NoHttpResponseException) {
                        NoHttpResponseException noHttpResponseException = new NoHttpResponseException(httpRoute.getTargetHost().toHostString() + " failed to respond");
                        noHttpResponseException.setStackTrace(iOException.getStackTrace());
                        throw noHttpResponseException;
                    }
                    throw iOException;
                }
                ++n;
                continue;
            }
            break;
        }
    }
}

