/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.libraries.mediaframework.layeredvideo;

import android.content.Context;
import android.graphics.Matrix;
import android.util.AttributeSet;
import android.view.TextureView;
import android.widget.FrameLayout;

public class VideoTextureView
extends TextureView {
    private static final float MAX_ASPECT_RATIO_DEFORMATION_PERCENT = 0.01f;
    private float videoAspectRatio;
    private FrameLayout layoutContainer;
    private boolean fixedContent;
    private float mVideoWidth;
    private float mVideoHeight;

    public VideoTextureView(Context context) {
        super(context);
    }

    public VideoTextureView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        if (this.isFixedContent()) {
            if (this.mVideoWidth == 0.0f && this.mVideoHeight == 0.0f) {
                return;
            }
            if (this.videoAspectRatio == 0.0f) {
                return;
            }
            float f = this.layoutContainer.getWidth();
            float f2 = this.layoutContainer.getHeight();
            this.updateTextureViewSize(f, f2);
            return;
        }
        int n3 = this.getMeasuredWidth();
        int n4 = this.getMeasuredHeight();
        if (this.videoAspectRatio != 0.0f) {
            float f = (float)n3 / (float)n4;
            float f3 = this.videoAspectRatio / f - 1.0f;
            if (f3 > 0.01f) {
                n4 = (int)((float)n3 / this.videoAspectRatio);
            } else if (f3 < -0.01f) {
                n3 = (int)((float)n4 * this.videoAspectRatio);
            }
        }
        this.setMeasuredDimension(n3, n4);
    }

    private void updateTextureViewSize(float f, float f2) {
        float f3 = 1.0f;
        float f4 = 1.0f;
        if (this.mVideoWidth > f && this.mVideoHeight > f2) {
            f3 = this.mVideoWidth / f;
            f4 = this.mVideoHeight / f2;
        } else if (this.mVideoWidth < f && this.mVideoHeight < f2) {
            f4 = f / this.mVideoWidth;
            f3 = f2 / this.mVideoHeight;
        } else if (f > this.mVideoWidth) {
            f4 = f / this.mVideoWidth / (f2 / this.mVideoHeight);
        } else if (f2 > this.mVideoHeight) {
            f3 = f2 / this.mVideoHeight / (f / this.mVideoWidth);
        }
        float f5 = f / 2.0f;
        float f6 = f2 / 2.0f;
        Matrix matrix = new Matrix();
        matrix.setScale(f3, f4, f5, f6);
        this.setTransform(matrix);
    }

    public void setVideoWidthHeightRatio(float f) {
        if (this.videoAspectRatio != f) {
            this.videoAspectRatio = f;
            this.requestLayout();
        }
    }

    public void setLayoutContainer(FrameLayout frameLayout) {
        this.layoutContainer = frameLayout;
    }

    public void setFixedContent(boolean bl) {
        this.fixedContent = bl;
    }

    public boolean isFixedContent() {
        return this.fixedContent;
    }

    public void setVideoSize(float f, float f2) {
        if (this.mVideoWidth == 0.0f && this.mVideoHeight == 0.0f) {
            this.mVideoWidth = f;
            this.mVideoHeight = f2;
        }
    }
}

