/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.libraries.mediaframework.layeredvideo;

import android.animation.Animator;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import com.google.android.exoplayer.util.PlayerControl;
import com.google.android.libraries.mediaframework.exoplayerextensions.ObservablePlayerControl;
import com.google.android.libraries.mediaframework.exoplayerextensions.PlayerControlCallback;
import com.google.android.libraries.mediaframework.layeredvideo.Layer;
import com.google.android.libraries.mediaframework.layeredvideo.LayerManager;
import com.google.android.libraries.mediaframework.layeredvideo.Util;
import com.vcc.playerwrappersdk.R;
import com.vcc.playerwrappersdk.a.a;
import com.vcc.playerwrappersdk.a.b;
import com.vcc.playerwrappersdk.a.c;
import com.vcc.playerwrappersdk.controllers.PlayerController;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.json.JSONException;
import org.json.JSONObject;

public class PlaybackControlLayer
implements PlayerControlCallback,
Layer {
    private boolean shouldbeHide = false;
    private PlayerController.OnPlayerCallback onPlayerCallback;
    private RelativeLayout layoutCustomSkin;
    public static final int DEFAULT_CHROME_COLOR = Color.argb((int)140, (int)0, (int)0, (int)0);
    public static final int DEFAULT_CONTROL_TINT_COLOR = 0;
    public static final int DEFAULT_TEXT_COLOR = -1;
    private static final int DEFAULT_TIMEOUT_MS = 2000;
    private static final int FADE_OUT_DURATION_MS = 400;
    private static final int FADE_OUT = 1;
    private static final int SHOW_PROGRESS = 2;
    private List<ImageButton> actionButtons;
    private boolean isVisible;
    private boolean isFadingOut;
    private boolean canSeek;
    private int chromeColor;
    private int controlColor;
    private int textColor;
    private int seekbarColor;
    private TextView currentTime;
    private TextView endTime;
    private ImageButton fullscreenButton;
    private FullscreenCallback fullscreenCallback;
    private PlayCallback playCallback;
    private Handler handler = new MessageHandler(this);
    private boolean isFullscreen;
    private boolean isSeekbarDragging;
    private LayerManager layerManager;
    private Drawable logoDrawable;
    private ImageView logoImageView;
    private ViewGroup.LayoutParams originalContainerLayoutParams;
    private LinearLayout actionButtonsContainer;
    private ImageButton pausePlayButton;
    private SeekBar seekBar;
    private boolean shouldBePlaying;
    private StringBuilder timeFormat;
    private Formatter timeFormatter;
    private RelativeLayout topChrome;
    private FrameLayout playbackControlRootView;
    private LinearLayout bottomChrome;
    private String videoTitle;
    private TextView videoTitleView;
    private FrameLayout view;
    private int savedOrientation;
    public static final String CLASS_NAME = "com.vcc.playerskin.PlayerSkinSDK";
    private static final String INIT_SKIN_METHOD = "initialized";
    public static final String EVENT = "event";
    public static final String VALUE = "value";
    public static final String LOAD_SKIN = "load_url_skin";
    public static final String PLAY_STATE = "play_state_skin";
    public static final String FULL_SCREEN = "full_screen_skin";
    public static final String GET_WEBVIEW = "get_webview_skin";
    public static final String INIT_SKIN = "init_sdk_skin";
    public static final String GET_WEBVIEW_RES = "get_webview_res_skin";

    public void setOnPlayerCallback(PlayerController.OnPlayerCallback onPlayerCallback) {
        this.onPlayerCallback = onPlayerCallback;
    }

    public PlayerController.OnPlayerCallback getOnPlayerCallback() {
        return this.onPlayerCallback;
    }

    public PlaybackControlLayer(String string2) {
        this(string2, null);
    }

    public PlaybackControlLayer(String string2, FullscreenCallback fullscreenCallback) {
        this.videoTitle = string2;
        this.canSeek = true;
        this.fullscreenCallback = fullscreenCallback;
        this.shouldBePlaying = false;
        this.actionButtons = new ArrayList<ImageButton>();
    }

    public void addActionButton(Context context, Drawable drawable2, String string2, View.OnClickListener onClickListener) {
        ImageButton imageButton = new ImageButton(context);
        imageButton.setContentDescription((CharSequence)string2);
        imageButton.setImageDrawable(drawable2);
        imageButton.setOnClickListener(onClickListener);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        int n = context.getResources().getDisplayMetrics().densityDpi * 5;
        layoutParams.setMargins(n, 0, n, 0);
        imageButton.setBackgroundColor(0);
        imageButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.isFullscreen = false;
        this.actionButtons.add(imageButton);
        if (this.playbackControlRootView != null) {
            this.updateActionButtons();
            this.updateColors();
        }
    }

    @Override
    public FrameLayout createView(LayerManager layerManager) {
        this.layerManager = layerManager;
        LayoutInflater layoutInflater = LayoutInflater.from((Context)layerManager.getContext());
        this.view = (FrameLayout)layoutInflater.inflate(R.layout.playback_control_layer, null);
        this.setupView();
        a.a().a(this);
        b.a(CLASS_NAME, INIT_SKIN_METHOD, new Object[]{layerManager.getContext()}, Context.class);
        this.originalContainerLayoutParams = layerManager.getContainer().getLayoutParams();
        layerManager.getControl().addCallback(this);
        this.savedOrientation = layerManager.getContext().getResources().getConfiguration().orientation;
        this.textColor = -1;
        this.chromeColor = DEFAULT_CHROME_COLOR;
        this.controlColor = 0;
        this.seekbarColor = -1;
        if (this.logoDrawable != null) {
            this.logoImageView.setImageDrawable(this.logoDrawable);
        }
        this.setEventClickController();
        this.playbackControlRootView.setVisibility(4);
        return this.view;
    }

    private void setEventClickController() {
        this.getLayerManager().getContainer().setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PlaybackControlLayer.this.shouldbeHide) {
                    return;
                }
                if (PlaybackControlLayer.this.isVisible) {
                    PlaybackControlLayer.this.hide();
                } else {
                    PlaybackControlLayer.this.show();
                }
            }
        });
    }

    public void disableSeeking() {
        this.canSeek = false;
        if (this.playbackControlRootView != null) {
            this.updateColors();
        }
    }

    public void doToggleFullscreen() {
        if (this.fullscreenCallback == null) {
            return;
        }
        ObservablePlayerControl observablePlayerControl = this.getLayerManager().getControl();
        if (observablePlayerControl == null) {
            return;
        }
        Context context = this.getLayerManager().getContext();
        if (context instanceof Activity) {
            Activity activity = (Activity)this.getLayerManager().getContext();
            FrameLayout frameLayout = this.getLayerManager().getContainer();
            if (this.isFullscreen) {
                this.fullscreenCallback.onReturnFromFullscreen();
                activity.setRequestedOrientation(this.savedOrientation);
                activity.getWindow().getDecorView().setSystemUiVisibility(0);
                frameLayout.setLayoutParams(this.originalContainerLayoutParams);
                this.fullscreenButton.setImageResource(R.drawable.ic_action_full_screen);
                this.isFullscreen = false;
            } else {
                this.fullscreenCallback.onGoToFullscreen();
                this.savedOrientation = activity.getResources().getConfiguration().orientation;
                activity.setRequestedOrientation(0);
                activity.getWindow().getDecorView().setSystemUiVisibility(6);
                activity.getWindow().getDecorView().setOnSystemUiVisibilityChangeListener(new View.OnSystemUiVisibilityChangeListener(){

                    public void onSystemUiVisibilityChange(int n) {
                        if ((n & 4) == 0) {
                            if (PlaybackControlLayer.this.shouldbeHide) {
                                return;
                            }
                            PlaybackControlLayer.this.show();
                        }
                    }
                });
                frameLayout.setLayoutParams(Util.getLayoutParamsBasedOnParent((View)frameLayout, -1, -1));
                this.fullscreenButton.setImageResource(R.drawable.ic_action_return_from_full_screen);
                this.isFullscreen = true;
            }
        }
    }

    public void enableSeeking() {
        this.canSeek = true;
        if (this.playbackControlRootView != null) {
            this.updateColors();
        }
    }

    public LayerManager getLayerManager() {
        return this.layerManager;
    }

    public void hide() {
        if (this.shouldbeHide) {
            this.playbackControlRootView.setVisibility(8);
            this.layoutCustomSkin.setVisibility(8);
            return;
        }
        if (this.isFadingOut) {
            return;
        }
        final FrameLayout frameLayout = this.getLayerManager().getContainer();
        if (frameLayout == null) {
            return;
        }
        if (this.isVisible) {
            this.isFadingOut = true;
            this.playbackControlRootView.animate().alpha(0.0f).setDuration(400L).setListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animator) {
                }

                public void onAnimationEnd(Animator animator) {
                    Context context;
                    PlaybackControlLayer.this.isFadingOut = false;
                    if (com.vcc.playerwrappersdk.controllers.a.a().b() && PlaybackControlLayer.this.layoutCustomSkin.getChildCount() > 0) {
                        PlaybackControlLayer.this.layoutCustomSkin.setVisibility(0);
                        return;
                    }
                    PlaybackControlLayer.this.playbackControlRootView.setVisibility(4);
                    PlaybackControlLayer.this.layoutCustomSkin.setVisibility(8);
                    frameLayout.removeView((View)PlaybackControlLayer.this.view);
                    if (PlaybackControlLayer.this.isFullscreen && (context = PlaybackControlLayer.this.getLayerManager().getContext()) instanceof Activity) {
                        ((Activity)context).getWindow().getDecorView().setSystemUiVisibility(6);
                    }
                    PlaybackControlLayer.this.handler.removeMessages(2);
                    PlaybackControlLayer.this.isVisible = false;
                    PlaybackControlLayer.this.getOnPlayerCallback().onShowHideControl(PlaybackControlLayer.this.isVisible);
                }

                public void onAnimationCancel(Animator animator) {
                }

                public void onAnimationRepeat(Animator animator) {
                }
            });
        }
    }

    public void show(int n) {
        Message message;
        if (this.shouldbeHide) {
            this.playbackControlRootView.setVisibility(8);
            this.layoutCustomSkin.setVisibility(8);
            return;
        }
        if (com.vcc.playerwrappersdk.controllers.a.a().b() && this.layoutCustomSkin.getChildCount() > 0) {
            return;
        }
        if (!this.isVisible && this.getLayerManager().getContainer() != null) {
            this.playbackControlRootView.setAlpha(1.0f);
            if (com.vcc.playerwrappersdk.controllers.a.a().b() && this.layoutCustomSkin.getChildCount() > 0) {
                this.playbackControlRootView.setVisibility(8);
                this.layoutCustomSkin.setVisibility(0);
            }
            this.updateProgress();
            message = new FrameLayout.LayoutParams(-1, -1, 17);
            this.getLayerManager().getContainer().removeView((View)this.view);
            this.getLayerManager().getContainer().addView((View)this.view, (ViewGroup.LayoutParams)message);
            this.setupView();
            this.isVisible = true;
            this.getOnPlayerCallback().onShowHideControl(this.isVisible);
        }
        this.updatePlayPauseButton();
        this.handler.sendEmptyMessage(2);
        message = this.handler.obtainMessage(1);
        this.handler.removeMessages(1);
        if (n > 0) {
            this.handler.sendMessageDelayed(message, (long)n);
        }
    }

    public void show() {
        this.show(2000);
    }

    public void hideTopChrome() {
        this.topChrome.setVisibility(8);
    }

    public void showTopChrome() {
        this.topChrome.setVisibility(0);
        this.updateActionButtons();
        this.updateColors();
    }

    public boolean isFullscreen() {
        return this.isFullscreen;
    }

    public void setFullscreen(boolean bl) {
        if (bl != this.isFullscreen) {
            this.doToggleFullscreen();
        }
        if (com.vcc.playerwrappersdk.controllers.a.a().b()) {
            this.pushMessage(FULL_SCREEN, "" + this.isFullscreen);
        }
    }

    @Override
    public void onLayerDisplayed(LayerManager layerManager) {
    }

    @Override
    public void onPause() {
        this.updatePlayPauseButton();
    }

    @Override
    public void onPlay() {
        this.updatePlayPauseButton();
        if (this.playCallback != null) {
            this.playCallback.onPlay();
        }
    }

    public void setChromeColor(int n) {
        this.chromeColor = n;
        if (this.playbackControlRootView != null) {
            this.updateColors();
        }
    }

    public void setControlColor(int n) {
        this.controlColor = n;
        if (this.playbackControlRootView != null) {
            this.updateColors();
            this.updateActionButtons();
        }
    }

    public void setSeekbarColor(int n) {
        this.seekbarColor = n;
        if (this.playbackControlRootView != null) {
            this.updateColors();
        }
    }

    public void setTextColor(int n) {
        this.textColor = n;
        if (this.playbackControlRootView != null) {
            this.updateColors();
        }
    }

    public void setFullscreenCallback(FullscreenCallback fullscreenCallback) {
        this.fullscreenCallback = fullscreenCallback;
        if (this.fullscreenButton != null && fullscreenCallback != null) {
            this.fullscreenButton.setVisibility(0);
        } else if (this.fullscreenButton != null && fullscreenCallback == null) {
            this.fullscreenButton.setVisibility(4);
        }
    }

    public void setLogoImageView(Drawable drawable2) {
        this.logoDrawable = drawable2;
        if (this.logoImageView != null) {
            this.logoImageView.setImageDrawable(drawable2);
        }
    }

    public void setPlayPause(boolean bl) {
        ObservablePlayerControl observablePlayerControl = this.getLayerManager().getControl();
        if (observablePlayerControl == null) {
            return;
        }
        if (bl) {
            ((PlayerControl)observablePlayerControl).start();
        } else {
            ((PlayerControl)observablePlayerControl).pause();
        }
        this.updatePlayPauseButton();
    }

    public void setVideoTitle(String string2) {
        this.videoTitle = string2;
        if (this.videoTitleView != null) {
            this.videoTitleView.setText((CharSequence)string2);
        }
    }

    private void setupView() {
        this.layoutCustomSkin = (RelativeLayout)this.view.findViewById(R.id.layout_custom_skin);
        this.pausePlayButton = (ImageButton)this.view.findViewById(R.id.pause);
        this.fullscreenButton = (ImageButton)this.view.findViewById(R.id.fullscreen);
        this.seekBar = (SeekBar)this.view.findViewById(R.id.mediacontroller_progress);
        this.videoTitleView = (TextView)this.view.findViewById(R.id.video_title);
        this.endTime = (TextView)this.view.findViewById(R.id.time_duration);
        this.currentTime = (TextView)this.view.findViewById(R.id.time_current);
        this.logoImageView = (ImageView)this.view.findViewById(R.id.logo_image);
        this.playbackControlRootView = (FrameLayout)this.view.findViewById(R.id.middle_section);
        this.topChrome = (RelativeLayout)this.view.findViewById(R.id.top_chrome);
        this.bottomChrome = (LinearLayout)this.view.findViewById(R.id.bottom_chrome);
        this.actionButtonsContainer = (LinearLayout)this.view.findViewById(R.id.actions_container);
        this.pausePlayButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PlaybackControlLayer.this.togglePlayPause();
                PlaybackControlLayer.this.show(2000);
            }
        });
        if (this.fullscreenCallback == null) {
            this.fullscreenButton.setVisibility(4);
        }
        this.fullscreenButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PlaybackControlLayer.this.doToggleFullscreen();
                PlaybackControlLayer.this.show(2000);
                PlaybackControlLayer.this.updateActionButtons();
                PlaybackControlLayer.this.updateColors();
            }
        });
        this.seekBar.setMax(1000);
        this.seekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int n, boolean bl) {
                if (!bl || !PlaybackControlLayer.this.canSeek) {
                    return;
                }
                ObservablePlayerControl observablePlayerControl = PlaybackControlLayer.this.getLayerManager().getControl();
                long l = observablePlayerControl.getDuration();
                long l2 = l * (long)n / 1000L;
                observablePlayerControl.seekTo((int)l2);
                if (PlaybackControlLayer.this.currentTime != null) {
                    PlaybackControlLayer.this.currentTime.setText((CharSequence)PlaybackControlLayer.this.stringForTime((int)l2));
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                PlaybackControlLayer.this.show(0);
                PlaybackControlLayer.this.isSeekbarDragging = true;
                PlaybackControlLayer.this.handler.removeMessages(2);
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                PlaybackControlLayer.this.isSeekbarDragging = false;
                PlaybackControlLayer.this.updateProgress();
                PlaybackControlLayer.this.updatePlayPauseButton();
                PlaybackControlLayer.this.show(2000);
                PlaybackControlLayer.this.handler.sendEmptyMessage(2);
            }
        });
        this.videoTitleView.setText((CharSequence)this.videoTitle);
        this.timeFormat = new StringBuilder();
        this.timeFormatter = new Formatter(this.timeFormat, Locale.getDefault());
        if (this.shouldbeHide) {
            this.layoutCustomSkin.setVisibility(8);
            this.playbackControlRootView.setVisibility(8);
        } else if (!com.vcc.playerwrappersdk.controllers.a.a().b() || TextUtils.isEmpty((CharSequence)com.vcc.playerwrappersdk.controllers.a.a().c())) {
            this.layoutCustomSkin.setVisibility(8);
            this.playbackControlRootView.setVisibility(!this.isVisible ? 0 : 8);
        } else if (this.layoutCustomSkin.getChildCount() > 0) {
            this.layoutCustomSkin.setVisibility(0);
            this.playbackControlRootView.setVisibility(8);
        } else {
            this.layoutCustomSkin.setVisibility(8);
            this.playbackControlRootView.setVisibility(!this.isVisible ? 0 : 8);
        }
    }

    public boolean shouldBePlaying() {
        return this.shouldBePlaying;
    }

    public String stringForTime(int n) {
        int n2 = n / 1000;
        int n3 = n2 % 60;
        int n4 = n2 / 60 % 60;
        int n5 = n2 / 3600;
        this.timeFormat.setLength(0);
        if (n5 > 0) {
            return this.timeFormatter.format("%d:%02d:%02d", n5, n4, n3).toString();
        }
        return this.timeFormatter.format("%02d:%02d", n4, n3).toString();
    }

    public void togglePlayPause() {
        this.shouldBePlaying = !this.getLayerManager().getControl().isPlaying();
        this.setPlayPause(this.shouldBePlaying);
    }

    public void updateActionButtons() {
        this.actionButtonsContainer.removeAllViews();
        if (this.isFullscreen) {
            for (ImageButton imageButton : this.actionButtons) {
                this.actionButtonsContainer.addView((View)imageButton);
            }
        } else {
            ImageButton imageButton = new ImageButton(this.getLayerManager().getContext());
            imageButton.setContentDescription((CharSequence)this.getLayerManager().getContext().getString(R.string.overflow));
            imageButton.setImageDrawable(this.getLayerManager().getContext().getResources().getDrawable(R.drawable.ic_action_overflow));
            AlertDialog.Builder builder = new AlertDialog.Builder(this.getLayerManager().getContext());
            builder.setTitle((CharSequence)this.getLayerManager().getContext().getString(R.string.select_an_action));
            CharSequence[] charSequenceArray = new CharSequence[this.actionButtons.size()];
            for (int i = 0; i < this.actionButtons.size(); ++i) {
                charSequenceArray[i] = this.actionButtons.get(i).getContentDescription();
            }
            builder.setItems(charSequenceArray, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    ((ImageButton)PlaybackControlLayer.this.actionButtons.get(n)).performClick();
                }
            });
            final AlertDialog alertDialog = builder.create();
            imageButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    alertDialog.show();
                }
            });
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
            int n = 5 * this.getLayerManager().getContext().getResources().getDisplayMetrics().densityDpi;
            layoutParams.setMargins(n, 0, n, 0);
            imageButton.setBackgroundColor(0);
            imageButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            imageButton.setColorFilter(this.controlColor);
            this.actionButtonsContainer.addView((View)imageButton);
        }
    }

    public void updateColors() {
        this.currentTime.setTextColor(this.textColor);
        this.endTime.setTextColor(this.textColor);
        this.videoTitleView.setTextColor(this.textColor);
        this.fullscreenButton.setColorFilter(this.controlColor);
        this.pausePlayButton.setColorFilter(this.controlColor);
        this.seekBar.getProgressDrawable().setColorFilter(this.seekbarColor, PorterDuff.Mode.SRC_ATOP);
        this.seekBar.getThumb().setColorFilter(this.seekbarColor, PorterDuff.Mode.SRC_ATOP);
        if (this.canSeek) {
            this.seekBar.getThumb().mutate().setAlpha(255);
        } else {
            this.seekBar.getThumb().mutate().setAlpha(0);
        }
        for (ImageButton imageButton : this.actionButtons) {
            imageButton.setColorFilter(this.controlColor);
        }
        this.topChrome.setBackgroundColor(this.chromeColor);
        this.bottomChrome.setBackgroundColor(this.chromeColor);
    }

    public void updatePlayPauseButton() {
        ObservablePlayerControl observablePlayerControl = this.getLayerManager().getControl();
        if (this.view == null) {
            return;
        }
        if (com.vcc.playerwrappersdk.controllers.a.a().b()) {
            this.pushMessage(PLAY_STATE, "" + !observablePlayerControl.isPlaying());
        }
        if (this.pausePlayButton == null || observablePlayerControl == null) {
            return;
        }
        if (observablePlayerControl.isPlaying()) {
            this.pausePlayButton.setImageResource(R.drawable.ic_action_pause_large);
        } else {
            this.pausePlayButton.setImageResource(R.drawable.ic_action_play_large);
        }
    }

    public int updateProgress() {
        ObservablePlayerControl observablePlayerControl = this.getLayerManager().getControl();
        if (observablePlayerControl == null || this.isSeekbarDragging) {
            return 0;
        }
        int n = observablePlayerControl.getCurrentPosition();
        int n2 = observablePlayerControl.getDuration();
        if (this.seekBar != null) {
            if (n2 > 0) {
                long l = 1000L * (long)n / (long)n2;
                this.seekBar.setProgress((int)l);
            }
            int n3 = observablePlayerControl.getBufferPercentage();
            this.seekBar.setSecondaryProgress(n3 * 10);
        }
        if (this.endTime != null) {
            this.endTime.setText((CharSequence)this.stringForTime(n2));
        }
        if (this.currentTime != null) {
            this.currentTime.setText((CharSequence)this.stringForTime(n));
        }
        return n;
    }

    public int getCurrentBuffering() {
        ObservablePlayerControl observablePlayerControl = this.getLayerManager().getControl();
        if (observablePlayerControl == null || this.isSeekbarDragging) {
            return 0;
        }
        return observablePlayerControl.getBufferPercentage();
    }

    public void setPlayCallback(PlayCallback playCallback) {
        this.playCallback = playCallback;
    }

    public void seekTo(int n) {
        ObservablePlayerControl observablePlayerControl = this.getLayerManager().getControl();
        if (observablePlayerControl == null || this.isSeekbarDragging) {
            return;
        }
        observablePlayerControl.seekTo(n);
    }

    public boolean isShouldbeHide() {
        return this.shouldbeHide;
    }

    public void setShouldbeHide(boolean bl) {
        this.shouldbeHide = bl;
    }

    @Subscribe(threadMode=ThreadMode.BACKGROUND)
    public void onEvent(JSONObject jSONObject) {
        c c2 = new c();
        String string2 = c2.a(EVENT, jSONObject);
        final Object object = c2.b(VALUE, jSONObject);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        if (this.view == null) {
            return;
        }
        switch (string2) {
            case "get_webview_res_skin": {
                if (!(object instanceof WebView)) break;
                this.view.post(new Runnable(){

                    @Override
                    public void run() {
                        if (PlaybackControlLayer.this.layoutCustomSkin.getChildCount() > 1) {
                            return;
                        }
                        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
                        if (((WebView)object).getParent() != null) {
                            ((ViewGroup)((WebView)object).getParent()).removeView((View)object);
                        }
                        PlaybackControlLayer.this.layoutCustomSkin.addView((View)object, (ViewGroup.LayoutParams)layoutParams);
                        PlaybackControlLayer.this.layoutCustomSkin.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                PlaybackControlLayer.this.pushMessage(PlaybackControlLayer.LOAD_SKIN, com.vcc.playerwrappersdk.controllers.a.a().c());
                            }
                        }, 100L);
                    }
                });
                break;
            }
            case "init_sdk_skin": {
                if (!(object instanceof String)) break;
                if (object.equals("true")) {
                    this.pushMessage(GET_WEBVIEW, "");
                    break;
                }
                this.view.post(new Runnable(){

                    @Override
                    public void run() {
                        if (PlaybackControlLayer.this.shouldbeHide) {
                            return;
                        }
                        PlaybackControlLayer.this.layoutCustomSkin.setVisibility(8);
                        PlaybackControlLayer.this.playbackControlRootView.setVisibility(4);
                        com.vcc.playerwrappersdk.a.a("Cannot init player skin");
                    }
                });
                break;
            }
            case "Play": {
                this.view.post(new Runnable(){

                    @Override
                    public void run() {
                        PlaybackControlLayer.this.setPlayPause(true);
                    }
                });
                break;
            }
            case "Pause": {
                this.view.post(new Runnable(){

                    @Override
                    public void run() {
                        PlaybackControlLayer.this.setPlayPause(false);
                    }
                });
                break;
            }
            case "Minimize": {
                this.view.post(new Runnable(){

                    @Override
                    public void run() {
                        if (PlaybackControlLayer.this.isFullscreen()) {
                            PlaybackControlLayer.this.doToggleFullscreen();
                        }
                    }
                });
                break;
            }
            case "Maximize": {
                this.view.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!PlaybackControlLayer.this.isFullscreen()) {
                            PlaybackControlLayer.this.doToggleFullscreen();
                        }
                    }
                });
                break;
            }
        }
    }

    private void pushMessage(String string2, Object object) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(EVENT, (Object)string2);
            jSONObject.put(VALUE, object);
            a.a().b(jSONObject);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private static class MessageHandler
    extends Handler {
        private final WeakReference<PlaybackControlLayer> playbackControlLayer;

        private MessageHandler(PlaybackControlLayer playbackControlLayer) {
            this.playbackControlLayer = new WeakReference<PlaybackControlLayer>(playbackControlLayer);
        }

        public void handleMessage(Message message) {
            PlaybackControlLayer playbackControlLayer = (PlaybackControlLayer)this.playbackControlLayer.get();
            if (playbackControlLayer == null || playbackControlLayer.getLayerManager().getControl() == null) {
                return;
            }
            switch (message.what) {
                case 1: {
                    playbackControlLayer.hide();
                    break;
                }
                case 2: {
                    int n = playbackControlLayer.updateProgress();
                    if (playbackControlLayer.isSeekbarDragging || !playbackControlLayer.isVisible || !playbackControlLayer.getLayerManager().getControl().isPlaying()) break;
                    message = this.obtainMessage(2);
                    this.sendMessageDelayed(message, 1000 - n % 1000);
                }
            }
        }
    }

    public static interface PlayCallback {
        public void onPlay();
    }

    public static interface FullscreenCallback {
        public void onGoToFullscreen();

        public void onReturnFromFullscreen();
    }
}

