/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.libraries.mediaframework.exoplayerextensions;

import android.content.Context;
import android.os.Handler;
import com.google.android.exoplayer.DefaultLoadControl;
import com.google.android.exoplayer.MediaCodecAudioTrackRenderer;
import com.google.android.exoplayer.MediaCodecSelector;
import com.google.android.exoplayer.MediaCodecUtil;
import com.google.android.exoplayer.MediaCodecVideoTrackRenderer;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.SampleSourceTrackRenderer;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.audio.AudioCapabilities;
import com.google.android.exoplayer.chunk.VideoFormatSelectorUtil;
import com.google.android.exoplayer.hls.DefaultHlsTrackSelector;
import com.google.android.exoplayer.hls.HlsChunkSource;
import com.google.android.exoplayer.hls.HlsMasterPlaylist;
import com.google.android.exoplayer.hls.HlsPlaylist;
import com.google.android.exoplayer.hls.HlsPlaylistParser;
import com.google.android.exoplayer.hls.HlsSampleSource;
import com.google.android.exoplayer.hls.PtsTimestampAdjusterProvider;
import com.google.android.exoplayer.metadata.MetadataTrackRenderer;
import com.google.android.exoplayer.metadata.id3.Id3Frame;
import com.google.android.exoplayer.metadata.id3.Id3Parser;
import com.google.android.exoplayer.text.SubtitleParser;
import com.google.android.exoplayer.text.TextRenderer;
import com.google.android.exoplayer.text.TextTrackRenderer;
import com.google.android.exoplayer.text.eia608.Eia608TrackRenderer;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DefaultAllocator;
import com.google.android.exoplayer.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer.upstream.DefaultUriDataSource;
import com.google.android.exoplayer.upstream.TransferListener;
import com.google.android.exoplayer.util.ManifestFetcher;
import com.google.android.libraries.mediaframework.exoplayerextensions.ExoplayerWrapper;
import java.io.IOException;
import java.util.List;

public class HlsRendererBuilder
implements ExoplayerWrapper.RendererBuilder {
    private static final int BUFFER_SEGMENT_SIZE = 65536;
    private static final int MAIN_BUFFER_SEGMENTS = 256;
    private static final int TEXT_BUFFER_SEGMENTS = 2;
    private final Context context;
    private final String userAgent;
    private final String url;
    private boolean fixedContent;
    private ExoplayerWrapper player;
    private AsyncRendererBuilder currentAsyncBuilder;

    public HlsRendererBuilder(Context context, String string, String string2, boolean bl) {
        this.context = context;
        this.userAgent = string;
        this.url = string2;
    }

    @Override
    public void buildRenderers(ExoplayerWrapper exoplayerWrapper) {
        this.player = exoplayerWrapper;
        this.currentAsyncBuilder = new AsyncRendererBuilder(this.context, this.userAgent, this.url, exoplayerWrapper, this.fixedContent);
        this.currentAsyncBuilder.init();
    }

    @Override
    public void cancel() {
        if (this.currentAsyncBuilder != null) {
            this.currentAsyncBuilder.cancel();
            this.currentAsyncBuilder = null;
        }
    }

    private static final class AsyncRendererBuilder
    implements ManifestFetcher.ManifestCallback<HlsPlaylist> {
        private final Context context;
        private final String userAgent;
        private final String url;
        private final ExoplayerWrapper player;
        private final ManifestFetcher<HlsPlaylist> playlistFetcher;
        private boolean fixedContent = false;
        private boolean canceled;

        public AsyncRendererBuilder(Context context, String string, String string2, ExoplayerWrapper exoplayerWrapper, boolean bl) {
            this.context = context;
            this.userAgent = string;
            this.url = string2;
            this.player = exoplayerWrapper;
            HlsPlaylistParser hlsPlaylistParser = new HlsPlaylistParser();
            this.playlistFetcher = new ManifestFetcher<HlsPlaylist>(string2, new DefaultUriDataSource(context, string), hlsPlaylistParser);
        }

        public void init() {
            this.playlistFetcher.singleLoad(this.player.getMainHandler().getLooper(), this);
        }

        public void cancel() {
            this.canceled = true;
        }

        @Override
        public void onSingleManifestError(IOException iOException) {
            if (this.canceled) {
                return;
            }
            this.player.onRenderersError(iOException);
        }

        @Override
        public void onSingleManifest(HlsPlaylist hlsPlaylist) {
            SampleSourceTrackRenderer sampleSourceTrackRenderer;
            TrackRenderer[] trackRendererArray;
            Object object;
            if (this.canceled) {
                return;
            }
            Handler handler = this.player.getMainHandler();
            DefaultLoadControl defaultLoadControl = new DefaultLoadControl(new DefaultAllocator(65536));
            DefaultBandwidthMeter defaultBandwidthMeter = new DefaultBandwidthMeter();
            int[] nArray = null;
            if (hlsPlaylist instanceof HlsMasterPlaylist) {
                object = (HlsMasterPlaylist)hlsPlaylist;
                try {
                    nArray = VideoFormatSelectorUtil.selectVideoFormatsForDefaultDisplay(this.context, ((HlsMasterPlaylist)object).variants, null, false);
                }
                catch (MediaCodecUtil.DecoderQueryException decoderQueryException) {
                    this.player.onRenderersError(decoderQueryException);
                    return;
                }
                if (nArray.length == 0) {
                    this.player.onRenderersError(new IllegalStateException("No variants selected."));
                    return;
                }
            }
            object = new PtsTimestampAdjusterProvider();
            DefaultUriDataSource defaultUriDataSource = new DefaultUriDataSource(this.context, (TransferListener)defaultBandwidthMeter, this.userAgent);
            HlsChunkSource hlsChunkSource = new HlsChunkSource(true, defaultUriDataSource, this.url, hlsPlaylist, DefaultHlsTrackSelector.newDefaultInstance(this.context), defaultBandwidthMeter, (PtsTimestampAdjusterProvider)object, 1);
            HlsSampleSource hlsSampleSource = new HlsSampleSource(hlsChunkSource, defaultLoadControl, 0x1000000, handler, this.player, 0);
            MediaCodecVideoTrackRenderer mediaCodecVideoTrackRenderer = this.fixedContent ? new MediaCodecVideoTrackRenderer(this.context, (SampleSource)hlsSampleSource, MediaCodecSelector.DEFAULT, 2, 5000L, handler, this.player, 50) : new MediaCodecVideoTrackRenderer(this.context, (SampleSource)hlsSampleSource, MediaCodecSelector.DEFAULT, 1, 5000L, handler, this.player, 50);
            MediaCodecAudioTrackRenderer mediaCodecAudioTrackRenderer = new MediaCodecAudioTrackRenderer((SampleSource)hlsSampleSource, MediaCodecSelector.DEFAULT, null, true, this.player.getMainHandler(), (MediaCodecAudioTrackRenderer.EventListener)this.player, AudioCapabilities.getCapabilities(this.context), 3);
            MetadataTrackRenderer<List<Id3Frame>> metadataTrackRenderer = new MetadataTrackRenderer<List<Id3Frame>>((SampleSource)hlsSampleSource, new Id3Parser(), this.player, handler.getLooper());
            boolean bl = false;
            if (hlsPlaylist instanceof HlsMasterPlaylist) {
                boolean bl2 = bl = !((HlsMasterPlaylist)hlsPlaylist).subtitles.isEmpty();
            }
            if (bl) {
                trackRendererArray = new DefaultUriDataSource(this.context, (TransferListener)defaultBandwidthMeter, this.userAgent);
                HlsChunkSource hlsChunkSource2 = new HlsChunkSource(false, (DataSource)trackRendererArray, this.url, hlsPlaylist, DefaultHlsTrackSelector.newSubtitleInstance(), defaultBandwidthMeter, (PtsTimestampAdjusterProvider)object, 1);
                HlsSampleSource hlsSampleSource2 = new HlsSampleSource(hlsChunkSource2, defaultLoadControl, 131072, handler, this.player, 2);
                sampleSourceTrackRenderer = new TextTrackRenderer((SampleSource)hlsSampleSource2, (TextRenderer)this.player, handler.getLooper(), new SubtitleParser[0]);
            } else {
                sampleSourceTrackRenderer = new Eia608TrackRenderer((SampleSource)hlsSampleSource, this.player, handler.getLooper());
            }
            trackRendererArray = new TrackRenderer[5];
            trackRendererArray[0] = mediaCodecVideoTrackRenderer;
            trackRendererArray[1] = mediaCodecAudioTrackRenderer;
            trackRendererArray[3] = metadataTrackRenderer;
            trackRendererArray[2] = sampleSourceTrackRenderer;
            this.player.onRenderers(trackRendererArray, defaultBandwidthMeter);
        }
    }
}

