/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.util.extensions;

import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.extensions.Buffer;
import com.google.android.exoplayer.util.extensions.Decoder;
import com.google.android.exoplayer.util.extensions.InputBuffer;
import com.google.android.exoplayer.util.extensions.OutputBuffer;
import java.util.LinkedList;

public abstract class SimpleDecoder<I extends InputBuffer, O extends OutputBuffer, E extends Exception>
extends Thread
implements Decoder<I, O, E> {
    private final Object lock = new Object();
    private final LinkedList<I> queuedInputBuffers = new LinkedList();
    private final LinkedList<O> queuedOutputBuffers = new LinkedList();
    private final I[] availableInputBuffers;
    private final O[] availableOutputBuffers;
    private int availableInputBufferCount;
    private int availableOutputBufferCount;
    private I dequeuedInputBuffer;
    private E exception;
    private boolean flushDecodedOutputBuffer;
    private boolean released;

    protected SimpleDecoder(I[] IArray, O[] OArray) {
        int n;
        this.availableInputBuffers = IArray;
        this.availableInputBufferCount = IArray.length;
        for (n = 0; n < this.availableInputBufferCount; ++n) {
            this.availableInputBuffers[n] = this.createInputBuffer();
        }
        this.availableOutputBuffers = OArray;
        this.availableOutputBufferCount = OArray.length;
        for (n = 0; n < this.availableOutputBufferCount; ++n) {
            this.availableOutputBuffers[n] = this.createOutputBuffer();
        }
    }

    protected final void setInitialInputBufferSize(int n) {
        Assertions.checkState(this.availableInputBufferCount == this.availableInputBuffers.length);
        for (int i = 0; i < this.availableInputBuffers.length; ++i) {
            ((InputBuffer)this.availableInputBuffers[i]).sampleHolder.ensureSpaceForWrite(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final I dequeueInputBuffer() throws E {
        Object object = this.lock;
        synchronized (object) {
            this.maybeThrowException();
            Assertions.checkState(this.dequeuedInputBuffer == null);
            if (this.availableInputBufferCount == 0) {
                return null;
            }
            I i = this.availableInputBuffers[--this.availableInputBufferCount];
            ((InputBuffer)i).reset();
            this.dequeuedInputBuffer = i;
            return i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void queueInputBuffer(I i) throws E {
        Object object = this.lock;
        synchronized (object) {
            this.maybeThrowException();
            Assertions.checkArgument(i == this.dequeuedInputBuffer);
            this.queuedInputBuffers.addLast(i);
            this.maybeNotifyDecodeLoop();
            this.dequeuedInputBuffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final O dequeueOutputBuffer() throws E {
        Object object = this.lock;
        synchronized (object) {
            this.maybeThrowException();
            if (this.queuedOutputBuffers.isEmpty()) {
                return null;
            }
            return (O)((OutputBuffer)this.queuedOutputBuffers.removeFirst());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseOutputBuffer(O o) {
        Object object = this.lock;
        synchronized (object) {
            this.availableOutputBuffers[this.availableOutputBufferCount++] = o;
            this.maybeNotifyDecodeLoop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void flush() {
        Object object = this.lock;
        synchronized (object) {
            this.flushDecodedOutputBuffer = true;
            if (this.dequeuedInputBuffer != null) {
                this.availableInputBuffers[this.availableInputBufferCount++] = this.dequeuedInputBuffer;
                this.dequeuedInputBuffer = null;
            }
            while (!this.queuedInputBuffers.isEmpty()) {
                this.availableInputBuffers[this.availableInputBufferCount++] = (InputBuffer)this.queuedInputBuffers.removeFirst();
            }
            while (!this.queuedOutputBuffers.isEmpty()) {
                this.availableOutputBuffers[this.availableOutputBufferCount++] = (OutputBuffer)this.queuedOutputBuffers.removeFirst();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.lock;
        synchronized (object) {
            this.released = true;
            this.lock.notify();
        }
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private void maybeThrowException() throws E {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    private void maybeNotifyDecodeLoop() {
        if (this.canDecodeBuffer()) {
            this.lock.notify();
        }
    }

    @Override
    public final void run() {
        try {
            while (this.decode()) {
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean decode() throws InterruptedException {
        O o;
        InputBuffer inputBuffer;
        Object object = this.lock;
        synchronized (object) {
            while (!this.released && !this.canDecodeBuffer()) {
                this.lock.wait();
            }
            if (this.released) {
                return false;
            }
            inputBuffer = (InputBuffer)this.queuedInputBuffers.removeFirst();
            o = this.availableOutputBuffers[--this.availableOutputBufferCount];
            this.flushDecodedOutputBuffer = false;
        }
        ((Buffer)o).reset();
        if (inputBuffer.getFlag(1)) {
            ((Buffer)o).setFlag(1);
        } else {
            if (inputBuffer.getFlag(0x8000000)) {
                ((Buffer)o).setFlag(0x8000000);
            }
            this.exception = this.decode(inputBuffer, o);
            if (this.exception != null) {
                object = this.lock;
                synchronized (object) {
                }
                return false;
            }
        }
        object = this.lock;
        synchronized (object) {
            if (this.flushDecodedOutputBuffer || ((Buffer)o).getFlag(4)) {
                this.availableOutputBuffers[this.availableOutputBufferCount++] = o;
            } else {
                this.queuedOutputBuffers.addLast(o);
            }
            this.availableInputBuffers[this.availableInputBufferCount++] = inputBuffer;
        }
        return true;
    }

    private boolean canDecodeBuffer() {
        return !this.queuedInputBuffers.isEmpty() && this.availableOutputBufferCount > 0;
    }

    protected abstract I createInputBuffer();

    protected abstract O createOutputBuffer();

    protected abstract E decode(I var1, O var2);

    public static interface EventListener<E> {
        public void onDecoderError(E var1);
    }
}

