/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.util.Assertions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Util {
    public static final int SDK_INT = Build.VERSION.SDK_INT == 23 && Build.VERSION.CODENAME.charAt(0) == 'N' ? 24 : Build.VERSION.SDK_INT;
    public static final String DEVICE = Build.DEVICE;
    public static final String MANUFACTURER = Build.MANUFACTURER;
    public static final String MODEL = Build.MODEL;
    public static final int TYPE_DASH = 0;
    public static final int TYPE_SS = 1;
    public static final int TYPE_HLS = 2;
    public static final int TYPE_OTHER = 3;
    private static final Pattern XS_DATE_TIME_PATTERN = Pattern.compile("(\\d\\d\\d\\d)\\-(\\d\\d)\\-(\\d\\d)[Tt](\\d\\d):(\\d\\d):(\\d\\d)(\\.(\\d+))?([Zz]|((\\+|\\-)(\\d\\d):(\\d\\d)))?");
    private static final Pattern XS_DURATION_PATTERN = Pattern.compile("^(-)?P(([0-9]*)Y)?(([0-9]*)M)?(([0-9]*)D)?(T(([0-9]*)H)?(([0-9]*)M)?(([0-9.]*)S)?)?$");
    private static final Pattern ESCAPED_CHARACTER_PATTERN = Pattern.compile("%([A-Fa-f0-9]{2})");
    private static final long MAX_BYTES_TO_DRAIN = 2048L;

    private Util() {
    }

    @SuppressLint(value={"InlinedApi"})
    public static boolean isAndroidTv(Context context) {
        return context.getPackageManager().hasSystemFeature("android.software.leanback");
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static boolean isLocalFileUri(Uri uri) {
        String string = uri.getScheme();
        return TextUtils.isEmpty((CharSequence)string) || string.equals("file");
    }

    public static boolean areEqual(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public static boolean contains(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!Util.areEqual(objectArray[i], object)) continue;
            return true;
        }
        return false;
    }

    public static ExecutorService newSingleThreadExecutor(final String string) {
        return Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, string);
            }
        });
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(final String string) {
        return Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, string);
            }
        });
    }

    public static void closeQuietly(DataSource dataSource) {
        try {
            dataSource.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(OutputStream outputStream) {
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String toLowerInvariant(String string) {
        return string == null ? null : string.toLowerCase(Locale.US);
    }

    public static int ceilDivide(int n, int n2) {
        return (n + n2 - 1) / n2;
    }

    public static long ceilDivide(long l, long l2) {
        return (l + l2 - 1L) / l2;
    }

    public static int binarySearchFloor(long[] lArray, long l, boolean bl, boolean bl2) {
        int n = Arrays.binarySearch(lArray, l);
        n = n < 0 ? -(n + 2) : (bl ? n : n - 1);
        return bl2 ? Math.max(0, n) : n;
    }

    public static int binarySearchCeil(long[] lArray, long l, boolean bl, boolean bl2) {
        int n = Arrays.binarySearch(lArray, l);
        n = n < 0 ? ~n : (bl ? n : n + 1);
        return bl2 ? Math.min(lArray.length - 1, n) : n;
    }

    public static <T> int binarySearchFloor(List<? extends Comparable<? super T>> list, T t, boolean bl, boolean bl2) {
        int n = Collections.binarySearch(list, t);
        n = n < 0 ? -(n + 2) : (bl ? n : n - 1);
        return bl2 ? Math.max(0, n) : n;
    }

    public static <T> int binarySearchCeil(List<? extends Comparable<? super T>> list, T t, boolean bl, boolean bl2) {
        int n = Collections.binarySearch(list, t);
        n = n < 0 ? ~n : (bl ? n : n + 1);
        return bl2 ? Math.min(list.size() - 1, n) : n;
    }

    public static int[] firstIntegersArray(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    public static long parseXsDuration(String string) {
        Matcher matcher = XS_DURATION_PATTERN.matcher(string);
        if (matcher.matches()) {
            boolean bl = !TextUtils.isEmpty((CharSequence)matcher.group(1));
            String string2 = matcher.group(3);
            double d = string2 != null ? Double.parseDouble(string2) * 3.1556908E7 : 0.0;
            String string3 = matcher.group(5);
            d += string3 != null ? Double.parseDouble(string3) * 2629739.0 : 0.0;
            String string4 = matcher.group(7);
            d += string4 != null ? Double.parseDouble(string4) * 86400.0 : 0.0;
            String string5 = matcher.group(10);
            d += string5 != null ? Double.parseDouble(string5) * 3600.0 : 0.0;
            String string6 = matcher.group(12);
            d += string6 != null ? Double.parseDouble(string6) * 60.0 : 0.0;
            String string7 = matcher.group(14);
            long l = (long)((d += string7 != null ? Double.parseDouble(string7) : 0.0) * 1000.0);
            return bl ? -l : l;
        }
        return (long)(Double.parseDouble(string) * 3600.0 * 1000.0);
    }

    public static long parseXsDateTime(String string) throws ParseException {
        int n;
        Matcher matcher = XS_DATE_TIME_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new ParseException("Invalid date/time format: " + string, 0);
        }
        if (matcher.group(9) == null) {
            n = 0;
        } else if (matcher.group(9).equalsIgnoreCase("Z")) {
            n = 0;
        } else {
            n = Integer.parseInt(matcher.group(12)) * 60 + Integer.parseInt(matcher.group(13));
            if (matcher.group(11).equals("-")) {
                n *= -1;
            }
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.clear();
        gregorianCalendar.set(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)) - 1, Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6)));
        if (!TextUtils.isEmpty((CharSequence)matcher.group(8))) {
            BigDecimal bigDecimal = new BigDecimal("0." + matcher.group(8));
            gregorianCalendar.set(14, bigDecimal.movePointRight(3).intValue());
        }
        long l = gregorianCalendar.getTimeInMillis();
        if (n != 0) {
            l -= (long)(n * 60000);
        }
        return l;
    }

    public static long scaleLargeTimestamp(long l, long l2, long l3) {
        if (l3 >= l2 && l3 % l2 == 0L) {
            long l4 = l3 / l2;
            return l / l4;
        }
        if (l3 < l2 && l2 % l3 == 0L) {
            long l5 = l2 / l3;
            return l * l5;
        }
        double d = (double)l2 / (double)l3;
        return (long)((double)l * d);
    }

    public static long[] scaleLargeTimestamps(List<Long> list, long l, long l2) {
        long[] lArray = new long[list.size()];
        if (l2 >= l && l2 % l == 0L) {
            long l3 = l2 / l;
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = list.get(i) / l3;
            }
        } else if (l2 < l && l % l2 == 0L) {
            long l4 = l / l2;
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = list.get(i) * l4;
            }
        } else {
            double d = (double)l / (double)l2;
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = (long)((double)list.get(i).longValue() * d);
            }
        }
        return lArray;
    }

    public static void scaleLargeTimestampsInPlace(long[] lArray, long l, long l2) {
        if (l2 >= l && l2 % l == 0L) {
            long l3 = l2 / l;
            int n = 0;
            while (n < lArray.length) {
                int n2 = n++;
                lArray[n2] = lArray[n2] / l3;
            }
        } else if (l2 < l && l % l2 == 0L) {
            long l4 = l / l2;
            int n = 0;
            while (n < lArray.length) {
                int n3 = n++;
                lArray[n3] = lArray[n3] * l4;
            }
        } else {
            double d = (double)l / (double)l2;
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = (long)((double)lArray[i] * d);
            }
        }
    }

    public static int[] toArray(List<Integer> list) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = list.get(i);
        }
        return nArray;
    }

    public static void maybeTerminateInputStream(HttpURLConnection httpURLConnection, long l) {
        if (SDK_INT != 19 && SDK_INT != 20) {
            return;
        }
        try {
            InputStream inputStream = httpURLConnection.getInputStream();
            if (l == -1L ? inputStream.read() == -1 : l <= 2048L) {
                return;
            }
            String string = inputStream.getClass().getName();
            if (string.equals("com.android.okhttp.internal.http.HttpTransport$ChunkedInputStream") || string.equals("com.android.okhttp.internal.http.HttpTransport$FixedLengthInputStream")) {
                Class<?> clazz = inputStream.getClass().getSuperclass();
                Method method = clazz.getDeclaredMethod("unexpectedEndOfInput", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)inputStream, new Object[0]);
            }
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static DataSpec getRemainderDataSpec(DataSpec dataSpec, int n) {
        if (n == 0) {
            return dataSpec;
        }
        long l = dataSpec.length == -1L ? -1L : dataSpec.length - (long)n;
        return new DataSpec(dataSpec.uri, dataSpec.position + (long)n, l, dataSpec.key, dataSpec.flags);
    }

    public static int getIntegerCodeForString(String string) {
        int n = string.length();
        Assertions.checkArgument(n <= 4);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 <<= 8;
            n2 |= string.charAt(i);
        }
        return n2;
    }

    public static int getTopInt(long l) {
        return (int)(l >>> 32);
    }

    public static int getBottomInt(long l) {
        return (int)l;
    }

    public static long getLong(int n, int n2) {
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    public static String getHexStringFromBytes(byte[] byArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(n2 - n);
        for (int i = n; i < n2; ++i) {
            stringBuilder.append(String.format(Locale.US, "%02X", byArray[i]));
        }
        return stringBuilder.toString();
    }

    public static byte[] getBytesFromHexString(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = i * 2;
            byArray[i] = (byte)((Character.digit(string.charAt(n), 16) << 4) + Character.digit(string.charAt(n + 1), 16));
        }
        return byArray;
    }

    public static <T> String getCommaDelimitedSimpleClassNames(T[] TArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < TArray.length; ++i) {
            stringBuilder.append(TArray[i].getClass().getSimpleName());
            if (i >= TArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public static String getUserAgent(Context context, String string) {
        String string2;
        try {
            String string3 = context.getPackageName();
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(string3, 0);
            string2 = packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            string2 = "?";
        }
        return string + "/" + string2 + " (Linux;Android " + Build.VERSION.RELEASE + ") ExoPlayerLib/" + "1.5.7";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] executePost(String string, byte[] byArray, Map<String, String> map) throws IOException {
        HttpURLConnection httpURLConnection = null;
        try {
            Object object;
            Object object2;
            httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(byArray != null);
            httpURLConnection.setDoInput(true);
            if (map != null) {
                object2 = map.entrySet().iterator();
                while (object2.hasNext()) {
                    object = (Map.Entry)object2.next();
                    httpURLConnection.setRequestProperty((String)object.getKey(), (String)object.getValue());
                }
            }
            if (byArray != null) {
                object2 = httpURLConnection.getOutputStream();
                try {
                    ((OutputStream)object2).write(byArray);
                }
                finally {
                    ((OutputStream)object2).close();
                }
            }
            object2 = httpURLConnection.getInputStream();
            try {
                object = Util.toByteArray((InputStream)object2);
            }
            catch (Throwable throwable) {
                ((InputStream)object2).close();
                throw throwable;
            }
            ((InputStream)object2).close();
            return object;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    public static int inferContentType(String string) {
        if (string == null) {
            return 3;
        }
        if (string.endsWith(".mpd")) {
            return 0;
        }
        if (string.endsWith(".ism")) {
            return 1;
        }
        if (string.endsWith(".m3u8")) {
            return 2;
        }
        return 3;
    }

    public static String escapeFileName(String string) {
        int n;
        int n2 = string.length();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (!Util.shouldEscapeCharacter(string.charAt(n))) continue;
            ++n3;
        }
        if (n3 == 0) {
            return string;
        }
        n = 0;
        StringBuilder stringBuilder = new StringBuilder(n2 + n3 * 2);
        while (n3 > 0) {
            char c2;
            if (Util.shouldEscapeCharacter(c2 = string.charAt(n++))) {
                stringBuilder.append('%').append(Integer.toHexString(c2));
                --n3;
                continue;
            }
            stringBuilder.append(c2);
        }
        if (n < n2) {
            stringBuilder.append(string, n, n2);
        }
        return stringBuilder.toString();
    }

    private static boolean shouldEscapeCharacter(char c2) {
        switch (c2) {
            case '\"': 
            case '%': 
            case '*': 
            case '/': 
            case ':': 
            case '<': 
            case '>': 
            case '?': 
            case '\\': 
            case '|': {
                return true;
            }
        }
        return false;
    }

    public static String unescapeFileName(String string) {
        int n;
        int n2 = string.length();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (string.charAt(n) != '%') continue;
            ++n3;
        }
        if (n3 == 0) {
            return string;
        }
        n = n2 - n3 * 2;
        StringBuilder stringBuilder = new StringBuilder(n);
        Matcher matcher = ESCAPED_CHARACTER_PATTERN.matcher(string);
        int n4 = 0;
        while (n3 > 0 && matcher.find()) {
            char c2 = (char)Integer.parseInt(matcher.group(1), 16);
            stringBuilder.append(string, n4, matcher.start()).append(c2);
            n4 = matcher.end();
            --n3;
        }
        if (n4 < n2) {
            stringBuilder.append(string, n4, n2);
        }
        if (stringBuilder.length() != n) {
            return null;
        }
        return stringBuilder.toString();
    }
}

