/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public final class SlidingPercentile {
    private static final Comparator<Sample> INDEX_COMPARATOR = new Comparator<Sample>(){

        @Override
        public int compare(Sample sample, Sample sample2) {
            return sample.index - sample2.index;
        }
    };
    private static final Comparator<Sample> VALUE_COMPARATOR = new Comparator<Sample>(){

        @Override
        public int compare(Sample sample, Sample sample2) {
            return sample.value < sample2.value ? -1 : (sample2.value < sample.value ? 1 : 0);
        }
    };
    private static final int SORT_ORDER_NONE = -1;
    private static final int SORT_ORDER_BY_VALUE = 0;
    private static final int SORT_ORDER_BY_INDEX = 1;
    private static final int MAX_RECYCLED_SAMPLES = 5;
    private final int maxWeight;
    private final ArrayList<Sample> samples;
    private final Sample[] recycledSamples;
    private int currentSortOrder;
    private int nextSampleIndex;
    private int totalWeight;
    private int recycledSampleCount;

    public SlidingPercentile(int n) {
        this.maxWeight = n;
        this.recycledSamples = new Sample[5];
        this.samples = new ArrayList();
        this.currentSortOrder = -1;
    }

    public void addSample(int n, float f) {
        this.ensureSortedByIndex();
        Sample sample = this.recycledSampleCount > 0 ? this.recycledSamples[--this.recycledSampleCount] : new Sample();
        sample.index = this.nextSampleIndex++;
        sample.weight = n;
        sample.value = f;
        this.samples.add(sample);
        this.totalWeight += n;
        while (this.totalWeight > this.maxWeight) {
            int n2 = this.totalWeight - this.maxWeight;
            Sample sample2 = this.samples.get(0);
            if (sample2.weight <= n2) {
                this.totalWeight -= sample2.weight;
                this.samples.remove(0);
                if (this.recycledSampleCount >= 5) continue;
                this.recycledSamples[this.recycledSampleCount++] = sample2;
                continue;
            }
            sample2.weight -= n2;
            this.totalWeight -= n2;
        }
    }

    public float getPercentile(float f) {
        this.ensureSortedByValue();
        float f2 = f * (float)this.totalWeight;
        int n = 0;
        for (int i = 0; i < this.samples.size(); ++i) {
            Sample sample = this.samples.get(i);
            if (!((float)(n += sample.weight) >= f2)) continue;
            return sample.value;
        }
        return this.samples.isEmpty() ? Float.NaN : this.samples.get((int)(this.samples.size() - 1)).value;
    }

    private void ensureSortedByIndex() {
        if (this.currentSortOrder != 1) {
            Collections.sort(this.samples, INDEX_COMPARATOR);
            this.currentSortOrder = 1;
        }
    }

    private void ensureSortedByValue() {
        if (this.currentSortOrder != 0) {
            Collections.sort(this.samples, VALUE_COMPARATOR);
            this.currentSortOrder = 0;
        }
    }

    private static class Sample {
        public int index;
        public int weight;
        public float value;

        private Sample() {
        }
    }
}

