/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.util;

import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.CodecSpecificDataUtil;
import com.google.android.exoplayer.util.ParsableBitArray;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.vcc.playerwrappersdk.a;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class NalUnitUtil {
    private static final String TAG = "NalUnitUtil";
    public static final byte[] NAL_START_CODE = new byte[]{0, 0, 0, 1};
    public static final int EXTENDED_SAR = 255;
    public static final float[] ASPECT_RATIO_IDC_VALUES = new float[]{1.0f, 1.0f, 1.0909091f, 0.90909094f, 1.4545455f, 1.2121212f, 2.1818182f, 1.8181819f, 2.909091f, 2.4242425f, 1.6363636f, 1.3636364f, 1.939394f, 1.6161616f, 1.3333334f, 1.5f, 2.0f};
    private static final int NAL_UNIT_TYPE_SPS = 7;
    private static final Object scratchEscapePositionsLock = new Object();
    private static int[] scratchEscapePositions = new int[10];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int unescapeStream(byte[] byArray, int n) {
        Object object = scratchEscapePositionsLock;
        synchronized (object) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            while (n3 < n) {
                if ((n3 = NalUnitUtil.findNextUnescapeIndex(byArray, n3, n)) >= n) continue;
                if (scratchEscapePositions.length <= n4) {
                    scratchEscapePositions = Arrays.copyOf(scratchEscapePositions, scratchEscapePositions.length * 2);
                }
                NalUnitUtil.scratchEscapePositions[n4++] = n3;
                n3 += 3;
            }
            int n5 = n - n4;
            int n6 = 0;
            int n7 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                int n8 = scratchEscapePositions[n2];
                int n9 = n8 - n6;
                System.arraycopy(byArray, n6, byArray, n7, n9);
                n7 += n9;
                byArray[n7++] = 0;
                byArray[n7++] = 0;
                n6 += n9 + 3;
            }
            n2 = n5 - n7;
            System.arraycopy(byArray, n6, byArray, n7, n2);
            return n5;
        }
    }

    public static void discardToSps(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        int n2 = 0;
        int n3 = 0;
        while (n3 + 1 < n) {
            int n4 = byteBuffer.get(n3) & 0xFF;
            if (n2 == 3) {
                if (n4 == 1 && (byteBuffer.get(n3 + 1) & 0x1F) == 7) {
                    ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                    byteBuffer2.position(n3 - 3);
                    byteBuffer2.limit(n);
                    byteBuffer.position(0);
                    byteBuffer.put(byteBuffer2);
                    return;
                }
            } else if (n4 == 0) {
                ++n2;
            }
            if (n4 != 0) {
                n2 = 0;
            }
            ++n3;
        }
        byteBuffer.clear();
    }

    public static byte[] parseChildNalUnit(ParsableByteArray parsableByteArray) {
        int n = parsableByteArray.readUnsignedShort();
        int n2 = parsableByteArray.getPosition();
        parsableByteArray.skipBytes(n);
        return CodecSpecificDataUtil.buildNalUnit(parsableByteArray.data, n2, n);
    }

    public static int getNalUnitType(byte[] byArray, int n) {
        return byArray[n + 3] & 0x1F;
    }

    public static int getH265NalUnitType(byte[] byArray, int n) {
        return (byArray[n + 3] & 0x7E) >> 1;
    }

    public static SpsData parseSpsNalUnit(ParsableBitArray parsableBitArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl;
        boolean bl2;
        int n6;
        int n7;
        int n8;
        int n9 = parsableBitArray.readBits(8);
        parsableBitArray.skipBits(16);
        int n10 = parsableBitArray.readUnsignedExpGolombCodedInt();
        int n11 = 1;
        boolean bl3 = false;
        if (n9 == 100 || n9 == 110 || n9 == 122 || n9 == 244 || n9 == 44 || n9 == 83 || n9 == 86 || n9 == 118 || n9 == 128 || n9 == 138) {
            n11 = parsableBitArray.readUnsignedExpGolombCodedInt();
            if (n11 == 3) {
                bl3 = parsableBitArray.readBit();
            }
            parsableBitArray.readUnsignedExpGolombCodedInt();
            parsableBitArray.readUnsignedExpGolombCodedInt();
            parsableBitArray.skipBits(1);
            n8 = parsableBitArray.readBit();
            if (n8 != 0) {
                n7 = n11 != 3 ? 8 : 12;
                for (n6 = 0; n6 < n7; ++n6) {
                    bl2 = parsableBitArray.readBit();
                    if (!bl2) continue;
                    NalUnitUtil.skipScalingList(parsableBitArray, n6 < 6 ? 16 : 64);
                }
            }
        }
        n8 = parsableBitArray.readUnsignedExpGolombCodedInt() + 4;
        n7 = parsableBitArray.readUnsignedExpGolombCodedInt();
        n6 = 0;
        bl2 = false;
        if (n7 == 0) {
            n6 = parsableBitArray.readUnsignedExpGolombCodedInt() + 4;
        } else if (n7 == 1) {
            bl2 = parsableBitArray.readBit();
            parsableBitArray.readSignedExpGolombCodedInt();
            parsableBitArray.readSignedExpGolombCodedInt();
            long l = parsableBitArray.readUnsignedExpGolombCodedInt();
            bl = false;
            while ((long)bl < l) {
                parsableBitArray.readUnsignedExpGolombCodedInt();
                bl += 1;
            }
        }
        parsableBitArray.readUnsignedExpGolombCodedInt();
        parsableBitArray.skipBits(1);
        int n12 = parsableBitArray.readUnsignedExpGolombCodedInt() + 1;
        int n13 = parsableBitArray.readUnsignedExpGolombCodedInt() + 1;
        bl = parsableBitArray.readBit();
        int n14 = (2 - (bl ? 1 : 0)) * n13;
        if (!bl) {
            parsableBitArray.skipBits(1);
        }
        parsableBitArray.skipBits(1);
        int n15 = n12 * 16;
        int n16 = n14 * 16;
        boolean bl4 = parsableBitArray.readBit();
        if (bl4) {
            int n17 = parsableBitArray.readUnsignedExpGolombCodedInt();
            n5 = parsableBitArray.readUnsignedExpGolombCodedInt();
            n4 = parsableBitArray.readUnsignedExpGolombCodedInt();
            n3 = parsableBitArray.readUnsignedExpGolombCodedInt();
            if (n11 == 0) {
                n2 = 1;
                n = 2 - (bl ? 1 : 0);
            } else {
                int n18 = n11 == 3 ? 1 : 2;
                int n19 = n11 == 1 ? 2 : 1;
                n2 = n18;
                n = n19 * (2 - (bl ? 1 : 0));
            }
            n15 -= (n17 + n5) * n2;
            n16 -= (n4 + n3) * n;
        }
        float f = 1.0f;
        n5 = parsableBitArray.readBit();
        if (n5 != 0 && (n4 = (int)(parsableBitArray.readBit() ? 1 : 0)) != 0) {
            n3 = parsableBitArray.readBits(8);
            if (n3 == 255) {
                n2 = parsableBitArray.readBits(16);
                n = parsableBitArray.readBits(16);
                if (n2 != 0 && n != 0) {
                    f = (float)n2 / (float)n;
                }
            } else if (n3 < ASPECT_RATIO_IDC_VALUES.length) {
                f = ASPECT_RATIO_IDC_VALUES[n3];
            } else {
                a.b(TAG, "Unexpected aspect_ratio_idc value: " + n3);
            }
        }
        return new SpsData(n10, n15, n16, f, bl3, bl, n8, n7, n6, bl2);
    }

    public static PpsData parsePpsNalUnit(ParsableBitArray parsableBitArray) {
        int n = parsableBitArray.readUnsignedExpGolombCodedInt();
        int n2 = parsableBitArray.readUnsignedExpGolombCodedInt();
        parsableBitArray.skipBits(1);
        boolean bl = parsableBitArray.readBit();
        return new PpsData(n, n2, bl);
    }

    public static int findNalUnit(byte[] byArray, int n, int n2, boolean[] blArray) {
        int n3 = n2 - n;
        Assertions.checkState(n3 >= 0);
        if (n3 == 0) {
            return n2;
        }
        if (blArray != null) {
            if (blArray[0]) {
                NalUnitUtil.clearPrefixFlags(blArray);
                return n - 3;
            }
            if (n3 > 1 && blArray[1] && byArray[n] == 1) {
                NalUnitUtil.clearPrefixFlags(blArray);
                return n - 2;
            }
            if (n3 > 2 && blArray[2] && byArray[n] == 0 && byArray[n + 1] == 1) {
                NalUnitUtil.clearPrefixFlags(blArray);
                return n - 1;
            }
        }
        int n4 = n2 - 1;
        for (int i = n + 2; i < n4; i += 3) {
            if ((byArray[i] & 0xFE) != 0) continue;
            if (byArray[i - 2] == 0 && byArray[i - 1] == 0 && byArray[i] == 1) {
                if (blArray != null) {
                    NalUnitUtil.clearPrefixFlags(blArray);
                }
                return i - 2;
            }
            i -= 2;
        }
        if (blArray != null) {
            boolean bl = n3 > 2 ? byArray[n2 - 3] == 0 && byArray[n2 - 2] == 0 && byArray[n2 - 1] == 1 : (n3 == 2 ? blArray[2] && byArray[n2 - 2] == 0 && byArray[n2 - 1] == 1 : (blArray[0] = blArray[1] && byArray[n2 - 1] == 1));
            blArray[1] = n3 > 1 ? byArray[n2 - 2] == 0 && byArray[n2 - 1] == 0 : blArray[2] && byArray[n2 - 1] == 0;
            blArray[2] = byArray[n2 - 1] == 0;
        }
        return n2;
    }

    public static void clearPrefixFlags(boolean[] blArray) {
        blArray[0] = false;
        blArray[1] = false;
        blArray[2] = false;
    }

    private static int findNextUnescapeIndex(byte[] byArray, int n, int n2) {
        for (int i = n; i < n2 - 2; ++i) {
            if (byArray[i] != 0 || byArray[i + 1] != 0 || byArray[i + 2] != 3) continue;
            return i;
        }
        return n2;
    }

    private static void skipScalingList(ParsableBitArray parsableBitArray, int n) {
        int n2 = 8;
        int n3 = 8;
        for (int i = 0; i < n; ++i) {
            if (n3 != 0) {
                int n4 = parsableBitArray.readSignedExpGolombCodedInt();
                n3 = (n2 + n4 + 256) % 256;
            }
            n2 = n3 == 0 ? n2 : n3;
        }
    }

    private NalUnitUtil() {
    }

    public static final class PpsData {
        public final int picParameterSetId;
        public final int seqParameterSetId;
        public final boolean bottomFieldPicOrderInFramePresentFlag;

        public PpsData(int n, int n2, boolean bl) {
            this.picParameterSetId = n;
            this.seqParameterSetId = n2;
            this.bottomFieldPicOrderInFramePresentFlag = bl;
        }
    }

    public static final class SpsData {
        public final int seqParameterSetId;
        public final int width;
        public final int height;
        public final float pixelWidthAspectRatio;
        public final boolean separateColorPlaneFlag;
        public final boolean frameMbsOnlyFlag;
        public final int frameNumLength;
        public final int picOrderCountType;
        public final int picOrderCntLsbLength;
        public final boolean deltaPicOrderAlwaysZeroFlag;

        public SpsData(int n, int n2, int n3, float f, boolean bl, boolean bl2, int n4, int n5, int n6, boolean bl3) {
            this.seqParameterSetId = n;
            this.width = n2;
            this.height = n3;
            this.pixelWidthAspectRatio = f;
            this.separateColorPlaneFlag = bl;
            this.frameMbsOnlyFlag = bl2;
            this.frameNumLength = n4;
            this.picOrderCountType = n5;
            this.picOrderCntLsbLength = n6;
            this.deltaPicOrderAlwaysZeroFlag = bl3;
        }
    }
}

