/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.util;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.util.ParsableBitArray;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.nio.ByteBuffer;

public final class Ac3Util {
    private static final int AUDIO_SAMPLES_PER_AUDIO_BLOCK = 256;
    private static final int AC3_SYNCFRAME_AUDIO_SAMPLE_COUNT = 1536;
    private static final int[] BLOCKS_PER_SYNCFRAME_BY_NUMBLKSCOD = new int[]{1, 2, 3, 6};
    private static final int[] SAMPLE_RATE_BY_FSCOD = new int[]{48000, 44100, 32000};
    private static final int[] SAMPLE_RATE_BY_FSCOD2 = new int[]{24000, 22050, 16000};
    private static final int[] CHANNEL_COUNT_BY_ACMOD = new int[]{2, 1, 2, 3, 3, 4, 4, 5};
    private static final int[] BITRATE_BY_HALF_FRMSIZECOD = new int[]{32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384, 448, 512, 576, 640};
    private static final int[] SYNCFRAME_SIZE_WORDS_BY_HALF_FRMSIZECOD_44_1 = new int[]{69, 87, 104, 121, 139, 174, 208, 243, 278, 348, 417, 487, 557, 696, 835, 975, 1114, 1253, 1393};

    public static MediaFormat parseAc3AnnexFFormat(ParsableByteArray parsableByteArray, String string, long l, String string2) {
        int n = (parsableByteArray.readUnsignedByte() & 0xC0) >> 6;
        int n2 = SAMPLE_RATE_BY_FSCOD[n];
        int n3 = parsableByteArray.readUnsignedByte();
        int n4 = CHANNEL_COUNT_BY_ACMOD[(n3 & 0x38) >> 3];
        if ((n3 & 4) != 0) {
            ++n4;
        }
        return MediaFormat.createAudioFormat(string, "audio/ac3", -1, -1, l, n4, n2, null, string2);
    }

    public static MediaFormat parseEAc3AnnexFFormat(ParsableByteArray parsableByteArray, String string, long l, String string2) {
        parsableByteArray.skipBytes(2);
        int n = (parsableByteArray.readUnsignedByte() & 0xC0) >> 6;
        int n2 = SAMPLE_RATE_BY_FSCOD[n];
        int n3 = parsableByteArray.readUnsignedByte();
        int n4 = CHANNEL_COUNT_BY_ACMOD[(n3 & 0xE) >> 1];
        if ((n3 & 1) != 0) {
            ++n4;
        }
        return MediaFormat.createAudioFormat(string, "audio/eac3", -1, -1, l, n4, n2, null, string2);
    }

    public static MediaFormat parseAc3SyncframeFormat(ParsableBitArray parsableBitArray, String string, long l, String string2) {
        parsableBitArray.skipBits(32);
        int n = parsableBitArray.readBits(2);
        parsableBitArray.skipBits(14);
        int n2 = parsableBitArray.readBits(3);
        if ((n2 & 1) != 0 && n2 != 1) {
            parsableBitArray.skipBits(2);
        }
        if ((n2 & 4) != 0) {
            parsableBitArray.skipBits(2);
        }
        if (n2 == 2) {
            parsableBitArray.skipBits(2);
        }
        boolean bl = parsableBitArray.readBit();
        return MediaFormat.createAudioFormat(string, "audio/ac3", -1, -1, l, CHANNEL_COUNT_BY_ACMOD[n2] + (bl ? 1 : 0), SAMPLE_RATE_BY_FSCOD[n], null, string2);
    }

    public static MediaFormat parseEac3SyncframeFormat(ParsableBitArray parsableBitArray, String string, long l, String string2) {
        int n;
        parsableBitArray.skipBits(32);
        int n2 = parsableBitArray.readBits(2);
        if (n2 == 3) {
            n = SAMPLE_RATE_BY_FSCOD2[parsableBitArray.readBits(2)];
        } else {
            parsableBitArray.skipBits(2);
            n = SAMPLE_RATE_BY_FSCOD[n2];
        }
        int n3 = parsableBitArray.readBits(3);
        boolean bl = parsableBitArray.readBit();
        return MediaFormat.createAudioFormat(string, "audio/eac3", -1, -1, l, CHANNEL_COUNT_BY_ACMOD[n3] + (bl ? 1 : 0), n, null, string2);
    }

    public static int parseAc3SyncframeSize(byte[] byArray) {
        int n = (byArray[4] & 0xC0) >> 6;
        int n2 = byArray[4] & 0x3F;
        return Ac3Util.getAc3SyncframeSize(n, n2);
    }

    public static int parseEAc3SyncframeSize(byte[] byArray) {
        return 2 * (((byArray[2] & 7) << 8) + (byArray[3] & 0xFF) + 1);
    }

    public static int getAc3SyncframeAudioSampleCount() {
        return 1536;
    }

    public static int parseEAc3SyncframeAudioSampleCount(byte[] byArray) {
        return 256 * ((byArray[4] & 0xC0) >> 6 == 3 ? 6 : BLOCKS_PER_SYNCFRAME_BY_NUMBLKSCOD[(byArray[4] & 0x30) >> 4]);
    }

    public static int parseEAc3SyncframeAudioSampleCount(ByteBuffer byteBuffer) {
        int n = (byteBuffer.get(byteBuffer.position() + 4) & 0xC0) >> 6;
        return 256 * (n == 3 ? 6 : BLOCKS_PER_SYNCFRAME_BY_NUMBLKSCOD[(byteBuffer.get(byteBuffer.position() + 4) & 0x30) >> 4]);
    }

    private static int getAc3SyncframeSize(int n, int n2) {
        int n3 = SAMPLE_RATE_BY_FSCOD[n];
        if (n3 == 44100) {
            return 2 * (SYNCFRAME_SIZE_WORDS_BY_HALF_FRMSIZECOD_44_1[n2 / 2] + n2 % 2);
        }
        int n4 = BITRATE_BY_HALF_FRMSIZECOD[n2 / 2];
        if (n3 == 32000) {
            return 6 * n4;
        }
        return 4 * n4;
    }

    private Ac3Util() {
    }
}

