/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream.cache;

import android.os.ConditionVariable;
import com.google.android.exoplayer.upstream.cache.Cache;
import com.google.android.exoplayer.upstream.cache.CacheEvictor;
import com.google.android.exoplayer.upstream.cache.CacheSpan;
import com.google.android.exoplayer.util.Assertions;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class SimpleCache
implements Cache {
    private final File cacheDir;
    private final CacheEvictor evictor;
    private final HashMap<String, CacheSpan> lockedSpans;
    private final HashMap<String, TreeSet<CacheSpan>> cachedSpans;
    private final HashMap<String, ArrayList<Cache.Listener>> listeners;
    private long totalSpace = 0L;

    public SimpleCache(File file, CacheEvictor cacheEvictor) {
        this.cacheDir = file;
        this.evictor = cacheEvictor;
        this.lockedSpans = new HashMap();
        this.cachedSpans = new HashMap();
        this.listeners = new HashMap();
        final ConditionVariable conditionVariable = new ConditionVariable();
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SimpleCache simpleCache = SimpleCache.this;
                synchronized (simpleCache) {
                    conditionVariable.open();
                    SimpleCache.this.initialize();
                }
            }
        }.start();
        conditionVariable.block();
    }

    @Override
    public synchronized NavigableSet<CacheSpan> addListener(String string, Cache.Listener listener) {
        ArrayList<Cache.Listener> arrayList = this.listeners.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.listeners.put(string, arrayList);
        }
        arrayList.add(listener);
        return this.getCachedSpans(string);
    }

    @Override
    public synchronized void removeListener(String string, Cache.Listener listener) {
        ArrayList<Cache.Listener> arrayList = this.listeners.get(string);
        if (arrayList != null) {
            arrayList.remove(listener);
            if (arrayList.isEmpty()) {
                this.listeners.remove(string);
            }
        }
    }

    @Override
    public synchronized NavigableSet<CacheSpan> getCachedSpans(String string) {
        TreeSet<CacheSpan> treeSet = this.cachedSpans.get(string);
        return treeSet == null ? null : new TreeSet<CacheSpan>((SortedSet<CacheSpan>)treeSet);
    }

    @Override
    public synchronized Set<String> getKeys() {
        return new HashSet<String>(this.cachedSpans.keySet());
    }

    @Override
    public synchronized long getCacheSpace() {
        return this.totalSpace;
    }

    @Override
    public synchronized CacheSpan startReadWrite(String string, long l) throws InterruptedException {
        CacheSpan cacheSpan = CacheSpan.createLookup(string, l);
        CacheSpan cacheSpan2;
        while ((cacheSpan2 = this.startReadWriteNonBlocking(cacheSpan)) == null) {
            this.wait();
        }
        return cacheSpan2;
    }

    @Override
    public synchronized CacheSpan startReadWriteNonBlocking(String string, long l) {
        return this.startReadWriteNonBlocking(CacheSpan.createLookup(string, l));
    }

    private synchronized CacheSpan startReadWriteNonBlocking(CacheSpan cacheSpan) {
        CacheSpan cacheSpan2 = this.getSpan(cacheSpan);
        if (cacheSpan2.isCached) {
            CacheSpan cacheSpan3 = cacheSpan2;
            TreeSet<CacheSpan> treeSet = this.cachedSpans.get(cacheSpan3.key);
            Assertions.checkState(treeSet.remove(cacheSpan3));
            cacheSpan2 = cacheSpan3.touch();
            treeSet.add(cacheSpan2);
            this.notifySpanTouched(cacheSpan3, cacheSpan2);
            return cacheSpan2;
        }
        if (!this.lockedSpans.containsKey(cacheSpan.key)) {
            this.lockedSpans.put(cacheSpan.key, cacheSpan2);
            return cacheSpan2;
        }
        return null;
    }

    @Override
    public synchronized File startFile(String string, long l, long l2) {
        Assertions.checkState(this.lockedSpans.containsKey(string));
        if (!this.cacheDir.exists()) {
            this.removeStaleSpans();
            this.cacheDir.mkdirs();
        }
        this.evictor.onStartFile(this, string, l, l2);
        return CacheSpan.getCacheFileName(this.cacheDir, string, l, System.currentTimeMillis());
    }

    @Override
    public synchronized void commitFile(File file) {
        CacheSpan cacheSpan = CacheSpan.createCacheEntry(file);
        Assertions.checkState(cacheSpan != null);
        Assertions.checkState(this.lockedSpans.containsKey(cacheSpan.key));
        if (!file.exists()) {
            return;
        }
        long l = file.length();
        if (l == 0L) {
            file.delete();
            return;
        }
        this.addSpan(cacheSpan);
        this.notifyAll();
    }

    @Override
    public synchronized void releaseHoleSpan(CacheSpan cacheSpan) {
        Assertions.checkState(cacheSpan == this.lockedSpans.remove(cacheSpan.key));
        this.notifyAll();
    }

    private CacheSpan getSpan(CacheSpan cacheSpan) {
        String string = cacheSpan.key;
        long l = cacheSpan.position;
        TreeSet<CacheSpan> treeSet = this.cachedSpans.get(string);
        if (treeSet == null) {
            return CacheSpan.createOpenHole(string, cacheSpan.position);
        }
        CacheSpan cacheSpan2 = treeSet.floor(cacheSpan);
        if (cacheSpan2 != null && cacheSpan2.position <= l && l < cacheSpan2.position + cacheSpan2.length) {
            if (cacheSpan2.file.exists()) {
                return cacheSpan2;
            }
            this.removeStaleSpans();
            return this.getSpan(cacheSpan);
        }
        CacheSpan cacheSpan3 = treeSet.ceiling(cacheSpan);
        return cacheSpan3 == null ? CacheSpan.createOpenHole(string, cacheSpan.position) : CacheSpan.createClosedHole(string, cacheSpan.position, cacheSpan3.position - cacheSpan.position);
    }

    private void initialize() {
        File[] fileArray;
        if (!this.cacheDir.exists()) {
            this.cacheDir.mkdirs();
        }
        if ((fileArray = this.cacheDir.listFiles()) == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (file.length() == 0L) {
                file.delete();
                continue;
            }
            CacheSpan cacheSpan = CacheSpan.createCacheEntry(file = CacheSpan.upgradeIfNeeded(file));
            if (cacheSpan == null) {
                file.delete();
                continue;
            }
            this.addSpan(cacheSpan);
        }
    }

    private void addSpan(CacheSpan cacheSpan) {
        TreeSet<CacheSpan> treeSet = this.cachedSpans.get(cacheSpan.key);
        if (treeSet == null) {
            treeSet = new TreeSet();
            this.cachedSpans.put(cacheSpan.key, treeSet);
        }
        treeSet.add(cacheSpan);
        this.totalSpace += cacheSpan.length;
        this.notifySpanAdded(cacheSpan);
    }

    @Override
    public synchronized void removeSpan(CacheSpan cacheSpan) {
        TreeSet<CacheSpan> treeSet = this.cachedSpans.get(cacheSpan.key);
        this.totalSpace -= cacheSpan.length;
        Assertions.checkState(treeSet.remove(cacheSpan));
        cacheSpan.file.delete();
        if (treeSet.isEmpty()) {
            this.cachedSpans.remove(cacheSpan.key);
        }
        this.notifySpanRemoved(cacheSpan);
    }

    private void removeStaleSpans() {
        Iterator<Map.Entry<String, TreeSet<CacheSpan>>> iterator = this.cachedSpans.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, TreeSet<CacheSpan>> entry = iterator.next();
            Iterator<CacheSpan> iterator2 = entry.getValue().iterator();
            boolean bl = true;
            while (iterator2.hasNext()) {
                CacheSpan cacheSpan = iterator2.next();
                if (!cacheSpan.file.exists()) {
                    iterator2.remove();
                    if (cacheSpan.isCached) {
                        this.totalSpace -= cacheSpan.length;
                    }
                    this.notifySpanRemoved(cacheSpan);
                    continue;
                }
                bl = false;
            }
            if (!bl) continue;
            iterator.remove();
        }
    }

    private void notifySpanRemoved(CacheSpan cacheSpan) {
        ArrayList<Cache.Listener> arrayList = this.listeners.get(cacheSpan.key);
        if (arrayList != null) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                arrayList.get(i).onSpanRemoved(this, cacheSpan);
            }
        }
        this.evictor.onSpanRemoved(this, cacheSpan);
    }

    private void notifySpanAdded(CacheSpan cacheSpan) {
        ArrayList<Cache.Listener> arrayList = this.listeners.get(cacheSpan.key);
        if (arrayList != null) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                arrayList.get(i).onSpanAdded(this, cacheSpan);
            }
        }
        this.evictor.onSpanAdded(this, cacheSpan);
    }

    private void notifySpanTouched(CacheSpan cacheSpan, CacheSpan cacheSpan2) {
        ArrayList<Cache.Listener> arrayList = this.listeners.get(cacheSpan.key);
        if (arrayList != null) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                arrayList.get(i).onSpanTouched(this, cacheSpan, cacheSpan2);
            }
        }
        this.evictor.onSpanTouched(this, cacheSpan, cacheSpan2);
    }

    @Override
    public synchronized boolean isCached(String string, long l, long l2) {
        TreeSet<CacheSpan> treeSet = this.cachedSpans.get(string);
        if (treeSet == null) {
            return false;
        }
        CacheSpan cacheSpan = CacheSpan.createLookup(string, l);
        CacheSpan cacheSpan2 = treeSet.floor(cacheSpan);
        if (cacheSpan2 == null || cacheSpan2.position + cacheSpan2.length <= l) {
            return false;
        }
        long l3 = cacheSpan2.position + cacheSpan2.length;
        long l4 = l + l2;
        if (l3 >= l4) {
            return true;
        }
        for (CacheSpan cacheSpan3 : treeSet.tailSet(cacheSpan2, false)) {
            if (cacheSpan3.position > l3) {
                return false;
            }
            if ((l3 = Math.max(l3, cacheSpan3.position + cacheSpan3.length)) < l4) continue;
            return true;
        }
        return false;
    }
}

