/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream.cache;

import android.net.Uri;
import com.google.android.exoplayer.upstream.DataSink;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.FileDataSource;
import com.google.android.exoplayer.upstream.TeeDataSource;
import com.google.android.exoplayer.upstream.cache.Cache;
import com.google.android.exoplayer.upstream.cache.CacheDataSink;
import com.google.android.exoplayer.upstream.cache.CacheSpan;
import com.vcc.playerwrappersdk.a;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;

public final class CacheDataSource
implements DataSource {
    private static final String TAG = "CacheDataSource";
    private final Cache cache;
    private final DataSource cacheReadDataSource;
    private final DataSource cacheWriteDataSource;
    private final DataSource upstreamDataSource;
    private final EventListener eventListener;
    private final boolean blockOnCache;
    private final boolean ignoreCacheOnError;
    private DataSource currentDataSource;
    private Uri uri;
    private int flags;
    private String key;
    private long readPosition;
    private long bytesRemaining;
    private CacheSpan lockedSpan;
    private boolean ignoreCache;
    private long totalCachedBytesRead;

    public CacheDataSource(Cache cache, DataSource dataSource, boolean bl, boolean bl2) {
        this(cache, dataSource, bl, bl2, Long.MAX_VALUE);
    }

    public CacheDataSource(Cache cache, DataSource dataSource, boolean bl, boolean bl2, long l) {
        this(cache, dataSource, new FileDataSource(), new CacheDataSink(cache, l), bl, bl2, null);
    }

    public CacheDataSource(Cache cache, DataSource dataSource, DataSource dataSource2, DataSink dataSink, boolean bl, boolean bl2, EventListener eventListener) {
        this.cache = cache;
        this.cacheReadDataSource = dataSource2;
        this.blockOnCache = bl;
        this.ignoreCacheOnError = bl2;
        this.upstreamDataSource = dataSource;
        this.cacheWriteDataSource = dataSink != null ? new TeeDataSource(dataSource, dataSink) : null;
        this.eventListener = eventListener;
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        try {
            this.uri = dataSpec.uri;
            this.flags = dataSpec.flags;
            this.key = dataSpec.key;
            this.readPosition = dataSpec.position;
            this.bytesRemaining = dataSpec.length;
            this.openNextSource();
            return dataSpec.length;
        }
        catch (IOException iOException) {
            this.handleBeforeThrow(iOException);
            throw iOException;
        }
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            int n3 = this.currentDataSource.read(byArray, n, n2);
            if (n3 >= 0) {
                if (this.currentDataSource == this.cacheReadDataSource) {
                    this.totalCachedBytesRead += (long)n3;
                }
                this.readPosition += (long)n3;
                if (this.bytesRemaining != -1L) {
                    this.bytesRemaining -= (long)n3;
                }
            } else {
                this.closeCurrentSource();
                if (this.bytesRemaining > 0L && this.bytesRemaining != -1L) {
                    this.openNextSource();
                    return this.read(byArray, n, n2);
                }
            }
            return n3;
        }
        catch (IOException iOException) {
            this.handleBeforeThrow(iOException);
            throw iOException;
        }
    }

    @Override
    public void close() throws IOException {
        this.notifyBytesRead();
        try {
            this.closeCurrentSource();
        }
        catch (IOException iOException) {
            this.handleBeforeThrow(iOException);
            throw iOException;
        }
    }

    private void openNextSource() throws IOException {
        DataSpec dataSpec;
        CacheSpan cacheSpan;
        if (this.ignoreCache) {
            cacheSpan = null;
        } else if (this.bytesRemaining == -1L) {
            a.b(TAG, "Cache bypassed due to unbounded length.");
            cacheSpan = null;
        } else if (this.blockOnCache) {
            try {
                cacheSpan = this.cache.startReadWrite(this.key, this.readPosition);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        } else {
            cacheSpan = this.cache.startReadWriteNonBlocking(this.key, this.readPosition);
        }
        if (cacheSpan == null) {
            this.currentDataSource = this.upstreamDataSource;
            dataSpec = new DataSpec(this.uri, this.readPosition, this.bytesRemaining, this.key, this.flags);
        } else if (cacheSpan.isCached) {
            Uri uri = Uri.fromFile((File)cacheSpan.file);
            long l = this.readPosition - cacheSpan.position;
            long l2 = Math.min(cacheSpan.length - l, this.bytesRemaining);
            dataSpec = new DataSpec(uri, this.readPosition, l, l2, this.key, this.flags);
            this.currentDataSource = this.cacheReadDataSource;
        } else {
            this.lockedSpan = cacheSpan;
            long l = cacheSpan.isOpenEnded() ? this.bytesRemaining : Math.min(cacheSpan.length, this.bytesRemaining);
            dataSpec = new DataSpec(this.uri, this.readPosition, l, this.key, this.flags);
            this.currentDataSource = this.cacheWriteDataSource != null ? this.cacheWriteDataSource : this.upstreamDataSource;
        }
        this.currentDataSource.open(dataSpec);
    }

    private void closeCurrentSource() throws IOException {
        if (this.currentDataSource == null) {
            return;
        }
        try {
            this.currentDataSource.close();
            this.currentDataSource = null;
        }
        finally {
            if (this.lockedSpan != null) {
                this.cache.releaseHoleSpan(this.lockedSpan);
                this.lockedSpan = null;
            }
        }
    }

    private void handleBeforeThrow(IOException iOException) {
        if (this.ignoreCacheOnError && (this.currentDataSource == this.cacheReadDataSource || iOException instanceof CacheDataSink.CacheDataSinkException)) {
            this.ignoreCache = true;
        }
    }

    private void notifyBytesRead() {
        if (this.eventListener != null && this.totalCachedBytesRead > 0L) {
            this.eventListener.onCachedBytesRead(this.cache.getCacheSpace(), this.totalCachedBytesRead);
            this.totalCachedBytesRead = 0L;
        }
    }

    public static interface EventListener {
        public void onCachedBytesRead(long var1, long var3);
    }
}

