/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import java.io.IOException;
import java.util.PriorityQueue;

public final class NetworkLock {
    public static final NetworkLock instance = new NetworkLock();
    public static final int STREAMING_PRIORITY = 0;
    public static final int DOWNLOAD_PRIORITY = 10;
    private final Object lock = new Object();
    private final PriorityQueue<Integer> queue = new PriorityQueue();
    private int highestPriority = Integer.MAX_VALUE;

    private NetworkLock() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void proceed(int n) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.highestPriority < n) {
                this.lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean proceedNonBlocking(int n) {
        Object object = this.lock;
        synchronized (object) {
            return this.highestPriority >= n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void proceedOrThrow(int n) throws PriorityTooLowException {
        Object object = this.lock;
        synchronized (object) {
            if (this.highestPriority < n) {
                throw new PriorityTooLowException(n, this.highestPriority);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.queue.add(n);
            this.highestPriority = Math.min(this.highestPriority, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.queue.remove(n);
            this.highestPriority = this.queue.isEmpty() ? Integer.MAX_VALUE : this.queue.peek();
            this.lock.notifyAll();
        }
    }

    public static class PriorityTooLowException
    extends IOException {
        public PriorityTooLowException(int n, int n2) {
            super("Priority too low [priority=" + n + ", highest=" + n2 + "]");
        }
    }
}

