/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import android.text.TextUtils;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.HttpDataSource;
import com.google.android.exoplayer.upstream.TransferListener;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Predicate;
import com.google.android.exoplayer.util.Util;
import com.vcc.playerwrappersdk.a;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultHttpDataSource
implements HttpDataSource {
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 8000;
    public static final int DEFAULT_READ_TIMEOUT_MILLIS = 8000;
    private static final int MAX_REDIRECTS = 20;
    private static final String TAG = "DefaultHttpDataSource";
    private static final Pattern CONTENT_RANGE_HEADER = Pattern.compile("^bytes (\\d+)-(\\d+)/(\\d+)$");
    private static final AtomicReference<byte[]> skipBufferReference = new AtomicReference();
    private final boolean allowCrossProtocolRedirects;
    private final int connectTimeoutMillis;
    private final int readTimeoutMillis;
    private final String userAgent;
    private final Predicate<String> contentTypePredicate;
    private final HashMap<String, String> requestProperties;
    private final TransferListener listener;
    private DataSpec dataSpec;
    private HttpURLConnection connection;
    private InputStream inputStream;
    private boolean opened;
    private long bytesToSkip;
    private long bytesToRead;
    private long bytesSkipped;
    private long bytesRead;

    public DefaultHttpDataSource(String string, Predicate<String> predicate) {
        this(string, predicate, null);
    }

    public DefaultHttpDataSource(String string, Predicate<String> predicate, TransferListener transferListener) {
        this(string, predicate, transferListener, 8000, 8000);
    }

    public DefaultHttpDataSource(String string, Predicate<String> predicate, TransferListener transferListener, int n, int n2) {
        this(string, predicate, transferListener, n, n2, false);
    }

    public DefaultHttpDataSource(String string, Predicate<String> predicate, TransferListener transferListener, int n, int n2, boolean bl) {
        this.userAgent = Assertions.checkNotEmpty(string);
        this.contentTypePredicate = predicate;
        this.listener = transferListener;
        this.requestProperties = new HashMap();
        this.connectTimeoutMillis = n;
        this.readTimeoutMillis = n2;
        this.allowCrossProtocolRedirects = bl;
    }

    @Override
    public String getUri() {
        return this.connection == null ? null : this.connection.getURL().toString();
    }

    @Override
    public Map<String, List<String>> getResponseHeaders() {
        return this.connection == null ? null : this.connection.getHeaderFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequestProperty(String string, String string2) {
        Assertions.checkNotNull(string);
        Assertions.checkNotNull(string2);
        HashMap<String, String> hashMap = this.requestProperties;
        synchronized (hashMap) {
            this.requestProperties.put(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearRequestProperty(String string) {
        Assertions.checkNotNull(string);
        HashMap<String, String> hashMap = this.requestProperties;
        synchronized (hashMap) {
            this.requestProperties.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllRequestProperties() {
        HashMap<String, String> hashMap = this.requestProperties;
        synchronized (hashMap) {
            this.requestProperties.clear();
        }
    }

    @Override
    public long open(DataSpec dataSpec) throws HttpDataSource.HttpDataSourceException {
        int n;
        this.dataSpec = dataSpec;
        this.bytesRead = 0L;
        this.bytesSkipped = 0L;
        try {
            this.connection = this.makeConnection(dataSpec);
        }
        catch (IOException iOException) {
            throw new HttpDataSource.HttpDataSourceException("Unable to connect to " + dataSpec.uri.toString(), iOException, dataSpec);
        }
        try {
            n = this.connection.getResponseCode();
        }
        catch (IOException iOException) {
            this.closeConnectionQuietly();
            throw new HttpDataSource.HttpDataSourceException("Unable to connect to " + dataSpec.uri.toString(), iOException, dataSpec);
        }
        if (n < 200 || n > 299) {
            Map<String, List<String>> map = this.connection.getHeaderFields();
            this.closeConnectionQuietly();
            throw new HttpDataSource.InvalidResponseCodeException(n, map, dataSpec);
        }
        String string = this.connection.getContentType();
        if (this.contentTypePredicate != null && !this.contentTypePredicate.evaluate(string)) {
            this.closeConnectionQuietly();
            throw new HttpDataSource.InvalidContentTypeException(string, dataSpec);
        }
        long l = this.bytesToSkip = n == 200 && dataSpec.position != 0L ? dataSpec.position : 0L;
        if ((dataSpec.flags & 1) == 0) {
            long l2 = DefaultHttpDataSource.getContentLength(this.connection);
            this.bytesToRead = dataSpec.length != -1L ? dataSpec.length : (l2 != -1L ? l2 - this.bytesToSkip : -1L);
        } else {
            this.bytesToRead = dataSpec.length;
        }
        try {
            this.inputStream = this.connection.getInputStream();
        }
        catch (IOException iOException) {
            this.closeConnectionQuietly();
            throw new HttpDataSource.HttpDataSourceException(iOException, dataSpec);
        }
        this.opened = true;
        if (this.listener != null) {
            this.listener.onTransferStart();
        }
        return this.bytesToRead;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws HttpDataSource.HttpDataSourceException {
        try {
            this.skipInternal();
            return this.readInternal(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new HttpDataSource.HttpDataSourceException(iOException, this.dataSpec);
        }
    }

    @Override
    public void close() throws HttpDataSource.HttpDataSourceException {
        block7: {
            try {
                if (this.inputStream == null) break block7;
                Util.maybeTerminateInputStream(this.connection, this.bytesRemaining());
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {
                    throw new HttpDataSource.HttpDataSourceException(iOException, this.dataSpec);
                }
            }
            finally {
                this.inputStream = null;
                this.closeConnectionQuietly();
                if (this.opened) {
                    this.opened = false;
                    if (this.listener != null) {
                        this.listener.onTransferEnd();
                    }
                }
            }
        }
    }

    protected final HttpURLConnection getConnection() {
        return this.connection;
    }

    protected final long bytesSkipped() {
        return this.bytesSkipped;
    }

    protected final long bytesRead() {
        return this.bytesRead;
    }

    protected final long bytesRemaining() {
        return this.bytesToRead == -1L ? this.bytesToRead : this.bytesToRead - this.bytesRead;
    }

    private HttpURLConnection makeConnection(DataSpec dataSpec) throws IOException {
        URL uRL = new URL(dataSpec.uri.toString());
        byte[] byArray = dataSpec.postBody;
        long l = dataSpec.position;
        long l2 = dataSpec.length;
        boolean bl = true;
        if (!this.allowCrossProtocolRedirects) {
            HttpURLConnection httpURLConnection = this.makeConnection(uRL, byArray, l, l2, bl, true);
            return httpURLConnection;
        }
        int n = 0;
        while (n++ <= 20) {
            HttpURLConnection httpURLConnection = this.makeConnection(uRL, byArray, l, l2, bl, false);
            int n2 = httpURLConnection.getResponseCode();
            if (n2 == 300 || n2 == 301 || n2 == 302 || n2 == 303 || byArray == null && (n2 == 307 || n2 == 308)) {
                byArray = null;
                String string = httpURLConnection.getHeaderField("Location");
                httpURLConnection.disconnect();
                uRL = DefaultHttpDataSource.handleRedirect(uRL, string);
                continue;
            }
            return httpURLConnection;
        }
        throw new NoRouteToHostException("Too many redirects: " + n);
    }

    private Date addDays(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, n);
        return calendar.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection makeConnection(URL uRL, byte[] byArray, long l, long l2, boolean bl, boolean bl2) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setConnectTimeout(this.connectTimeoutMillis);
        httpURLConnection.setReadTimeout(this.readTimeoutMillis);
        Object object = this.requestProperties;
        synchronized (object) {
            for (Map.Entry<String, String> entry : this.requestProperties.entrySet()) {
                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (l != 0L || l2 != -1L) {
            object = "bytes=" + l + "-";
            if (l2 != -1L) {
                object = (String)object + (l + l2 - 1L);
            }
            httpURLConnection.setRequestProperty("Range", (String)object);
        }
        httpURLConnection.setRequestProperty("User-Agent", this.userAgent);
        if (!bl) {
            httpURLConnection.setRequestProperty("Accept-Encoding", "identity");
        }
        httpURLConnection.setInstanceFollowRedirects(bl2);
        httpURLConnection.setDoOutput(byArray != null);
        if (byArray != null) {
            httpURLConnection.setFixedLengthStreamingMode(byArray.length);
            httpURLConnection.connect();
            object = httpURLConnection.getOutputStream();
            ((OutputStream)object).write(byArray);
            ((OutputStream)object).close();
        } else {
            httpURLConnection.connect();
        }
        return httpURLConnection;
    }

    private static URL handleRedirect(URL uRL, String string) throws IOException {
        if (string == null) {
            throw new ProtocolException("Null location redirect");
        }
        URL uRL2 = new URL(uRL, string);
        String string2 = uRL2.getProtocol();
        if (!"https".equals(string2) && !"http".equals(string2)) {
            throw new ProtocolException("Unsupported protocol redirect: " + string2);
        }
        return uRL2;
    }

    private static long getContentLength(HttpURLConnection httpURLConnection) {
        Matcher matcher;
        String string;
        long l = -1L;
        String string2 = httpURLConnection.getHeaderField("Content-Length");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                l = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                a.c(TAG, "Unexpected Content-Length [" + string2 + "]");
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(string = httpURLConnection.getHeaderField("Content-Range"))) && (matcher = CONTENT_RANGE_HEADER.matcher(string)).find()) {
            try {
                long l2 = Long.parseLong(matcher.group(2)) - Long.parseLong(matcher.group(1)) + 1L;
                if (l < 0L) {
                    l = l2;
                } else if (l != l2) {
                    a.b(TAG, "Inconsistent headers [" + string2 + "] [" + string + "]");
                    l = Math.max(l, l2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                a.c(TAG, "Unexpected Content-Range [" + string + "]");
            }
        }
        return l;
    }

    private void skipInternal() throws IOException {
        if (this.bytesSkipped == this.bytesToSkip) {
            return;
        }
        byte[] byArray = skipBufferReference.getAndSet(null);
        if (byArray == null) {
            byArray = new byte[4096];
        }
        while (this.bytesSkipped != this.bytesToSkip) {
            int n = (int)Math.min(this.bytesToSkip - this.bytesSkipped, (long)byArray.length);
            int n2 = this.inputStream.read(byArray, 0, n);
            if (Thread.interrupted()) {
                throw new InterruptedIOException();
            }
            if (n2 == -1) {
                throw new EOFException();
            }
            this.bytesSkipped += (long)n2;
            if (this.listener == null) continue;
            this.listener.onBytesTransferred(n2);
        }
        skipBufferReference.set(byArray);
    }

    private int readInternal(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n2 = this.bytesToRead == -1L ? n2 : (int)Math.min((long)n2, this.bytesToRead - this.bytesRead);
        if (n2 == 0) {
            return -1;
        }
        int n4 = this.inputStream.read(byArray, n, n2);
        if (n4 == -1) {
            if (this.bytesToRead != -1L && this.bytesToRead != this.bytesRead) {
                throw new EOFException();
            }
            return -1;
        }
        this.bytesRead += (long)n4;
        if (this.listener != null) {
            this.listener.onBytesTransferred(n4);
        }
        return n4;
    }

    private void closeConnectionQuietly() {
        if (this.connection != null) {
            try {
                this.connection.disconnect();
            }
            catch (Exception exception) {
                a.b(TAG, "Unexpected error while disconnecting", exception);
            }
            this.connection = null;
        }
    }
}

