/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import android.os.Handler;
import com.google.android.exoplayer.upstream.BandwidthMeter;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Clock;
import com.google.android.exoplayer.util.SlidingPercentile;
import com.google.android.exoplayer.util.SystemClock;

public final class DefaultBandwidthMeter
implements BandwidthMeter {
    public static final int DEFAULT_MAX_WEIGHT = 2000;
    private final Handler eventHandler;
    private final BandwidthMeter.EventListener eventListener;
    private final Clock clock;
    private final SlidingPercentile slidingPercentile;
    private long bytesAccumulator;
    private long startTimeMs;
    private long bitrateEstimate;
    private int streamCount;

    public DefaultBandwidthMeter() {
        this(null, null);
    }

    public DefaultBandwidthMeter(Handler handler, BandwidthMeter.EventListener eventListener) {
        this(handler, eventListener, new SystemClock());
    }

    public DefaultBandwidthMeter(Handler handler, BandwidthMeter.EventListener eventListener, Clock clock) {
        this(handler, eventListener, clock, 2000);
    }

    public DefaultBandwidthMeter(Handler handler, BandwidthMeter.EventListener eventListener, int n) {
        this(handler, eventListener, new SystemClock(), n);
    }

    public DefaultBandwidthMeter(Handler handler, BandwidthMeter.EventListener eventListener, Clock clock, int n) {
        this.eventHandler = handler;
        this.eventListener = eventListener;
        this.clock = clock;
        this.slidingPercentile = new SlidingPercentile(n);
        this.bitrateEstimate = -1L;
    }

    @Override
    public synchronized long getBitrateEstimate() {
        return this.bitrateEstimate;
    }

    @Override
    public synchronized void onTransferStart() {
        if (this.streamCount == 0) {
            this.startTimeMs = this.clock.elapsedRealtime();
        }
        ++this.streamCount;
    }

    @Override
    public synchronized void onBytesTransferred(int n) {
        this.bytesAccumulator += (long)n;
    }

    @Override
    public synchronized void onTransferEnd() {
        Assertions.checkState(this.streamCount > 0);
        long l = this.clock.elapsedRealtime();
        int n = (int)(l - this.startTimeMs);
        if (n > 0) {
            float f = this.bytesAccumulator * 8000L / (long)n;
            this.slidingPercentile.addSample((int)Math.sqrt(this.bytesAccumulator), f);
            float f2 = this.slidingPercentile.getPercentile(0.5f);
            this.bitrateEstimate = Float.isNaN(f2) ? -1L : (long)f2;
            this.notifyBandwidthSample(n, this.bytesAccumulator, this.bitrateEstimate);
        }
        --this.streamCount;
        if (this.streamCount > 0) {
            this.startTimeMs = l;
        }
        this.bytesAccumulator = 0L;
    }

    private void notifyBandwidthSample(final int n, final long l, final long l2) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    DefaultBandwidthMeter.this.eventListener.onBandwidthSample(n, l, l2);
                }
            });
        }
    }
}

