/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.webvtt;

import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.style.StyleSpan;
import android.text.style.UnderlineSpan;
import com.google.android.exoplayer.text.webvtt.WebvttCue;
import com.google.android.exoplayer.text.webvtt.WebvttParserUtil;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.vcc.playerwrappersdk.a;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class WebvttCueParser {
    public static final Pattern CUE_HEADER_PATTERN = Pattern.compile("^(\\S+)\\s+-->\\s+(\\S+)(.*)?$");
    private static final Pattern COMMENT = Pattern.compile("^NOTE(( |\t).*)?$");
    private static final Pattern CUE_SETTING_PATTERN = Pattern.compile("(\\S+?):(\\S+)");
    private static final char CHAR_LESS_THAN = '<';
    private static final char CHAR_GREATER_THAN = '>';
    private static final char CHAR_SLASH = '/';
    private static final char CHAR_AMPERSAND = '&';
    private static final char CHAR_SEMI_COLON = ';';
    private static final char CHAR_SPACE = ' ';
    private static final String SPACE = " ";
    private static final String ENTITY_LESS_THAN = "lt";
    private static final String ENTITY_GREATER_THAN = "gt";
    private static final String ENTITY_AMPERSAND = "amp";
    private static final String ENTITY_NON_BREAK_SPACE = "nbsp";
    private static final String TAG_BOLD = "b";
    private static final String TAG_ITALIC = "i";
    private static final String TAG_UNDERLINE = "u";
    private static final String TAG_CLASS = "c";
    private static final String TAG_VOICE = "v";
    private static final String TAG_LANG = "lang";
    private static final int STYLE_BOLD = 1;
    private static final int STYLE_ITALIC = 2;
    private static final String TAG = "WebvttCueParser";
    private final StringBuilder textBuilder = new StringBuilder();

    boolean parseNextValidCue(ParsableByteArray parsableByteArray, WebvttCue.Builder builder) {
        Matcher matcher;
        while ((matcher = WebvttCueParser.findNextCueHeader(parsableByteArray)) != null) {
            if (!WebvttCueParser.parseCue(matcher, parsableByteArray, builder, this.textBuilder)) continue;
            return true;
        }
        return false;
    }

    static void parseCueSettingsList(String string, WebvttCue.Builder builder) {
        Matcher matcher = CUE_SETTING_PATTERN.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            try {
                if ("line".equals(string2)) {
                    WebvttCueParser.parseLineAttribute(string3, builder);
                    continue;
                }
                if ("align".equals(string2)) {
                    builder.setTextAlignment(WebvttCueParser.parseTextAlignment(string3));
                    continue;
                }
                if ("position".equals(string2)) {
                    WebvttCueParser.parsePositionAttribute(string3, builder);
                    continue;
                }
                if ("size".equals(string2)) {
                    builder.setWidth(WebvttParserUtil.parsePercentage(string3));
                    continue;
                }
                a.b(TAG, "Unknown cue setting " + string2 + ":" + string3);
            }
            catch (NumberFormatException numberFormatException) {
                a.b(TAG, "Skipping bad cue setting: " + matcher.group());
            }
        }
    }

    public static Matcher findNextCueHeader(ParsableByteArray parsableByteArray) {
        String string;
        while ((string = parsableByteArray.readLine()) != null) {
            if (COMMENT.matcher(string).matches()) {
                while ((string = parsableByteArray.readLine()) != null && !string.isEmpty()) {
                }
                continue;
            }
            Matcher matcher = CUE_HEADER_PATTERN.matcher(string);
            if (!matcher.matches()) continue;
            return matcher;
        }
        return null;
    }

    static void parseCueText(String string, WebvttCue.Builder builder) {
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder();
        Stack<StartTag> stack = new Stack<StartTag>();
        int n = 0;
        block4: while (n < string.length()) {
            char c2 = string.charAt(n);
            block0 : switch (c2) {
                case '<': {
                    boolean bl;
                    int n2;
                    if (n + 1 >= string.length()) {
                        ++n;
                        break;
                    }
                    boolean bl2 = string.charAt((n2 = n) + 1) == '/';
                    String[] stringArray = WebvttCueParser.tokenizeTag(string.substring(n2 + (bl2 ? 2 : 1), (bl = string.charAt((n = WebvttCueParser.findEndOfTag(string, n2 + 1)) - 2) == '/') ? n - 2 : n - 1));
                    if (stringArray == null || !WebvttCueParser.isSupportedTag(stringArray[0])) continue block4;
                    if (bl2) {
                        while (!stack.isEmpty()) {
                            StartTag startTag = (StartTag)stack.pop();
                            WebvttCueParser.applySpansForTag(startTag, spannableStringBuilder);
                            if (!startTag.name.equals(stringArray[0])) continue;
                            break block0;
                        }
                        continue block4;
                    }
                    if (bl) continue block4;
                    stack.push(new StartTag(stringArray[0], spannableStringBuilder.length()));
                    break;
                }
                case '&': {
                    int n3;
                    int n4 = string.indexOf(59, n + 1);
                    int n5 = string.indexOf(32, n + 1);
                    int n6 = n4 == -1 ? n5 : (n3 = n5 == -1 ? n4 : Math.min(n4, n5));
                    if (n3 != -1) {
                        WebvttCueParser.applyEntity(string.substring(n + 1, n3), spannableStringBuilder);
                        if (n3 == n5) {
                            spannableStringBuilder.append((CharSequence)SPACE);
                        }
                        n = n3 + 1;
                        break;
                    }
                    spannableStringBuilder.append(c2);
                    ++n;
                    break;
                }
                default: {
                    spannableStringBuilder.append(c2);
                    ++n;
                }
            }
        }
        while (!stack.isEmpty()) {
            WebvttCueParser.applySpansForTag((StartTag)stack.pop(), spannableStringBuilder);
        }
        builder.setText((CharSequence)spannableStringBuilder);
    }

    private static boolean parseCue(Matcher matcher, ParsableByteArray parsableByteArray, WebvttCue.Builder builder, StringBuilder stringBuilder) {
        String string;
        try {
            builder.setStartTime(WebvttParserUtil.parseTimestampUs(matcher.group(1))).setEndTime(WebvttParserUtil.parseTimestampUs(matcher.group(2)));
        }
        catch (NumberFormatException numberFormatException) {
            a.b(TAG, "Skipping cue with bad header: " + matcher.group());
            return false;
        }
        WebvttCueParser.parseCueSettingsList(matcher.group(3), builder);
        stringBuilder.setLength(0);
        while ((string = parsableByteArray.readLine()) != null && !string.isEmpty()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(string.trim());
        }
        WebvttCueParser.parseCueText(stringBuilder.toString(), builder);
        return true;
    }

    private static void parseLineAttribute(String string, WebvttCue.Builder builder) throws NumberFormatException {
        int n = string.indexOf(44);
        if (n != -1) {
            builder.setLineAnchor(WebvttCueParser.parsePositionAnchor(string.substring(n + 1)));
            string = string.substring(0, n);
        } else {
            builder.setLineAnchor(Integer.MIN_VALUE);
        }
        if (string.endsWith("%")) {
            builder.setLine(WebvttParserUtil.parsePercentage(string)).setLineType(0);
        } else {
            builder.setLine(Integer.parseInt(string)).setLineType(1);
        }
    }

    private static void parsePositionAttribute(String string, WebvttCue.Builder builder) throws NumberFormatException {
        int n = string.indexOf(44);
        if (n != -1) {
            builder.setPositionAnchor(WebvttCueParser.parsePositionAnchor(string.substring(n + 1)));
            string = string.substring(0, n);
        } else {
            builder.setPositionAnchor(Integer.MIN_VALUE);
        }
        builder.setPosition(WebvttParserUtil.parsePercentage(string));
    }

    private static int parsePositionAnchor(String string) {
        switch (string) {
            case "start": {
                return 0;
            }
            case "center": 
            case "middle": {
                return 1;
            }
            case "end": {
                return 2;
            }
        }
        a.b(TAG, "Invalid anchor value: " + string);
        return Integer.MIN_VALUE;
    }

    private static Layout.Alignment parseTextAlignment(String string) {
        switch (string) {
            case "start": 
            case "left": {
                return Layout.Alignment.ALIGN_NORMAL;
            }
            case "center": 
            case "middle": {
                return Layout.Alignment.ALIGN_CENTER;
            }
            case "end": 
            case "right": {
                return Layout.Alignment.ALIGN_OPPOSITE;
            }
        }
        a.b(TAG, "Invalid alignment value: " + string);
        return null;
    }

    private static int findEndOfTag(String string, int n) {
        int n2 = string.indexOf(62, n);
        return n2 == -1 ? string.length() : n2 + 1;
    }

    private static void applyEntity(String string, SpannableStringBuilder spannableStringBuilder) {
        switch (string) {
            case "lt": {
                spannableStringBuilder.append('<');
                break;
            }
            case "gt": {
                spannableStringBuilder.append('>');
                break;
            }
            case "nbsp": {
                spannableStringBuilder.append(' ');
                break;
            }
            case "amp": {
                spannableStringBuilder.append('&');
                break;
            }
            default: {
                a.b(TAG, "ignoring unsupported entity: '&" + string + ";'");
            }
        }
    }

    private static boolean isSupportedTag(String string) {
        switch (string) {
            case "b": 
            case "c": 
            case "i": 
            case "lang": 
            case "u": 
            case "v": {
                return true;
            }
        }
        return false;
    }

    private static void applySpansForTag(StartTag startTag, SpannableStringBuilder spannableStringBuilder) {
        switch (startTag.name) {
            case "b": {
                spannableStringBuilder.setSpan((Object)new StyleSpan(1), startTag.position, spannableStringBuilder.length(), 33);
                return;
            }
            case "i": {
                spannableStringBuilder.setSpan((Object)new StyleSpan(2), startTag.position, spannableStringBuilder.length(), 33);
                return;
            }
            case "u": {
                spannableStringBuilder.setSpan((Object)new UnderlineSpan(), startTag.position, spannableStringBuilder.length(), 33);
                return;
            }
        }
    }

    private static String[] tokenizeTag(String string) {
        if ((string = string.replace("\\s+", SPACE).trim()).length() == 0) {
            return null;
        }
        if (string.contains(SPACE)) {
            string = string.substring(0, string.indexOf(SPACE));
        }
        return string.split("\\.");
    }

    private static final class StartTag {
        public final String name;
        public final int position;

        public StartTag(String string, int n) {
            this.position = n;
            this.name = string;
        }
    }
}

