/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.subrip;

import android.text.Html;
import android.text.TextUtils;
import com.google.android.exoplayer.text.Cue;
import com.google.android.exoplayer.text.SubtitleParser;
import com.google.android.exoplayer.text.subrip.SubripSubtitle;
import com.google.android.exoplayer.util.LongArray;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.vcc.playerwrappersdk.a;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SubripParser
implements SubtitleParser {
    private static final String TAG = "SubripParser";
    private static final Pattern SUBRIP_TIMING_LINE = Pattern.compile("(\\S*)\\s*-->\\s*(\\S*)");
    private static final Pattern SUBRIP_TIMESTAMP = Pattern.compile("(?:(\\d+):)?(\\d+):(\\d+),(\\d+)");
    private final StringBuilder textBuilder = new StringBuilder();

    @Override
    public boolean canParse(String string) {
        return "application/x-subrip".equals(string);
    }

    @Override
    public SubripSubtitle parse(byte[] byArray, int n, int n2) {
        Object object;
        Object object2;
        String string;
        ArrayList<Cue> arrayList = new ArrayList<Cue>();
        LongArray longArray = new LongArray();
        ParsableByteArray parsableByteArray = new ParsableByteArray(byArray, n + n2);
        parsableByteArray.setPosition(n);
        while ((string = parsableByteArray.readLine()) != null) {
            if (string.length() == 0) continue;
            try {
                Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                a.b(TAG, "Skipping invalid index: " + string);
                continue;
            }
            boolean bl = false;
            string = parsableByteArray.readLine();
            object2 = SUBRIP_TIMING_LINE.matcher(string);
            if (((Matcher)object2).find()) {
                longArray.add(SubripParser.parseTimecode(((Matcher)object2).group(1)));
                object = ((Matcher)object2).group(2);
                if (!TextUtils.isEmpty((CharSequence)object)) {
                    bl = true;
                    longArray.add(SubripParser.parseTimecode(((Matcher)object2).group(2)));
                }
            } else {
                a.b(TAG, "Skipping invalid timing: " + string);
                continue;
            }
            this.textBuilder.setLength(0);
            while (!TextUtils.isEmpty((CharSequence)(string = parsableByteArray.readLine()))) {
                if (this.textBuilder.length() > 0) {
                    this.textBuilder.append("<br>");
                }
                this.textBuilder.append(string.trim());
            }
            object = Html.fromHtml((String)this.textBuilder.toString());
            arrayList.add(new Cue((CharSequence)object));
            if (!bl) continue;
            arrayList.add(null);
        }
        object2 = new Cue[arrayList.size()];
        arrayList.toArray((T[])object2);
        object = longArray.toArray();
        return new SubripSubtitle((Cue[])object2, (long[])object);
    }

    private static long parseTimecode(String string) throws NumberFormatException {
        Matcher matcher = SUBRIP_TIMESTAMP.matcher(string);
        if (!matcher.matches()) {
            throw new NumberFormatException("has invalid format");
        }
        long l = Long.parseLong(matcher.group(1)) * 60L * 60L * 1000L;
        l += Long.parseLong(matcher.group(2)) * 60L * 1000L;
        l += Long.parseLong(matcher.group(3)) * 1000L;
        return (l += Long.parseLong(matcher.group(4))) * 1000L;
    }
}

