/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.google.android.exoplayer.text.CaptionStyleCompat;
import com.google.android.exoplayer.text.Cue;
import com.google.android.exoplayer.text.CuePainter;
import java.util.ArrayList;
import java.util.List;

public final class SubtitleLayout
extends View {
    public static final float DEFAULT_TEXT_SIZE_FRACTION = 0.0533f;
    public static final float DEFAULT_BOTTOM_PADDING_FRACTION = 0.08f;
    private static final int FRACTIONAL = 0;
    private static final int FRACTIONAL_IGNORE_PADDING = 1;
    private static final int ABSOLUTE = 2;
    private final List<CuePainter> painters = new ArrayList<CuePainter>();
    private List<Cue> cues;
    private int textSizeType = 0;
    private float textSize = 0.0533f;
    private boolean applyEmbeddedStyles = true;
    private CaptionStyleCompat style = CaptionStyleCompat.DEFAULT;
    private float bottomPaddingFraction = 0.08f;

    public SubtitleLayout(Context context) {
        this(context, null);
    }

    public SubtitleLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public void setCues(List<Cue> list) {
        int n;
        if (this.cues == list) {
            return;
        }
        this.cues = list;
        int n2 = n = list == null ? 0 : list.size();
        while (this.painters.size() < n) {
            this.painters.add(new CuePainter(this.getContext()));
        }
        this.invalidate();
    }

    public void setFixedTextSize(int n, float f) {
        Context context = this.getContext();
        Resources resources = context == null ? Resources.getSystem() : context.getResources();
        this.setTextSize(2, TypedValue.applyDimension((int)n, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
    }

    public void setFractionalTextSize(float f) {
        this.setFractionalTextSize(f, false);
    }

    public void setFractionalTextSize(float f, boolean bl) {
        this.setTextSize(bl ? 1 : 0, f);
    }

    private void setTextSize(int n, float f) {
        if (this.textSizeType == n && this.textSize == f) {
            return;
        }
        this.textSizeType = n;
        this.textSize = f;
        this.invalidate();
    }

    public void setApplyEmbeddedStyles(boolean bl) {
        if (this.applyEmbeddedStyles == bl) {
            return;
        }
        this.applyEmbeddedStyles = bl;
        this.invalidate();
    }

    public void setStyle(CaptionStyleCompat captionStyleCompat) {
        if (this.style == captionStyleCompat) {
            return;
        }
        this.style = captionStyleCompat;
        this.invalidate();
    }

    public void setBottomPaddingFraction(float f) {
        if (this.bottomPaddingFraction == f) {
            return;
        }
        this.bottomPaddingFraction = f;
        this.invalidate();
    }

    public void dispatchDraw(Canvas canvas) {
        float f;
        int n = this.cues == null ? 0 : this.cues.size();
        int n2 = this.getTop();
        int n3 = this.getBottom();
        int n4 = this.getLeft() + this.getPaddingLeft();
        int n5 = n2 + this.getPaddingTop();
        int n6 = this.getRight() + this.getPaddingRight();
        int n7 = n3 - this.getPaddingBottom();
        if (n7 <= n5 || n6 <= n4) {
            return;
        }
        float f2 = this.textSizeType == 2 ? this.textSize : (f = this.textSize * (float)(this.textSizeType == 0 ? n7 - n5 : n3 - n2));
        if (f <= 0.0f) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.painters.get(i).draw(this.cues.get(i), this.applyEmbeddedStyles, this.style, f, this.bottomPaddingFraction, canvas, n4, n5, n6, n7);
        }
    }
}

