/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.smoothstreaming;

import android.content.Context;
import com.google.android.exoplayer.chunk.VideoFormatSelectorUtil;
import com.google.android.exoplayer.smoothstreaming.SmoothStreamingManifest;
import com.google.android.exoplayer.smoothstreaming.SmoothStreamingTrackSelector;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;
import java.util.Arrays;

public final class DefaultSmoothStreamingTrackSelector
implements SmoothStreamingTrackSelector {
    private final int streamElementType;
    private final Context context;
    private final boolean filterVideoRepresentations;
    private final boolean filterProtectedHdContent;

    public static DefaultSmoothStreamingTrackSelector newVideoInstance(Context context, boolean bl, boolean bl2) {
        return new DefaultSmoothStreamingTrackSelector(1, context, bl, bl2);
    }

    public static DefaultSmoothStreamingTrackSelector newAudioInstance() {
        return new DefaultSmoothStreamingTrackSelector(0, null, false, false);
    }

    public static DefaultSmoothStreamingTrackSelector newTextInstance() {
        return new DefaultSmoothStreamingTrackSelector(2, null, false, false);
    }

    private DefaultSmoothStreamingTrackSelector(int n, Context context, boolean bl, boolean bl2) {
        this.context = context;
        this.streamElementType = n;
        this.filterVideoRepresentations = bl;
        this.filterProtectedHdContent = bl2;
    }

    @Override
    public void selectTracks(SmoothStreamingManifest smoothStreamingManifest, SmoothStreamingTrackSelector.Output output) throws IOException {
        for (int i = 0; i < smoothStreamingManifest.streamElements.length; ++i) {
            SmoothStreamingManifest.TrackElement[] trackElementArray = smoothStreamingManifest.streamElements[i].tracks;
            if (smoothStreamingManifest.streamElements[i].type != this.streamElementType) continue;
            if (this.streamElementType == 1) {
                int[] nArray = this.filterVideoRepresentations ? VideoFormatSelectorUtil.selectVideoFormatsForDefaultDisplay(this.context, Arrays.asList(trackElementArray), null, this.filterProtectedHdContent && smoothStreamingManifest.protectionElement != null) : Util.firstIntegersArray(trackElementArray.length);
                int n = nArray.length;
                if (n > 1) {
                    output.adaptiveTrack(smoothStreamingManifest, i, nArray);
                }
                for (int j = 0; j < n; ++j) {
                    output.fixedTrack(smoothStreamingManifest, i, nArray[j]);
                }
                continue;
            }
            for (int j = 0; j < trackElementArray.length; ++j) {
                output.fixedTrack(smoothStreamingManifest, i, j);
            }
        }
    }
}

