/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.metadata;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.SampleSourceTrackRenderer;
import com.google.android.exoplayer.metadata.MetadataParser;
import com.google.android.exoplayer.util.Assertions;
import java.io.IOException;

public final class MetadataTrackRenderer<T>
extends SampleSourceTrackRenderer
implements Handler.Callback {
    private static final int MSG_INVOKE_RENDERER = 0;
    private final MetadataParser<T> metadataParser;
    private final MetadataRenderer<T> metadataRenderer;
    private final Handler metadataHandler;
    private final MediaFormatHolder formatHolder;
    private final SampleHolder sampleHolder;
    private boolean inputStreamEnded;
    private long pendingMetadataTimestamp;
    private T pendingMetadata;

    public MetadataTrackRenderer(SampleSource sampleSource, MetadataParser<T> metadataParser, MetadataRenderer<T> metadataRenderer, Looper looper) {
        super(sampleSource);
        this.metadataParser = Assertions.checkNotNull(metadataParser);
        this.metadataRenderer = Assertions.checkNotNull(metadataRenderer);
        this.metadataHandler = looper == null ? null : new Handler(looper, (Handler.Callback)this);
        this.formatHolder = new MediaFormatHolder();
        this.sampleHolder = new SampleHolder(1);
    }

    @Override
    protected boolean handlesTrack(MediaFormat mediaFormat) {
        return this.metadataParser.canParse(mediaFormat.mimeType);
    }

    @Override
    protected void onDiscontinuity(long l) {
        this.pendingMetadata = null;
        this.inputStreamEnded = false;
    }

    @Override
    protected void doSomeWork(long l, long l2, boolean bl) throws ExoPlaybackException {
        if (!this.inputStreamEnded && this.pendingMetadata == null) {
            this.sampleHolder.clearData();
            int n = this.readSource(l, this.formatHolder, this.sampleHolder);
            if (n == -3) {
                this.pendingMetadataTimestamp = this.sampleHolder.timeUs;
                try {
                    this.pendingMetadata = this.metadataParser.parse(this.sampleHolder.data.array(), this.sampleHolder.size);
                }
                catch (IOException iOException) {
                    throw new ExoPlaybackException(iOException);
                }
            } else if (n == -1) {
                this.inputStreamEnded = true;
            }
        }
        if (this.pendingMetadata != null && this.pendingMetadataTimestamp <= l) {
            this.invokeRenderer(this.pendingMetadata);
            this.pendingMetadata = null;
        }
    }

    @Override
    protected void onDisabled() throws ExoPlaybackException {
        this.pendingMetadata = null;
        super.onDisabled();
    }

    @Override
    protected long getBufferedPositionUs() {
        return -3L;
    }

    @Override
    protected boolean isEnded() {
        return this.inputStreamEnded;
    }

    @Override
    protected boolean isReady() {
        return true;
    }

    private void invokeRenderer(T t) {
        if (this.metadataHandler != null) {
            this.metadataHandler.obtainMessage(0, t).sendToTarget();
        } else {
            this.invokeRendererInternal(t);
        }
    }

    public boolean handleMessage(Message message) {
        switch (message.what) {
            case 0: {
                this.invokeRendererInternal(message.obj);
                return true;
            }
        }
        return false;
    }

    private void invokeRendererInternal(T t) {
        this.metadataRenderer.onMetadata(t);
    }

    public static interface MetadataRenderer<T> {
        public void onMetadata(T var1);
    }
}

