/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.hls;

import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.hls.HlsMasterPlaylist;
import com.google.android.exoplayer.hls.HlsMediaPlaylist;
import com.google.android.exoplayer.hls.HlsParserUtil;
import com.google.android.exoplayer.hls.HlsPlaylist;
import com.google.android.exoplayer.hls.Variant;
import com.google.android.exoplayer.upstream.UriLoadable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.regex.Pattern;

public final class HlsPlaylistParser
implements UriLoadable.Parser<HlsPlaylist> {
    private static final String VERSION_TAG = "#EXT-X-VERSION";
    private static final String STREAM_INF_TAG = "#EXT-X-STREAM-INF";
    private static final String MEDIA_TAG = "#EXT-X-MEDIA";
    private static final String DISCONTINUITY_TAG = "#EXT-X-DISCONTINUITY";
    private static final String DISCONTINUITY_SEQUENCE_TAG = "#EXT-X-DISCONTINUITY-SEQUENCE";
    private static final String MEDIA_DURATION_TAG = "#EXTINF";
    private static final String MEDIA_SEQUENCE_TAG = "#EXT-X-MEDIA-SEQUENCE";
    private static final String TARGET_DURATION_TAG = "#EXT-X-TARGETDURATION";
    private static final String ENDLIST_TAG = "#EXT-X-ENDLIST";
    private static final String KEY_TAG = "#EXT-X-KEY";
    private static final String BYTERANGE_TAG = "#EXT-X-BYTERANGE";
    private static final String BANDWIDTH_ATTR = "BANDWIDTH";
    private static final String CODECS_ATTR = "CODECS";
    private static final String RESOLUTION_ATTR = "RESOLUTION";
    private static final String LANGUAGE_ATTR = "LANGUAGE";
    private static final String NAME_ATTR = "NAME";
    private static final String TYPE_ATTR = "TYPE";
    private static final String METHOD_ATTR = "METHOD";
    private static final String URI_ATTR = "URI";
    private static final String IV_ATTR = "IV";
    private static final String INSTREAM_ID_ATTR = "INSTREAM-ID";
    private static final String AUDIO_TYPE = "AUDIO";
    private static final String VIDEO_TYPE = "VIDEO";
    private static final String SUBTITLES_TYPE = "SUBTITLES";
    private static final String CLOSED_CAPTIONS_TYPE = "CLOSED-CAPTIONS";
    private static final String METHOD_NONE = "NONE";
    private static final String METHOD_AES128 = "AES-128";
    private static final Pattern BANDWIDTH_ATTR_REGEX = Pattern.compile("BANDWIDTH=(\\d+)\\b");
    private static final Pattern CODECS_ATTR_REGEX = Pattern.compile("CODECS=\"(.+?)\"");
    private static final Pattern RESOLUTION_ATTR_REGEX = Pattern.compile("RESOLUTION=(\\d+x\\d+)");
    private static final Pattern MEDIA_DURATION_REGEX = Pattern.compile("#EXTINF:([\\d.]+)\\b");
    private static final Pattern MEDIA_SEQUENCE_REGEX = Pattern.compile("#EXT-X-MEDIA-SEQUENCE:(\\d+)\\b");
    private static final Pattern TARGET_DURATION_REGEX = Pattern.compile("#EXT-X-TARGETDURATION:(\\d+)\\b");
    private static final Pattern VERSION_REGEX = Pattern.compile("#EXT-X-VERSION:(\\d+)\\b");
    private static final Pattern BYTERANGE_REGEX = Pattern.compile("#EXT-X-BYTERANGE:(\\d+(?:@\\d+)?)\\b");
    private static final Pattern METHOD_ATTR_REGEX = Pattern.compile("METHOD=(NONE|AES-128)");
    private static final Pattern URI_ATTR_REGEX = Pattern.compile("URI=\"(.+?)\"");
    private static final Pattern IV_ATTR_REGEX = Pattern.compile("IV=([^,.*]+)");
    private static final Pattern TYPE_ATTR_REGEX = Pattern.compile("TYPE=(AUDIO|VIDEO|SUBTITLES|CLOSED-CAPTIONS)");
    private static final Pattern LANGUAGE_ATTR_REGEX = Pattern.compile("LANGUAGE=\"(.+?)\"");
    private static final Pattern NAME_ATTR_REGEX = Pattern.compile("NAME=\"(.+?)\"");
    private static final Pattern INSTREAM_ID_ATTR_REGEX = Pattern.compile("INSTREAM-ID=\"(.+?)\"");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HlsPlaylist parse(String string, InputStream inputStream) throws IOException, ParserException {
        LinkedList<String> linkedList = new LinkedList<String>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim()).isEmpty()) continue;
                if (string2.startsWith(STREAM_INF_TAG)) {
                    linkedList.add(string2);
                    HlsMasterPlaylist hlsMasterPlaylist = HlsPlaylistParser.parseMasterPlaylist(new LineIterator(linkedList, bufferedReader), string);
                    return hlsMasterPlaylist;
                }
                if (string2.startsWith(TARGET_DURATION_TAG) || string2.startsWith(MEDIA_SEQUENCE_TAG) || string2.startsWith(MEDIA_DURATION_TAG) || string2.startsWith(KEY_TAG) || string2.startsWith(BYTERANGE_TAG) || string2.equals(DISCONTINUITY_TAG) || string2.equals(DISCONTINUITY_SEQUENCE_TAG) || string2.equals(ENDLIST_TAG)) {
                    linkedList.add(string2);
                    HlsMediaPlaylist hlsMediaPlaylist = HlsPlaylistParser.parseMediaPlaylist(new LineIterator(linkedList, bufferedReader), string);
                    return hlsMediaPlaylist;
                }
                linkedList.add(string2);
            }
        }
        throw new ParserException("Failed to parse the playlist, could not identify any tags.");
    }

    private static HlsMasterPlaylist parseMasterPlaylist(LineIterator lineIterator, String string) throws IOException {
        ArrayList<Variant> arrayList = new ArrayList<Variant>();
        ArrayList<Variant> arrayList2 = new ArrayList<Variant>();
        ArrayList<Variant> arrayList3 = new ArrayList<Variant>();
        int n = 0;
        String string2 = null;
        int n2 = -1;
        int n3 = -1;
        String string3 = null;
        String[] stringArray = null;
        String string4 = null;
        boolean bl = false;
        while (lineIterator.hasNext()) {
            String[] stringArray2;
            Object object;
            String string5 = lineIterator.next();
            if (string5.startsWith(MEDIA_TAG)) {
                Format format;
                String string6;
                String string7;
                object = HlsParserUtil.parseStringAttr(string5, TYPE_ATTR_REGEX, TYPE_ATTR);
                if (CLOSED_CAPTIONS_TYPE.equals(object)) {
                    stringArray2 = HlsParserUtil.parseStringAttr(string5, INSTREAM_ID_ATTR_REGEX, INSTREAM_ID_ATTR);
                    if (!"CC1".equals(stringArray2)) continue;
                    string4 = HlsParserUtil.parseOptionalStringAttr(string5, LANGUAGE_ATTR_REGEX);
                    continue;
                }
                if (SUBTITLES_TYPE.equals(object)) {
                    stringArray2 = HlsParserUtil.parseStringAttr(string5, NAME_ATTR_REGEX, NAME_ATTR);
                    string7 = HlsParserUtil.parseStringAttr(string5, URI_ATTR_REGEX, URI_ATTR);
                    string6 = HlsParserUtil.parseOptionalStringAttr(string5, LANGUAGE_ATTR_REGEX);
                    format = new Format((String)stringArray2, "application/x-mpegURL", -1, -1, -1.0f, -1, -1, -1, string6, string2);
                    arrayList3.add(new Variant(string7, format));
                    continue;
                }
                if (!AUDIO_TYPE.equals(object)) continue;
                stringArray2 = HlsParserUtil.parseOptionalStringAttr(string5, LANGUAGE_ATTR_REGEX);
                string7 = HlsParserUtil.parseOptionalStringAttr(string5, URI_ATTR_REGEX);
                if (string7 != null) {
                    string6 = HlsParserUtil.parseStringAttr(string5, NAME_ATTR_REGEX, NAME_ATTR);
                    format = new Format(string6, "application/x-mpegURL", -1, -1, -1.0f, -1, -1, -1, (String)stringArray2, string2);
                    arrayList2.add(new Variant(string7, format));
                    continue;
                }
                stringArray = stringArray2;
                continue;
            }
            if (string5.startsWith(STREAM_INF_TAG)) {
                n = HlsParserUtil.parseIntAttr(string5, BANDWIDTH_ATTR_REGEX, BANDWIDTH_ATTR);
                string2 = HlsParserUtil.parseOptionalStringAttr(string5, CODECS_ATTR_REGEX);
                string3 = HlsParserUtil.parseOptionalStringAttr(string5, NAME_ATTR_REGEX);
                object = HlsParserUtil.parseOptionalStringAttr(string5, RESOLUTION_ATTR_REGEX);
                if (object != null) {
                    stringArray2 = ((String)object).split("x");
                    n2 = Integer.parseInt(stringArray2[0]);
                    if (n2 <= 0) {
                        n2 = -1;
                    }
                    if ((n3 = Integer.parseInt(stringArray2[1])) <= 0) {
                        n3 = -1;
                    }
                } else {
                    n2 = -1;
                    n3 = -1;
                }
                bl = true;
                continue;
            }
            if (string5.startsWith("#") || !bl) continue;
            if (string3 == null) {
                string3 = Integer.toString(arrayList.size());
            }
            object = new Format(string3, "application/x-mpegURL", n2, n3, -1.0f, -1, -1, n, null, string2);
            arrayList.add(new Variant(string5, (Format)object));
            n = 0;
            string2 = null;
            string3 = null;
            n2 = -1;
            n3 = -1;
            bl = false;
        }
        return new HlsMasterPlaylist(string, (List<Variant>)arrayList, (List<Variant>)arrayList2, (List<Variant>)arrayList3, (String)stringArray, string4);
    }

    private static HlsMediaPlaylist parseMediaPlaylist(LineIterator lineIterator, String string) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        boolean bl = true;
        ArrayList<HlsMediaPlaylist.Segment> arrayList = new ArrayList<HlsMediaPlaylist.Segment>();
        double d = 0.0;
        int n4 = 0;
        long l = 0L;
        long l2 = 0L;
        long l3 = -1L;
        int n5 = 0;
        boolean bl2 = false;
        String string2 = null;
        String string3 = null;
        while (lineIterator.hasNext()) {
            String string4;
            String string5 = lineIterator.next();
            if (string5.startsWith(TARGET_DURATION_TAG)) {
                n2 = HlsParserUtil.parseIntAttr(string5, TARGET_DURATION_REGEX, TARGET_DURATION_TAG);
                continue;
            }
            if (string5.startsWith(MEDIA_SEQUENCE_TAG)) {
                n5 = n = HlsParserUtil.parseIntAttr(string5, MEDIA_SEQUENCE_REGEX, MEDIA_SEQUENCE_TAG);
                continue;
            }
            if (string5.startsWith(VERSION_TAG)) {
                n3 = HlsParserUtil.parseIntAttr(string5, VERSION_REGEX, VERSION_TAG);
                continue;
            }
            if (string5.startsWith(MEDIA_DURATION_TAG)) {
                d = HlsParserUtil.parseDoubleAttr(string5, MEDIA_DURATION_REGEX, MEDIA_DURATION_TAG);
                continue;
            }
            if (string5.startsWith(KEY_TAG)) {
                string4 = HlsParserUtil.parseStringAttr(string5, METHOD_ATTR_REGEX, METHOD_ATTR);
                bl2 = METHOD_AES128.equals(string4);
                if (bl2) {
                    string2 = HlsParserUtil.parseStringAttr(string5, URI_ATTR_REGEX, URI_ATTR);
                    string3 = HlsParserUtil.parseOptionalStringAttr(string5, IV_ATTR_REGEX);
                    continue;
                }
                string2 = null;
                string3 = null;
                continue;
            }
            if (string5.startsWith(BYTERANGE_TAG)) {
                string4 = HlsParserUtil.parseStringAttr(string5, BYTERANGE_REGEX, BYTERANGE_TAG);
                String[] stringArray = string4.split("@");
                l3 = Long.parseLong(stringArray[0]);
                if (stringArray.length <= 1) continue;
                l2 = Long.parseLong(stringArray[1]);
                continue;
            }
            if (string5.startsWith(DISCONTINUITY_SEQUENCE_TAG)) {
                n4 = Integer.parseInt(string5.substring(string5.indexOf(58) + 1));
                continue;
            }
            if (string5.equals(DISCONTINUITY_TAG)) {
                ++n4;
                continue;
            }
            if (!string5.startsWith("#")) {
                string4 = !bl2 ? null : (string3 != null ? string3 : Integer.toHexString(n5));
                ++n5;
                if (l3 == -1L) {
                    l2 = 0L;
                }
                arrayList.add(new HlsMediaPlaylist.Segment(string5, d, n4, l, bl2, string2, string4, l2, l3));
                l += (long)(d * 1000000.0);
                d = 0.0;
                if (l3 != -1L) {
                    l2 += l3;
                }
                l3 = -1L;
                continue;
            }
            if (!string5.equals(ENDLIST_TAG)) continue;
            bl = false;
            break;
        }
        return new HlsMediaPlaylist(string, n, n2, n3, bl, Collections.unmodifiableList(arrayList));
    }

    private static class LineIterator {
        private final BufferedReader reader;
        private final Queue<String> extraLines;
        private String next;

        public LineIterator(Queue<String> queue, BufferedReader bufferedReader) {
            this.extraLines = queue;
            this.reader = bufferedReader;
        }

        public boolean hasNext() throws IOException {
            if (this.next != null) {
                return true;
            }
            if (!this.extraLines.isEmpty()) {
                this.next = this.extraLines.poll();
                return true;
            }
            while ((this.next = this.reader.readLine()) != null) {
                this.next = this.next.trim();
                if (this.next.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public String next() throws IOException {
            String string = null;
            if (this.hasNext()) {
                string = this.next;
                this.next = null;
            }
            return string;
        }
    }
}

