/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.hls;

import com.google.android.exoplayer.hls.HlsPlaylist;
import java.util.List;

public final class HlsMediaPlaylist
extends HlsPlaylist {
    public static final String ENCRYPTION_METHOD_NONE = "NONE";
    public static final String ENCRYPTION_METHOD_AES_128 = "AES-128";
    public final int mediaSequence;
    public final int targetDurationSecs;
    public final int version;
    public final List<Segment> segments;
    public final boolean live;
    public final long durationUs;

    public HlsMediaPlaylist(String string, int n, int n2, int n3, boolean bl, List<Segment> list) {
        super(string, 1);
        this.mediaSequence = n;
        this.targetDurationSecs = n2;
        this.version = n3;
        this.live = bl;
        this.segments = list;
        if (!list.isEmpty()) {
            Segment segment = list.get(list.size() - 1);
            this.durationUs = segment.startTimeUs + (long)(segment.durationSecs * 1000000.0);
        } else {
            this.durationUs = 0L;
        }
    }

    public static final class Segment
    implements Comparable<Long> {
        public final String url;
        public final double durationSecs;
        public final int discontinuitySequenceNumber;
        public final long startTimeUs;
        public final boolean isEncrypted;
        public final String encryptionKeyUri;
        public final String encryptionIV;
        public final long byterangeOffset;
        public final long byterangeLength;

        public Segment(String string, double d, int n, long l, boolean bl, String string2, String string3, long l2, long l3) {
            this.url = string;
            this.durationSecs = d;
            this.discontinuitySequenceNumber = n;
            this.startTimeUs = l;
            this.isEncrypted = bl;
            this.encryptionKeyUri = string2;
            this.encryptionIV = string3;
            this.byterangeOffset = l2;
            this.byterangeLength = l3;
        }

        @Override
        public int compareTo(Long l) {
            return this.startTimeUs > l ? 1 : (this.startTimeUs < l ? -1 : 0);
        }
    }
}

