/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.webm;

import android.util.Pair;
import android.util.SparseArray;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.drm.DrmInitData;
import com.google.android.exoplayer.extractor.ChunkIndex;
import com.google.android.exoplayer.extractor.Extractor;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.ExtractorOutput;
import com.google.android.exoplayer.extractor.PositionHolder;
import com.google.android.exoplayer.extractor.SeekMap;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.extractor.webm.DefaultEbmlReader;
import com.google.android.exoplayer.extractor.webm.EbmlReader;
import com.google.android.exoplayer.extractor.webm.EbmlReaderOutput;
import com.google.android.exoplayer.extractor.webm.Sniffer;
import com.google.android.exoplayer.extractor.webm.VarintReader;
import com.google.android.exoplayer.util.LongArray;
import com.google.android.exoplayer.util.MimeTypes;
import com.google.android.exoplayer.util.NalUnitUtil;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public final class WebmExtractor
implements Extractor {
    private static final int BLOCK_STATE_START = 0;
    private static final int BLOCK_STATE_HEADER = 1;
    private static final int BLOCK_STATE_DATA = 2;
    private static final String DOC_TYPE_WEBM = "webm";
    private static final String DOC_TYPE_MATROSKA = "matroska";
    private static final String CODEC_ID_VP8 = "V_VP8";
    private static final String CODEC_ID_VP9 = "V_VP9";
    private static final String CODEC_ID_MPEG2 = "V_MPEG2";
    private static final String CODEC_ID_MPEG4_SP = "V_MPEG4/ISO/SP";
    private static final String CODEC_ID_MPEG4_ASP = "V_MPEG4/ISO/ASP";
    private static final String CODEC_ID_MPEG4_AP = "V_MPEG4/ISO/AP";
    private static final String CODEC_ID_H264 = "V_MPEG4/ISO/AVC";
    private static final String CODEC_ID_H265 = "V_MPEGH/ISO/HEVC";
    private static final String CODEC_ID_FOURCC = "V_MS/VFW/FOURCC";
    private static final String CODEC_ID_VORBIS = "A_VORBIS";
    private static final String CODEC_ID_OPUS = "A_OPUS";
    private static final String CODEC_ID_AAC = "A_AAC";
    private static final String CODEC_ID_MP3 = "A_MPEG/L3";
    private static final String CODEC_ID_AC3 = "A_AC3";
    private static final String CODEC_ID_E_AC3 = "A_EAC3";
    private static final String CODEC_ID_TRUEHD = "A_TRUEHD";
    private static final String CODEC_ID_DTS = "A_DTS";
    private static final String CODEC_ID_DTS_EXPRESS = "A_DTS/EXPRESS";
    private static final String CODEC_ID_DTS_LOSSLESS = "A_DTS/LOSSLESS";
    private static final String CODEC_ID_FLAC = "A_FLAC";
    private static final String CODEC_ID_ACM = "A_MS/ACM";
    private static final String CODEC_ID_PCM_INT_LIT = "A_PCM/INT/LIT";
    private static final String CODEC_ID_SUBRIP = "S_TEXT/UTF8";
    private static final String CODEC_ID_VOBSUB = "S_VOBSUB";
    private static final String CODEC_ID_PGS = "S_HDMV/PGS";
    private static final int VORBIS_MAX_INPUT_SIZE = 8192;
    private static final int OPUS_MAX_INPUT_SIZE = 5760;
    private static final int MP3_MAX_INPUT_SIZE = 4096;
    private static final int ENCRYPTION_IV_SIZE = 8;
    private static final int TRACK_TYPE_AUDIO = 2;
    private static final int UNKNOWN = -1;
    private static final int ID_EBML = 440786851;
    private static final int ID_EBML_READ_VERSION = 17143;
    private static final int ID_DOC_TYPE = 17026;
    private static final int ID_DOC_TYPE_READ_VERSION = 17029;
    private static final int ID_SEGMENT = 408125543;
    private static final int ID_SEGMENT_INFO = 357149030;
    private static final int ID_SEEK_HEAD = 290298740;
    private static final int ID_SEEK = 19899;
    private static final int ID_SEEK_ID = 21419;
    private static final int ID_SEEK_POSITION = 21420;
    private static final int ID_INFO = 357149030;
    private static final int ID_TIMECODE_SCALE = 2807729;
    private static final int ID_DURATION = 17545;
    private static final int ID_CLUSTER = 524531317;
    private static final int ID_TIME_CODE = 231;
    private static final int ID_SIMPLE_BLOCK = 163;
    private static final int ID_BLOCK_GROUP = 160;
    private static final int ID_BLOCK = 161;
    private static final int ID_BLOCK_DURATION = 155;
    private static final int ID_REFERENCE_BLOCK = 251;
    private static final int ID_TRACKS = 374648427;
    private static final int ID_TRACK_ENTRY = 174;
    private static final int ID_TRACK_NUMBER = 215;
    private static final int ID_TRACK_TYPE = 131;
    private static final int ID_DEFAULT_DURATION = 2352003;
    private static final int ID_CODEC_ID = 134;
    private static final int ID_CODEC_PRIVATE = 25506;
    private static final int ID_CODEC_DELAY = 22186;
    private static final int ID_SEEK_PRE_ROLL = 22203;
    private static final int ID_VIDEO = 224;
    private static final int ID_PIXEL_WIDTH = 176;
    private static final int ID_PIXEL_HEIGHT = 186;
    private static final int ID_DISPLAY_WIDTH = 21680;
    private static final int ID_DISPLAY_HEIGHT = 21690;
    private static final int ID_DISPLAY_UNIT = 21682;
    private static final int ID_AUDIO = 225;
    private static final int ID_CHANNELS = 159;
    private static final int ID_AUDIO_BIT_DEPTH = 25188;
    private static final int ID_SAMPLING_FREQUENCY = 181;
    private static final int ID_CONTENT_ENCODINGS = 28032;
    private static final int ID_CONTENT_ENCODING = 25152;
    private static final int ID_CONTENT_ENCODING_ORDER = 20529;
    private static final int ID_CONTENT_ENCODING_SCOPE = 20530;
    private static final int ID_CONTENT_COMPRESSION = 20532;
    private static final int ID_CONTENT_COMPRESSION_ALGORITHM = 16980;
    private static final int ID_CONTENT_COMPRESSION_SETTINGS = 16981;
    private static final int ID_CONTENT_ENCRYPTION = 20533;
    private static final int ID_CONTENT_ENCRYPTION_ALGORITHM = 18401;
    private static final int ID_CONTENT_ENCRYPTION_KEY_ID = 18402;
    private static final int ID_CONTENT_ENCRYPTION_AES_SETTINGS = 18407;
    private static final int ID_CONTENT_ENCRYPTION_AES_SETTINGS_CIPHER_MODE = 18408;
    private static final int ID_CUES = 475249515;
    private static final int ID_CUE_POINT = 187;
    private static final int ID_CUE_TIME = 179;
    private static final int ID_CUE_TRACK_POSITIONS = 183;
    private static final int ID_CUE_CLUSTER_POSITION = 241;
    private static final int ID_LANGUAGE = 2274716;
    private static final int LACING_NONE = 0;
    private static final int LACING_XIPH = 1;
    private static final int LACING_FIXED_SIZE = 2;
    private static final int LACING_EBML = 3;
    private static final int FOURCC_COMPRESSION_VC1 = 826496599;
    private static final byte[] SUBRIP_PREFIX = new byte[]{49, 10, 48, 48, 58, 48, 48, 58, 48, 48, 44, 48, 48, 48, 32, 45, 45, 62, 32, 48, 48, 58, 48, 48, 58, 48, 48, 44, 48, 48, 48, 10};
    private static final byte[] SUBRIP_TIMECODE_EMPTY = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
    private static final int SUBRIP_PREFIX_END_TIMECODE_OFFSET = 19;
    private static final int SUBRIP_TIMECODE_LENGTH = 12;
    private static final int WAVE_FORMAT_SIZE = 18;
    private static final int WAVE_FORMAT_EXTENSIBLE = 65534;
    private static final int WAVE_FORMAT_PCM = 1;
    private static final UUID WAVE_SUBFORMAT_PCM = new UUID(0x100000000001000L, -9223371306706625679L);
    private final EbmlReader reader;
    private final VarintReader varintReader;
    private final SparseArray<Track> tracks;
    private final ParsableByteArray nalStartCode;
    private final ParsableByteArray nalLength;
    private final ParsableByteArray scratch;
    private final ParsableByteArray vorbisNumPageSamples;
    private final ParsableByteArray seekEntryIdBytes;
    private final ParsableByteArray sampleStrippedBytes;
    private final ParsableByteArray subripSample;
    private long segmentContentPosition = -1L;
    private long segmentContentSize = -1L;
    private long timecodeScale = -1L;
    private long durationTimecode = -1L;
    private long durationUs = -1L;
    private Track currentTrack;
    private boolean sentDrmInitData;
    private boolean sentSeekMap;
    private int seekEntryId;
    private long seekEntryPosition;
    private boolean seekForCues;
    private long cuesContentPosition = -1L;
    private long seekPositionAfterBuildingCues = -1L;
    private long clusterTimecodeUs = -1L;
    private LongArray cueTimesUs;
    private LongArray cueClusterPositions;
    private boolean seenClusterPositionForCurrentCuePoint;
    private int blockState;
    private long blockTimeUs;
    private long blockDurationUs;
    private int blockLacingSampleIndex;
    private int blockLacingSampleCount;
    private int[] blockLacingSampleSizes;
    private int blockTrackNumber;
    private int blockTrackNumberLength;
    private int blockFlags;
    private int sampleBytesRead;
    private boolean sampleEncodingHandled;
    private int sampleCurrentNalBytesRemaining;
    private int sampleBytesWritten;
    private boolean sampleRead;
    private boolean sampleSeenReferenceBlock;
    private ExtractorOutput extractorOutput;

    public WebmExtractor() {
        this(new DefaultEbmlReader());
    }

    WebmExtractor(EbmlReader ebmlReader) {
        this.reader = ebmlReader;
        this.reader.init(new InnerEbmlReaderOutput());
        this.varintReader = new VarintReader();
        this.tracks = new SparseArray();
        this.scratch = new ParsableByteArray(4);
        this.vorbisNumPageSamples = new ParsableByteArray(ByteBuffer.allocate(4).putInt(-1).array());
        this.seekEntryIdBytes = new ParsableByteArray(4);
        this.nalStartCode = new ParsableByteArray(NalUnitUtil.NAL_START_CODE);
        this.nalLength = new ParsableByteArray(4);
        this.sampleStrippedBytes = new ParsableByteArray();
        this.subripSample = new ParsableByteArray();
    }

    @Override
    public boolean sniff(ExtractorInput extractorInput) throws IOException, InterruptedException {
        return new Sniffer().sniff(extractorInput);
    }

    @Override
    public void init(ExtractorOutput extractorOutput) {
        this.extractorOutput = extractorOutput;
    }

    @Override
    public void seek() {
        this.clusterTimecodeUs = -1L;
        this.blockState = 0;
        this.reader.reset();
        this.varintReader.reset();
        this.resetSample();
    }

    @Override
    public void release() {
    }

    @Override
    public int read(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException, InterruptedException {
        this.sampleRead = false;
        boolean bl = true;
        while (bl && !this.sampleRead) {
            bl = this.reader.read(extractorInput);
            if (!bl || !this.maybeSeekForCues(positionHolder, extractorInput.getPosition())) continue;
            return 1;
        }
        return bl ? 0 : -1;
    }

    int getElementType(int n) {
        switch (n) {
            case 160: 
            case 174: 
            case 183: 
            case 187: 
            case 224: 
            case 225: 
            case 18407: 
            case 19899: 
            case 20532: 
            case 20533: 
            case 25152: 
            case 28032: 
            case 290298740: 
            case 357149030: 
            case 374648427: 
            case 408125543: 
            case 440786851: 
            case 475249515: 
            case 524531317: {
                return 1;
            }
            case 131: 
            case 155: 
            case 159: 
            case 176: 
            case 179: 
            case 186: 
            case 215: 
            case 231: 
            case 241: 
            case 251: 
            case 16980: 
            case 17029: 
            case 17143: 
            case 18401: 
            case 18408: 
            case 20529: 
            case 20530: 
            case 21420: 
            case 21680: 
            case 21682: 
            case 21690: 
            case 22186: 
            case 22203: 
            case 25188: 
            case 2352003: 
            case 2807729: {
                return 2;
            }
            case 134: 
            case 17026: 
            case 2274716: {
                return 3;
            }
            case 161: 
            case 163: 
            case 16981: 
            case 18402: 
            case 21419: 
            case 25506: {
                return 4;
            }
            case 181: 
            case 17545: {
                return 5;
            }
        }
        return 0;
    }

    boolean isLevel1Element(int n) {
        return n == 357149030 || n == 524531317 || n == 475249515 || n == 374648427;
    }

    void startMasterElement(int n, long l, long l2) throws ParserException {
        switch (n) {
            case 408125543: {
                if (this.segmentContentPosition != -1L && this.segmentContentPosition != l) {
                    throw new ParserException("Multiple Segment elements not supported");
                }
                this.segmentContentPosition = l;
                this.segmentContentSize = l2;
                return;
            }
            case 19899: {
                this.seekEntryId = -1;
                this.seekEntryPosition = -1L;
                return;
            }
            case 475249515: {
                this.cueTimesUs = new LongArray();
                this.cueClusterPositions = new LongArray();
                return;
            }
            case 187: {
                this.seenClusterPositionForCurrentCuePoint = false;
                return;
            }
            case 524531317: {
                if (!this.sentSeekMap) {
                    if (this.cuesContentPosition != -1L) {
                        this.seekForCues = true;
                    } else {
                        this.extractorOutput.seekMap(SeekMap.UNSEEKABLE);
                        this.sentSeekMap = true;
                    }
                }
                return;
            }
            case 160: {
                this.sampleSeenReferenceBlock = false;
                return;
            }
            case 25152: {
                return;
            }
            case 20533: {
                this.currentTrack.hasContentEncryption = true;
                return;
            }
            case 174: {
                this.currentTrack = new Track();
                return;
            }
        }
    }

    void endMasterElement(int n) throws ParserException {
        switch (n) {
            case 357149030: {
                if (this.timecodeScale == -1L) {
                    this.timecodeScale = 1000000L;
                }
                if (this.durationTimecode != -1L) {
                    this.durationUs = this.scaleTimecodeToUs(this.durationTimecode);
                }
                return;
            }
            case 19899: {
                if (this.seekEntryId == -1 || this.seekEntryPosition == -1L) {
                    throw new ParserException("Mandatory element SeekID or SeekPosition not found");
                }
                if (this.seekEntryId == 475249515) {
                    this.cuesContentPosition = this.seekEntryPosition;
                }
                return;
            }
            case 475249515: {
                if (!this.sentSeekMap) {
                    this.extractorOutput.seekMap(this.buildSeekMap());
                    this.sentSeekMap = true;
                }
                return;
            }
            case 160: {
                if (this.blockState != 2) {
                    return;
                }
                if (!this.sampleSeenReferenceBlock) {
                    this.blockFlags |= 1;
                }
                this.commitSampleToOutput((Track)this.tracks.get(this.blockTrackNumber), this.blockTimeUs);
                this.blockState = 0;
                return;
            }
            case 25152: {
                if (this.currentTrack.hasContentEncryption) {
                    if (this.currentTrack.encryptionKeyId == null) {
                        throw new ParserException("Encrypted Track found but ContentEncKeyID was not found");
                    }
                    if (!this.sentDrmInitData) {
                        this.extractorOutput.drmInitData(new DrmInitData.Universal(new DrmInitData.SchemeInitData("video/webm", this.currentTrack.encryptionKeyId)));
                        this.sentDrmInitData = true;
                    }
                }
                return;
            }
            case 28032: {
                if (this.currentTrack.hasContentEncryption && this.currentTrack.sampleStrippedBytes != null) {
                    throw new ParserException("Combining encryption and compression is not supported");
                }
                return;
            }
            case 174: {
                if (this.tracks.get(this.currentTrack.number) == null && WebmExtractor.isCodecSupported(this.currentTrack.codecId)) {
                    this.currentTrack.initializeOutput(this.extractorOutput, this.currentTrack.number, this.durationUs);
                    this.tracks.put(this.currentTrack.number, (Object)this.currentTrack);
                }
                this.currentTrack = null;
                return;
            }
            case 374648427: {
                if (this.tracks.size() == 0) {
                    throw new ParserException("No valid tracks were found");
                }
                this.extractorOutput.endTracks();
                return;
            }
        }
    }

    void integerElement(int n, long l) throws ParserException {
        switch (n) {
            case 17143: {
                if (l != 1L) {
                    throw new ParserException("EBMLReadVersion " + l + " not supported");
                }
                return;
            }
            case 17029: {
                if (l < 1L || l > 2L) {
                    throw new ParserException("DocTypeReadVersion " + l + " not supported");
                }
                return;
            }
            case 21420: {
                this.seekEntryPosition = l + this.segmentContentPosition;
                return;
            }
            case 2807729: {
                this.timecodeScale = l;
                return;
            }
            case 176: {
                this.currentTrack.width = (int)l;
                return;
            }
            case 186: {
                this.currentTrack.height = (int)l;
                return;
            }
            case 21680: {
                this.currentTrack.displayWidth = (int)l;
                return;
            }
            case 21690: {
                this.currentTrack.displayHeight = (int)l;
                return;
            }
            case 21682: {
                this.currentTrack.displayUnit = (int)l;
                return;
            }
            case 215: {
                this.currentTrack.number = (int)l;
                return;
            }
            case 131: {
                this.currentTrack.type = (int)l;
                return;
            }
            case 2352003: {
                this.currentTrack.defaultSampleDurationNs = (int)l;
                return;
            }
            case 22186: {
                this.currentTrack.codecDelayNs = l;
                return;
            }
            case 22203: {
                this.currentTrack.seekPreRollNs = l;
                return;
            }
            case 159: {
                this.currentTrack.channelCount = (int)l;
                return;
            }
            case 25188: {
                this.currentTrack.audioBitDepth = (int)l;
                return;
            }
            case 251: {
                this.sampleSeenReferenceBlock = true;
                return;
            }
            case 20529: {
                if (l != 0L) {
                    throw new ParserException("ContentEncodingOrder " + l + " not supported");
                }
                return;
            }
            case 20530: {
                if (l != 1L) {
                    throw new ParserException("ContentEncodingScope " + l + " not supported");
                }
                return;
            }
            case 16980: {
                if (l != 3L) {
                    throw new ParserException("ContentCompAlgo " + l + " not supported");
                }
                return;
            }
            case 18401: {
                if (l != 5L) {
                    throw new ParserException("ContentEncAlgo " + l + " not supported");
                }
                return;
            }
            case 18408: {
                if (l != 1L) {
                    throw new ParserException("AESSettingsCipherMode " + l + " not supported");
                }
                return;
            }
            case 179: {
                this.cueTimesUs.add(this.scaleTimecodeToUs(l));
                return;
            }
            case 241: {
                if (!this.seenClusterPositionForCurrentCuePoint) {
                    this.cueClusterPositions.add(l);
                    this.seenClusterPositionForCurrentCuePoint = true;
                }
                return;
            }
            case 231: {
                this.clusterTimecodeUs = this.scaleTimecodeToUs(l);
                return;
            }
            case 155: {
                this.blockDurationUs = this.scaleTimecodeToUs(l);
                return;
            }
        }
    }

    void floatElement(int n, double d) {
        switch (n) {
            case 17545: {
                this.durationTimecode = (long)d;
                return;
            }
            case 181: {
                this.currentTrack.sampleRate = (int)d;
                return;
            }
        }
    }

    void stringElement(int n, String string) throws ParserException {
        switch (n) {
            case 17026: {
                if (!DOC_TYPE_WEBM.equals(string) && !DOC_TYPE_MATROSKA.equals(string)) {
                    throw new ParserException("DocType " + string + " not supported");
                }
                return;
            }
            case 134: {
                this.currentTrack.codecId = string;
                return;
            }
            case 2274716: {
                this.currentTrack.language = string;
                return;
            }
        }
    }

    void binaryElement(int n, int n2, ExtractorInput extractorInput) throws IOException, InterruptedException {
        switch (n) {
            case 21419: {
                Arrays.fill(this.seekEntryIdBytes.data, (byte)0);
                extractorInput.readFully(this.seekEntryIdBytes.data, 4 - n2, n2);
                this.seekEntryIdBytes.setPosition(0);
                this.seekEntryId = (int)this.seekEntryIdBytes.readUnsignedInt();
                return;
            }
            case 25506: {
                this.currentTrack.codecPrivate = new byte[n2];
                extractorInput.readFully(this.currentTrack.codecPrivate, 0, n2);
                return;
            }
            case 16981: {
                this.currentTrack.sampleStrippedBytes = new byte[n2];
                extractorInput.readFully(this.currentTrack.sampleStrippedBytes, 0, n2);
                return;
            }
            case 18402: {
                this.currentTrack.encryptionKeyId = new byte[n2];
                extractorInput.readFully(this.currentTrack.encryptionKeyId, 0, n2);
                return;
            }
            case 161: 
            case 163: {
                Track track;
                if (this.blockState == 0) {
                    this.blockTrackNumber = (int)this.varintReader.readUnsignedVarint(extractorInput, false, true, 8);
                    this.blockTrackNumberLength = this.varintReader.getLastLength();
                    this.blockDurationUs = -1L;
                    this.blockState = 1;
                    this.scratch.reset();
                }
                if ((track = (Track)this.tracks.get(this.blockTrackNumber)) == null) {
                    extractorInput.skipFully(n2 - this.blockTrackNumberLength);
                    this.blockState = 0;
                    return;
                }
                if (this.blockState == 1) {
                    int n3;
                    int n4;
                    int n5;
                    this.readScratch(extractorInput, 3);
                    int n6 = (this.scratch.data[2] & 6) >> 1;
                    if (n6 == 0) {
                        this.blockLacingSampleCount = 1;
                        this.blockLacingSampleSizes = WebmExtractor.ensureArrayCapacity(this.blockLacingSampleSizes, 1);
                        this.blockLacingSampleSizes[0] = n2 - this.blockTrackNumberLength - 3;
                    } else {
                        if (n != 163) {
                            throw new ParserException("Lacing only supported in SimpleBlocks.");
                        }
                        this.readScratch(extractorInput, 4);
                        this.blockLacingSampleCount = (this.scratch.data[3] & 0xFF) + 1;
                        this.blockLacingSampleSizes = WebmExtractor.ensureArrayCapacity(this.blockLacingSampleSizes, this.blockLacingSampleCount);
                        if (n6 == 2) {
                            n5 = (n2 - this.blockTrackNumberLength - 4) / this.blockLacingSampleCount;
                            Arrays.fill(this.blockLacingSampleSizes, 0, this.blockLacingSampleCount, n5);
                        } else if (n6 == 1) {
                            n5 = 0;
                            n4 = 4;
                            for (n3 = 0; n3 < this.blockLacingSampleCount - 1; ++n3) {
                                int n7;
                                this.blockLacingSampleSizes[n3] = 0;
                                do {
                                    this.readScratch(extractorInput, ++n4);
                                    n7 = this.scratch.data[n4 - 1] & 0xFF;
                                    int n8 = n3;
                                    this.blockLacingSampleSizes[n8] = this.blockLacingSampleSizes[n8] + n7;
                                } while (n7 == 255);
                                n5 += this.blockLacingSampleSizes[n3];
                            }
                            this.blockLacingSampleSizes[this.blockLacingSampleCount - 1] = n2 - this.blockTrackNumberLength - n4 - n5;
                        } else if (n6 == 3) {
                            n5 = 0;
                            n4 = 4;
                            for (n3 = 0; n3 < this.blockLacingSampleCount - 1; ++n3) {
                                int n9;
                                this.blockLacingSampleSizes[n3] = 0;
                                this.readScratch(extractorInput, ++n4);
                                if (this.scratch.data[n4 - 1] == 0) {
                                    throw new ParserException("No valid varint length mask found");
                                }
                                long l = 0L;
                                for (n9 = 0; n9 < 8; ++n9) {
                                    int n10 = 1 << 7 - n9;
                                    if ((this.scratch.data[n4 - 1] & n10) == 0) continue;
                                    int n11 = n4 - 1;
                                    this.readScratch(extractorInput, n4 += n9);
                                    l = this.scratch.data[n11++] & 0xFF & ~n10;
                                    while (n11 < n4) {
                                        l <<= 8;
                                        l |= (long)(this.scratch.data[n11++] & 0xFF);
                                    }
                                    if (n3 <= 0) break;
                                    l -= (1L << 6 + n9 * 7) - 1L;
                                    break;
                                }
                                if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                                    throw new ParserException("EBML lacing sample size out of range.");
                                }
                                n9 = (int)l;
                                this.blockLacingSampleSizes[n3] = n3 == 0 ? n9 : this.blockLacingSampleSizes[n3 - 1] + n9;
                                n5 += this.blockLacingSampleSizes[n3];
                            }
                            this.blockLacingSampleSizes[this.blockLacingSampleCount - 1] = n2 - this.blockTrackNumberLength - n4 - n5;
                        } else {
                            throw new ParserException("Unexpected lacing value: " + n6);
                        }
                    }
                    n5 = this.scratch.data[0] << 8 | this.scratch.data[1] & 0xFF;
                    this.blockTimeUs = this.clusterTimecodeUs + this.scaleTimecodeToUs(n5);
                    n4 = (this.scratch.data[2] & 8) == 8 ? 1 : 0;
                    n3 = track.type == 2 || n == 163 && (this.scratch.data[2] & 0x80) == 128 ? 1 : 0;
                    this.blockFlags = (n3 != 0 ? 1 : 0) | (n4 != 0 ? 0x8000000 : 0);
                    this.blockState = 2;
                    this.blockLacingSampleIndex = 0;
                }
                if (n == 163) {
                    while (this.blockLacingSampleIndex < this.blockLacingSampleCount) {
                        this.writeSampleData(extractorInput, track, this.blockLacingSampleSizes[this.blockLacingSampleIndex]);
                        long l = this.blockTimeUs + (long)(this.blockLacingSampleIndex * track.defaultSampleDurationNs / 1000);
                        this.commitSampleToOutput(track, l);
                        ++this.blockLacingSampleIndex;
                    }
                    this.blockState = 0;
                } else {
                    this.writeSampleData(extractorInput, track, this.blockLacingSampleSizes[0]);
                }
                return;
            }
        }
        throw new ParserException("Unexpected id: " + n);
    }

    private void commitSampleToOutput(Track track, long l) {
        if (CODEC_ID_SUBRIP.equals(track.codecId)) {
            this.writeSubripSample(track);
        }
        track.output.sampleMetadata(l, this.blockFlags, this.sampleBytesWritten, 0, track.encryptionKeyId);
        this.sampleRead = true;
        this.resetSample();
    }

    private void resetSample() {
        this.sampleBytesRead = 0;
        this.sampleBytesWritten = 0;
        this.sampleCurrentNalBytesRemaining = 0;
        this.sampleEncodingHandled = false;
        this.sampleStrippedBytes.reset();
    }

    private void readScratch(ExtractorInput extractorInput, int n) throws IOException, InterruptedException {
        if (this.scratch.limit() >= n) {
            return;
        }
        if (this.scratch.capacity() < n) {
            this.scratch.reset(Arrays.copyOf(this.scratch.data, Math.max(this.scratch.data.length * 2, n)), this.scratch.limit());
        }
        extractorInput.readFully(this.scratch.data, this.scratch.limit(), n - this.scratch.limit());
        this.scratch.setLimit(n);
    }

    private void writeSampleData(ExtractorInput extractorInput, Track track, int n) throws IOException, InterruptedException {
        if (CODEC_ID_SUBRIP.equals(track.codecId)) {
            int n2 = SUBRIP_PREFIX.length + n;
            if (this.subripSample.capacity() < n2) {
                this.subripSample.data = Arrays.copyOf(SUBRIP_PREFIX, n2 + n);
            }
            extractorInput.readFully(this.subripSample.data, SUBRIP_PREFIX.length, n);
            this.subripSample.setPosition(0);
            this.subripSample.setLimit(n2);
            return;
        }
        TrackOutput trackOutput = track.output;
        if (!this.sampleEncodingHandled) {
            if (track.hasContentEncryption) {
                this.blockFlags &= 0xFFFFFFFD;
                extractorInput.readFully(this.scratch.data, 0, 1);
                ++this.sampleBytesRead;
                if ((this.scratch.data[0] & 0x80) == 128) {
                    throw new ParserException("Extension bit is set in signal byte");
                }
                if ((this.scratch.data[0] & 1) == 1) {
                    this.scratch.data[0] = 8;
                    this.scratch.setPosition(0);
                    trackOutput.sampleData(this.scratch, 1);
                    ++this.sampleBytesWritten;
                    this.blockFlags |= 2;
                }
            } else if (track.sampleStrippedBytes != null) {
                this.sampleStrippedBytes.reset(track.sampleStrippedBytes, track.sampleStrippedBytes.length);
            }
            this.sampleEncodingHandled = true;
        }
        n += this.sampleStrippedBytes.limit();
        if (CODEC_ID_H264.equals(track.codecId) || CODEC_ID_H265.equals(track.codecId)) {
            byte[] byArray = this.nalLength.data;
            byArray[0] = 0;
            byArray[1] = 0;
            byArray[2] = 0;
            int n3 = track.nalUnitLengthFieldLength;
            int n4 = 4 - track.nalUnitLengthFieldLength;
            while (this.sampleBytesRead < n) {
                if (this.sampleCurrentNalBytesRemaining == 0) {
                    this.readToTarget(extractorInput, byArray, n4, n3);
                    this.nalLength.setPosition(0);
                    this.sampleCurrentNalBytesRemaining = this.nalLength.readUnsignedIntToInt();
                    this.nalStartCode.setPosition(0);
                    trackOutput.sampleData(this.nalStartCode, 4);
                    this.sampleBytesWritten += 4;
                    continue;
                }
                this.sampleCurrentNalBytesRemaining -= this.readToOutput(extractorInput, trackOutput, this.sampleCurrentNalBytesRemaining);
            }
        } else {
            while (this.sampleBytesRead < n) {
                this.readToOutput(extractorInput, trackOutput, n - this.sampleBytesRead);
            }
        }
        if (CODEC_ID_VORBIS.equals(track.codecId)) {
            this.vorbisNumPageSamples.setPosition(0);
            trackOutput.sampleData(this.vorbisNumPageSamples, 4);
            this.sampleBytesWritten += 4;
        }
    }

    private void writeSubripSample(Track track) {
        WebmExtractor.setSubripSampleEndTimecode(this.subripSample.data, this.blockDurationUs);
        track.output.sampleData(this.subripSample, this.subripSample.limit());
        this.sampleBytesWritten += this.subripSample.limit();
    }

    private static void setSubripSampleEndTimecode(byte[] byArray, long l) {
        byte[] byArray2;
        if (l == -1L) {
            byArray2 = SUBRIP_TIMECODE_EMPTY;
        } else {
            int n = (int)(l / 3600000000L);
            int n2 = (int)((l -= (long)n * 3600000000L) / 60000000L);
            int n3 = (int)((l -= (long)(n2 * 60000000)) / 1000000L);
            int n4 = (int)((l -= (long)(n3 * 1000000)) / 1000L);
            byArray2 = String.format(Locale.US, "%02d:%02d:%02d,%03d", n, n2, n3, n4).getBytes();
        }
        System.arraycopy(byArray2, 0, byArray, 19, 12);
    }

    private void readToTarget(ExtractorInput extractorInput, byte[] byArray, int n, int n2) throws IOException, InterruptedException {
        int n3 = Math.min(n2, this.sampleStrippedBytes.bytesLeft());
        extractorInput.readFully(byArray, n + n3, n2 - n3);
        if (n3 > 0) {
            this.sampleStrippedBytes.readBytes(byArray, n, n3);
        }
        this.sampleBytesRead += n2;
    }

    private int readToOutput(ExtractorInput extractorInput, TrackOutput trackOutput, int n) throws IOException, InterruptedException {
        int n2;
        int n3 = this.sampleStrippedBytes.bytesLeft();
        if (n3 > 0) {
            n2 = Math.min(n, n3);
            trackOutput.sampleData(this.sampleStrippedBytes, n2);
        } else {
            n2 = trackOutput.sampleData(extractorInput, n, false);
        }
        this.sampleBytesRead += n2;
        this.sampleBytesWritten += n2;
        return n2;
    }

    private SeekMap buildSeekMap() {
        int n;
        if (this.segmentContentPosition == -1L || this.durationUs == -1L || this.cueTimesUs == null || this.cueTimesUs.size() == 0 || this.cueClusterPositions == null || this.cueClusterPositions.size() != this.cueTimesUs.size()) {
            this.cueTimesUs = null;
            this.cueClusterPositions = null;
            return SeekMap.UNSEEKABLE;
        }
        int n2 = this.cueTimesUs.size();
        int[] nArray = new int[n2];
        long[] lArray = new long[n2];
        long[] lArray2 = new long[n2];
        long[] lArray3 = new long[n2];
        for (n = 0; n < n2; ++n) {
            lArray3[n] = this.cueTimesUs.get(n);
            lArray[n] = this.segmentContentPosition + this.cueClusterPositions.get(n);
        }
        for (n = 0; n < n2 - 1; ++n) {
            nArray[n] = (int)(lArray[n + 1] - lArray[n]);
            lArray2[n] = lArray3[n + 1] - lArray3[n];
        }
        nArray[n2 - 1] = (int)(this.segmentContentPosition + this.segmentContentSize - lArray[n2 - 1]);
        lArray2[n2 - 1] = this.durationUs - lArray3[n2 - 1];
        this.cueTimesUs = null;
        this.cueClusterPositions = null;
        return new ChunkIndex(nArray, lArray, lArray2, lArray3);
    }

    private boolean maybeSeekForCues(PositionHolder positionHolder, long l) {
        if (this.seekForCues) {
            this.seekPositionAfterBuildingCues = l;
            positionHolder.position = this.cuesContentPosition;
            this.seekForCues = false;
            return true;
        }
        if (this.sentSeekMap && this.seekPositionAfterBuildingCues != -1L) {
            positionHolder.position = this.seekPositionAfterBuildingCues;
            this.seekPositionAfterBuildingCues = -1L;
            return true;
        }
        return false;
    }

    private long scaleTimecodeToUs(long l) throws ParserException {
        if (this.timecodeScale == -1L) {
            throw new ParserException("Can't scale timecode prior to timecodeScale being set.");
        }
        return Util.scaleLargeTimestamp(l, this.timecodeScale, 1000L);
    }

    private static boolean isCodecSupported(String string) {
        return CODEC_ID_VP8.equals(string) || CODEC_ID_VP9.equals(string) || CODEC_ID_MPEG2.equals(string) || CODEC_ID_MPEG4_SP.equals(string) || CODEC_ID_MPEG4_ASP.equals(string) || CODEC_ID_MPEG4_AP.equals(string) || CODEC_ID_H264.equals(string) || CODEC_ID_H265.equals(string) || CODEC_ID_FOURCC.equals(string) || CODEC_ID_OPUS.equals(string) || CODEC_ID_VORBIS.equals(string) || CODEC_ID_AAC.equals(string) || CODEC_ID_MP3.equals(string) || CODEC_ID_AC3.equals(string) || CODEC_ID_E_AC3.equals(string) || CODEC_ID_TRUEHD.equals(string) || CODEC_ID_DTS.equals(string) || CODEC_ID_DTS_EXPRESS.equals(string) || CODEC_ID_DTS_LOSSLESS.equals(string) || CODEC_ID_FLAC.equals(string) || CODEC_ID_ACM.equals(string) || CODEC_ID_PCM_INT_LIT.equals(string) || CODEC_ID_SUBRIP.equals(string) || CODEC_ID_VOBSUB.equals(string) || CODEC_ID_PGS.equals(string);
    }

    private static int[] ensureArrayCapacity(int[] nArray, int n) {
        if (nArray == null) {
            return new int[n];
        }
        if (nArray.length >= n) {
            return nArray;
        }
        return new int[Math.max(nArray.length * 2, n)];
    }

    private static final class Track {
        private static final int DISPLAY_UNIT_PIXELS = 0;
        public String codecId;
        public int number;
        public int type;
        public int defaultSampleDurationNs;
        public boolean hasContentEncryption;
        public byte[] sampleStrippedBytes;
        public byte[] encryptionKeyId;
        public byte[] codecPrivate;
        public int width = -1;
        public int height = -1;
        public int displayWidth = -1;
        public int displayHeight = -1;
        public int displayUnit = 0;
        public int channelCount = 1;
        public int audioBitDepth = -1;
        public int sampleRate = 8000;
        public long codecDelayNs = 0L;
        public long seekPreRollNs = 0L;
        private String language = "eng";
        public TrackOutput output;
        public int nalUnitLengthFieldLength;

        private Track() {
        }

        public void initializeOutput(ExtractorOutput extractorOutput, int n, long l) throws ParserException {
            Object object;
            String string;
            int n2 = -1;
            List list = null;
            switch (this.codecId) {
                case "V_VP8": {
                    string = "video/x-vnd.on2.vp8";
                    break;
                }
                case "V_VP9": {
                    string = "video/x-vnd.on2.vp9";
                    break;
                }
                case "V_MPEG2": {
                    string = "video/mpeg2";
                    break;
                }
                case "V_MPEG4/ISO/SP": 
                case "V_MPEG4/ISO/ASP": 
                case "V_MPEG4/ISO/AP": {
                    string = "video/mp4v-es";
                    list = this.codecPrivate == null ? null : Collections.singletonList(this.codecPrivate);
                    break;
                }
                case "V_MPEG4/ISO/AVC": {
                    string = "video/avc";
                    Pair<List<byte[]>, Integer> pair = Track.parseAvcCodecPrivate(new ParsableByteArray(this.codecPrivate));
                    list = (List)pair.first;
                    this.nalUnitLengthFieldLength = (Integer)pair.second;
                    break;
                }
                case "V_MPEGH/ISO/HEVC": {
                    string = "video/hevc";
                    Pair<List<byte[]>, Integer> pair = Track.parseHevcCodecPrivate(new ParsableByteArray(this.codecPrivate));
                    list = (List)pair.first;
                    this.nalUnitLengthFieldLength = (Integer)pair.second;
                    break;
                }
                case "V_MS/VFW/FOURCC": {
                    string = "video/wvc1";
                    list = Track.parseFourCcVc1Private(new ParsableByteArray(this.codecPrivate));
                    break;
                }
                case "A_VORBIS": {
                    string = "audio/vorbis";
                    n2 = 8192;
                    list = Track.parseVorbisCodecPrivate(this.codecPrivate);
                    break;
                }
                case "A_OPUS": {
                    string = "audio/opus";
                    n2 = 5760;
                    list = new ArrayList<byte[]>(3);
                    list.add(this.codecPrivate);
                    list.add(ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(this.codecDelayNs).array());
                    list.add(ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(this.seekPreRollNs).array());
                    break;
                }
                case "A_AAC": {
                    string = "audio/mp4a-latm";
                    list = Collections.singletonList(this.codecPrivate);
                    break;
                }
                case "A_MPEG/L3": {
                    string = "audio/mpeg";
                    n2 = 4096;
                    break;
                }
                case "A_AC3": {
                    string = "audio/ac3";
                    break;
                }
                case "A_EAC3": {
                    string = "audio/eac3";
                    break;
                }
                case "A_TRUEHD": {
                    string = "audio/true-hd";
                    break;
                }
                case "A_DTS": 
                case "A_DTS/EXPRESS": {
                    string = "audio/vnd.dts";
                    break;
                }
                case "A_DTS/LOSSLESS": {
                    string = "audio/vnd.dts.hd";
                    break;
                }
                case "A_FLAC": {
                    string = "audio/x-flac";
                    list = Collections.singletonList(this.codecPrivate);
                    break;
                }
                case "A_MS/ACM": {
                    string = "audio/raw";
                    if (!Track.parseMsAcmCodecPrivate(new ParsableByteArray(this.codecPrivate))) {
                        throw new ParserException("Non-PCM MS/ACM is unsupported");
                    }
                    if (this.audioBitDepth == 16) break;
                    throw new ParserException("Unsupported PCM bit depth: " + this.audioBitDepth);
                }
                case "A_PCM/INT/LIT": {
                    string = "audio/raw";
                    if (this.audioBitDepth == 16) break;
                    throw new ParserException("Unsupported PCM bit depth: " + this.audioBitDepth);
                }
                case "S_TEXT/UTF8": {
                    string = "application/x-subrip";
                    break;
                }
                case "S_VOBSUB": {
                    string = "application/vobsub";
                    list = Collections.singletonList(this.codecPrivate);
                    break;
                }
                case "S_HDMV/PGS": {
                    string = "application/pgs";
                    break;
                }
                default: {
                    throw new ParserException("Unrecognized codec identifier.");
                }
            }
            if (MimeTypes.isAudio(string)) {
                object = MediaFormat.createAudioFormat(Integer.toString(n), string, -1, n2, l, this.channelCount, this.sampleRate, list, this.language);
            } else if (MimeTypes.isVideo(string)) {
                if (this.displayUnit == 0) {
                    this.displayWidth = this.displayWidth == -1 ? this.width : this.displayWidth;
                    this.displayHeight = this.displayHeight == -1 ? this.height : this.displayHeight;
                }
                float f = -1.0f;
                if (this.displayWidth != -1 && this.displayHeight != -1) {
                    f = (float)(this.height * this.displayWidth) / (float)(this.width * this.displayHeight);
                }
                object = MediaFormat.createVideoFormat(Integer.toString(n), string, -1, n2, l, this.width, this.height, list, -1, f);
            } else if ("application/x-subrip".equals(string)) {
                object = MediaFormat.createTextFormat(Integer.toString(n), string, -1, l, this.language);
            } else if ("application/vobsub".equals(string) || "application/pgs".equals(string)) {
                object = MediaFormat.createImageFormat(Integer.toString(n), string, -1, l, list, this.language);
            } else {
                throw new ParserException("Unexpected MIME type.");
            }
            this.output = extractorOutput.track(this.number);
            this.output.format((MediaFormat)object);
        }

        private static List<byte[]> parseFourCcVc1Private(ParsableByteArray parsableByteArray) throws ParserException {
            try {
                parsableByteArray.skipBytes(16);
                long l = parsableByteArray.readLittleEndianUnsignedInt();
                if (l != 826496599L) {
                    throw new ParserException("Unsupported FourCC compression type: " + l);
                }
                int n = parsableByteArray.getPosition() + 20;
                byte[] byArray = parsableByteArray.data;
                for (int i = n; i < byArray.length - 4; ++i) {
                    if (byArray[i] != 0 || byArray[i + 1] != 0 || byArray[i + 2] != 1 || byArray[i + 3] != 15) continue;
                    byte[] byArray2 = Arrays.copyOfRange(byArray, i, byArray.length);
                    return Collections.singletonList(byArray2);
                }
                throw new ParserException("Failed to find FourCC VC1 initialization data");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ParserException("Error parsing FourCC VC1 codec private");
            }
        }

        private static Pair<List<byte[]>, Integer> parseAvcCodecPrivate(ParsableByteArray parsableByteArray) throws ParserException {
            try {
                int n;
                parsableByteArray.setPosition(4);
                int n2 = (parsableByteArray.readUnsignedByte() & 3) + 1;
                if (n2 == 3) {
                    throw new ParserException();
                }
                ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
                int n3 = parsableByteArray.readUnsignedByte() & 0x1F;
                for (n = 0; n < n3; ++n) {
                    arrayList.add(NalUnitUtil.parseChildNalUnit(parsableByteArray));
                }
                n = parsableByteArray.readUnsignedByte();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(NalUnitUtil.parseChildNalUnit(parsableByteArray));
                }
                return Pair.create(arrayList, (Object)n2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ParserException("Error parsing AVC codec private");
            }
        }

        private static Pair<List<byte[]>, Integer> parseHevcCodecPrivate(ParsableByteArray parsableByteArray) throws ParserException {
            try {
                int n;
                int n2;
                int n3;
                parsableByteArray.setPosition(21);
                int n4 = parsableByteArray.readUnsignedByte() & 3;
                int n5 = parsableByteArray.readUnsignedByte();
                int n6 = 0;
                int n7 = parsableByteArray.getPosition();
                for (int i = 0; i < n5; ++i) {
                    parsableByteArray.skipBytes(1);
                    n3 = parsableByteArray.readUnsignedShort();
                    for (n2 = 0; n2 < n3; ++n2) {
                        n = parsableByteArray.readUnsignedShort();
                        n6 += 4 + n;
                        parsableByteArray.skipBytes(n);
                    }
                }
                parsableByteArray.setPosition(n7);
                byte[] byArray = new byte[n6];
                n3 = 0;
                for (n2 = 0; n2 < n5; ++n2) {
                    parsableByteArray.skipBytes(1);
                    n = parsableByteArray.readUnsignedShort();
                    for (int i = 0; i < n; ++i) {
                        int n8 = parsableByteArray.readUnsignedShort();
                        System.arraycopy(NalUnitUtil.NAL_START_CODE, 0, byArray, n3, NalUnitUtil.NAL_START_CODE.length);
                        System.arraycopy(parsableByteArray.data, parsableByteArray.getPosition(), byArray, n3 += NalUnitUtil.NAL_START_CODE.length, n8);
                        n3 += n8;
                        parsableByteArray.skipBytes(n8);
                    }
                }
                List<byte[]> list = n6 == 0 ? null : Collections.singletonList(byArray);
                return Pair.create(list, (Object)(n4 + 1));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ParserException("Error parsing HEVC codec private");
            }
        }

        private static List<byte[]> parseVorbisCodecPrivate(byte[] byArray) throws ParserException {
            try {
                if (byArray[0] != 2) {
                    throw new ParserException("Error parsing vorbis codec private");
                }
                int n = 1;
                int n2 = 0;
                while (byArray[n] == -1) {
                    n2 += 255;
                    ++n;
                }
                n2 += byArray[n++];
                int n3 = 0;
                while (byArray[n] == -1) {
                    n3 += 255;
                    ++n;
                }
                n3 += byArray[n++];
                if (byArray[n] != 1) {
                    throw new ParserException("Error parsing vorbis codec private");
                }
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
                if (byArray[n += n2] != 3) {
                    throw new ParserException("Error parsing vorbis codec private");
                }
                if (byArray[n += n3] != 5) {
                    throw new ParserException("Error parsing vorbis codec private");
                }
                byte[] byArray3 = new byte[byArray.length - n];
                System.arraycopy(byArray, n, byArray3, 0, byArray.length - n);
                ArrayList<byte[]> arrayList = new ArrayList<byte[]>(2);
                arrayList.add(byArray2);
                arrayList.add(byArray3);
                return arrayList;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ParserException("Error parsing vorbis codec private");
            }
        }

        private static boolean parseMsAcmCodecPrivate(ParsableByteArray parsableByteArray) throws ParserException {
            try {
                int n = parsableByteArray.readLittleEndianUnsignedShort();
                if (n == 1) {
                    return true;
                }
                if (n == 65534) {
                    parsableByteArray.setPosition(24);
                    return parsableByteArray.readLong() == WAVE_SUBFORMAT_PCM.getMostSignificantBits() && parsableByteArray.readLong() == WAVE_SUBFORMAT_PCM.getLeastSignificantBits();
                }
                return false;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ParserException("Error parsing MS/ACM codec private");
            }
        }
    }

    private final class InnerEbmlReaderOutput
    implements EbmlReaderOutput {
        private InnerEbmlReaderOutput() {
        }

        @Override
        public int getElementType(int n) {
            return WebmExtractor.this.getElementType(n);
        }

        @Override
        public boolean isLevel1Element(int n) {
            return WebmExtractor.this.isLevel1Element(n);
        }

        @Override
        public void startMasterElement(int n, long l, long l2) throws ParserException {
            WebmExtractor.this.startMasterElement(n, l, l2);
        }

        @Override
        public void endMasterElement(int n) throws ParserException {
            WebmExtractor.this.endMasterElement(n);
        }

        @Override
        public void integerElement(int n, long l) throws ParserException {
            WebmExtractor.this.integerElement(n, l);
        }

        @Override
        public void floatElement(int n, double d) throws ParserException {
            WebmExtractor.this.floatElement(n, d);
        }

        @Override
        public void stringElement(int n, String string) throws ParserException {
            WebmExtractor.this.stringElement(n, string);
        }

        @Override
        public void binaryElement(int n, int n2, ExtractorInput extractorInput) throws IOException, InterruptedException {
            WebmExtractor.this.binaryElement(n, n2, extractorInput);
        }
    }
}

