/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.webm;

import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.io.IOException;

final class Sniffer {
    private static final int SEARCH_LENGTH = 1024;
    private static final int ID_EBML = 440786851;
    private final ParsableByteArray scratch = new ParsableByteArray(8);
    private int peekLength;

    public boolean sniff(ExtractorInput extractorInput) throws IOException, InterruptedException {
        long l = extractorInput.getLength();
        int n = (int)(l == -1L || l > 1024L ? 1024L : l);
        extractorInput.peekFully(this.scratch.data, 0, 4);
        this.peekLength = 4;
        for (long i = this.scratch.readUnsignedInt(); i != 440786851L; i |= (long)(this.scratch.data[0] & 0xFF)) {
            if (++this.peekLength == n) {
                return false;
            }
            extractorInput.peekFully(this.scratch.data, 0, 1);
            i = i << 8 & 0xFFFFFFFFFFFFFF00L;
        }
        long l2 = this.readUint(extractorInput);
        long l3 = this.peekLength;
        if (l2 == Long.MIN_VALUE || l != -1L && l3 + l2 >= l) {
            return false;
        }
        while ((long)this.peekLength < l3 + l2) {
            long l4 = this.readUint(extractorInput);
            if (l4 == Long.MIN_VALUE) {
                return false;
            }
            long l5 = this.readUint(extractorInput);
            if (l5 < 0L || l5 > Integer.MAX_VALUE) {
                return false;
            }
            if (l5 == 0L) continue;
            extractorInput.advancePeekPosition((int)l5);
            this.peekLength = (int)((long)this.peekLength + l5);
        }
        return (long)this.peekLength == l3 + l2;
    }

    private long readUint(ExtractorInput extractorInput) throws IOException, InterruptedException {
        extractorInput.peekFully(this.scratch.data, 0, 1);
        int n = this.scratch.data[0] & 0xFF;
        if (n == 0) {
            return Long.MIN_VALUE;
        }
        int n2 = 128;
        int n3 = 0;
        while ((n & n2) == 0) {
            n2 >>= 1;
            ++n3;
        }
        n &= ~n2;
        extractorInput.peekFully(this.scratch.data, 1, n3);
        for (int i = 0; i < n3; ++i) {
            n <<= 8;
            n += this.scratch.data[i + 1] & 0xFF;
        }
        this.peekLength += n3 + 1;
        return n;
    }
}

