/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.ts;

import android.util.SparseArray;
import android.util.SparseBooleanArray;
import com.google.android.exoplayer.extractor.DummyTrackOutput;
import com.google.android.exoplayer.extractor.Extractor;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.ExtractorOutput;
import com.google.android.exoplayer.extractor.PositionHolder;
import com.google.android.exoplayer.extractor.SeekMap;
import com.google.android.exoplayer.extractor.ts.Ac3Reader;
import com.google.android.exoplayer.extractor.ts.AdtsReader;
import com.google.android.exoplayer.extractor.ts.DtsReader;
import com.google.android.exoplayer.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer.extractor.ts.H262Reader;
import com.google.android.exoplayer.extractor.ts.H264Reader;
import com.google.android.exoplayer.extractor.ts.H265Reader;
import com.google.android.exoplayer.extractor.ts.Id3Reader;
import com.google.android.exoplayer.extractor.ts.MpegAudioReader;
import com.google.android.exoplayer.extractor.ts.PtsTimestampAdjuster;
import com.google.android.exoplayer.extractor.ts.SeiReader;
import com.google.android.exoplayer.util.ParsableBitArray;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.google.android.exoplayer.util.Util;
import com.vcc.playerwrappersdk.a;
import java.io.IOException;

public final class TsExtractor
implements Extractor {
    public static final int WORKAROUND_ALLOW_NON_IDR_KEYFRAMES = 1;
    public static final int WORKAROUND_IGNORE_AAC_STREAM = 2;
    public static final int WORKAROUND_IGNORE_H264_STREAM = 4;
    public static final int WORKAROUND_DETECT_ACCESS_UNITS = 8;
    private static final String TAG = "TsExtractor";
    private static final int TS_PACKET_SIZE = 188;
    private static final int TS_SYNC_BYTE = 71;
    private static final int TS_PAT_PID = 0;
    private static final int TS_STREAM_TYPE_MPA = 3;
    private static final int TS_STREAM_TYPE_MPA_LSF = 4;
    private static final int TS_STREAM_TYPE_AAC = 15;
    private static final int TS_STREAM_TYPE_AC3 = 129;
    private static final int TS_STREAM_TYPE_DTS = 138;
    private static final int TS_STREAM_TYPE_HDMV_DTS = 130;
    private static final int TS_STREAM_TYPE_E_AC3 = 135;
    private static final int TS_STREAM_TYPE_H262 = 2;
    private static final int TS_STREAM_TYPE_H264 = 27;
    private static final int TS_STREAM_TYPE_H265 = 36;
    private static final int TS_STREAM_TYPE_ID3 = 21;
    private static final int TS_STREAM_TYPE_EIA608 = 256;
    private static final long AC3_FORMAT_IDENTIFIER = Util.getIntegerCodeForString("AC-3");
    private static final long E_AC3_FORMAT_IDENTIFIER = Util.getIntegerCodeForString("EAC3");
    private static final long HEVC_FORMAT_IDENTIFIER = Util.getIntegerCodeForString("HEVC");
    private final PtsTimestampAdjuster ptsTimestampAdjuster;
    private final int workaroundFlags;
    private final ParsableByteArray tsPacketBuffer;
    private final ParsableBitArray tsScratch;
    final SparseArray<TsPayloadReader> tsPayloadReaders;
    final SparseBooleanArray streamTypes;
    private ExtractorOutput output;
    Id3Reader id3Reader;

    public TsExtractor() {
        this(new PtsTimestampAdjuster(0L));
    }

    public TsExtractor(PtsTimestampAdjuster ptsTimestampAdjuster) {
        this(ptsTimestampAdjuster, 0);
    }

    public TsExtractor(PtsTimestampAdjuster ptsTimestampAdjuster, int n) {
        this.ptsTimestampAdjuster = ptsTimestampAdjuster;
        this.workaroundFlags = n;
        this.tsPacketBuffer = new ParsableByteArray(188);
        this.tsScratch = new ParsableBitArray(new byte[3]);
        this.tsPayloadReaders = new SparseArray();
        this.tsPayloadReaders.put(0, (Object)new PatReader());
        this.streamTypes = new SparseBooleanArray();
    }

    @Override
    public boolean sniff(ExtractorInput extractorInput) throws IOException, InterruptedException {
        byte[] byArray = new byte[1];
        for (int i = 0; i < 5; ++i) {
            extractorInput.peekFully(byArray, 0, 1);
            if ((byArray[0] & 0xFF) != 71) {
                return false;
            }
            extractorInput.advancePeekPosition(187);
        }
        return true;
    }

    @Override
    public void init(ExtractorOutput extractorOutput) {
        this.output = extractorOutput;
        extractorOutput.seekMap(SeekMap.UNSEEKABLE);
    }

    @Override
    public void seek() {
        this.ptsTimestampAdjuster.reset();
        for (int i = 0; i < this.tsPayloadReaders.size(); ++i) {
            ((TsPayloadReader)this.tsPayloadReaders.valueAt(i)).seek();
        }
    }

    @Override
    public void release() {
    }

    @Override
    public int read(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException, InterruptedException {
        TsPayloadReader tsPayloadReader;
        if (!extractorInput.readFully(this.tsPacketBuffer.data, 0, 188, true)) {
            return -1;
        }
        this.tsPacketBuffer.setPosition(0);
        this.tsPacketBuffer.setLimit(188);
        int n = this.tsPacketBuffer.readUnsignedByte();
        if (n != 71) {
            return 0;
        }
        this.tsPacketBuffer.readBytes(this.tsScratch, 3);
        this.tsScratch.skipBits(1);
        boolean bl = this.tsScratch.readBit();
        this.tsScratch.skipBits(1);
        int n2 = this.tsScratch.readBits(13);
        this.tsScratch.skipBits(2);
        boolean bl2 = this.tsScratch.readBit();
        boolean bl3 = this.tsScratch.readBit();
        if (bl2) {
            int n3 = this.tsPacketBuffer.readUnsignedByte();
            this.tsPacketBuffer.skipBytes(n3);
        }
        if (bl3 && (tsPayloadReader = (TsPayloadReader)this.tsPayloadReaders.get(n2)) != null) {
            tsPayloadReader.consume(this.tsPacketBuffer, bl, this.output);
        }
        return 0;
    }

    private static final class PesReader
    extends TsPayloadReader {
        private static final int STATE_FINDING_HEADER = 0;
        private static final int STATE_READING_HEADER = 1;
        private static final int STATE_READING_HEADER_EXTENSION = 2;
        private static final int STATE_READING_BODY = 3;
        private static final int HEADER_SIZE = 9;
        private static final int MAX_HEADER_EXTENSION_SIZE = 10;
        private static final int PES_SCRATCH_SIZE = 10;
        private final ElementaryStreamReader pesPayloadReader;
        private final PtsTimestampAdjuster ptsTimestampAdjuster;
        private final ParsableBitArray pesScratch;
        private int state;
        private int bytesRead;
        private boolean ptsFlag;
        private boolean dtsFlag;
        private boolean seenFirstDts;
        private int extendedHeaderLength;
        private int payloadSize;
        private boolean dataAlignmentIndicator;
        private long timeUs;

        public PesReader(ElementaryStreamReader elementaryStreamReader, PtsTimestampAdjuster ptsTimestampAdjuster) {
            this.pesPayloadReader = elementaryStreamReader;
            this.ptsTimestampAdjuster = ptsTimestampAdjuster;
            this.pesScratch = new ParsableBitArray(new byte[10]);
            this.state = 0;
        }

        @Override
        public void seek() {
            this.state = 0;
            this.bytesRead = 0;
            this.seenFirstDts = false;
            this.pesPayloadReader.seek();
        }

        @Override
        public void consume(ParsableByteArray parsableByteArray, boolean bl, ExtractorOutput extractorOutput) {
            if (bl) {
                switch (this.state) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: {
                        a.b(TsExtractor.TAG, "Unexpected start indicator reading extended header");
                        break;
                    }
                    case 3: {
                        if (this.payloadSize != -1) {
                            a.b(TsExtractor.TAG, "Unexpected start indicator: expected " + this.payloadSize + " more bytes");
                        }
                        this.pesPayloadReader.packetFinished();
                    }
                }
                this.setState(1);
            }
            while (parsableByteArray.bytesLeft() > 0) {
                switch (this.state) {
                    case 0: {
                        parsableByteArray.skipBytes(parsableByteArray.bytesLeft());
                        break;
                    }
                    case 1: {
                        if (!this.continueRead(parsableByteArray, this.pesScratch.data, 9)) break;
                        this.setState(this.parseHeader() ? 2 : 0);
                        break;
                    }
                    case 2: {
                        int n2 = Math.min(10, this.extendedHeaderLength);
                        if (!this.continueRead(parsableByteArray, this.pesScratch.data, n2) || !this.continueRead(parsableByteArray, null, this.extendedHeaderLength)) break;
                        this.parseHeaderExtension();
                        this.pesPayloadReader.packetStarted(this.timeUs, this.dataAlignmentIndicator);
                        this.setState(3);
                        break;
                    }
                    case 3: {
                        int n;
                        int n2 = parsableByteArray.bytesLeft();
                        int n3 = n = this.payloadSize == -1 ? 0 : n2 - this.payloadSize;
                        if (n > 0) {
                            parsableByteArray.setLimit(parsableByteArray.getPosition() + (n2 -= n));
                        }
                        this.pesPayloadReader.consume(parsableByteArray);
                        if (this.payloadSize == -1) break;
                        this.payloadSize -= n2;
                        if (this.payloadSize != 0) break;
                        this.pesPayloadReader.packetFinished();
                        this.setState(1);
                    }
                }
            }
        }

        private void setState(int n) {
            this.state = n;
            this.bytesRead = 0;
        }

        private boolean continueRead(ParsableByteArray parsableByteArray, byte[] byArray, int n) {
            int n2 = Math.min(parsableByteArray.bytesLeft(), n - this.bytesRead);
            if (n2 <= 0) {
                return true;
            }
            if (byArray == null) {
                parsableByteArray.skipBytes(n2);
            } else {
                parsableByteArray.readBytes(byArray, this.bytesRead, n2);
            }
            this.bytesRead += n2;
            return this.bytesRead == n;
        }

        private boolean parseHeader() {
            this.pesScratch.setPosition(0);
            int n = this.pesScratch.readBits(24);
            if (n != 1) {
                a.b(TsExtractor.TAG, "Unexpected start code prefix: " + n);
                this.payloadSize = -1;
                return false;
            }
            this.pesScratch.skipBits(8);
            int n2 = this.pesScratch.readBits(16);
            this.pesScratch.skipBits(5);
            this.dataAlignmentIndicator = this.pesScratch.readBit();
            this.pesScratch.skipBits(2);
            this.ptsFlag = this.pesScratch.readBit();
            this.dtsFlag = this.pesScratch.readBit();
            this.pesScratch.skipBits(6);
            this.extendedHeaderLength = this.pesScratch.readBits(8);
            this.payloadSize = n2 == 0 ? -1 : n2 + 6 - 9 - this.extendedHeaderLength;
            return true;
        }

        private void parseHeaderExtension() {
            this.pesScratch.setPosition(0);
            this.timeUs = -1L;
            if (this.ptsFlag) {
                this.pesScratch.skipBits(4);
                long l = (long)this.pesScratch.readBits(3) << 30;
                this.pesScratch.skipBits(1);
                l |= (long)(this.pesScratch.readBits(15) << 15);
                this.pesScratch.skipBits(1);
                l |= (long)this.pesScratch.readBits(15);
                this.pesScratch.skipBits(1);
                if (!this.seenFirstDts && this.dtsFlag) {
                    this.pesScratch.skipBits(4);
                    long l2 = (long)this.pesScratch.readBits(3) << 30;
                    this.pesScratch.skipBits(1);
                    l2 |= (long)(this.pesScratch.readBits(15) << 15);
                    this.pesScratch.skipBits(1);
                    this.pesScratch.skipBits(1);
                    this.ptsTimestampAdjuster.adjustTimestamp(l2 |= (long)this.pesScratch.readBits(15));
                    this.seenFirstDts = true;
                }
                this.timeUs = this.ptsTimestampAdjuster.adjustTimestamp(l);
            }
        }
    }

    private class PmtReader
    extends TsPayloadReader {
        private final ParsableBitArray pmtScratch;
        private final ParsableByteArray sectionData;
        private int sectionLength;
        private int sectionBytesRead;

        public PmtReader() {
            this.pmtScratch = new ParsableBitArray(new byte[5]);
            this.sectionData = new ParsableByteArray();
        }

        @Override
        public void seek() {
        }

        @Override
        public void consume(ParsableByteArray parsableByteArray, boolean bl, ExtractorOutput extractorOutput) {
            int n;
            if (bl) {
                n = parsableByteArray.readUnsignedByte();
                parsableByteArray.skipBytes(n);
                parsableByteArray.readBytes(this.pmtScratch, 3);
                this.pmtScratch.skipBits(12);
                this.sectionLength = this.pmtScratch.readBits(12);
                if (this.sectionData.capacity() < this.sectionLength) {
                    this.sectionData.reset(new byte[this.sectionLength], this.sectionLength);
                } else {
                    this.sectionData.reset();
                    this.sectionData.setLimit(this.sectionLength);
                }
            }
            n = Math.min(parsableByteArray.bytesLeft(), this.sectionLength - this.sectionBytesRead);
            parsableByteArray.readBytes(this.sectionData.data, this.sectionBytesRead, n);
            this.sectionBytesRead += n;
            if (this.sectionBytesRead < this.sectionLength) {
                return;
            }
            this.sectionData.skipBytes(7);
            this.sectionData.readBytes(this.pmtScratch, 2);
            this.pmtScratch.skipBits(4);
            int n2 = this.pmtScratch.readBits(12);
            this.sectionData.skipBytes(n2);
            if (TsExtractor.this.id3Reader == null) {
                TsExtractor.this.id3Reader = new Id3Reader(extractorOutput.track(21));
            }
            int n3 = this.sectionLength - 9 - n2 - 4;
            while (n3 > 0) {
                ElementaryStreamReader elementaryStreamReader;
                this.sectionData.readBytes(this.pmtScratch, 5);
                int n4 = this.pmtScratch.readBits(8);
                this.pmtScratch.skipBits(3);
                int n5 = this.pmtScratch.readBits(13);
                this.pmtScratch.skipBits(4);
                int n6 = this.pmtScratch.readBits(12);
                if (n4 == 6) {
                    n4 = this.readPrivateDataStreamType(this.sectionData, n6);
                } else {
                    this.sectionData.skipBytes(n6);
                }
                n3 -= n6 + 5;
                if (TsExtractor.this.streamTypes.get(n4)) continue;
                switch (n4) {
                    case 3: {
                        elementaryStreamReader = new MpegAudioReader(extractorOutput.track(3));
                        break;
                    }
                    case 4: {
                        elementaryStreamReader = new MpegAudioReader(extractorOutput.track(4));
                        break;
                    }
                    case 15: {
                        elementaryStreamReader = (TsExtractor.this.workaroundFlags & 2) != 0 ? null : new AdtsReader(extractorOutput.track(15), new DummyTrackOutput());
                        break;
                    }
                    case 129: {
                        elementaryStreamReader = new Ac3Reader(extractorOutput.track(129), false);
                        break;
                    }
                    case 135: {
                        elementaryStreamReader = new Ac3Reader(extractorOutput.track(135), true);
                        break;
                    }
                    case 130: 
                    case 138: {
                        elementaryStreamReader = new DtsReader(extractorOutput.track(138));
                        break;
                    }
                    case 2: {
                        elementaryStreamReader = new H262Reader(extractorOutput.track(2));
                        break;
                    }
                    case 27: {
                        elementaryStreamReader = (TsExtractor.this.workaroundFlags & 4) != 0 ? null : new H264Reader(extractorOutput.track(27), new SeiReader(extractorOutput.track(256)), (TsExtractor.this.workaroundFlags & 1) != 0, (TsExtractor.this.workaroundFlags & 8) != 0);
                        break;
                    }
                    case 36: {
                        elementaryStreamReader = new H265Reader(extractorOutput.track(36), new SeiReader(extractorOutput.track(256)));
                        break;
                    }
                    case 21: {
                        elementaryStreamReader = TsExtractor.this.id3Reader;
                        break;
                    }
                    default: {
                        elementaryStreamReader = null;
                    }
                }
                if (elementaryStreamReader == null) continue;
                TsExtractor.this.streamTypes.put(n4, true);
                TsExtractor.this.tsPayloadReaders.put(n5, (Object)new PesReader(elementaryStreamReader, TsExtractor.this.ptsTimestampAdjuster));
            }
            extractorOutput.endTracks();
        }

        private int readPrivateDataStreamType(ParsableByteArray parsableByteArray, int n) {
            int n2 = -1;
            int n3 = parsableByteArray.getPosition() + n;
            while (parsableByteArray.getPosition() < n3) {
                int n4 = parsableByteArray.readUnsignedByte();
                int n5 = parsableByteArray.readUnsignedByte();
                if (n4 == 5) {
                    long l = parsableByteArray.readUnsignedInt();
                    if (l == AC3_FORMAT_IDENTIFIER) {
                        n2 = 129;
                        break;
                    }
                    if (l == E_AC3_FORMAT_IDENTIFIER) {
                        n2 = 135;
                        break;
                    }
                    if (l != HEVC_FORMAT_IDENTIFIER) break;
                    n2 = 36;
                    break;
                }
                if (n4 == 106) {
                    n2 = 129;
                } else if (n4 == 122) {
                    n2 = 135;
                } else if (n4 == 123) {
                    n2 = 138;
                }
                parsableByteArray.skipBytes(n5);
            }
            parsableByteArray.setPosition(n3);
            return n2;
        }
    }

    private class PatReader
    extends TsPayloadReader {
        private final ParsableBitArray patScratch;

        public PatReader() {
            this.patScratch = new ParsableBitArray(new byte[4]);
        }

        @Override
        public void seek() {
        }

        @Override
        public void consume(ParsableByteArray parsableByteArray, boolean bl, ExtractorOutput extractorOutput) {
            int n;
            if (bl) {
                n = parsableByteArray.readUnsignedByte();
                parsableByteArray.skipBytes(n);
            }
            parsableByteArray.readBytes(this.patScratch, 3);
            this.patScratch.skipBits(12);
            n = this.patScratch.readBits(12);
            parsableByteArray.skipBytes(5);
            int n2 = (n - 9) / 4;
            for (int i = 0; i < n2; ++i) {
                parsableByteArray.readBytes(this.patScratch, 4);
                int n3 = this.patScratch.readBits(16);
                this.patScratch.skipBits(3);
                if (n3 == 0) {
                    this.patScratch.skipBits(13);
                    continue;
                }
                int n4 = this.patScratch.readBits(13);
                TsExtractor.this.tsPayloadReaders.put(n4, (Object)new PmtReader());
            }
        }
    }

    private static abstract class TsPayloadReader {
        private TsPayloadReader() {
        }

        public abstract void seek();

        public abstract void consume(ParsableByteArray var1, boolean var2, ExtractorOutput var3);
    }
}

