/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.ts;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer.extractor.ts.NalUnitTargetBuffer;
import com.google.android.exoplayer.extractor.ts.SeiReader;
import com.google.android.exoplayer.util.NalUnitUtil;
import com.google.android.exoplayer.util.ParsableBitArray;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.vcc.playerwrappersdk.a;
import java.util.Collections;

final class H265Reader
extends ElementaryStreamReader {
    private static final String TAG = "H265Reader";
    private static final int RASL_R = 9;
    private static final int BLA_W_LP = 16;
    private static final int CRA_NUT = 21;
    private static final int VPS_NUT = 32;
    private static final int SPS_NUT = 33;
    private static final int PPS_NUT = 34;
    private static final int PREFIX_SEI_NUT = 39;
    private static final int SUFFIX_SEI_NUT = 40;
    private boolean hasOutputFormat;
    private final SeiReader seiReader;
    private final boolean[] prefixFlags;
    private final NalUnitTargetBuffer vps;
    private final NalUnitTargetBuffer sps;
    private final NalUnitTargetBuffer pps;
    private final NalUnitTargetBuffer prefixSei;
    private final NalUnitTargetBuffer suffixSei;
    private final SampleReader sampleReader;
    private long totalBytesWritten;
    private long pesTimeUs;
    private final ParsableByteArray seiWrapper;

    public H265Reader(TrackOutput trackOutput, SeiReader seiReader) {
        super(trackOutput);
        this.seiReader = seiReader;
        this.prefixFlags = new boolean[3];
        this.vps = new NalUnitTargetBuffer(32, 128);
        this.sps = new NalUnitTargetBuffer(33, 128);
        this.pps = new NalUnitTargetBuffer(34, 128);
        this.prefixSei = new NalUnitTargetBuffer(39, 128);
        this.suffixSei = new NalUnitTargetBuffer(40, 128);
        this.sampleReader = new SampleReader(trackOutput);
        this.seiWrapper = new ParsableByteArray();
    }

    @Override
    public void seek() {
        NalUnitUtil.clearPrefixFlags(this.prefixFlags);
        this.vps.reset();
        this.sps.reset();
        this.pps.reset();
        this.prefixSei.reset();
        this.suffixSei.reset();
        this.sampleReader.reset();
        this.totalBytesWritten = 0L;
    }

    @Override
    public void packetStarted(long l, boolean bl) {
        this.pesTimeUs = l;
    }

    @Override
    public void consume(ParsableByteArray parsableByteArray) {
        while (parsableByteArray.bytesLeft() > 0) {
            int n = parsableByteArray.getPosition();
            int n2 = parsableByteArray.limit();
            byte[] byArray = parsableByteArray.data;
            this.totalBytesWritten += (long)parsableByteArray.bytesLeft();
            this.output.sampleData(parsableByteArray, parsableByteArray.bytesLeft());
            while (n < n2) {
                int n3 = NalUnitUtil.findNalUnit(byArray, n, n2, this.prefixFlags);
                if (n3 == n2) {
                    this.nalUnitData(byArray, n, n2);
                    return;
                }
                int n4 = NalUnitUtil.getH265NalUnitType(byArray, n3);
                int n5 = n3 - n;
                if (n5 > 0) {
                    this.nalUnitData(byArray, n, n3);
                }
                int n6 = n2 - n3;
                long l = this.totalBytesWritten - (long)n6;
                this.endNalUnit(l, n6, n5 < 0 ? -n5 : 0, this.pesTimeUs);
                this.startNalUnit(l, n6, n4, this.pesTimeUs);
                n = n3 + 3;
            }
        }
    }

    @Override
    public void packetFinished() {
    }

    private void startNalUnit(long l, int n, int n2, long l2) {
        if (!this.hasOutputFormat) {
            this.vps.startNalUnit(n2);
            this.sps.startNalUnit(n2);
            this.pps.startNalUnit(n2);
        }
        this.prefixSei.startNalUnit(n2);
        this.suffixSei.startNalUnit(n2);
        this.sampleReader.startNalUnit(l, n, n2, l2);
    }

    private void nalUnitData(byte[] byArray, int n, int n2) {
        if (this.hasOutputFormat) {
            this.sampleReader.readNalUnitData(byArray, n, n2);
        } else {
            this.vps.appendToNalUnit(byArray, n, n2);
            this.sps.appendToNalUnit(byArray, n, n2);
            this.pps.appendToNalUnit(byArray, n, n2);
        }
        this.prefixSei.appendToNalUnit(byArray, n, n2);
        this.suffixSei.appendToNalUnit(byArray, n, n2);
    }

    private void endNalUnit(long l, int n, int n2, long l2) {
        int n3;
        if (this.hasOutputFormat) {
            this.sampleReader.endNalUnit(l, n);
        } else {
            this.vps.endNalUnit(n2);
            this.sps.endNalUnit(n2);
            this.pps.endNalUnit(n2);
            if (this.vps.isCompleted() && this.sps.isCompleted() && this.pps.isCompleted()) {
                this.output.format(H265Reader.parseMediaFormat(this.vps, this.sps, this.pps));
                this.hasOutputFormat = true;
            }
        }
        if (this.prefixSei.endNalUnit(n2)) {
            n3 = NalUnitUtil.unescapeStream(this.prefixSei.nalData, this.prefixSei.nalLength);
            this.seiWrapper.reset(this.prefixSei.nalData, n3);
            this.seiWrapper.skipBytes(5);
            this.seiReader.consume(l2, this.seiWrapper);
        }
        if (this.suffixSei.endNalUnit(n2)) {
            n3 = NalUnitUtil.unescapeStream(this.suffixSei.nalData, this.suffixSei.nalLength);
            this.seiWrapper.reset(this.suffixSei.nalData, n3);
            this.seiWrapper.skipBytes(5);
            this.seiReader.consume(l2, this.seiWrapper);
        }
    }

    private static MediaFormat parseMediaFormat(NalUnitTargetBuffer nalUnitTargetBuffer, NalUnitTargetBuffer nalUnitTargetBuffer2, NalUnitTargetBuffer nalUnitTargetBuffer3) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        byte[] byArray = new byte[nalUnitTargetBuffer.nalLength + nalUnitTargetBuffer2.nalLength + nalUnitTargetBuffer3.nalLength];
        System.arraycopy(nalUnitTargetBuffer.nalData, 0, byArray, 0, nalUnitTargetBuffer.nalLength);
        System.arraycopy(nalUnitTargetBuffer2.nalData, 0, byArray, nalUnitTargetBuffer.nalLength, nalUnitTargetBuffer2.nalLength);
        System.arraycopy(nalUnitTargetBuffer3.nalData, 0, byArray, nalUnitTargetBuffer.nalLength + nalUnitTargetBuffer2.nalLength, nalUnitTargetBuffer3.nalLength);
        NalUnitUtil.unescapeStream(nalUnitTargetBuffer2.nalData, nalUnitTargetBuffer2.nalLength);
        ParsableBitArray parsableBitArray = new ParsableBitArray(nalUnitTargetBuffer2.nalData);
        parsableBitArray.skipBits(44);
        int n7 = parsableBitArray.readBits(3);
        parsableBitArray.skipBits(1);
        parsableBitArray.skipBits(88);
        parsableBitArray.skipBits(8);
        int n8 = 0;
        for (n6 = 0; n6 < n7; ++n6) {
            if (parsableBitArray.readBit()) {
                n8 += 89;
            }
            if (!parsableBitArray.readBit()) continue;
            n8 += 8;
        }
        parsableBitArray.skipBits(n8);
        if (n7 > 0) {
            parsableBitArray.skipBits(2 * (8 - n7));
        }
        parsableBitArray.readUnsignedExpGolombCodedInt();
        n6 = parsableBitArray.readUnsignedExpGolombCodedInt();
        if (n6 == 3) {
            parsableBitArray.skipBits(1);
        }
        int n9 = parsableBitArray.readUnsignedExpGolombCodedInt();
        int n10 = parsableBitArray.readUnsignedExpGolombCodedInt();
        if (parsableBitArray.readBit()) {
            n5 = parsableBitArray.readUnsignedExpGolombCodedInt();
            n4 = parsableBitArray.readUnsignedExpGolombCodedInt();
            n3 = parsableBitArray.readUnsignedExpGolombCodedInt();
            n2 = parsableBitArray.readUnsignedExpGolombCodedInt();
            n = n6 == 1 || n6 == 2 ? 2 : 1;
            int n11 = n6 == 1 ? 2 : 1;
            n9 -= n * (n5 + n4);
            n10 -= n11 * (n3 + n2);
        }
        parsableBitArray.readUnsignedExpGolombCodedInt();
        parsableBitArray.readUnsignedExpGolombCodedInt();
        n5 = parsableBitArray.readUnsignedExpGolombCodedInt();
        int n12 = n4 = parsableBitArray.readBit() ? 0 : n7;
        while (n4 <= n7) {
            parsableBitArray.readUnsignedExpGolombCodedInt();
            parsableBitArray.readUnsignedExpGolombCodedInt();
            parsableBitArray.readUnsignedExpGolombCodedInt();
            ++n4;
        }
        parsableBitArray.readUnsignedExpGolombCodedInt();
        parsableBitArray.readUnsignedExpGolombCodedInt();
        parsableBitArray.readUnsignedExpGolombCodedInt();
        parsableBitArray.readUnsignedExpGolombCodedInt();
        parsableBitArray.readUnsignedExpGolombCodedInt();
        parsableBitArray.readUnsignedExpGolombCodedInt();
        if (parsableBitArray.readBit() && parsableBitArray.readBit()) {
            H265Reader.skipScalingList(parsableBitArray);
        }
        parsableBitArray.skipBits(2);
        if (parsableBitArray.readBit()) {
            parsableBitArray.skipBits(8);
            parsableBitArray.readUnsignedExpGolombCodedInt();
            parsableBitArray.readUnsignedExpGolombCodedInt();
            parsableBitArray.skipBits(1);
        }
        H265Reader.skipShortTermRefPicSets(parsableBitArray);
        if (parsableBitArray.readBit()) {
            for (n4 = 0; n4 < parsableBitArray.readUnsignedExpGolombCodedInt(); ++n4) {
                n3 = n5 + 4;
                parsableBitArray.skipBits(n3 + 1);
            }
        }
        parsableBitArray.skipBits(2);
        float f = 1.0f;
        if (parsableBitArray.readBit() && parsableBitArray.readBit()) {
            n3 = parsableBitArray.readBits(8);
            if (n3 == 255) {
                n2 = parsableBitArray.readBits(16);
                n = parsableBitArray.readBits(16);
                if (n2 != 0 && n != 0) {
                    f = (float)n2 / (float)n;
                }
            } else if (n3 < NalUnitUtil.ASPECT_RATIO_IDC_VALUES.length) {
                f = NalUnitUtil.ASPECT_RATIO_IDC_VALUES[n3];
            } else {
                a.b(TAG, "Unexpected aspect_ratio_idc value: " + n3);
            }
        }
        return MediaFormat.createVideoFormat(null, "video/hevc", -1, -1, -1L, n9, n10, Collections.singletonList(byArray), -1, f);
    }

    private static void skipScalingList(ParsableBitArray parsableBitArray) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 6; j += i == 3 ? 3 : 1) {
                if (!parsableBitArray.readBit()) {
                    parsableBitArray.readUnsignedExpGolombCodedInt();
                    continue;
                }
                int n = Math.min(64, 1 << 4 + (i << 1));
                if (i > 1) {
                    parsableBitArray.readSignedExpGolombCodedInt();
                }
                for (int k = 0; k < n; ++k) {
                    parsableBitArray.readSignedExpGolombCodedInt();
                }
            }
        }
    }

    private static void skipShortTermRefPicSets(ParsableBitArray parsableBitArray) {
        int n = parsableBitArray.readUnsignedExpGolombCodedInt();
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            int n5;
            if (i != 0) {
                bl = parsableBitArray.readBit();
            }
            if (bl) {
                parsableBitArray.skipBits(1);
                parsableBitArray.readUnsignedExpGolombCodedInt();
                for (n5 = 0; n5 <= n4; ++n5) {
                    if (!parsableBitArray.readBit()) continue;
                    parsableBitArray.skipBits(1);
                }
                continue;
            }
            n2 = parsableBitArray.readUnsignedExpGolombCodedInt();
            n3 = parsableBitArray.readUnsignedExpGolombCodedInt();
            n4 = n2 + n3;
            for (n5 = 0; n5 < n2; ++n5) {
                parsableBitArray.readUnsignedExpGolombCodedInt();
                parsableBitArray.skipBits(1);
            }
            for (n5 = 0; n5 < n3; ++n5) {
                parsableBitArray.readUnsignedExpGolombCodedInt();
                parsableBitArray.skipBits(1);
            }
        }
    }

    private static final class SampleReader {
        private static final int FIRST_SLICE_FLAG_OFFSET = 2;
        private final TrackOutput output;
        private long nalUnitStartPosition;
        private boolean nalUnitHasKeyframeData;
        private int nalUnitBytesRead;
        private long nalUnitTimeUs;
        private boolean lookingForFirstSliceFlag;
        private boolean firstSliceFlag;
        private boolean readingSample;
        private long samplePosition;
        private long sampleTimeUs;
        private boolean sampleIsKeyframe;

        public SampleReader(TrackOutput trackOutput) {
            this.output = trackOutput;
        }

        public void reset() {
            this.lookingForFirstSliceFlag = false;
            this.firstSliceFlag = false;
            this.readingSample = false;
        }

        public void startNalUnit(long l, int n, int n2, long l2) {
            this.firstSliceFlag = false;
            this.nalUnitTimeUs = l2;
            this.nalUnitBytesRead = 0;
            this.nalUnitStartPosition = l;
            if (n2 >= 32 && this.readingSample) {
                this.outputSample(n);
                this.readingSample = false;
            }
            this.nalUnitHasKeyframeData = n2 >= 16 && n2 <= 21;
            this.lookingForFirstSliceFlag = this.nalUnitHasKeyframeData || n2 <= 9;
        }

        public void readNalUnitData(byte[] byArray, int n, int n2) {
            if (this.lookingForFirstSliceFlag) {
                int n3 = n + 2 - this.nalUnitBytesRead;
                if (n3 < n2) {
                    this.firstSliceFlag = (byArray[n3] & 0x80) != 0;
                    this.lookingForFirstSliceFlag = false;
                } else {
                    this.nalUnitBytesRead += n2 - n;
                }
            }
        }

        public void endNalUnit(long l, int n) {
            if (this.firstSliceFlag) {
                if (this.readingSample) {
                    int n2 = (int)(l - this.nalUnitStartPosition);
                    this.outputSample(n + n2);
                }
                this.samplePosition = this.nalUnitStartPosition;
                this.sampleTimeUs = this.nalUnitTimeUs;
                this.readingSample = true;
                this.sampleIsKeyframe = this.nalUnitHasKeyframeData;
            }
        }

        private void outputSample(int n) {
            int n2 = this.sampleIsKeyframe ? 1 : 0;
            int n3 = (int)(this.nalUnitStartPosition - this.samplePosition);
            this.output.sampleMetadata(this.sampleTimeUs, n2, n3, n, null);
        }
    }
}

