/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.ts;

import android.util.Pair;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer.util.NalUnitUtil;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.util.Arrays;
import java.util.Collections;

final class H262Reader
extends ElementaryStreamReader {
    private static final int START_PICTURE = 0;
    private static final int START_SEQUENCE_HEADER = 179;
    private static final int START_EXTENSION = 181;
    private static final int START_GROUP = 184;
    private static final double[] FRAME_RATE_VALUES = new double[]{23.976023976023978, 24.0, 25.0, 29.97002997002997, 30.0, 50.0, 59.94005994005994, 60.0};
    private boolean hasOutputFormat;
    private long frameDurationUs;
    private final boolean[] prefixFlags = new boolean[4];
    private final CsdBuffer csdBuffer = new CsdBuffer(128);
    private boolean foundFirstFrameInGroup;
    private long totalBytesWritten;
    private long pesTimeUs;
    private boolean pesPtsUsAvailable;
    private boolean isKeyframe;
    private long framePosition;
    private long frameTimeUs;

    public H262Reader(TrackOutput trackOutput) {
        super(trackOutput);
    }

    @Override
    public void seek() {
        NalUnitUtil.clearPrefixFlags(this.prefixFlags);
        this.csdBuffer.reset();
        this.pesPtsUsAvailable = false;
        this.foundFirstFrameInGroup = false;
        this.totalBytesWritten = 0L;
    }

    @Override
    public void packetStarted(long l, boolean bl) {
        boolean bl2 = this.pesPtsUsAvailable = l != -1L;
        if (this.pesPtsUsAvailable) {
            this.pesTimeUs = l;
        }
    }

    @Override
    public void consume(ParsableByteArray parsableByteArray) {
        if (parsableByteArray.bytesLeft() > 0) {
            int n = parsableByteArray.getPosition();
            int n2 = parsableByteArray.limit();
            byte[] byArray = parsableByteArray.data;
            this.totalBytesWritten += (long)parsableByteArray.bytesLeft();
            this.output.sampleData(parsableByteArray, parsableByteArray.bytesLeft());
            int n3 = n;
            while (true) {
                int n4;
                int n5;
                int n6;
                if ((n6 = NalUnitUtil.findNalUnit(byArray, n3, n2, this.prefixFlags)) == n2) {
                    if (!this.hasOutputFormat) {
                        this.csdBuffer.onData(byArray, n, n2);
                    }
                    return;
                }
                int n7 = parsableByteArray.data[n6 + 3] & 0xFF;
                if (!this.hasOutputFormat) {
                    n5 = n6 - n;
                    if (n5 > 0) {
                        this.csdBuffer.onData(byArray, n, n6);
                    }
                    int n8 = n4 = n5 < 0 ? -n5 : 0;
                    if (this.csdBuffer.onStartCode(n7, n4)) {
                        Pair<MediaFormat, Long> pair = H262Reader.parseCsdBuffer(this.csdBuffer);
                        this.output.format((MediaFormat)pair.first);
                        this.frameDurationUs = (Long)pair.second;
                        this.hasOutputFormat = true;
                    }
                }
                if (this.hasOutputFormat && (n7 == 184 || n7 == 0)) {
                    n5 = n2 - n6;
                    if (this.foundFirstFrameInGroup) {
                        n4 = this.isKeyframe ? 1 : 0;
                        int n9 = (int)(this.totalBytesWritten - this.framePosition) - n5;
                        this.output.sampleMetadata(this.frameTimeUs, n4, n9, n5, null);
                        this.isKeyframe = false;
                    }
                    if (n7 == 184) {
                        this.foundFirstFrameInGroup = false;
                        this.isKeyframe = true;
                    } else {
                        this.frameTimeUs = this.pesPtsUsAvailable ? this.pesTimeUs : this.frameTimeUs + this.frameDurationUs;
                        this.framePosition = this.totalBytesWritten - (long)n5;
                        this.pesPtsUsAvailable = false;
                        this.foundFirstFrameInGroup = true;
                    }
                }
                n = n6;
                n3 = n + 3;
            }
        }
    }

    @Override
    public void packetFinished() {
    }

    private static Pair<MediaFormat, Long> parseCsdBuffer(CsdBuffer csdBuffer) {
        byte[] byArray = Arrays.copyOf(csdBuffer.data, csdBuffer.length);
        int n = byArray[4] & 0xFF;
        int n2 = byArray[5] & 0xFF;
        int n3 = byArray[6] & 0xFF;
        int n4 = n << 4 | n2 >> 4;
        int n5 = (n2 & 0xF) << 8 | n3;
        float f = 1.0f;
        int n6 = (byArray[7] & 0xF0) >> 4;
        switch (n6) {
            case 2: {
                f = (float)(4 * n5) / (float)(3 * n4);
                break;
            }
            case 3: {
                f = (float)(16 * n5) / (float)(9 * n4);
                break;
            }
            case 4: {
                f = (float)(121 * n5) / (float)(100 * n4);
                break;
            }
        }
        MediaFormat mediaFormat = MediaFormat.createVideoFormat(null, "video/mpeg2", -1, -1, -1L, n4, n5, Collections.singletonList(byArray), -1, f);
        long l = 0L;
        int n7 = (byArray[7] & 0xF) - 1;
        if (0 <= n7 && n7 < FRAME_RATE_VALUES.length) {
            double d = FRAME_RATE_VALUES[n7];
            int n8 = csdBuffer.sequenceExtensionPosition;
            int n9 = (byArray[n8 + 9] & 0x60) >> 5;
            int n10 = byArray[n8 + 9] & 0x1F;
            if (n9 != n10) {
                d *= ((double)n9 + 1.0) / (double)(n10 + 1);
            }
            l = (long)(1000000.0 / d);
        }
        return Pair.create((Object)mediaFormat, (Object)l);
    }

    private static final class CsdBuffer {
        private boolean isFilling;
        public int length;
        public int sequenceExtensionPosition;
        public byte[] data;

        public CsdBuffer(int n) {
            this.data = new byte[n];
        }

        public void reset() {
            this.isFilling = false;
            this.length = 0;
            this.sequenceExtensionPosition = 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean onStartCode(int n, int n2) {
            if (!this.isFilling) {
                if (n != 179) return false;
                this.isFilling = true;
                return false;
            }
            if (this.sequenceExtensionPosition == 0 && n == 181) {
                this.sequenceExtensionPosition = this.length;
                return false;
            }
            this.length -= n2;
            this.isFilling = false;
            return true;
        }

        public void onData(byte[] byArray, int n, int n2) {
            if (!this.isFilling) {
                return;
            }
            int n3 = n2 - n;
            if (this.data.length < this.length + n3) {
                this.data = Arrays.copyOf(this.data, (this.length + n3) * 2);
            }
            System.arraycopy(byArray, n, this.data, this.length, n3);
            this.length += n3;
        }
    }
}

