/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.ts;

import android.util.Pair;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer.util.CodecSpecificDataUtil;
import com.google.android.exoplayer.util.ParsableBitArray;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.vcc.playerwrappersdk.a;
import java.util.Arrays;
import java.util.Collections;

final class AdtsReader
extends ElementaryStreamReader {
    private static final String TAG = "AdtsReader";
    private static final int STATE_FINDING_SAMPLE = 0;
    private static final int STATE_READING_ID3_HEADER = 1;
    private static final int STATE_READING_ADTS_HEADER = 2;
    private static final int STATE_READING_SAMPLE = 3;
    private static final int HEADER_SIZE = 5;
    private static final int CRC_SIZE = 2;
    private static final int MATCH_STATE_VALUE_SHIFT = 8;
    private static final int MATCH_STATE_START = 256;
    private static final int MATCH_STATE_FF = 512;
    private static final int MATCH_STATE_I = 768;
    private static final int MATCH_STATE_ID = 1024;
    private static final int ID3_HEADER_SIZE = 10;
    private static final int ID3_SIZE_OFFSET = 6;
    private static final byte[] ID3_IDENTIFIER = new byte[]{73, 68, 51};
    private final ParsableBitArray adtsScratch;
    private final ParsableByteArray id3HeaderBuffer;
    private final TrackOutput id3Output;
    private int state;
    private int bytesRead;
    private int matchState;
    private boolean hasCrc;
    private boolean hasOutputFormat;
    private long sampleDurationUs;
    private int sampleSize;
    private long timeUs;
    private TrackOutput currentOutput;
    private long currentSampleDuration;

    public AdtsReader(TrackOutput trackOutput, TrackOutput trackOutput2) {
        super(trackOutput);
        this.id3Output = trackOutput2;
        trackOutput2.format(MediaFormat.createId3Format());
        this.adtsScratch = new ParsableBitArray(new byte[7]);
        this.id3HeaderBuffer = new ParsableByteArray(Arrays.copyOf(ID3_IDENTIFIER, 10));
        this.setFindingSampleState();
    }

    @Override
    public void seek() {
        this.setFindingSampleState();
    }

    @Override
    public void packetStarted(long l, boolean bl) {
        this.timeUs = l;
    }

    @Override
    public void consume(ParsableByteArray parsableByteArray) {
        while (parsableByteArray.bytesLeft() > 0) {
            switch (this.state) {
                case 0: {
                    this.findNextSample(parsableByteArray);
                    break;
                }
                case 1: {
                    if (!this.continueRead(parsableByteArray, this.id3HeaderBuffer.data, 10)) break;
                    this.parseId3Header();
                    break;
                }
                case 2: {
                    int n;
                    int n2 = n = this.hasCrc ? 7 : 5;
                    if (!this.continueRead(parsableByteArray, this.adtsScratch.data, n)) break;
                    this.parseAdtsHeader();
                    break;
                }
                case 3: {
                    this.readSample(parsableByteArray);
                }
            }
        }
    }

    @Override
    public void packetFinished() {
    }

    private boolean continueRead(ParsableByteArray parsableByteArray, byte[] byArray, int n) {
        int n2 = Math.min(parsableByteArray.bytesLeft(), n - this.bytesRead);
        parsableByteArray.readBytes(byArray, this.bytesRead, n2);
        this.bytesRead += n2;
        return this.bytesRead == n;
    }

    private void setFindingSampleState() {
        this.state = 0;
        this.bytesRead = 0;
        this.matchState = 256;
    }

    private void setReadingId3HeaderState() {
        this.state = 1;
        this.bytesRead = ID3_IDENTIFIER.length;
        this.sampleSize = 0;
        this.id3HeaderBuffer.setPosition(0);
    }

    private void setReadingSampleState(TrackOutput trackOutput, long l, int n, int n2) {
        this.state = 3;
        this.bytesRead = n;
        this.currentOutput = trackOutput;
        this.currentSampleDuration = l;
        this.sampleSize = n2;
    }

    private void setReadingAdtsHeaderState() {
        this.state = 2;
        this.bytesRead = 0;
    }

    private void findNextSample(ParsableByteArray parsableByteArray) {
        byte[] byArray = parsableByteArray.data;
        int n = parsableByteArray.getPosition();
        int n2 = parsableByteArray.limit();
        block6: while (n < n2) {
            int n3 = byArray[n++] & 0xFF;
            if (this.matchState == 512 && n3 >= 240 && n3 != 255) {
                this.hasCrc = (n3 & 1) == 0;
                this.setReadingAdtsHeaderState();
                parsableByteArray.setPosition(n);
                return;
            }
            switch (this.matchState | n3) {
                case 511: {
                    this.matchState = 512;
                    continue block6;
                }
                case 329: {
                    this.matchState = 768;
                    continue block6;
                }
                case 836: {
                    this.matchState = 1024;
                    continue block6;
                }
                case 1075: {
                    this.setReadingId3HeaderState();
                    parsableByteArray.setPosition(n);
                    return;
                }
            }
            if (this.matchState == 256) continue;
            this.matchState = 256;
            --n;
        }
        parsableByteArray.setPosition(n);
    }

    private void parseId3Header() {
        this.id3Output.sampleData(this.id3HeaderBuffer, 10);
        this.id3HeaderBuffer.setPosition(6);
        this.setReadingSampleState(this.id3Output, 0L, 10, this.id3HeaderBuffer.readSynchSafeInt() + 10);
    }

    private void parseAdtsHeader() {
        int n;
        this.adtsScratch.setPosition(0);
        if (!this.hasOutputFormat) {
            n = this.adtsScratch.readBits(2) + 1;
            if (n == 1) {
                a.b(TAG, "Detected AAC Main audio, but assuming AAC LC.");
                n = 2;
            }
            int n2 = this.adtsScratch.readBits(4);
            this.adtsScratch.skipBits(1);
            int n3 = this.adtsScratch.readBits(3);
            byte[] byArray = CodecSpecificDataUtil.buildAacAudioSpecificConfig(n, n2, n3);
            Pair<Integer, Integer> pair = CodecSpecificDataUtil.parseAacAudioSpecificConfig(byArray);
            MediaFormat mediaFormat = MediaFormat.createAudioFormat(null, "audio/mp4a-latm", -1, -1, -1L, (Integer)pair.second, (Integer)pair.first, Collections.singletonList(byArray), null);
            this.sampleDurationUs = 1024000000L / (long)mediaFormat.sampleRate;
            this.output.format(mediaFormat);
            this.hasOutputFormat = true;
        } else {
            this.adtsScratch.skipBits(10);
        }
        this.adtsScratch.skipBits(4);
        n = this.adtsScratch.readBits(13) - 2 - 5;
        if (this.hasCrc) {
            n -= 2;
        }
        this.setReadingSampleState(this.output, this.sampleDurationUs, 0, n);
    }

    private void readSample(ParsableByteArray parsableByteArray) {
        int n = Math.min(parsableByteArray.bytesLeft(), this.sampleSize - this.bytesRead);
        this.currentOutput.sampleData(parsableByteArray, n);
        this.bytesRead += n;
        if (this.bytesRead == this.sampleSize) {
            this.currentOutput.sampleMetadata(this.timeUs, 1, this.sampleSize, 0, null);
            this.timeUs += this.currentSampleDuration;
            this.setFindingSampleState();
        }
    }
}

