/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.ogg;

import com.google.android.exoplayer.util.Assertions;

final class VorbisBitArray {
    public final byte[] data;
    private int limit;
    private int byteOffset;
    private int bitOffset;

    public VorbisBitArray(byte[] byArray) {
        this(byArray, byArray.length);
    }

    public VorbisBitArray(byte[] byArray, int n) {
        this.data = byArray;
        this.limit = n * 8;
    }

    public void reset() {
        this.byteOffset = 0;
        this.bitOffset = 0;
    }

    public boolean readBit() {
        return this.readBits(1) == 1;
    }

    public int readBits(int n) {
        int n2;
        int n3;
        Assertions.checkState(this.getPosition() + n <= this.limit);
        if (n == 0) {
            return 0;
        }
        int n4 = 0;
        int n5 = 0;
        if (this.bitOffset != 0) {
            n5 = Math.min(n, 8 - this.bitOffset);
            n3 = 255 >>> 8 - n5;
            n4 = this.data[this.byteOffset] >>> this.bitOffset & n3;
            this.bitOffset += n5;
            if (this.bitOffset == 8) {
                ++this.byteOffset;
                this.bitOffset = 0;
            }
        }
        if (n - n5 > 7) {
            n3 = (n - n5) / 8;
            for (n2 = 0; n2 < n3; ++n2) {
                n4 = (int)((long)n4 | ((long)this.data[this.byteOffset++] & 0xFFL) << n5);
                n5 += 8;
            }
        }
        if (n > n5) {
            n3 = n - n5;
            n2 = 255 >>> 8 - n3;
            n4 |= (this.data[this.byteOffset] & n2) << n5;
            this.bitOffset += n3;
        }
        return n4;
    }

    public void skipBits(int n) {
        Assertions.checkState(this.getPosition() + n <= this.limit);
        this.byteOffset += n / 8;
        this.bitOffset += n % 8;
        if (this.bitOffset > 7) {
            ++this.byteOffset;
            this.bitOffset -= 8;
        }
    }

    public int getPosition() {
        return this.byteOffset * 8 + this.bitOffset;
    }

    public void setPosition(int n) {
        Assertions.checkArgument(n < this.limit && n >= 0);
        this.byteOffset = n / 8;
        this.bitOffset = n - this.byteOffset * 8;
    }

    public int bitsLeft() {
        return this.limit - this.getPosition();
    }

    public int limit() {
        return this.limit;
    }
}

