/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.ogg;

import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.ogg.OggUtil;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.io.IOException;

final class OggSeeker {
    private static final int MATCH_RANGE = 72000;
    private final OggUtil.PageHeader pageHeader = new OggUtil.PageHeader();
    private final ParsableByteArray headerArray = new ParsableByteArray(282);
    private long audioDataLength = -1L;
    private long totalSamples;

    OggSeeker() {
    }

    public void setup(long l, long l2) {
        Assertions.checkArgument(l > 0L && l2 > 0L);
        this.audioDataLength = l;
        this.totalSamples = l2;
    }

    public void reset() {
        this.pageHeader.reset();
        this.headerArray.reset();
    }

    public long getNextSeekPosition(long l, ExtractorInput extractorInput) throws IOException, InterruptedException {
        Assertions.checkState(this.audioDataLength != -1L && this.totalSamples != 0L);
        OggUtil.populatePageHeader(extractorInput, this.pageHeader, this.headerArray, false);
        long l2 = l - this.pageHeader.granulePosition;
        if (l2 <= 0L || l2 > 72000L) {
            long l3 = (this.pageHeader.bodySize + this.pageHeader.headerSize) * (l2 <= 0L ? 2 : 1);
            return extractorInput.getPosition() - l3 + l2 * this.audioDataLength / this.totalSamples;
        }
        extractorInput.resetPeekPosition();
        return -1L;
    }
}

