/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.mp4;

import android.util.Pair;
import android.util.SparseArray;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.drm.DrmInitData;
import com.google.android.exoplayer.extractor.ChunkIndex;
import com.google.android.exoplayer.extractor.Extractor;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.ExtractorOutput;
import com.google.android.exoplayer.extractor.PositionHolder;
import com.google.android.exoplayer.extractor.SeekMap;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.extractor.mp4.Atom;
import com.google.android.exoplayer.extractor.mp4.AtomParsers;
import com.google.android.exoplayer.extractor.mp4.DefaultSampleValues;
import com.google.android.exoplayer.extractor.mp4.PsshAtomUtil;
import com.google.android.exoplayer.extractor.mp4.Sniffer;
import com.google.android.exoplayer.extractor.mp4.Track;
import com.google.android.exoplayer.extractor.mp4.TrackEncryptionBox;
import com.google.android.exoplayer.extractor.mp4.TrackFragment;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.NalUnitUtil;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.google.android.exoplayer.util.Util;
import com.vcc.playerwrappersdk.a;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.UUID;

public final class FragmentedMp4Extractor
implements Extractor {
    private static final String TAG = "FragmentedMp4Extractor";
    public static final int FLAG_WORKAROUND_EVERY_VIDEO_FRAME_IS_SYNC_FRAME = 1;
    public static final int FLAG_WORKAROUND_IGNORE_TFDT_BOX = 2;
    private static final int FLAG_SIDELOADED = 4;
    private static final byte[] PIFF_SAMPLE_ENCRYPTION_BOX_EXTENDED_TYPE = new byte[]{-94, 57, 79, 82, 90, -101, 79, 20, -94, 68, 108, 66, 124, 100, -115, -12};
    private static final int STATE_READING_ATOM_HEADER = 0;
    private static final int STATE_READING_ATOM_PAYLOAD = 1;
    private static final int STATE_READING_ENCRYPTION_DATA = 2;
    private static final int STATE_READING_SAMPLE_START = 3;
    private static final int STATE_READING_SAMPLE_CONTINUE = 4;
    private final int flags;
    private final Track sideloadedTrack;
    private final SparseArray<TrackBundle> trackBundles;
    private final ParsableByteArray nalStartCode;
    private final ParsableByteArray nalLength;
    private final ParsableByteArray encryptionSignalByte;
    private final ParsableByteArray atomHeader;
    private final byte[] extendedTypeScratch;
    private final Stack<Atom.ContainerAtom> containerAtoms;
    private int parserState;
    private int atomType;
    private long atomSize;
    private int atomHeaderBytesRead;
    private ParsableByteArray atomData;
    private long endOfMdatPosition;
    private TrackBundle currentTrackBundle;
    private int sampleSize;
    private int sampleBytesWritten;
    private int sampleCurrentNalBytesRemaining;
    private ExtractorOutput extractorOutput;
    private boolean haveOutputSeekMap;

    public FragmentedMp4Extractor() {
        this(0);
    }

    public FragmentedMp4Extractor(int n) {
        this(n, null);
    }

    public FragmentedMp4Extractor(int n, Track track) {
        this.sideloadedTrack = track;
        this.flags = n | (track != null ? 4 : 0);
        this.atomHeader = new ParsableByteArray(16);
        this.nalStartCode = new ParsableByteArray(NalUnitUtil.NAL_START_CODE);
        this.nalLength = new ParsableByteArray(4);
        this.encryptionSignalByte = new ParsableByteArray(1);
        this.extendedTypeScratch = new byte[16];
        this.containerAtoms = new Stack();
        this.trackBundles = new SparseArray();
        this.enterReadingAtomHeaderState();
    }

    @Override
    public boolean sniff(ExtractorInput extractorInput) throws IOException, InterruptedException {
        return Sniffer.sniffFragmented(extractorInput);
    }

    @Override
    public void init(ExtractorOutput extractorOutput) {
        this.extractorOutput = extractorOutput;
        if (this.sideloadedTrack != null) {
            TrackBundle trackBundle = new TrackBundle(extractorOutput.track(0));
            trackBundle.init(this.sideloadedTrack, new DefaultSampleValues(0, 0, 0, 0));
            this.trackBundles.put(0, (Object)trackBundle);
            this.extractorOutput.endTracks();
        }
    }

    @Override
    public void seek() {
        this.containerAtoms.clear();
        this.enterReadingAtomHeaderState();
    }

    @Override
    public void release() {
    }

    @Override
    public int read(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException, InterruptedException {
        block5: while (true) {
            switch (this.parserState) {
                case 0: {
                    if (this.readAtomHeader(extractorInput)) continue block5;
                    return -1;
                }
                case 1: {
                    this.readAtomPayload(extractorInput);
                    continue block5;
                }
                case 2: {
                    this.readEncryptionData(extractorInput);
                    continue block5;
                }
            }
            if (this.readSample(extractorInput)) break;
        }
        return 0;
    }

    private void enterReadingAtomHeaderState() {
        this.parserState = 0;
        this.atomHeaderBytesRead = 0;
    }

    private boolean readAtomHeader(ExtractorInput extractorInput) throws IOException, InterruptedException {
        if (this.atomHeaderBytesRead == 0) {
            if (!extractorInput.readFully(this.atomHeader.data, 0, 8, true)) {
                return false;
            }
            this.atomHeaderBytesRead = 8;
            this.atomHeader.setPosition(0);
            this.atomSize = this.atomHeader.readUnsignedInt();
            this.atomType = this.atomHeader.readInt();
        }
        if (this.atomSize == 1L) {
            int n = 8;
            extractorInput.readFully(this.atomHeader.data, 8, n);
            this.atomHeaderBytesRead += n;
            this.atomSize = this.atomHeader.readUnsignedLongToLong();
        }
        long l = extractorInput.getPosition() - (long)this.atomHeaderBytesRead;
        if (this.atomType == Atom.TYPE_moof) {
            int n = this.trackBundles.size();
            for (int i = 0; i < n; ++i) {
                TrackFragment trackFragment = ((TrackBundle)this.trackBundles.valueAt((int)i)).fragment;
                trackFragment.auxiliaryDataPosition = l;
                trackFragment.dataPosition = l;
            }
        }
        if (this.atomType == Atom.TYPE_mdat) {
            this.currentTrackBundle = null;
            this.endOfMdatPosition = l + this.atomSize;
            if (!this.haveOutputSeekMap) {
                this.extractorOutput.seekMap(SeekMap.UNSEEKABLE);
                this.haveOutputSeekMap = true;
            }
            this.parserState = 2;
            return true;
        }
        if (FragmentedMp4Extractor.shouldParseContainerAtom(this.atomType)) {
            long l2 = extractorInput.getPosition() + this.atomSize - 8L;
            this.containerAtoms.add(new Atom.ContainerAtom(this.atomType, l2));
            if (this.atomSize == (long)this.atomHeaderBytesRead) {
                this.processAtomEnded(l2);
            } else {
                this.enterReadingAtomHeaderState();
            }
        } else if (FragmentedMp4Extractor.shouldParseLeafAtom(this.atomType)) {
            if (this.atomHeaderBytesRead != 8) {
                throw new ParserException("Leaf atom defines extended atom size (unsupported).");
            }
            if (this.atomSize > Integer.MAX_VALUE) {
                throw new ParserException("Leaf atom with length > 2147483647 (unsupported).");
            }
            this.atomData = new ParsableByteArray((int)this.atomSize);
            System.arraycopy(this.atomHeader.data, 0, this.atomData.data, 0, 8);
            this.parserState = 1;
        } else {
            if (this.atomSize > Integer.MAX_VALUE) {
                throw new ParserException("Skipping atom with length > 2147483647 (unsupported).");
            }
            this.atomData = null;
            this.parserState = 1;
        }
        return true;
    }

    private void readAtomPayload(ExtractorInput extractorInput) throws IOException, InterruptedException {
        int n = (int)this.atomSize - this.atomHeaderBytesRead;
        if (this.atomData != null) {
            extractorInput.readFully(this.atomData.data, 8, n);
            this.onLeafAtomRead(new Atom.LeafAtom(this.atomType, this.atomData), extractorInput.getPosition());
        } else {
            extractorInput.skipFully(n);
        }
        this.processAtomEnded(extractorInput.getPosition());
    }

    private void processAtomEnded(long l) throws ParserException {
        while (!this.containerAtoms.isEmpty() && this.containerAtoms.peek().endPosition == l) {
            this.onContainerAtomRead(this.containerAtoms.pop());
        }
        this.enterReadingAtomHeaderState();
    }

    private void onLeafAtomRead(Atom.LeafAtom leafAtom, long l) throws ParserException {
        if (!this.containerAtoms.isEmpty()) {
            this.containerAtoms.peek().add(leafAtom);
        } else if (leafAtom.type == Atom.TYPE_sidx) {
            ChunkIndex chunkIndex = FragmentedMp4Extractor.parseSidx(leafAtom.data, l);
            this.extractorOutput.seekMap(chunkIndex);
            this.haveOutputSeekMap = true;
        }
    }

    private void onContainerAtomRead(Atom.ContainerAtom containerAtom) throws ParserException {
        if (containerAtom.type == Atom.TYPE_moov) {
            this.onMoovContainerAtomRead(containerAtom);
        } else if (containerAtom.type == Atom.TYPE_moof) {
            this.onMoofContainerAtomRead(containerAtom);
        } else if (!this.containerAtoms.isEmpty()) {
            this.containerAtoms.peek().add(containerAtom);
        }
    }

    private void onMoovContainerAtomRead(Atom.ContainerAtom containerAtom) {
        Track track;
        int n;
        Atom.LeafAtom leafAtom;
        Assertions.checkState(this.sideloadedTrack == null, "Unexpected moov box.");
        List<Atom.LeafAtom> list = containerAtom.leafChildren;
        int n2 = list.size();
        DrmInitData.Mapped mapped = null;
        for (int i = 0; i < n2; ++i) {
            byte[] byArray;
            UUID uUID;
            leafAtom = list.get(i);
            if (leafAtom.type != Atom.TYPE_pssh) continue;
            if (mapped == null) {
                mapped = new DrmInitData.Mapped();
            }
            if ((uUID = PsshAtomUtil.parseUuid(byArray = leafAtom.data.data)) == null) {
                a.b(TAG, "Skipped pssh atom (failed to extract uuid)");
                continue;
            }
            mapped.put(PsshAtomUtil.parseUuid(byArray), new DrmInitData.SchemeInitData("video/mp4", byArray));
        }
        if (mapped != null) {
            this.extractorOutput.drmInitData(mapped);
        }
        Atom.ContainerAtom containerAtom2 = containerAtom.getContainerAtomOfType(Atom.TYPE_mvex);
        leafAtom = new SparseArray();
        int n3 = containerAtom2.leafChildren.size();
        for (int i = 0; i < n3; ++i) {
            Atom.LeafAtom leafAtom2 = containerAtom2.leafChildren.get(i);
            if (leafAtom2.type != Atom.TYPE_trex) continue;
            Pair<Integer, DefaultSampleValues> pair = FragmentedMp4Extractor.parseTrex(leafAtom2.data);
            leafAtom.put((Integer)pair.first, pair.second);
        }
        SparseArray sparseArray = new SparseArray();
        int n4 = containerAtom.containerChildren.size();
        for (n = 0; n < n4; ++n) {
            Atom.ContainerAtom containerAtom3 = containerAtom.containerChildren.get(n);
            if (containerAtom3.type != Atom.TYPE_trak || (track = AtomParsers.parseTrak(containerAtom3, containerAtom.getLeafAtomOfType(Atom.TYPE_mvhd), false)) == null) continue;
            sparseArray.put(track.id, (Object)track);
        }
        n = sparseArray.size();
        if (this.trackBundles.size() == 0) {
            for (int i = 0; i < n; ++i) {
                this.trackBundles.put(((Track)sparseArray.valueAt((int)i)).id, (Object)new TrackBundle(this.extractorOutput.track(i)));
            }
            this.extractorOutput.endTracks();
        } else {
            Assertions.checkState(this.trackBundles.size() == n);
        }
        for (int i = 0; i < n; ++i) {
            track = (Track)sparseArray.valueAt(i);
            ((TrackBundle)this.trackBundles.get(track.id)).init(track, (DefaultSampleValues)leafAtom.get(track.id));
        }
    }

    private void onMoofContainerAtomRead(Atom.ContainerAtom containerAtom) throws ParserException {
        FragmentedMp4Extractor.parseMoof(containerAtom, this.trackBundles, this.flags, this.extendedTypeScratch);
    }

    private static Pair<Integer, DefaultSampleValues> parseTrex(ParsableByteArray parsableByteArray) {
        parsableByteArray.setPosition(12);
        int n = parsableByteArray.readInt();
        int n2 = parsableByteArray.readUnsignedIntToInt() - 1;
        int n3 = parsableByteArray.readUnsignedIntToInt();
        int n4 = parsableByteArray.readUnsignedIntToInt();
        int n5 = parsableByteArray.readInt();
        return Pair.create((Object)n, (Object)new DefaultSampleValues(n2, n3, n4, n5));
    }

    private static void parseMoof(Atom.ContainerAtom containerAtom, SparseArray<TrackBundle> sparseArray, int n, byte[] byArray) throws ParserException {
        int n2 = containerAtom.containerChildren.size();
        for (int i = 0; i < n2; ++i) {
            Atom.ContainerAtom containerAtom2 = containerAtom.containerChildren.get(i);
            if (containerAtom2.type != Atom.TYPE_traf) continue;
            FragmentedMp4Extractor.parseTraf(containerAtom2, sparseArray, n, byArray);
        }
    }

    private static void parseTraf(Atom.ContainerAtom containerAtom, SparseArray<TrackBundle> sparseArray, int n, byte[] byArray) throws ParserException {
        Atom.LeafAtom leafAtom;
        Object object;
        if (containerAtom.getChildAtomOfTypeCount(Atom.TYPE_trun) != 1) {
            throw new ParserException("Trun count in traf != 1 (unsupported).");
        }
        Atom.LeafAtom leafAtom2 = containerAtom.getLeafAtomOfType(Atom.TYPE_tfhd);
        TrackBundle trackBundle = FragmentedMp4Extractor.parseTfhd(leafAtom2.data, sparseArray, n);
        if (trackBundle == null) {
            return;
        }
        TrackFragment trackFragment = trackBundle.fragment;
        trackBundle.currentSampleIndex = 0;
        trackFragment.reset();
        Atom.LeafAtom leafAtom3 = containerAtom.getLeafAtomOfType(Atom.TYPE_tfdt);
        long l = leafAtom3 == null || (n & 2) != 0 ? 0L : FragmentedMp4Extractor.parseTfdt(containerAtom.getLeafAtomOfType((int)Atom.TYPE_tfdt).data);
        Atom.LeafAtom leafAtom4 = containerAtom.getLeafAtomOfType(Atom.TYPE_trun);
        FragmentedMp4Extractor.parseTrun(trackBundle, l, n, leafAtom4.data);
        Atom.LeafAtom leafAtom5 = containerAtom.getLeafAtomOfType(Atom.TYPE_saiz);
        if (leafAtom5 != null) {
            object = trackBundle.track.sampleDescriptionEncryptionBoxes[trackFragment.header.sampleDescriptionIndex];
            FragmentedMp4Extractor.parseSaiz((TrackEncryptionBox)object, leafAtom5.data, trackFragment);
        }
        if ((object = containerAtom.getLeafAtomOfType(Atom.TYPE_saio)) != null) {
            FragmentedMp4Extractor.parseSaio(((Atom.LeafAtom)object).data, trackFragment);
        }
        if ((leafAtom = containerAtom.getLeafAtomOfType(Atom.TYPE_senc)) != null) {
            FragmentedMp4Extractor.parseSenc(leafAtom.data, trackFragment);
        }
        int n2 = containerAtom.leafChildren.size();
        for (int i = 0; i < n2; ++i) {
            Atom.LeafAtom leafAtom6 = containerAtom.leafChildren.get(i);
            if (leafAtom6.type != Atom.TYPE_uuid) continue;
            FragmentedMp4Extractor.parseUuid(leafAtom6.data, trackFragment, byArray);
        }
    }

    private static void parseSaiz(TrackEncryptionBox trackEncryptionBox, ParsableByteArray parsableByteArray, TrackFragment trackFragment) throws ParserException {
        int n = trackEncryptionBox.initializationVectorSize;
        parsableByteArray.setPosition(8);
        int n2 = parsableByteArray.readInt();
        int n3 = Atom.parseFullAtomFlags(n2);
        if ((n3 & 1) == 1) {
            parsableByteArray.skipBytes(8);
        }
        int n4 = parsableByteArray.readUnsignedByte();
        int n5 = parsableByteArray.readUnsignedIntToInt();
        if (n5 != trackFragment.length) {
            throw new ParserException("Length mismatch: " + n5 + ", " + trackFragment.length);
        }
        int n6 = 0;
        if (n4 == 0) {
            boolean[] blArray = trackFragment.sampleHasSubsampleEncryptionTable;
            for (int i = 0; i < n5; ++i) {
                int n7 = parsableByteArray.readUnsignedByte();
                n6 += n7;
                blArray[i] = n7 > n;
            }
        } else {
            boolean bl = n4 > n;
            n6 += n4 * n5;
            Arrays.fill(trackFragment.sampleHasSubsampleEncryptionTable, 0, n5, bl);
        }
        trackFragment.initEncryptionData(n6);
    }

    private static void parseSaio(ParsableByteArray parsableByteArray, TrackFragment trackFragment) throws ParserException {
        int n;
        parsableByteArray.setPosition(8);
        int n2 = parsableByteArray.readInt();
        int n3 = Atom.parseFullAtomFlags(n2);
        if ((n3 & 1) == 1) {
            parsableByteArray.skipBytes(8);
        }
        if ((n = parsableByteArray.readUnsignedIntToInt()) != 1) {
            throw new ParserException("Unexpected saio entry count: " + n);
        }
        int n4 = Atom.parseFullAtomVersion(n2);
        trackFragment.auxiliaryDataPosition = trackFragment.auxiliaryDataPosition + (n4 == 0 ? parsableByteArray.readUnsignedInt() : parsableByteArray.readUnsignedLongToLong());
    }

    private static TrackBundle parseTfhd(ParsableByteArray parsableByteArray, SparseArray<TrackBundle> sparseArray, int n) {
        parsableByteArray.setPosition(8);
        int n2 = parsableByteArray.readInt();
        int n3 = Atom.parseFullAtomFlags(n2);
        int n4 = parsableByteArray.readInt();
        TrackBundle trackBundle = (TrackBundle)sparseArray.get((n & 4) == 0 ? n4 : 0);
        if (trackBundle == null) {
            return null;
        }
        if ((n3 & 1) != 0) {
            long l;
            trackBundle.fragment.dataPosition = l = parsableByteArray.readUnsignedLongToLong();
            trackBundle.fragment.auxiliaryDataPosition = l;
        }
        DefaultSampleValues defaultSampleValues = trackBundle.defaultSampleValues;
        int n5 = (n3 & 2) != 0 ? parsableByteArray.readUnsignedIntToInt() - 1 : defaultSampleValues.sampleDescriptionIndex;
        int n6 = (n3 & 8) != 0 ? parsableByteArray.readUnsignedIntToInt() : defaultSampleValues.duration;
        int n7 = (n3 & 0x10) != 0 ? parsableByteArray.readUnsignedIntToInt() : defaultSampleValues.size;
        int n8 = (n3 & 0x20) != 0 ? parsableByteArray.readUnsignedIntToInt() : defaultSampleValues.flags;
        trackBundle.fragment.header = new DefaultSampleValues(n5, n6, n7, n8);
        return trackBundle;
    }

    private static long parseTfdt(ParsableByteArray parsableByteArray) {
        parsableByteArray.setPosition(8);
        int n = parsableByteArray.readInt();
        int n2 = Atom.parseFullAtomVersion(n);
        return n2 == 1 ? parsableByteArray.readUnsignedLongToLong() : parsableByteArray.readUnsignedInt();
    }

    private static void parseTrun(TrackBundle trackBundle, long l, int n, ParsableByteArray parsableByteArray) {
        parsableByteArray.setPosition(8);
        int n2 = parsableByteArray.readInt();
        int n3 = Atom.parseFullAtomFlags(n2);
        Track track = trackBundle.track;
        TrackFragment trackFragment = trackBundle.fragment;
        DefaultSampleValues defaultSampleValues = trackFragment.header;
        int n4 = parsableByteArray.readUnsignedIntToInt();
        if ((n3 & 1) != 0) {
            trackFragment.dataPosition += (long)parsableByteArray.readInt();
        }
        boolean bl = (n3 & 4) != 0;
        int n5 = defaultSampleValues.flags;
        if (bl) {
            n5 = parsableByteArray.readUnsignedIntToInt();
        }
        boolean bl2 = (n3 & 0x100) != 0;
        boolean bl3 = (n3 & 0x200) != 0;
        boolean bl4 = (n3 & 0x400) != 0;
        boolean bl5 = (n3 & 0x800) != 0;
        long l2 = 0L;
        if (track.editListDurations != null && track.editListDurations.length == 1 && track.editListDurations[0] == 0L) {
            l2 = Util.scaleLargeTimestamp(track.editListMediaTimes[0], 1000L, track.timescale);
        }
        trackFragment.initTables(n4);
        int[] nArray = trackFragment.sampleSizeTable;
        int[] nArray2 = trackFragment.sampleCompositionTimeOffsetTable;
        long[] lArray = trackFragment.sampleDecodingTimeTable;
        boolean[] blArray = trackFragment.sampleIsSyncFrameTable;
        long l3 = track.timescale;
        long l4 = l;
        boolean bl6 = track.type == Track.TYPE_vide && (n & 1) != 0;
        for (int i = 0; i < n4; ++i) {
            int n6;
            int n7;
            int n8 = bl2 ? parsableByteArray.readUnsignedIntToInt() : defaultSampleValues.duration;
            int n9 = n7 = bl3 ? parsableByteArray.readUnsignedIntToInt() : defaultSampleValues.size;
            int n10 = i == 0 && bl ? n5 : (n6 = bl4 ? parsableByteArray.readInt() : defaultSampleValues.flags);
            if (bl5) {
                int n11 = parsableByteArray.readInt();
                nArray2[i] = (int)((long)(n11 * 1000) / l3);
            } else {
                nArray2[i] = 0;
            }
            lArray[i] = Util.scaleLargeTimestamp(l4, 1000L, l3) - l2;
            nArray[i] = n7;
            blArray[i] = (n6 >> 16 & 1) == 0 && (!bl6 || i == 0);
            l4 += (long)n8;
        }
    }

    private static void parseUuid(ParsableByteArray parsableByteArray, TrackFragment trackFragment, byte[] byArray) throws ParserException {
        parsableByteArray.setPosition(8);
        parsableByteArray.readBytes(byArray, 0, 16);
        if (!Arrays.equals(byArray, PIFF_SAMPLE_ENCRYPTION_BOX_EXTENDED_TYPE)) {
            return;
        }
        FragmentedMp4Extractor.parseSenc(parsableByteArray, 16, trackFragment);
    }

    private static void parseSenc(ParsableByteArray parsableByteArray, TrackFragment trackFragment) throws ParserException {
        FragmentedMp4Extractor.parseSenc(parsableByteArray, 0, trackFragment);
    }

    private static void parseSenc(ParsableByteArray parsableByteArray, int n, TrackFragment trackFragment) throws ParserException {
        parsableByteArray.setPosition(8 + n);
        int n2 = parsableByteArray.readInt();
        int n3 = Atom.parseFullAtomFlags(n2);
        if ((n3 & 1) != 0) {
            throw new ParserException("Overriding TrackEncryptionBox parameters is unsupported.");
        }
        boolean bl = (n3 & 2) != 0;
        int n4 = parsableByteArray.readUnsignedIntToInt();
        if (n4 != trackFragment.length) {
            throw new ParserException("Length mismatch: " + n4 + ", " + trackFragment.length);
        }
        Arrays.fill(trackFragment.sampleHasSubsampleEncryptionTable, 0, n4, bl);
        trackFragment.initEncryptionData(parsableByteArray.bytesLeft());
        trackFragment.fillEncryptionData(parsableByteArray);
    }

    private static ChunkIndex parseSidx(ParsableByteArray parsableByteArray, long l) throws ParserException {
        long l2;
        parsableByteArray.setPosition(8);
        int n = parsableByteArray.readInt();
        int n2 = Atom.parseFullAtomVersion(n);
        parsableByteArray.skipBytes(4);
        long l3 = parsableByteArray.readUnsignedInt();
        long l4 = l;
        if (n2 == 0) {
            l2 = parsableByteArray.readUnsignedInt();
            l4 += parsableByteArray.readUnsignedInt();
        } else {
            l2 = parsableByteArray.readUnsignedLongToLong();
            l4 += parsableByteArray.readUnsignedLongToLong();
        }
        parsableByteArray.skipBytes(2);
        int n3 = parsableByteArray.readUnsignedShort();
        int[] nArray = new int[n3];
        long[] lArray = new long[n3];
        long[] lArray2 = new long[n3];
        long[] lArray3 = new long[n3];
        long l5 = l2;
        long l6 = Util.scaleLargeTimestamp(l5, 1000000L, l3);
        for (int i = 0; i < n3; ++i) {
            int n4 = parsableByteArray.readInt();
            int n5 = Integer.MIN_VALUE & n4;
            if (n5 != 0) {
                throw new ParserException("Unhandled indirect reference");
            }
            long l7 = parsableByteArray.readUnsignedInt();
            nArray[i] = Integer.MAX_VALUE & n4;
            lArray[i] = l4;
            lArray3[i] = l6;
            l6 = Util.scaleLargeTimestamp(l5 += l7, 1000000L, l3);
            lArray2[i] = l6 - lArray3[i];
            parsableByteArray.skipBytes(4);
            l4 += (long)nArray[i];
        }
        return new ChunkIndex(nArray, lArray, lArray2, lArray3);
    }

    private void readEncryptionData(ExtractorInput extractorInput) throws IOException, InterruptedException {
        int n;
        TrackBundle trackBundle = null;
        long l = Long.MAX_VALUE;
        int n2 = this.trackBundles.size();
        for (n = 0; n < n2; ++n) {
            TrackFragment trackFragment = ((TrackBundle)this.trackBundles.valueAt((int)n)).fragment;
            if (!trackFragment.sampleEncryptionDataNeedsFill || trackFragment.auxiliaryDataPosition >= l) continue;
            l = trackFragment.auxiliaryDataPosition;
            trackBundle = (TrackBundle)this.trackBundles.valueAt(n);
        }
        if (trackBundle == null) {
            this.parserState = 3;
            return;
        }
        n = (int)(l - extractorInput.getPosition());
        if (n < 0) {
            throw new ParserException("Offset to encryption data was negative.");
        }
        extractorInput.skipFully(n);
        trackBundle.fragment.fillEncryptionData(extractorInput);
    }

    private boolean readSample(ExtractorInput extractorInput) throws IOException, InterruptedException {
        int n;
        int n2;
        if (this.parserState == 3) {
            if (this.currentTrackBundle == null) {
                this.currentTrackBundle = FragmentedMp4Extractor.getNextFragmentRun(this.trackBundles);
                if (this.currentTrackBundle == null) {
                    int n3 = (int)(this.endOfMdatPosition - extractorInput.getPosition());
                    if (n3 < 0) {
                        throw new ParserException("Offset to end of mdat was negative.");
                    }
                    extractorInput.skipFully(n3);
                    this.enterReadingAtomHeaderState();
                    return false;
                }
                long l = this.currentTrackBundle.fragment.dataPosition;
                int n4 = (int)(l - extractorInput.getPosition());
                if (n4 < 0) {
                    throw new ParserException("Offset to sample data was negative.");
                }
                extractorInput.skipFully(n4);
            }
            this.sampleSize = this.currentTrackBundle.fragment.sampleSizeTable[this.currentTrackBundle.currentSampleIndex];
            if (this.currentTrackBundle.fragment.definesEncryptionData) {
                this.sampleBytesWritten = this.appendSampleEncryptionData(this.currentTrackBundle);
                this.sampleSize += this.sampleBytesWritten;
            } else {
                this.sampleBytesWritten = 0;
            }
            this.parserState = 4;
            this.sampleCurrentNalBytesRemaining = 0;
        }
        TrackFragment trackFragment = this.currentTrackBundle.fragment;
        Track track = this.currentTrackBundle.track;
        TrackOutput trackOutput = this.currentTrackBundle.output;
        int n5 = this.currentTrackBundle.currentSampleIndex;
        if (track.nalUnitLengthFieldLength != -1) {
            byte[] byArray = this.nalLength.data;
            byArray[0] = 0;
            byArray[1] = 0;
            byArray[2] = 0;
            int n6 = track.nalUnitLengthFieldLength;
            n2 = 4 - track.nalUnitLengthFieldLength;
            while (this.sampleBytesWritten < this.sampleSize) {
                if (this.sampleCurrentNalBytesRemaining == 0) {
                    extractorInput.readFully(this.nalLength.data, n2, n6);
                    this.nalLength.setPosition(0);
                    this.sampleCurrentNalBytesRemaining = this.nalLength.readUnsignedIntToInt();
                    this.nalStartCode.setPosition(0);
                    trackOutput.sampleData(this.nalStartCode, 4);
                    this.sampleBytesWritten += 4;
                    this.sampleSize += n2;
                    continue;
                }
                n = trackOutput.sampleData(extractorInput, this.sampleCurrentNalBytesRemaining, false);
                this.sampleBytesWritten += n;
                this.sampleCurrentNalBytesRemaining -= n;
            }
        } else {
            while (this.sampleBytesWritten < this.sampleSize) {
                int n7 = trackOutput.sampleData(extractorInput, this.sampleSize - this.sampleBytesWritten, false);
                this.sampleBytesWritten += n7;
            }
        }
        long l = trackFragment.getSamplePresentationTime(n5) * 1000L;
        n2 = (trackFragment.definesEncryptionData ? 2 : 0) | (trackFragment.sampleIsSyncFrameTable[n5] ? 1 : 0);
        n = trackFragment.header.sampleDescriptionIndex;
        byte[] byArray = trackFragment.definesEncryptionData ? track.sampleDescriptionEncryptionBoxes[n].keyId : null;
        trackOutput.sampleMetadata(l, n2, this.sampleSize, 0, byArray);
        ++this.currentTrackBundle.currentSampleIndex;
        if (this.currentTrackBundle.currentSampleIndex == trackFragment.length) {
            this.currentTrackBundle = null;
        }
        this.parserState = 3;
        return true;
    }

    private static TrackBundle getNextFragmentRun(SparseArray<TrackBundle> sparseArray) {
        TrackBundle trackBundle = null;
        long l = Long.MAX_VALUE;
        int n = sparseArray.size();
        for (int i = 0; i < n; ++i) {
            long l2;
            TrackBundle trackBundle2 = (TrackBundle)sparseArray.valueAt(i);
            if (trackBundle2.currentSampleIndex == trackBundle2.fragment.length || (l2 = trackBundle2.fragment.dataPosition) >= l) continue;
            trackBundle = trackBundle2;
            l = l2;
        }
        return trackBundle;
    }

    private int appendSampleEncryptionData(TrackBundle trackBundle) {
        TrackFragment trackFragment = trackBundle.fragment;
        ParsableByteArray parsableByteArray = trackFragment.sampleEncryptionData;
        int n = trackFragment.header.sampleDescriptionIndex;
        TrackEncryptionBox trackEncryptionBox = trackBundle.track.sampleDescriptionEncryptionBoxes[n];
        int n2 = trackEncryptionBox.initializationVectorSize;
        boolean bl = trackFragment.sampleHasSubsampleEncryptionTable[trackBundle.currentSampleIndex];
        this.encryptionSignalByte.data[0] = (byte)(n2 | (bl ? 128 : 0));
        this.encryptionSignalByte.setPosition(0);
        TrackOutput trackOutput = trackBundle.output;
        trackOutput.sampleData(this.encryptionSignalByte, 1);
        trackOutput.sampleData(parsableByteArray, n2);
        if (!bl) {
            return 1 + n2;
        }
        int n3 = parsableByteArray.readUnsignedShort();
        parsableByteArray.skipBytes(-2);
        int n4 = 2 + 6 * n3;
        trackOutput.sampleData(parsableByteArray, n4);
        return 1 + n2 + n4;
    }

    private static boolean shouldParseLeafAtom(int n) {
        return n == Atom.TYPE_hdlr || n == Atom.TYPE_mdhd || n == Atom.TYPE_mvhd || n == Atom.TYPE_sidx || n == Atom.TYPE_stsd || n == Atom.TYPE_tfdt || n == Atom.TYPE_tfhd || n == Atom.TYPE_tkhd || n == Atom.TYPE_trex || n == Atom.TYPE_trun || n == Atom.TYPE_pssh || n == Atom.TYPE_saiz || n == Atom.TYPE_saio || n == Atom.TYPE_senc || n == Atom.TYPE_uuid || n == Atom.TYPE_elst;
    }

    private static boolean shouldParseContainerAtom(int n) {
        return n == Atom.TYPE_moov || n == Atom.TYPE_trak || n == Atom.TYPE_mdia || n == Atom.TYPE_minf || n == Atom.TYPE_stbl || n == Atom.TYPE_moof || n == Atom.TYPE_traf || n == Atom.TYPE_mvex || n == Atom.TYPE_edts;
    }

    private static final class TrackBundle {
        public final TrackFragment fragment = new TrackFragment();
        public final TrackOutput output;
        public Track track;
        public DefaultSampleValues defaultSampleValues;
        public int currentSampleIndex;

        public TrackBundle(TrackOutput trackOutput) {
            this.output = trackOutput;
        }

        public void init(Track track, DefaultSampleValues defaultSampleValues) {
            this.track = Assertions.checkNotNull(track);
            this.defaultSampleValues = Assertions.checkNotNull(defaultSampleValues);
            this.output.format(track.mediaFormat);
            this.fragment.reset();
            this.currentSampleIndex = 0;
        }
    }
}

