/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.mp3;

import com.google.android.exoplayer.extractor.mp3.Mp3Extractor;
import com.google.android.exoplayer.util.MpegAudioHeader;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.google.android.exoplayer.util.Util;

final class XingSeeker
implements Mp3Extractor.Seeker {
    private final long firstFramePosition;
    private final long durationUs;
    private final long inputLength;
    private final long[] tableOfContents;
    private final long sizeBytes;
    private final int headerSize;

    public static XingSeeker create(MpegAudioHeader mpegAudioHeader, ParsableByteArray parsableByteArray, long l, long l2) {
        int n;
        int n2 = mpegAudioHeader.samplesPerFrame;
        int n3 = mpegAudioHeader.sampleRate;
        long l3 = l + (long)mpegAudioHeader.frameSize;
        int n4 = parsableByteArray.readInt();
        if ((n4 & 1) != 1 || (n = parsableByteArray.readUnsignedIntToInt()) == 0) {
            return null;
        }
        long l4 = Util.scaleLargeTimestamp(n, (long)n2 * 1000000L, n3);
        if ((n4 & 6) != 6) {
            return new XingSeeker(l3, l4, l2);
        }
        long l5 = parsableByteArray.readUnsignedIntToInt();
        parsableByteArray.skipBytes(1);
        long[] lArray = new long[99];
        for (int i = 0; i < 99; ++i) {
            lArray[i] = parsableByteArray.readUnsignedByte();
        }
        return new XingSeeker(l3, l4, l2, lArray, l5, mpegAudioHeader.frameSize);
    }

    private XingSeeker(long l, long l2, long l3) {
        this(l, l2, l3, null, 0L, 0);
    }

    private XingSeeker(long l, long l2, long l3, long[] lArray, long l4, int n) {
        this.firstFramePosition = l;
        this.durationUs = l2;
        this.inputLength = l3;
        this.tableOfContents = lArray;
        this.sizeBytes = l4;
        this.headerSize = n;
    }

    @Override
    public boolean isSeekable() {
        return this.tableOfContents != null;
    }

    @Override
    public long getPosition(long l) {
        float f;
        if (!this.isSeekable()) {
            return this.firstFramePosition;
        }
        float f2 = (float)l * 100.0f / (float)this.durationUs;
        if (f2 <= 0.0f) {
            f = 0.0f;
        } else if (f2 >= 100.0f) {
            f = 256.0f;
        } else {
            int n = (int)f2;
            float f3 = n == 0 ? 0.0f : (float)this.tableOfContents[n - 1];
            float f4 = n < 99 ? (float)this.tableOfContents[n] : 256.0f;
            f = f3 + (f4 - f3) * (f2 - (float)n);
        }
        long l2 = Math.round(0.00390625 * (double)f * (double)this.sizeBytes) + this.firstFramePosition;
        long l3 = this.inputLength != -1L ? this.inputLength - 1L : this.firstFramePosition - (long)this.headerSize + this.sizeBytes - 1L;
        return Math.min(l2, l3);
    }

    @Override
    public long getTimeUs(long l) {
        if (!this.isSeekable() || l < this.firstFramePosition) {
            return 0L;
        }
        double d = 256.0 * (double)(l - this.firstFramePosition) / (double)this.sizeBytes;
        int n = Util.binarySearchFloor(this.tableOfContents, (long)d, true, false) + 1;
        long l2 = this.getTimeUsForTocPosition(n);
        long l3 = n == 0 ? 0L : this.tableOfContents[n - 1];
        long l4 = n == 99 ? 256L : this.tableOfContents[n];
        long l5 = this.getTimeUsForTocPosition(n + 1);
        long l6 = l4 == l3 ? 0L : (long)((double)(l5 - l2) * (d - (double)l3) / (double)(l4 - l3));
        return l2 + l6;
    }

    @Override
    public long getDurationUs() {
        return this.durationUs;
    }

    private long getTimeUsForTocPosition(int n) {
        return this.durationUs * (long)n / 100L;
    }
}

