/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.mp3;

import com.google.android.exoplayer.extractor.mp3.Mp3Extractor;

final class ConstantBitrateSeeker
implements Mp3Extractor.Seeker {
    private static final int BITS_PER_BYTE = 8;
    private final long firstFramePosition;
    private final int bitrate;
    private final long durationUs;

    public ConstantBitrateSeeker(long l, int n, long l2) {
        this.firstFramePosition = l;
        this.bitrate = n;
        this.durationUs = l2 == -1L ? -1L : this.getTimeUs(l2);
    }

    @Override
    public boolean isSeekable() {
        return this.durationUs != -1L;
    }

    @Override
    public long getPosition(long l) {
        return this.durationUs == -1L ? 0L : this.firstFramePosition + l * (long)this.bitrate / 8000000L;
    }

    @Override
    public long getTimeUs(long l) {
        return Math.max(0L, l - this.firstFramePosition) * 1000000L * 8L / (long)this.bitrate;
    }

    @Override
    public long getDurationUs() {
        return this.durationUs;
    }
}

