/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.flv;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.extractor.flv.TagPayloadReader;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.NalUnitUtil;
import com.google.android.exoplayer.util.ParsableBitArray;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.util.ArrayList;
import java.util.List;

final class VideoTagPayloadReader
extends TagPayloadReader {
    private static final int VIDEO_CODEC_AVC = 7;
    private static final int VIDEO_FRAME_KEYFRAME = 1;
    private static final int VIDEO_FRAME_VIDEO_INFO = 5;
    private static final int AVC_PACKET_TYPE_SEQUENCE_HEADER = 0;
    private static final int AVC_PACKET_TYPE_AVC_NALU = 1;
    private final ParsableByteArray nalStartCode = new ParsableByteArray(NalUnitUtil.NAL_START_CODE);
    private final ParsableByteArray nalLength = new ParsableByteArray(4);
    private int nalUnitLengthFieldLength;
    private boolean hasOutputFormat;
    private int frameType;

    public VideoTagPayloadReader(TrackOutput trackOutput) {
        super(trackOutput);
    }

    @Override
    public void seek() {
    }

    @Override
    protected boolean parseHeader(ParsableByteArray parsableByteArray) throws TagPayloadReader.UnsupportedFormatException {
        int n = parsableByteArray.readUnsignedByte();
        int n2 = n >> 4 & 0xF;
        int n3 = n & 0xF;
        if (n3 != 7) {
            throw new TagPayloadReader.UnsupportedFormatException("Video format not supported: " + n3);
        }
        this.frameType = n2;
        return n2 != 5;
    }

    @Override
    protected void parsePayload(ParsableByteArray parsableByteArray, long l) throws ParserException {
        int n = parsableByteArray.readUnsignedByte();
        int n2 = parsableByteArray.readUnsignedInt24();
        l += (long)n2 * 1000L;
        if (n == 0 && !this.hasOutputFormat) {
            ParsableByteArray parsableByteArray2 = new ParsableByteArray(new byte[parsableByteArray.bytesLeft()]);
            parsableByteArray.readBytes(parsableByteArray2.data, 0, parsableByteArray.bytesLeft());
            AvcSequenceHeaderData avcSequenceHeaderData = this.parseAvcCodecPrivate(parsableByteArray2);
            this.nalUnitLengthFieldLength = avcSequenceHeaderData.nalUnitLengthFieldLength;
            MediaFormat mediaFormat = MediaFormat.createVideoFormat(null, "video/avc", -1, -1, this.getDurationUs(), avcSequenceHeaderData.width, avcSequenceHeaderData.height, avcSequenceHeaderData.initializationData, -1, avcSequenceHeaderData.pixelWidthAspectRatio);
            this.output.format(mediaFormat);
            this.hasOutputFormat = true;
        } else if (n == 1) {
            byte[] byArray = this.nalLength.data;
            byArray[0] = 0;
            byArray[1] = 0;
            byArray[2] = 0;
            int n3 = 4 - this.nalUnitLengthFieldLength;
            int n4 = 0;
            while (parsableByteArray.bytesLeft() > 0) {
                parsableByteArray.readBytes(this.nalLength.data, n3, this.nalUnitLengthFieldLength);
                this.nalLength.setPosition(0);
                int n5 = this.nalLength.readUnsignedIntToInt();
                this.nalStartCode.setPosition(0);
                this.output.sampleData(this.nalStartCode, 4);
                n4 += 4;
                this.output.sampleData(parsableByteArray, n5);
                n4 += n5;
            }
            this.output.sampleMetadata(l, this.frameType == 1 ? 1 : 0, n4, 0, null);
        }
    }

    private AvcSequenceHeaderData parseAvcCodecPrivate(ParsableByteArray parsableByteArray) throws ParserException {
        int n;
        parsableByteArray.setPosition(4);
        int n2 = (parsableByteArray.readUnsignedByte() & 3) + 1;
        Assertions.checkState(n2 != 3);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        int n3 = parsableByteArray.readUnsignedByte() & 0x1F;
        for (n = 0; n < n3; ++n) {
            arrayList.add(NalUnitUtil.parseChildNalUnit(parsableByteArray));
        }
        n = parsableByteArray.readUnsignedByte();
        for (int i = 0; i < n; ++i) {
            arrayList.add(NalUnitUtil.parseChildNalUnit(parsableByteArray));
        }
        float f = 1.0f;
        int n4 = -1;
        int n5 = -1;
        if (n3 > 0) {
            ParsableBitArray parsableBitArray = new ParsableBitArray((byte[])arrayList.get(0));
            parsableBitArray.setPosition(8 * (n2 + 1));
            NalUnitUtil.SpsData spsData = NalUnitUtil.parseSpsNalUnit(parsableBitArray);
            n4 = spsData.width;
            n5 = spsData.height;
            f = spsData.pixelWidthAspectRatio;
        }
        return new AvcSequenceHeaderData(arrayList, n2, n4, n5, f);
    }

    private static final class AvcSequenceHeaderData {
        public final List<byte[]> initializationData;
        public final int nalUnitLengthFieldLength;
        public final float pixelWidthAspectRatio;
        public final int width;
        public final int height;

        public AvcSequenceHeaderData(List<byte[]> list, int n, int n2, int n3, float f) {
            this.initializationData = list;
            this.nalUnitLengthFieldLength = n;
            this.pixelWidthAspectRatio = f;
            this.width = n2;
            this.height = n3;
        }
    }
}

