/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.flv;

import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.extractor.flv.TagPayloadReader;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

final class ScriptTagPayloadReader
extends TagPayloadReader {
    private static final String NAME_METADATA = "onMetaData";
    private static final String KEY_DURATION = "duration";
    private static final int AMF_TYPE_NUMBER = 0;
    private static final int AMF_TYPE_BOOLEAN = 1;
    private static final int AMF_TYPE_STRING = 2;
    private static final int AMF_TYPE_OBJECT = 3;
    private static final int AMF_TYPE_ECMA_ARRAY = 8;
    private static final int AMF_TYPE_END_MARKER = 9;
    private static final int AMF_TYPE_STRICT_ARRAY = 10;
    private static final int AMF_TYPE_DATE = 11;

    public ScriptTagPayloadReader(TrackOutput trackOutput) {
        super(trackOutput);
    }

    @Override
    public void seek() {
    }

    @Override
    protected boolean parseHeader(ParsableByteArray parsableByteArray) {
        return true;
    }

    @Override
    protected void parsePayload(ParsableByteArray parsableByteArray, long l) throws ParserException {
        double d;
        int n = ScriptTagPayloadReader.readAmfType(parsableByteArray);
        if (n != 2) {
            throw new ParserException();
        }
        String string = ScriptTagPayloadReader.readAmfString(parsableByteArray);
        if (!NAME_METADATA.equals(string)) {
            return;
        }
        int n2 = ScriptTagPayloadReader.readAmfType(parsableByteArray);
        if (n2 != 8) {
            throw new ParserException();
        }
        HashMap<String, Object> hashMap = ScriptTagPayloadReader.readAmfEcmaArray(parsableByteArray);
        if (hashMap.containsKey(KEY_DURATION) && (d = ((Double)hashMap.get(KEY_DURATION)).doubleValue()) > 0.0) {
            this.setDurationUs((long)(d * 1000000.0));
        }
    }

    private static int readAmfType(ParsableByteArray parsableByteArray) {
        return parsableByteArray.readUnsignedByte();
    }

    private static Boolean readAmfBoolean(ParsableByteArray parsableByteArray) {
        return parsableByteArray.readUnsignedByte() == 1;
    }

    private static Double readAmfDouble(ParsableByteArray parsableByteArray) {
        return Double.longBitsToDouble(parsableByteArray.readLong());
    }

    private static String readAmfString(ParsableByteArray parsableByteArray) {
        int n = parsableByteArray.readUnsignedShort();
        int n2 = parsableByteArray.getPosition();
        parsableByteArray.skipBytes(n);
        return new String(parsableByteArray.data, n2, n);
    }

    private static ArrayList<Object> readAmfStrictArray(ParsableByteArray parsableByteArray) {
        int n = parsableByteArray.readUnsignedIntToInt();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            int n2 = ScriptTagPayloadReader.readAmfType(parsableByteArray);
            arrayList.add(ScriptTagPayloadReader.readAmfData(parsableByteArray, n2));
        }
        return arrayList;
    }

    private static HashMap<String, Object> readAmfObject(ParsableByteArray parsableByteArray) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (true) {
            String string = ScriptTagPayloadReader.readAmfString(parsableByteArray);
            int n = ScriptTagPayloadReader.readAmfType(parsableByteArray);
            if (n == 9) break;
            hashMap.put(string, ScriptTagPayloadReader.readAmfData(parsableByteArray, n));
        }
        return hashMap;
    }

    private static HashMap<String, Object> readAmfEcmaArray(ParsableByteArray parsableByteArray) {
        int n = parsableByteArray.readUnsignedIntToInt();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(n);
        for (int i = 0; i < n; ++i) {
            String string = ScriptTagPayloadReader.readAmfString(parsableByteArray);
            int n2 = ScriptTagPayloadReader.readAmfType(parsableByteArray);
            hashMap.put(string, ScriptTagPayloadReader.readAmfData(parsableByteArray, n2));
        }
        return hashMap;
    }

    private static Date readAmfDate(ParsableByteArray parsableByteArray) {
        Date date = new Date((long)ScriptTagPayloadReader.readAmfDouble(parsableByteArray).doubleValue());
        parsableByteArray.skipBytes(2);
        return date;
    }

    private static Object readAmfData(ParsableByteArray parsableByteArray, int n) {
        switch (n) {
            case 0: {
                return ScriptTagPayloadReader.readAmfDouble(parsableByteArray);
            }
            case 1: {
                return ScriptTagPayloadReader.readAmfBoolean(parsableByteArray);
            }
            case 2: {
                return ScriptTagPayloadReader.readAmfString(parsableByteArray);
            }
            case 3: {
                return ScriptTagPayloadReader.readAmfObject(parsableByteArray);
            }
            case 8: {
                return ScriptTagPayloadReader.readAmfEcmaArray(parsableByteArray);
            }
            case 10: {
                return ScriptTagPayloadReader.readAmfStrictArray(parsableByteArray);
            }
            case 11: {
                return ScriptTagPayloadReader.readAmfDate(parsableByteArray);
            }
        }
        return null;
    }
}

