/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.dash.mpd;

import android.text.TextUtils;
import android.util.Base64;
import android.util.Pair;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.dash.mpd.AdaptationSet;
import com.google.android.exoplayer.dash.mpd.ContentProtection;
import com.google.android.exoplayer.dash.mpd.MediaPresentationDescription;
import com.google.android.exoplayer.dash.mpd.Period;
import com.google.android.exoplayer.dash.mpd.RangedUri;
import com.google.android.exoplayer.dash.mpd.Representation;
import com.google.android.exoplayer.dash.mpd.SegmentBase;
import com.google.android.exoplayer.dash.mpd.UrlTemplate;
import com.google.android.exoplayer.dash.mpd.UtcTimingElement;
import com.google.android.exoplayer.drm.DrmInitData;
import com.google.android.exoplayer.extractor.mp4.PsshAtomUtil;
import com.google.android.exoplayer.upstream.UriLoadable;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.MimeTypes;
import com.google.android.exoplayer.util.ParserUtil;
import com.google.android.exoplayer.util.UriUtil;
import com.google.android.exoplayer.util.Util;
import com.vcc.playerwrappersdk.a;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class MediaPresentationDescriptionParser
extends DefaultHandler
implements UriLoadable.Parser<MediaPresentationDescription> {
    private static final String TAG = "MediaPresentationDescriptionParser";
    private static final Pattern FRAME_RATE_PATTERN = Pattern.compile("(\\d+)(?:/(\\d+))?");
    private final String contentId;
    private final XmlPullParserFactory xmlParserFactory;

    public MediaPresentationDescriptionParser() {
        this(null);
    }

    public MediaPresentationDescriptionParser(String string) {
        this.contentId = string;
        try {
            this.xmlParserFactory = XmlPullParserFactory.newInstance();
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new RuntimeException("Couldn't create XmlPullParserFactory instance", xmlPullParserException);
        }
    }

    @Override
    public MediaPresentationDescription parse(String string, InputStream inputStream) throws IOException, ParserException {
        try {
            XmlPullParser xmlPullParser = this.xmlParserFactory.newPullParser();
            xmlPullParser.setInput(inputStream, null);
            int n = xmlPullParser.next();
            if (n != 2 || !"MPD".equals(xmlPullParser.getName())) {
                throw new ParserException("inputStream does not contain a valid media presentation description");
            }
            return this.parseMediaPresentationDescription(xmlPullParser, string);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new ParserException(xmlPullParserException);
        }
        catch (ParseException parseException) {
            throw new ParserException(parseException);
        }
    }

    protected MediaPresentationDescription parseMediaPresentationDescription(XmlPullParser xmlPullParser, String string) throws XmlPullParserException, IOException, ParseException {
        long l = MediaPresentationDescriptionParser.parseDateTime(xmlPullParser, "availabilityStartTime", -1L);
        long l2 = MediaPresentationDescriptionParser.parseDuration(xmlPullParser, "mediaPresentationDuration", -1L);
        long l3 = MediaPresentationDescriptionParser.parseDuration(xmlPullParser, "minBufferTime", -1L);
        String string2 = xmlPullParser.getAttributeValue(null, "type");
        boolean bl = string2 != null ? string2.equals("dynamic") : false;
        long l4 = bl ? MediaPresentationDescriptionParser.parseDuration(xmlPullParser, "minimumUpdatePeriod", -1L) : -1L;
        long l5 = bl ? MediaPresentationDescriptionParser.parseDuration(xmlPullParser, "timeShiftBufferDepth", -1L) : -1L;
        UtcTimingElement utcTimingElement = null;
        String string3 = null;
        ArrayList<Period> arrayList = new ArrayList<Period>();
        long l6 = bl ? -1L : 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        do {
            xmlPullParser.next();
            if (ParserUtil.isStartTag(xmlPullParser, "BaseURL")) {
                if (bl3) continue;
                string = MediaPresentationDescriptionParser.parseBaseUrl(xmlPullParser, string);
                bl3 = true;
                continue;
            }
            if (ParserUtil.isStartTag(xmlPullParser, "UTCTiming")) {
                utcTimingElement = this.parseUtcTiming(xmlPullParser);
                continue;
            }
            if (ParserUtil.isStartTag(xmlPullParser, "Location")) {
                string3 = xmlPullParser.nextText();
                continue;
            }
            if (!ParserUtil.isStartTag(xmlPullParser, "Period") || bl2) continue;
            Pair<Period, Long> pair = this.parsePeriod(xmlPullParser, string, l6);
            Period period = (Period)pair.first;
            if (period.startMs == -1L) {
                if (bl) {
                    bl2 = true;
                    continue;
                }
                throw new ParserException("Unable to determine start of period " + arrayList.size());
            }
            long l7 = (Long)pair.second;
            l6 = l7 == -1L ? -1L : period.startMs + l7;
            arrayList.add(period);
        } while (!ParserUtil.isEndTag(xmlPullParser, "MPD"));
        if (l2 == -1L) {
            if (l6 != -1L) {
                l2 = l6;
            } else if (!bl) {
                throw new ParserException("Unable to determine duration of static manifest.");
            }
        }
        if (arrayList.isEmpty()) {
            throw new ParserException("No periods found.");
        }
        return this.buildMediaPresentationDescription(l, l2, l3, bl, l4, l5, utcTimingElement, string3, arrayList);
    }

    protected MediaPresentationDescription buildMediaPresentationDescription(long l, long l2, long l3, boolean bl, long l4, long l5, UtcTimingElement utcTimingElement, String string, List<Period> list) {
        return new MediaPresentationDescription(l, l2, l3, bl, l4, l5, utcTimingElement, string, list);
    }

    protected UtcTimingElement parseUtcTiming(XmlPullParser xmlPullParser) {
        String string = xmlPullParser.getAttributeValue(null, "schemeIdUri");
        String string2 = xmlPullParser.getAttributeValue(null, "value");
        return this.buildUtcTimingElement(string, string2);
    }

    protected UtcTimingElement buildUtcTimingElement(String string, String string2) {
        return new UtcTimingElement(string, string2);
    }

    protected Pair<Period, Long> parsePeriod(XmlPullParser xmlPullParser, String string, long l) throws XmlPullParserException, IOException {
        String string2 = xmlPullParser.getAttributeValue(null, "id");
        long l2 = MediaPresentationDescriptionParser.parseDuration(xmlPullParser, "start", l);
        long l3 = MediaPresentationDescriptionParser.parseDuration(xmlPullParser, "duration", -1L);
        SegmentBase segmentBase = null;
        ArrayList<AdaptationSet> arrayList = new ArrayList<AdaptationSet>();
        boolean bl = false;
        do {
            xmlPullParser.next();
            if (ParserUtil.isStartTag(xmlPullParser, "BaseURL")) {
                if (bl) continue;
                string = MediaPresentationDescriptionParser.parseBaseUrl(xmlPullParser, string);
                bl = true;
                continue;
            }
            if (ParserUtil.isStartTag(xmlPullParser, "AdaptationSet")) {
                arrayList.add(this.parseAdaptationSet(xmlPullParser, string, segmentBase));
                continue;
            }
            if (ParserUtil.isStartTag(xmlPullParser, "SegmentBase")) {
                segmentBase = this.parseSegmentBase(xmlPullParser, string, null);
                continue;
            }
            if (ParserUtil.isStartTag(xmlPullParser, "SegmentList")) {
                segmentBase = this.parseSegmentList(xmlPullParser, string, null);
                continue;
            }
            if (!ParserUtil.isStartTag(xmlPullParser, "SegmentTemplate")) continue;
            segmentBase = this.parseSegmentTemplate(xmlPullParser, string, null);
        } while (!ParserUtil.isEndTag(xmlPullParser, "Period"));
        return Pair.create((Object)this.buildPeriod(string2, l2, arrayList), (Object)l3);
    }

    protected Period buildPeriod(String string, long l, List<AdaptationSet> list) {
        return new Period(string, l, list);
    }

    protected AdaptationSet parseAdaptationSet(XmlPullParser xmlPullParser, String string, SegmentBase segmentBase) throws XmlPullParserException, IOException {
        int n = MediaPresentationDescriptionParser.parseInt(xmlPullParser, "id", -1);
        int n2 = this.parseContentType(xmlPullParser);
        String string2 = xmlPullParser.getAttributeValue(null, "mimeType");
        String string3 = xmlPullParser.getAttributeValue(null, "codecs");
        int n3 = MediaPresentationDescriptionParser.parseInt(xmlPullParser, "width", -1);
        int n4 = MediaPresentationDescriptionParser.parseInt(xmlPullParser, "height", -1);
        float f = MediaPresentationDescriptionParser.parseFrameRate(xmlPullParser, -1.0f);
        int n5 = -1;
        int n6 = MediaPresentationDescriptionParser.parseInt(xmlPullParser, "audioSamplingRate", -1);
        String string4 = xmlPullParser.getAttributeValue(null, "lang");
        ContentProtectionsBuilder contentProtectionsBuilder = new ContentProtectionsBuilder();
        ArrayList<Representation> arrayList = new ArrayList<Representation>();
        boolean bl = false;
        do {
            Object object;
            xmlPullParser.next();
            if (ParserUtil.isStartTag(xmlPullParser, "BaseURL")) {
                if (bl) continue;
                string = MediaPresentationDescriptionParser.parseBaseUrl(xmlPullParser, string);
                bl = true;
                continue;
            }
            if (ParserUtil.isStartTag(xmlPullParser, "ContentProtection")) {
                object = this.parseContentProtection(xmlPullParser);
                if (object == null) continue;
                contentProtectionsBuilder.addAdaptationSetProtection((ContentProtection)object);
                continue;
            }
            if (ParserUtil.isStartTag(xmlPullParser, "ContentComponent")) {
                string4 = MediaPresentationDescriptionParser.checkLanguageConsistency(string4, xmlPullParser.getAttributeValue(null, "lang"));
                n2 = MediaPresentationDescriptionParser.checkContentTypeConsistency(n2, this.parseContentType(xmlPullParser));
                continue;
            }
            if (ParserUtil.isStartTag(xmlPullParser, "Representation")) {
                object = this.parseRepresentation(xmlPullParser, string, string2, string3, n3, n4, f, n5, n6, string4, segmentBase, contentProtectionsBuilder);
                contentProtectionsBuilder.endRepresentation();
                n2 = MediaPresentationDescriptionParser.checkContentTypeConsistency(n2, this.getContentType((Representation)object));
                arrayList.add((Representation)object);
                continue;
            }
            if (ParserUtil.isStartTag(xmlPullParser, "AudioChannelConfiguration")) {
                n5 = this.parseAudioChannelConfiguration(xmlPullParser);
                continue;
            }
            if (ParserUtil.isStartTag(xmlPullParser, "SegmentBase")) {
                segmentBase = this.parseSegmentBase(xmlPullParser, string, (SegmentBase.SingleSegmentBase)segmentBase);
                continue;
            }
            if (ParserUtil.isStartTag(xmlPullParser, "SegmentList")) {
                segmentBase = this.parseSegmentList(xmlPullParser, string, (SegmentBase.SegmentList)segmentBase);
                continue;
            }
            if (ParserUtil.isStartTag(xmlPullParser, "SegmentTemplate")) {
                segmentBase = this.parseSegmentTemplate(xmlPullParser, string, (SegmentBase.SegmentTemplate)segmentBase);
                continue;
            }
            if (!ParserUtil.isStartTag(xmlPullParser)) continue;
            this.parseAdaptationSetChild(xmlPullParser);
        } while (!ParserUtil.isEndTag(xmlPullParser, "AdaptationSet"));
        return this.buildAdaptationSet(n, n2, arrayList, contentProtectionsBuilder.build());
    }

    protected AdaptationSet buildAdaptationSet(int n, int n2, List<Representation> list, List<ContentProtection> list2) {
        return new AdaptationSet(n, n2, list, list2);
    }

    protected int parseContentType(XmlPullParser xmlPullParser) {
        String string = xmlPullParser.getAttributeValue(null, "contentType");
        return TextUtils.isEmpty((CharSequence)string) ? -1 : ("audio".equals(string) ? 1 : ("video".equals(string) ? 0 : ("text".equals(string) ? 2 : -1)));
    }

    protected int getContentType(Representation representation) {
        String string;
        String string2 = representation.format.mimeType;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return -1;
        }
        if (MimeTypes.isVideo(string2)) {
            return 0;
        }
        if (MimeTypes.isAudio(string2)) {
            return 1;
        }
        if (MimeTypes.isText(string2) || "application/ttml+xml".equals(string2)) {
            return 2;
        }
        if ("application/mp4".equals(string2) && ("stpp".equals(string = representation.format.codecs) || "wvtt".equals(string))) {
            return 2;
        }
        return -1;
    }

    protected ContentProtection parseContentProtection(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        String string = xmlPullParser.getAttributeValue(null, "schemeIdUri");
        UUID uUID = null;
        DrmInitData.SchemeInitData schemeInitData = null;
        boolean bl = false;
        do {
            xmlPullParser.next();
            if (!ParserUtil.isStartTag(xmlPullParser, "cenc:pssh") || xmlPullParser.next() != 4) continue;
            bl = true;
            schemeInitData = new DrmInitData.SchemeInitData("video/mp4", Base64.decode((String)xmlPullParser.getText(), (int)0));
            uUID = PsshAtomUtil.parseUuid(schemeInitData.data);
        } while (!ParserUtil.isEndTag(xmlPullParser, "ContentProtection"));
        if (bl && uUID == null) {
            a.b(TAG, "Skipped unsupported ContentProtection element");
            return null;
        }
        return this.buildContentProtection(string, uUID, schemeInitData);
    }

    protected ContentProtection buildContentProtection(String string, UUID uUID, DrmInitData.SchemeInitData schemeInitData) {
        return new ContentProtection(string, uUID, schemeInitData);
    }

    protected void parseAdaptationSetChild(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
    }

    protected Representation parseRepresentation(XmlPullParser xmlPullParser, String string, String string2, String string3, int n, int n2, float f, int n3, int n4, String string4, SegmentBase segmentBase, ContentProtectionsBuilder contentProtectionsBuilder) throws XmlPullParserException, IOException {
        Object object;
        String string5 = xmlPullParser.getAttributeValue(null, "id");
        int n5 = MediaPresentationDescriptionParser.parseInt(xmlPullParser, "bandwidth");
        String string6 = MediaPresentationDescriptionParser.parseString(xmlPullParser, "mimeType", string2);
        String string7 = MediaPresentationDescriptionParser.parseString(xmlPullParser, "codecs", string3);
        int n6 = MediaPresentationDescriptionParser.parseInt(xmlPullParser, "width", n);
        int n7 = MediaPresentationDescriptionParser.parseInt(xmlPullParser, "height", n2);
        float f2 = MediaPresentationDescriptionParser.parseFrameRate(xmlPullParser, f);
        int n8 = n3;
        int n9 = MediaPresentationDescriptionParser.parseInt(xmlPullParser, "audioSamplingRate", n4);
        String string8 = string4;
        boolean bl = false;
        do {
            xmlPullParser.next();
            if (ParserUtil.isStartTag(xmlPullParser, "BaseURL")) {
                if (bl) continue;
                string = MediaPresentationDescriptionParser.parseBaseUrl(xmlPullParser, string);
                bl = true;
                continue;
            }
            if (ParserUtil.isStartTag(xmlPullParser, "AudioChannelConfiguration")) {
                n8 = this.parseAudioChannelConfiguration(xmlPullParser);
                continue;
            }
            if (ParserUtil.isStartTag(xmlPullParser, "SegmentBase")) {
                segmentBase = this.parseSegmentBase(xmlPullParser, string, (SegmentBase.SingleSegmentBase)segmentBase);
                continue;
            }
            if (ParserUtil.isStartTag(xmlPullParser, "SegmentList")) {
                segmentBase = this.parseSegmentList(xmlPullParser, string, (SegmentBase.SegmentList)segmentBase);
                continue;
            }
            if (ParserUtil.isStartTag(xmlPullParser, "SegmentTemplate")) {
                segmentBase = this.parseSegmentTemplate(xmlPullParser, string, (SegmentBase.SegmentTemplate)segmentBase);
                continue;
            }
            if (!ParserUtil.isStartTag(xmlPullParser, "ContentProtection") || (object = this.parseContentProtection(xmlPullParser)) == null) continue;
            contentProtectionsBuilder.addAdaptationSetProtection((ContentProtection)object);
        } while (!ParserUtil.isEndTag(xmlPullParser, "Representation"));
        object = this.buildFormat(string5, string6, n6, n7, f2, n8, n9, n5, string8, string7);
        return this.buildRepresentation(this.contentId, -1, (Format)object, segmentBase != null ? segmentBase : new SegmentBase.SingleSegmentBase(string));
    }

    protected Format buildFormat(String string, String string2, int n, int n2, float f, int n3, int n4, int n5, String string3, String string4) {
        return new Format(string, string2, n, n2, f, n3, n4, n5, string3, string4);
    }

    protected Representation buildRepresentation(String string, int n, Format format, SegmentBase segmentBase) {
        return Representation.newInstance(string, n, format, segmentBase);
    }

    protected SegmentBase.SingleSegmentBase parseSegmentBase(XmlPullParser xmlPullParser, String string, SegmentBase.SingleSegmentBase singleSegmentBase) throws XmlPullParserException, IOException {
        Object object;
        long l = MediaPresentationDescriptionParser.parseLong(xmlPullParser, "timescale", singleSegmentBase != null ? singleSegmentBase.timescale : 1L);
        long l2 = MediaPresentationDescriptionParser.parseLong(xmlPullParser, "presentationTimeOffset", singleSegmentBase != null ? singleSegmentBase.presentationTimeOffset : 0L);
        long l3 = singleSegmentBase != null ? singleSegmentBase.indexStart : 0L;
        long l4 = singleSegmentBase != null ? singleSegmentBase.indexLength : -1L;
        String string2 = xmlPullParser.getAttributeValue(null, "indexRange");
        if (string2 != null) {
            object = string2.split("-");
            l3 = Long.parseLong(object[0]);
            l4 = Long.parseLong(object[1]) - l3 + 1L;
        }
        object = singleSegmentBase != null ? singleSegmentBase.initialization : null;
        do {
            xmlPullParser.next();
            if (!ParserUtil.isStartTag(xmlPullParser, "Initialization")) continue;
            object = this.parseInitialization(xmlPullParser, string);
        } while (!ParserUtil.isEndTag(xmlPullParser, "SegmentBase"));
        return this.buildSingleSegmentBase((RangedUri)object, l, l2, string, l3, l4);
    }

    protected SegmentBase.SingleSegmentBase buildSingleSegmentBase(RangedUri rangedUri, long l, long l2, String string, long l3, long l4) {
        return new SegmentBase.SingleSegmentBase(rangedUri, l, l2, string, l3, l4);
    }

    protected SegmentBase.SegmentList parseSegmentList(XmlPullParser xmlPullParser, String string, SegmentBase.SegmentList segmentList) throws XmlPullParserException, IOException {
        long l = MediaPresentationDescriptionParser.parseLong(xmlPullParser, "timescale", segmentList != null ? segmentList.timescale : 1L);
        long l2 = MediaPresentationDescriptionParser.parseLong(xmlPullParser, "presentationTimeOffset", segmentList != null ? segmentList.presentationTimeOffset : 0L);
        long l3 = MediaPresentationDescriptionParser.parseLong(xmlPullParser, "duration", segmentList != null ? segmentList.duration : -1L);
        int n = MediaPresentationDescriptionParser.parseInt(xmlPullParser, "startNumber", segmentList != null ? segmentList.startNumber : 1);
        RangedUri rangedUri = null;
        List list = null;
        ArrayList<RangedUri> arrayList = null;
        do {
            xmlPullParser.next();
            if (ParserUtil.isStartTag(xmlPullParser, "Initialization")) {
                rangedUri = this.parseInitialization(xmlPullParser, string);
                continue;
            }
            if (ParserUtil.isStartTag(xmlPullParser, "SegmentTimeline")) {
                list = this.parseSegmentTimeline(xmlPullParser);
                continue;
            }
            if (!ParserUtil.isStartTag(xmlPullParser, "SegmentURL")) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<RangedUri>();
            }
            arrayList.add(this.parseSegmentUrl(xmlPullParser, string));
        } while (!ParserUtil.isEndTag(xmlPullParser, "SegmentList"));
        if (segmentList != null) {
            rangedUri = rangedUri != null ? rangedUri : segmentList.initialization;
            list = list != null ? list : segmentList.segmentTimeline;
            arrayList = arrayList != null ? arrayList : segmentList.mediaSegments;
        }
        return this.buildSegmentList(rangedUri, l, l2, n, l3, list, arrayList);
    }

    protected SegmentBase.SegmentList buildSegmentList(RangedUri rangedUri, long l, long l2, int n, long l3, List<SegmentBase.SegmentTimelineElement> list, List<RangedUri> list2) {
        return new SegmentBase.SegmentList(rangedUri, l, l2, n, l3, list, list2);
    }

    protected SegmentBase.SegmentTemplate parseSegmentTemplate(XmlPullParser xmlPullParser, String string, SegmentBase.SegmentTemplate segmentTemplate) throws XmlPullParserException, IOException {
        long l = MediaPresentationDescriptionParser.parseLong(xmlPullParser, "timescale", segmentTemplate != null ? segmentTemplate.timescale : 1L);
        long l2 = MediaPresentationDescriptionParser.parseLong(xmlPullParser, "presentationTimeOffset", segmentTemplate != null ? segmentTemplate.presentationTimeOffset : 0L);
        long l3 = MediaPresentationDescriptionParser.parseLong(xmlPullParser, "duration", segmentTemplate != null ? segmentTemplate.duration : -1L);
        int n = MediaPresentationDescriptionParser.parseInt(xmlPullParser, "startNumber", segmentTemplate != null ? segmentTemplate.startNumber : 1);
        UrlTemplate urlTemplate = this.parseUrlTemplate(xmlPullParser, "media", segmentTemplate != null ? segmentTemplate.mediaTemplate : null);
        UrlTemplate urlTemplate2 = this.parseUrlTemplate(xmlPullParser, "initialization", segmentTemplate != null ? segmentTemplate.initializationTemplate : null);
        RangedUri rangedUri = null;
        List list = null;
        do {
            xmlPullParser.next();
            if (ParserUtil.isStartTag(xmlPullParser, "Initialization")) {
                rangedUri = this.parseInitialization(xmlPullParser, string);
                continue;
            }
            if (!ParserUtil.isStartTag(xmlPullParser, "SegmentTimeline")) continue;
            list = this.parseSegmentTimeline(xmlPullParser);
        } while (!ParserUtil.isEndTag(xmlPullParser, "SegmentTemplate"));
        if (segmentTemplate != null) {
            rangedUri = rangedUri != null ? rangedUri : segmentTemplate.initialization;
            list = list != null ? list : segmentTemplate.segmentTimeline;
        }
        return this.buildSegmentTemplate(rangedUri, l, l2, n, l3, list, urlTemplate2, urlTemplate, string);
    }

    protected SegmentBase.SegmentTemplate buildSegmentTemplate(RangedUri rangedUri, long l, long l2, int n, long l3, List<SegmentBase.SegmentTimelineElement> list, UrlTemplate urlTemplate, UrlTemplate urlTemplate2, String string) {
        return new SegmentBase.SegmentTemplate(rangedUri, l, l2, n, l3, list, urlTemplate, urlTemplate2, string);
    }

    protected List<SegmentBase.SegmentTimelineElement> parseSegmentTimeline(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        ArrayList<SegmentBase.SegmentTimelineElement> arrayList = new ArrayList<SegmentBase.SegmentTimelineElement>();
        long l = 0L;
        do {
            xmlPullParser.next();
            if (!ParserUtil.isStartTag(xmlPullParser, "S")) continue;
            l = MediaPresentationDescriptionParser.parseLong(xmlPullParser, "t", l);
            long l2 = MediaPresentationDescriptionParser.parseLong(xmlPullParser, "d");
            int n = 1 + MediaPresentationDescriptionParser.parseInt(xmlPullParser, "r", 0);
            for (int i = 0; i < n; ++i) {
                arrayList.add(this.buildSegmentTimelineElement(l, l2));
                l += l2;
            }
        } while (!ParserUtil.isEndTag(xmlPullParser, "SegmentTimeline"));
        return arrayList;
    }

    protected SegmentBase.SegmentTimelineElement buildSegmentTimelineElement(long l, long l2) {
        return new SegmentBase.SegmentTimelineElement(l, l2);
    }

    protected UrlTemplate parseUrlTemplate(XmlPullParser xmlPullParser, String string, UrlTemplate urlTemplate) {
        String string2 = xmlPullParser.getAttributeValue(null, string);
        if (string2 != null) {
            return UrlTemplate.compile(string2);
        }
        return urlTemplate;
    }

    protected RangedUri parseInitialization(XmlPullParser xmlPullParser, String string) {
        return this.parseRangedUrl(xmlPullParser, string, "sourceURL", "range");
    }

    protected RangedUri parseSegmentUrl(XmlPullParser xmlPullParser, String string) {
        return this.parseRangedUrl(xmlPullParser, string, "media", "mediaRange");
    }

    protected RangedUri parseRangedUrl(XmlPullParser xmlPullParser, String string, String string2, String string3) {
        String string4 = xmlPullParser.getAttributeValue(null, string2);
        long l = 0L;
        long l2 = -1L;
        String string5 = xmlPullParser.getAttributeValue(null, string3);
        if (string5 != null) {
            String[] stringArray = string5.split("-");
            l = Long.parseLong(stringArray[0]);
            if (stringArray.length == 2) {
                l2 = Long.parseLong(stringArray[1]) - l + 1L;
            }
        }
        return this.buildRangedUri(string, string4, l, l2);
    }

    protected RangedUri buildRangedUri(String string, String string2, long l, long l2) {
        return new RangedUri(string, string2, l, l2);
    }

    protected int parseAudioChannelConfiguration(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        String string = MediaPresentationDescriptionParser.parseString(xmlPullParser, "schemeIdUri", null);
        int n = "urn:mpeg:dash:23003:3:audio_channel_configuration:2011".equals(string) ? MediaPresentationDescriptionParser.parseInt(xmlPullParser, "value") : -1;
        do {
            xmlPullParser.next();
        } while (!ParserUtil.isEndTag(xmlPullParser, "AudioChannelConfiguration"));
        return n;
    }

    private static String checkLanguageConsistency(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        Assertions.checkState(string.equals(string2));
        return string;
    }

    private static int checkContentTypeConsistency(int n, int n2) {
        if (n == -1) {
            return n2;
        }
        if (n2 == -1) {
            return n;
        }
        Assertions.checkState(n == n2);
        return n;
    }

    protected static float parseFrameRate(XmlPullParser xmlPullParser, float f) {
        Matcher matcher;
        float f2 = f;
        String string = xmlPullParser.getAttributeValue(null, "frameRate");
        if (string != null && (matcher = FRAME_RATE_PATTERN.matcher(string)).matches()) {
            int n = Integer.parseInt(matcher.group(1));
            String string2 = matcher.group(2);
            f2 = !TextUtils.isEmpty((CharSequence)string2) ? (float)n / (float)Integer.parseInt(string2) : (float)n;
        }
        return f2;
    }

    protected static long parseDuration(XmlPullParser xmlPullParser, String string, long l) {
        String string2 = xmlPullParser.getAttributeValue(null, string);
        if (string2 == null) {
            return l;
        }
        return Util.parseXsDuration(string2);
    }

    protected static long parseDateTime(XmlPullParser xmlPullParser, String string, long l) throws ParseException {
        String string2 = xmlPullParser.getAttributeValue(null, string);
        if (string2 == null) {
            return l;
        }
        return Util.parseXsDateTime(string2);
    }

    protected static String parseBaseUrl(XmlPullParser xmlPullParser, String string) throws XmlPullParserException, IOException {
        xmlPullParser.next();
        return UriUtil.resolve(string, xmlPullParser.getText());
    }

    protected static int parseInt(XmlPullParser xmlPullParser, String string) {
        return MediaPresentationDescriptionParser.parseInt(xmlPullParser, string, -1);
    }

    protected static int parseInt(XmlPullParser xmlPullParser, String string, int n) {
        String string2 = xmlPullParser.getAttributeValue(null, string);
        return string2 == null ? n : Integer.parseInt(string2);
    }

    protected static long parseLong(XmlPullParser xmlPullParser, String string) {
        return MediaPresentationDescriptionParser.parseLong(xmlPullParser, string, -1L);
    }

    protected static long parseLong(XmlPullParser xmlPullParser, String string, long l) {
        String string2 = xmlPullParser.getAttributeValue(null, string);
        return string2 == null ? l : Long.parseLong(string2);
    }

    protected static String parseString(XmlPullParser xmlPullParser, String string, String string2) {
        String string3 = xmlPullParser.getAttributeValue(null, string);
        return string3 == null ? string2 : string3;
    }

    protected static final class ContentProtectionsBuilder
    implements Comparator<ContentProtection> {
        private ArrayList<ContentProtection> adaptationSetProtections;
        private ArrayList<ContentProtection> representationProtections;
        private ArrayList<ContentProtection> currentRepresentationProtections;
        private boolean representationProtectionsSet;

        protected ContentProtectionsBuilder() {
        }

        public void addAdaptationSetProtection(ContentProtection contentProtection) {
            if (this.adaptationSetProtections == null) {
                this.adaptationSetProtections = new ArrayList();
            }
            this.maybeAddContentProtection(this.adaptationSetProtections, contentProtection);
        }

        public void addRepresentationProtection(ContentProtection contentProtection) {
            if (this.currentRepresentationProtections == null) {
                this.currentRepresentationProtections = new ArrayList();
            }
            this.maybeAddContentProtection(this.currentRepresentationProtections, contentProtection);
        }

        public void endRepresentation() {
            if (!this.representationProtectionsSet) {
                if (this.currentRepresentationProtections != null) {
                    Collections.sort(this.currentRepresentationProtections, this);
                }
                this.representationProtections = this.currentRepresentationProtections;
                this.representationProtectionsSet = true;
            } else if (this.currentRepresentationProtections == null) {
                Assertions.checkState(this.representationProtections == null);
            } else {
                Collections.sort(this.currentRepresentationProtections, this);
                Assertions.checkState(this.currentRepresentationProtections.equals(this.representationProtections));
            }
            this.currentRepresentationProtections = null;
        }

        public ArrayList<ContentProtection> build() {
            if (this.adaptationSetProtections == null) {
                return this.representationProtections;
            }
            if (this.representationProtections == null) {
                return this.adaptationSetProtections;
            }
            for (int i = 0; i < this.representationProtections.size(); ++i) {
                this.maybeAddContentProtection(this.adaptationSetProtections, this.representationProtections.get(i));
            }
            return this.adaptationSetProtections;
        }

        private void maybeAddContentProtection(List<ContentProtection> list, ContentProtection contentProtection) {
            if (!list.contains(contentProtection)) {
                for (int i = 0; i < list.size(); ++i) {
                    Assertions.checkState(!list.get((int)i).schemeUriId.equals(contentProtection.schemeUriId));
                }
                list.add(contentProtection);
            }
        }

        @Override
        public int compare(ContentProtection contentProtection, ContentProtection contentProtection2) {
            return contentProtection.schemeUriId.compareTo(contentProtection2.schemeUriId);
        }
    }
}

