/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.chunk;

import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.chunk.MediaChunk;
import com.google.android.exoplayer.upstream.BandwidthMeter;
import java.util.List;
import java.util.Random;

public interface FormatEvaluator {
    public void enable();

    public void disable();

    public void evaluate(List<? extends MediaChunk> var1, long var2, Format[] var4, Evaluation var5);

    public static final class AdaptiveEvaluator
    implements FormatEvaluator {
        public static final int DEFAULT_MAX_INITIAL_BITRATE = 800000;
        public static final int DEFAULT_MIN_DURATION_FOR_QUALITY_INCREASE_MS = 10000;
        public static final int DEFAULT_MAX_DURATION_FOR_QUALITY_DECREASE_MS = 25000;
        public static final int DEFAULT_MIN_DURATION_TO_RETAIN_AFTER_DISCARD_MS = 25000;
        public static final float DEFAULT_BANDWIDTH_FRACTION = 0.75f;
        private final BandwidthMeter bandwidthMeter;
        private final int maxInitialBitrate;
        private final long minDurationForQualityIncreaseUs;
        private final long maxDurationForQualityDecreaseUs;
        private final long minDurationToRetainAfterDiscardUs;
        private final float bandwidthFraction;

        public AdaptiveEvaluator(BandwidthMeter bandwidthMeter) {
            this(bandwidthMeter, 800000, 10000, 25000, 25000, 0.75f);
        }

        public AdaptiveEvaluator(BandwidthMeter bandwidthMeter, int n, int n2, int n3, int n4, float f) {
            this.bandwidthMeter = bandwidthMeter;
            this.maxInitialBitrate = n;
            this.minDurationForQualityIncreaseUs = (long)n2 * 1000L;
            this.maxDurationForQualityDecreaseUs = (long)n3 * 1000L;
            this.minDurationToRetainAfterDiscardUs = (long)n4 * 1000L;
            this.bandwidthFraction = f;
        }

        @Override
        public void enable() {
        }

        @Override
        public void disable() {
        }

        @Override
        public void evaluate(List<? extends MediaChunk> list, long l, Format[] formatArray, Evaluation evaluation) {
            boolean bl;
            long l2 = list.isEmpty() ? 0L : list.get((int)(list.size() - 1)).endTimeUs - l;
            Format format = evaluation.format;
            Format format2 = this.determineIdealFormat(formatArray, this.bandwidthMeter.getBitrateEstimate());
            boolean bl2 = format2 != null && format != null && format2.bitrate > format.bitrate;
            boolean bl3 = bl = format2 != null && format != null && format2.bitrate < format.bitrate;
            if (bl2) {
                if (l2 < this.minDurationForQualityIncreaseUs) {
                    format2 = format;
                } else if (l2 >= this.minDurationToRetainAfterDiscardUs) {
                    for (int i = 1; i < list.size(); ++i) {
                        MediaChunk mediaChunk = list.get(i);
                        long l3 = mediaChunk.startTimeUs - l;
                        if (l3 < this.minDurationToRetainAfterDiscardUs || mediaChunk.format.bitrate >= format2.bitrate || mediaChunk.format.height >= format2.height || mediaChunk.format.height >= 720 || mediaChunk.format.width >= 1280) continue;
                        evaluation.queueSize = i;
                        break;
                    }
                }
            } else if (bl && format != null && l2 >= this.maxDurationForQualityDecreaseUs) {
                format2 = format;
            }
            if (format != null && format2 != format) {
                evaluation.trigger = 3;
            }
            evaluation.format = format2;
        }

        private Format determineIdealFormat(Format[] formatArray, long l) {
            long l2 = l == -1L ? (long)this.maxInitialBitrate : (long)((float)l * this.bandwidthFraction);
            for (int i = 0; i < formatArray.length; ++i) {
                Format format = formatArray[i];
                if ((long)format.bitrate > l2) continue;
                return format;
            }
            return formatArray[formatArray.length - 1];
        }
    }

    public static final class RandomEvaluator
    implements FormatEvaluator {
        private final Random random;

        public RandomEvaluator() {
            this.random = new Random();
        }

        public RandomEvaluator(int n) {
            this.random = new Random(n);
        }

        @Override
        public void enable() {
        }

        @Override
        public void disable() {
        }

        @Override
        public void evaluate(List<? extends MediaChunk> list, long l, Format[] formatArray, Evaluation evaluation) {
            Format format = formatArray[this.random.nextInt(formatArray.length)];
            if (evaluation.format != null && !evaluation.format.equals(format)) {
                evaluation.trigger = 3;
            }
            evaluation.format = format;
        }
    }

    public static final class FixedEvaluator
    implements FormatEvaluator {
        @Override
        public void enable() {
        }

        @Override
        public void disable() {
        }

        @Override
        public void evaluate(List<? extends MediaChunk> list, long l, Format[] formatArray, Evaluation evaluation) {
            evaluation.format = formatArray[0];
        }
    }

    public static final class Evaluation {
        public int queueSize;
        public int trigger = 1;
        public Format format;
    }
}

