/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.TargetApi;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.exoplayer.DecoderInfo;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import com.vcc.playerwrappersdk.a;
import java.io.IOException;
import java.util.HashMap;

@TargetApi(value=16)
public final class MediaCodecUtil {
    private static final String TAG = "MediaCodecUtil";
    private static final HashMap<CodecKey, Pair<String, MediaCodecInfo.CodecCapabilities>> codecs = new HashMap();

    private MediaCodecUtil() {
    }

    public static DecoderInfo getDecoderInfo(String string, boolean bl) throws DecoderQueryException {
        Pair<String, MediaCodecInfo.CodecCapabilities> pair = MediaCodecUtil.getMediaCodecInfo(string, bl);
        if (pair == null) {
            return null;
        }
        return new DecoderInfo((String)pair.first, MediaCodecUtil.isAdaptive((MediaCodecInfo.CodecCapabilities)pair.second));
    }

    public static synchronized void warmCodec(String string, boolean bl) {
        try {
            MediaCodecUtil.getMediaCodecInfo(string, bl);
        }
        catch (DecoderQueryException decoderQueryException) {
            a.b(TAG, "Codec warming failed", decoderQueryException);
        }
    }

    public static synchronized Pair<String, MediaCodecInfo.CodecCapabilities> getMediaCodecInfo(String string, boolean bl) throws DecoderQueryException {
        CodecKey codecKey = new CodecKey(string, bl);
        if (codecs.containsKey(codecKey)) {
            return codecs.get(codecKey);
        }
        MediaCodecListCompat mediaCodecListCompat = Util.SDK_INT >= 21 ? new MediaCodecListCompatV21(bl) : new MediaCodecListCompatV16();
        Pair<String, MediaCodecInfo.CodecCapabilities> pair = MediaCodecUtil.getMediaCodecInfo(codecKey, mediaCodecListCompat);
        if (bl && pair == null && 21 <= Util.SDK_INT && Util.SDK_INT <= 23 && (pair = MediaCodecUtil.getMediaCodecInfo(codecKey, mediaCodecListCompat = new MediaCodecListCompatV16())) != null) {
            a.b(TAG, "MediaCodecList API didn't list secure decoder for: " + string + ". Assuming: " + (String)pair.first);
        }
        return pair;
    }

    private static Pair<String, MediaCodecInfo.CodecCapabilities> getMediaCodecInfo(CodecKey codecKey, MediaCodecListCompat mediaCodecListCompat) throws DecoderQueryException {
        try {
            return MediaCodecUtil.getMediaCodecInfoInternal(codecKey, mediaCodecListCompat);
        }
        catch (Exception exception) {
            throw new DecoderQueryException(exception);
        }
    }

    private static Pair<String, MediaCodecInfo.CodecCapabilities> getMediaCodecInfoInternal(CodecKey codecKey, MediaCodecListCompat mediaCodecListCompat) {
        String string = codecKey.mimeType;
        int n = mediaCodecListCompat.getCodecCount();
        boolean bl = mediaCodecListCompat.secureDecodersExplicit();
        for (int i = 0; i < n; ++i) {
            String string2;
            MediaCodecInfo mediaCodecInfo = mediaCodecListCompat.getCodecInfoAt(i);
            if (!MediaCodecUtil.isCodecUsableDecoder(mediaCodecInfo, string2 = mediaCodecInfo.getName(), bl)) continue;
            String[] stringArray = mediaCodecInfo.getSupportedTypes();
            for (int j = 0; j < stringArray.length; ++j) {
                String string3 = stringArray[j];
                if (!string3.equalsIgnoreCase(string)) continue;
                MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(string3);
                boolean bl2 = mediaCodecListCompat.isSecurePlaybackSupported(codecKey.mimeType, codecCapabilities);
                if (!bl) {
                    codecs.put(codecKey.secure ? new CodecKey(string, false) : codecKey, (Pair<String, MediaCodecInfo.CodecCapabilities>)Pair.create((Object)string2, (Object)codecCapabilities));
                    if (bl2) {
                        codecs.put(codecKey.secure ? codecKey : new CodecKey(string, true), (Pair<String, MediaCodecInfo.CodecCapabilities>)Pair.create((Object)(string2 + ".secure"), (Object)codecCapabilities));
                    }
                } else {
                    codecs.put(codecKey.secure == bl2 ? codecKey : new CodecKey(string, bl2), (Pair<String, MediaCodecInfo.CodecCapabilities>)Pair.create((Object)string2, (Object)codecCapabilities));
                }
                if (!codecs.containsKey(codecKey)) continue;
                return codecs.get(codecKey);
            }
        }
        return null;
    }

    private static boolean isCodecUsableDecoder(MediaCodecInfo mediaCodecInfo, String string, boolean bl) {
        if (mediaCodecInfo.isEncoder() || !bl && string.endsWith(".secure")) {
            return false;
        }
        if (Util.SDK_INT < 21 && "CIPAACDecoder".equals(string) || "CIPMP3Decoder".equals(string) || "CIPVorbisDecoder".equals(string) || "AACDecoder".equals(string) || "MP3Decoder".equals(string)) {
            return false;
        }
        if (Util.SDK_INT == 16 && "OMX.SEC.MP3.Decoder".equals(string)) {
            return false;
        }
        if (Util.SDK_INT == 16 && "OMX.qcom.audio.decoder.mp3".equals(string) && ("dlxu".equals(Util.DEVICE) || "protou".equals(Util.DEVICE) || "C6602".equals(Util.DEVICE) || "C6603".equals(Util.DEVICE) || "C6606".equals(Util.DEVICE) || "C6616".equals(Util.DEVICE) || "L36h".equals(Util.DEVICE) || "SO-02E".equals(Util.DEVICE))) {
            return false;
        }
        if (Util.SDK_INT == 16 && "OMX.qcom.audio.decoder.aac".equals(string) && ("C1504".equals(Util.DEVICE) || "C1505".equals(Util.DEVICE) || "C1604".equals(Util.DEVICE) || "C1605".equals(Util.DEVICE))) {
            return false;
        }
        return Util.SDK_INT > 19 || Util.DEVICE == null || !Util.DEVICE.startsWith("d2") && !Util.DEVICE.startsWith("serrano") || !"samsung".equals(Util.MANUFACTURER) || !string.equals("OMX.SEC.vp8.dec");
    }

    private static boolean isAdaptive(MediaCodecInfo.CodecCapabilities codecCapabilities) {
        if (Util.SDK_INT >= 19) {
            return MediaCodecUtil.isAdaptiveV19(codecCapabilities);
        }
        return false;
    }

    @TargetApi(value=19)
    private static boolean isAdaptiveV19(MediaCodecInfo.CodecCapabilities codecCapabilities) {
        return codecCapabilities.isFeatureSupported("adaptive-playback");
    }

    @TargetApi(value=21)
    public static boolean isSizeSupportedV21(String string, boolean bl, int n, int n2) throws DecoderQueryException {
        Assertions.checkState(Util.SDK_INT >= 21);
        MediaCodecInfo.VideoCapabilities videoCapabilities = MediaCodecUtil.getVideoCapabilitiesV21(string, bl);
        return videoCapabilities != null && videoCapabilities.isSizeSupported(n, n2);
    }

    @TargetApi(value=21)
    public static boolean isSizeAndRateSupportedV21(String string, boolean bl, int n, int n2, double d) throws DecoderQueryException {
        Assertions.checkState(Util.SDK_INT >= 21);
        MediaCodecInfo.VideoCapabilities videoCapabilities = MediaCodecUtil.getVideoCapabilitiesV21(string, bl);
        return videoCapabilities != null && videoCapabilities.areSizeAndRateSupported(n, n2, d);
    }

    public static boolean isH264ProfileSupported(int n, int n2) throws DecoderQueryException {
        Pair<String, MediaCodecInfo.CodecCapabilities> pair = MediaCodecUtil.getMediaCodecInfo("video/avc", false);
        if (pair == null) {
            return false;
        }
        MediaCodecInfo.CodecCapabilities codecCapabilities = (MediaCodecInfo.CodecCapabilities)pair.second;
        for (int i = 0; i < codecCapabilities.profileLevels.length; ++i) {
            MediaCodecInfo.CodecProfileLevel codecProfileLevel = codecCapabilities.profileLevels[i];
            if (codecProfileLevel.profile != n || codecProfileLevel.level < n2) continue;
            return true;
        }
        return false;
    }

    public static int maxH264DecodableFrameSize() throws DecoderQueryException {
        Pair<String, MediaCodecInfo.CodecCapabilities> pair = MediaCodecUtil.getMediaCodecInfo("video/avc", false);
        if (pair == null) {
            return 0;
        }
        int n = 0;
        MediaCodecInfo.CodecCapabilities codecCapabilities = (MediaCodecInfo.CodecCapabilities)pair.second;
        for (int i = 0; i < codecCapabilities.profileLevels.length; ++i) {
            MediaCodecInfo.CodecProfileLevel codecProfileLevel = codecCapabilities.profileLevels[i];
            n = Math.max(MediaCodecUtil.avcLevelToMaxFrameSize(codecProfileLevel.level), n);
        }
        return n;
    }

    @TargetApi(value=21)
    private static MediaCodecInfo.VideoCapabilities getVideoCapabilitiesV21(String string, boolean bl) throws DecoderQueryException {
        Pair<String, MediaCodecInfo.CodecCapabilities> pair = MediaCodecUtil.getMediaCodecInfo(string, bl);
        if (pair == null) {
            return null;
        }
        return ((MediaCodecInfo.CodecCapabilities)pair.second).getVideoCapabilities();
    }

    private static int avcLevelToMaxFrameSize(int n) {
        switch (n) {
            case 1: {
                return 25344;
            }
            case 2: {
                return 25344;
            }
            case 8: {
                return 101376;
            }
            case 16: {
                return 101376;
            }
            case 32: {
                return 101376;
            }
            case 64: {
                return 202752;
            }
            case 128: {
                return 414720;
            }
            case 256: {
                return 414720;
            }
            case 512: {
                return 921600;
            }
            case 1024: {
                return 0x140000;
            }
            case 2048: {
                return 0x200000;
            }
            case 4096: {
                return 0x200000;
            }
            case 8192: {
                return 0x220000;
            }
            case 16384: {
                return 5652480;
            }
            case 32768: {
                return 0x900000;
            }
        }
        return -1;
    }

    private static final class CodecKey {
        public final String mimeType;
        public final boolean secure;

        public CodecKey(String string, boolean bl) {
            this.mimeType = string;
            this.secure = bl;
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + (this.mimeType == null ? 0 : this.mimeType.hashCode());
            n2 = 31 * n2 + (this.secure ? 1231 : 1237);
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || object.getClass() != CodecKey.class) {
                return false;
            }
            CodecKey codecKey = (CodecKey)object;
            return TextUtils.equals((CharSequence)this.mimeType, (CharSequence)codecKey.mimeType) && this.secure == codecKey.secure;
        }
    }

    private static final class MediaCodecListCompatV16
    implements MediaCodecListCompat {
        private MediaCodecListCompatV16() {
        }

        @Override
        public int getCodecCount() {
            return MediaCodecList.getCodecCount();
        }

        @Override
        public MediaCodecInfo getCodecInfoAt(int n) {
            return MediaCodecList.getCodecInfoAt((int)n);
        }

        @Override
        public boolean secureDecodersExplicit() {
            return false;
        }

        @Override
        public boolean isSecurePlaybackSupported(String string, MediaCodecInfo.CodecCapabilities codecCapabilities) {
            return "video/avc".equals(string);
        }
    }

    @TargetApi(value=21)
    private static final class MediaCodecListCompatV21
    implements MediaCodecListCompat {
        private final int codecKind;
        private MediaCodecInfo[] mediaCodecInfos;

        public MediaCodecListCompatV21(boolean bl) {
            this.codecKind = bl ? 1 : 0;
        }

        @Override
        public int getCodecCount() {
            this.ensureMediaCodecInfosInitialized();
            return this.mediaCodecInfos.length;
        }

        @Override
        public MediaCodecInfo getCodecInfoAt(int n) {
            this.ensureMediaCodecInfosInitialized();
            return this.mediaCodecInfos[n];
        }

        @Override
        public boolean secureDecodersExplicit() {
            return true;
        }

        @Override
        public boolean isSecurePlaybackSupported(String string, MediaCodecInfo.CodecCapabilities codecCapabilities) {
            return codecCapabilities.isFeatureSupported("secure-playback");
        }

        private void ensureMediaCodecInfosInitialized() {
            if (this.mediaCodecInfos == null) {
                this.mediaCodecInfos = new MediaCodecList(this.codecKind).getCodecInfos();
            }
        }
    }

    private static interface MediaCodecListCompat {
        public int getCodecCount();

        public MediaCodecInfo getCodecInfoAt(int var1);

        public boolean secureDecodersExplicit();

        public boolean isSecurePlaybackSupported(String var1, MediaCodecInfo.CodecCapabilities var2);
    }

    public static class DecoderQueryException
    extends IOException {
        private DecoderQueryException(Throwable throwable) {
            super("Failed to query underlying media codecs", throwable);
        }
    }
}

